/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.apache.shiro.ShiroException;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.io.Serializer;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.ioc.annotations.Order;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.services.ApplicationInitializer;
import org.apache.tapestry5.services.ApplicationInitializerFilter;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.slf4j.Logger;
import org.tynamo.security.Security;
import org.tynamo.security.SecurityComponentRequestFilter;
import org.tynamo.security.ShiroAnnotationWorker;
import org.tynamo.security.internal.ModularRealmAuthenticator;
import org.tynamo.security.internal.SecurityExceptionHandlerAssistant;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.internal.services.impl.LoginContextServiceImpl;
import org.tynamo.security.internal.services.impl.PermissionBindingFactory;
import org.tynamo.security.services.ClassInterceptorsCache;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.SecurityFilterChainHub;
import org.tynamo.security.services.SecurityService;
import org.tynamo.security.services.TapestryRealmSecurityManager;
import org.tynamo.security.services.impl.ClassInterceptorsCacheImpl;
import org.tynamo.security.services.impl.SecurityConfiguration;
import org.tynamo.security.services.impl.SecurityFilterChain;
import org.tynamo.security.services.impl.SecurityFilterChainFactoryImpl;
import org.tynamo.security.services.impl.SecurityFilterChainHubImpl;
import org.tynamo.security.services.impl.SecurityServiceImpl;
import org.tynamo.security.shiro.SimplePrincipalSerializer;
import org.tynamo.shiro.extension.authz.aop.AopHelper;
import org.tynamo.shiro.extension.authz.aop.DefaultSecurityInterceptor;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

@Security
public class SecurityModule {
    private static final String PATH_PREFIX = "security";

    public static void bind(ServiceBinder binder) {
        binder.bind(WebSecurityManager.class, TapestryRealmSecurityManager.class);
        binder.bind(ModularRealmAuthenticator.class);
        binder.bind(SubjectFactory.class, DefaultWebSubjectFactory.class);
        binder.bind(HttpServletRequestFilter.class, SecurityConfiguration.class).withId("SecurityConfiguration").withMarker(new Class[]{Security.class});
        binder.bind(ClassInterceptorsCache.class, ClassInterceptorsCacheImpl.class);
        binder.bind(SecurityService.class, SecurityServiceImpl.class);
        binder.bind(SecurityFilterChainFactory.class, SecurityFilterChainFactoryImpl.class);
        binder.bind(ComponentRequestFilter.class, SecurityComponentRequestFilter.class);
        binder.bind(SecurityFilterChainHub.class, SecurityFilterChainHubImpl.class);
        binder.bind(LoginContextService.class, LoginContextServiceImpl.class);
        binder.bind(Serializer.class, SimplePrincipalSerializer.class);
    }

    public static RememberMeManager buildRememberMeManager(Serializer serializer, Logger logger, @Symbol(value="tapestry.hmac-passphrase") String hmacPassphrase, @Symbol(value="security.remembermecipherkey") String rememberMeCipherKey) throws UnsupportedEncodingException {
        CookieRememberMeManager rememberMeManager = new CookieRememberMeManager();
        rememberMeManager.setSerializer(serializer);
        byte[] cipherKey = Base64.decode((String)rememberMeCipherKey);
        if (cipherKey.length <= 0) {
            if (hmacPassphrase.isEmpty()) {
                logger.error("Neither symbol 'security.remembermecipherkey' nor  'tapestry.hmac-passphrase' is set. Using a random value as the cipher key for encrypting rememberMe information. Cookies will be invalidated when the JVM is restarted");
                return rememberMeManager;
            }
            logger.warn("Symbol 'security.remembermecipherkey' is not set, using 'tapestry.hmac-passphrase' as the cipher. Beware that changing the value will invalidate rememberMe cookies");
            if (hmacPassphrase.length() < 16) {
                hmacPassphrase = hmacPassphrase + "================".substring(hmacPassphrase.length());
            }
            if ((cipherKey = hmacPassphrase.getBytes("UTF-8")).length > 16) {
                cipherKey = Arrays.copyOf(cipherKey, 16);
            }
        }
        rememberMeManager.setCipherKey(cipherKey);
        return rememberMeManager;
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"security.loginurl", (Object)"/security/login");
        configuration.add((Object)"security.successurl", (Object)"/${tapestry.start-page-name}");
        configuration.add((Object)"security.unauthorizedurl", (Object)"/security/unauthorized");
        configuration.add((Object)"security.redirecttosavedurl", (Object)"true");
        configuration.add((Object)"security.remembermecipherkey", (Object)"");
    }

    public void contributeApplicationInitializer(OrderedConfiguration<ApplicationInitializerFilter> configuration, final ComponentClassResolver componentClassResolver, final ClassInterceptorsCache classInterceptorsCache) {
        configuration.add("SecurityApplicationInitializerFilter", (Object)new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                initializer.initializeApplication(context);
                for (String name : componentClassResolver.getPageNames()) {
                    String className = componentClassResolver.resolvePageNameToClassName(name);
                    for (Class clazz = ClassUtils.forName((String)className); clazz != null; clazz = clazz.getSuperclass()) {
                        for (Class<? extends Annotation> annotationClass : AopHelper.getAutorizationAnnotationClasses()) {
                            Annotation classAnnotation = clazz.getAnnotation(annotationClass);
                            if (classAnnotation == null) continue;
                            classInterceptorsCache.add(className, new DefaultSecurityInterceptor(classAnnotation));
                        }
                    }
                }
            }
        }, new String[0]);
    }

    public static void contributeComponentRequestHandler(OrderedConfiguration<ComponentRequestFilter> configuration, @Local ComponentRequestFilter filter) {
        configuration.add("SecurityFilter", (Object)filter, new String[]{"before:*"});
    }

    @Contribute(value=Serializer.class)
    public static void addSafePrincipalTypes(Configuration<Class> configuration) {
        configuration.add(Long.class);
        configuration.add(String.class);
        configuration.add(Integer.class);
        configuration.add(Number.class);
    }

    @Contribute(value=ComponentClassTransformWorker2.class)
    public static void addTransformWorkers(OrderedConfiguration<ComponentClassTransformWorker2> configuration) {
        configuration.addInstance(ShiroAnnotationWorker.class.getSimpleName(), ShiroAnnotationWorker.class, new String[0]);
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping(PATH_PREFIX, "org.tynamo.security"));
    }

    @Match(value={"*"})
    @Order(value={"before:*"})
    public static void adviseSecurityAssert(MethodAdviceReceiver receiver, final @Core Environment environment) {
        Class serviceInterface = receiver.getInterface();
        for (Method method : serviceInterface.getMethods()) {
            List<SecurityInterceptor> interceptors = AopHelper.createSecurityInterceptorsSeeingInterfaces(method, serviceInterface);
            for (final SecurityInterceptor interceptor : interceptors) {
                MethodAdvice advice = new MethodAdvice(){

                    public void advise(MethodInvocation invocation) {
                        if (ThreadContext.getSubject() != null) {
                            environment.push(MethodInvocation.class, (Object)invocation);
                            try {
                                interceptor.intercept();
                            }
                            finally {
                                environment.pop(MethodInvocation.class);
                            }
                        }
                        invocation.proceed();
                    }
                };
                receiver.adviseMethod(method, advice);
            }
        }
    }

    public void contributeRequestExceptionHandler(MappedConfiguration<Class, Object> configuration) {
        configuration.add(ShiroException.class, SecurityExceptionHandlerAssistant.class);
    }

    public static void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, @InjectService(value="SecurityConfiguration") HttpServletRequestFilter securityConfiguration) {
        configuration.add("SecurityConfiguration", (Object)securityConfiguration, new String[]{"after:StoreIntoGlobals", "before:IgnoredPaths"});
    }

    @Contribute(value=HttpServletRequestFilter.class)
    @Security
    public static void defaultSecurity(OrderedConfiguration<SecurityFilterChain> configuration, SecurityFilterChainFactory factory) {
        configuration.add("ModulesCompressed", (Object)factory.createChain("/modules.gz/**").add((Filter)factory.anon()).build(), new String[0]);
        configuration.add("Modules", (Object)factory.createChain("/modules/**").add((Filter)factory.anon()).build(), new String[0]);
        configuration.add("Assets", (Object)factory.createChain("/assets/**").add((Filter)factory.anon()).build(), new String[0]);
    }

    @Contribute(value=BindingSource.class)
    public static void addPermissionBinding(MappedConfiguration<String, BindingFactory> configuration) {
        configuration.addInstance((Object)"permission", PermissionBindingFactory.class);
    }
}

