/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authz;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.CollectionUtils;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.shiro.authz.AuthorizationFilter;

public class RolesAuthorizationFilter
extends AuthorizationFilter {
    public RolesAuthorizationFilter(LoginContextService loginContextService) {
        super(loginContextService);
    }

    @Override
    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        Subject subject = this.getSubject(request, response);
        Object[] rolesArray = (String[])mappedValue;
        if (rolesArray == null || rolesArray.length == 0) {
            return true;
        }
        Set roles = CollectionUtils.asSet((Object[])rolesArray);
        return subject.hasAllRoles((Collection)roles);
    }
}

