/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;
import org.tynamo.shiro.extension.authz.aop.AopHelper;
import org.tynamo.shiro.extension.authz.aop.DefaultSecurityInterceptor;

public class ShiroAnnotationWorker
implements ComponentClassTransformWorker2 {
    private final Environment environment;

    public ShiroAnnotationWorker(Environment environment) {
        this.environment = environment;
    }

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (Class<? extends Annotation> annotationClass : AopHelper.getAutorizationAnnotationClasses()) {
            List methodsToTransform = plasticClass.getMethodsWithAnnotation(annotationClass);
            for (PlasticMethod tm : methodsToTransform) {
                this.processTransform(tm, tm.getAnnotation(annotationClass));
            }
        }
    }

    private void processTransform(PlasticMethod tm, Annotation annotation) {
        final DefaultSecurityInterceptor interceptor = new DefaultSecurityInterceptor(annotation);
        MethodAdvice advice = new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                ShiroAnnotationWorker.this.environment.push(MethodInvocation.class, (Object)invocation);
                try {
                    interceptor.intercept();
                }
                finally {
                    ShiroAnnotationWorker.this.environment.pop(MethodInvocation.class);
                }
                invocation.proceed();
            }
        };
        tm.addAdvice(advice);
    }
}

