/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.components;

import java.io.IOException;
import java.net.URL;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.subject.Subject;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.services.SecurityService;

public class LoginForm {
    private static final Logger logger = LoggerFactory.getLogger(LoginForm.class);
    private static final String LOGIN_FORM_ID = "tynamoLoginForm";
    @Property
    private String login;
    @Property
    private String password;
    @Property
    private boolean tynamoRememberMe;
    private String loginMessage;
    @Parameter(defaultPrefix="literal")
    private String successURL;
    @Inject
    private Messages messages;
    @Inject
    private Response response;
    @Inject
    private RequestGlobals requestGlobals;
    @Inject
    private SecurityService securityService;
    @Inject
    private LoginContextService loginContextService;
    @Inject
    private PageRenderLinkSource pageRenderLinkSource;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private Cookies cookies;
    @Inject
    @Symbol(value="security.redirecttosavedurl")
    private boolean redirectToSavedUrl;

    @OnEvent(value="validate", component="tynamoLoginForm")
    public void attemptToLogin() throws ValidationException {
        Subject currentUser = this.securityService.getSubject();
        if (currentUser == null) {
            throw new IllegalStateException("Subject can't be null");
        }
        UsernamePasswordToken token = new UsernamePasswordToken(this.login, this.password);
        token.setRememberMe(this.tynamoRememberMe);
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException e) {
            this.loginMessage = this.messages.get("AccountDoesNotExists");
        }
        catch (IncorrectCredentialsException e) {
            this.loginMessage = this.messages.get("WrongPassword");
        }
        catch (LockedAccountException e) {
            this.loginMessage = this.messages.get("AccountLocked");
        }
        catch (AuthenticationException e) {
            this.loginMessage = this.messages.get("AuthenticationError");
        }
        if (this.loginMessage != null) {
            throw new ValidationException(this.loginMessage);
        }
    }

    @OnEvent(value="success", component="tynamoLoginForm")
    public Object onSuccessfulLogin() throws IOException {
        if (StringUtils.hasText((String)this.successURL)) {
            if ("^".equals(this.successURL)) {
                return this.pageRenderLinkSource.createPageRenderLink(this.componentResources.getPage().getClass());
            }
            return new URL(this.successURL);
        }
        if (this.redirectToSavedUrl) {
            Object requestUri = this.loginContextService.getSuccessPage();
            if (!((String)requestUri).startsWith("/") && !((String)requestUri).startsWith("http")) {
                requestUri = "/" + (String)requestUri;
            }
            this.loginContextService.redirectToSavedRequest((String)requestUri);
            return null;
        }
        return this.loginContextService.getSuccessPage();
    }

    public void setLoginMessage(String loginMessage) {
        this.loginMessage = loginMessage;
    }

    public String getLoginMessage() {
        if (StringUtils.hasText((String)this.loginMessage)) {
            return this.loginMessage;
        }
        return " ";
    }
}

