/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.internal;

import java.io.IOException;
import java.util.List;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.tapestry5.ExceptionHandlerAssistant;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.services.SecurityService;

public class SecurityExceptionHandlerAssistant
implements ExceptionHandlerAssistant {
    private final SecurityService securityService;
    private final LoginContextService loginContextService;
    private final Response response;
    private final PageResponseRenderer renderer;
    private final RequestPageCache pageCache;

    public SecurityExceptionHandlerAssistant(SecurityService securityService, LoginContextService pageService, RequestPageCache pageCache, Response response, PageResponseRenderer renderer) {
        this.securityService = securityService;
        this.loginContextService = pageService;
        this.pageCache = pageCache;
        this.response = response;
        this.renderer = renderer;
    }

    public Object handleRequestException(Throwable exception, List<Object> exceptionContext) throws IOException {
        if (this.securityService.isAuthenticated()) {
            String unauthorizedPage = this.loginContextService.getUnauthorizedPage();
            this.response.setStatus(401);
            if (!StringUtils.hasText((String)unauthorizedPage)) {
                return null;
            }
            Page page = this.pageCache.get(unauthorizedPage);
            this.renderer.renderPageResponse(page);
            return null;
        }
        this.loginContextService.saveRequest();
        return this.loginContextService.getLoginPage();
    }
}

