/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.apache.shiro.web.util.WebUtils;
import org.tynamo.security.internal.services.LoginContextService;

public abstract class AccessControlFilter
extends AdviceFilter {
    public static String TAPESTRY_VERSION;
    public static String LOGIN_URL;
    public static String SUCCESS_URL;
    public static String UNAUTHORIZED_URL;
    public static boolean REDIRECT_TO_SAVED_URL;
    protected PatternMatcher pathMatcher = new AntPathMatcher(){

        public boolean match(String pattern, String string) {
            return super.match(pattern, string.toLowerCase());
        }
    };
    private String[] configElements;
    private String config;
    private final LoginContextService loginContextService;
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    private String loginUrl = LOGIN_URL;
    private String successUrl = SUCCESS_URL;
    private String unauthorizedUrl = UNAUTHORIZED_URL;
    private boolean redirectToSavedUrl = REDIRECT_TO_SAVED_URL;

    public AccessControlFilter(LoginContextService loginContextService) {
        this.loginContextService = loginContextService;
    }

    public void addConfig(String config) {
        if (config == null && this.config == null && this.configElements != null) {
            return;
        }
        if (config != null && config.equals(this.config)) {
            return;
        }
        if (this.configElements != null) {
            throw new IllegalArgumentException("Configuration is already add for this filter, existing config is " + String.valueOf(this.configElements) + ". Use setConfig if you want to override the existing configuration");
        }
        this.setConfig(config);
    }

    public void setConfig(String config) {
        this.configElements = config != null ? StringUtils.split((String)config) : new String[0];
        this.config = config;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getUnauthorizedUrl() {
        return this.unauthorizedUrl;
    }

    public void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = unauthorizedUrl;
    }

    protected Subject getSubject(ServletRequest request, ServletResponse response) {
        return SecurityUtils.getSubject();
    }

    protected abstract boolean isAccessAllowed(ServletRequest var1, ServletResponse var2, Object var3) throws Exception;

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return this.onAccessDenied(request, response);
    }

    protected abstract boolean onAccessDenied(ServletRequest var1, ServletResponse var2) throws Exception;

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return this.isAccessAllowed(request, response, mappedValue) || this.onAccessDenied(request, response, mappedValue);
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return this.onPreHandle(request, response, this.configElements);
    }

    protected boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        return this.pathMatcher.matches(this.getLoginUrl(), WebUtils.getPathWithinApplication((HttpServletRequest)WebUtils.toHttp((ServletRequest)request)));
    }

    protected void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.saveRequest(request);
        this.redirectToLogin(request, response);
    }

    protected void saveRequest(ServletRequest request) {
        this.loginContextService.saveRequest();
    }

    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        String loginUrl;
        String localeName = this.loginContextService.getLocaleFromPath(WebUtils.getPathWithinApplication((HttpServletRequest)WebUtils.toHttp((ServletRequest)request)));
        String string = loginUrl = localeName == null ? "/" + this.loginContextService.getLoginPage() : "/" + localeName + "/" + this.loginContextService.getLoginPage();
        if ("XMLHttpRequest".equals(WebUtils.toHttp((ServletRequest)request).getHeader("X-Requested-With"))) {
            WebUtils.toHttp((ServletResponse)response).setContentType("application/json;charset=UTF-8");
            ServletOutputStream os = WebUtils.toHttp((ServletResponse)response).getOutputStream();
            os.write(("{\"_tapestry\":{\"redirectURL\":\"" + WebUtils.toHttp((ServletRequest)request).getContextPath() + loginUrl + "\"}}").getBytes());
            os.close();
        } else {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)loginUrl);
        }
    }

    public boolean isRedirectToSavedUrl() {
        return this.redirectToSavedUrl;
    }

    public void setRedirectToSavedUrl(boolean redirectToSavedUrl) {
        this.redirectToSavedUrl = redirectToSavedUrl;
    }

    protected LoginContextService getLoginContextService() {
        return this.loginContextService;
    }
}

