/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authc;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.shiro.authc.AuthenticatingFilter;

public class CasFilter
extends AuthenticatingFilter {
    private static Logger logger = LoggerFactory.getLogger(CasFilter.class);
    private static final String TICKET_PARAMETER = "ticket";
    private String failureUrl;

    public CasFilter(LoginContextService loginContextService) {
        super(loginContextService);
    }

    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String ticket = httpRequest.getParameter(TICKET_PARAMETER);
        return new CasToken(ticket);
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        return this.executeLogin(request, response);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return false;
    }

    @Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        this.issueSuccessRedirect(request, response);
        return false;
    }

    @Override
    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
        Subject subject = this.getSubject(request, response);
        if (subject.isAuthenticated() || subject.isRemembered()) {
            try {
                this.issueSuccessRedirect(request, response);
            }
            catch (Exception e) {
                logger.error("Cannot redirect to the default success url", (Throwable)e);
            }
        } else {
            try {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.failureUrl);
            }
            catch (IOException e) {
                logger.error("Cannot redirect to failure url : {}", (Object)this.failureUrl, (Object)e);
            }
        }
        return false;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }
}

