/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authc;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.shiro.AccessControlFilter;

public class UserFilter
extends AccessControlFilter {
    public UserFilter(LoginContextService loginContextService) {
        super(loginContextService);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginRequest(request, response)) {
            return true;
        }
        Subject subject = this.getSubject(request, response);
        return subject.getPrincipal() != null;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }
}

