/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authz;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.shiro.AccessControlFilter;

public abstract class AuthorizationFilter
extends AccessControlFilter {
    private String unauthorizedUrl;

    public AuthorizationFilter(LoginContextService loginContextService) {
        super(loginContextService);
    }

    @Override
    public String getUnauthorizedUrl() {
        return this.unauthorizedUrl;
    }

    @Override
    public void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = unauthorizedUrl;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        Subject subject = this.getSubject(request, response);
        if (subject.getPrincipal() == null) {
            this.saveRequestAndRedirectToLogin(request, response);
        } else {
            String unauthorizedUrl = this.getUnauthorizedUrl();
            if (StringUtils.hasText((String)unauthorizedUrl)) {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)unauthorizedUrl);
            } else {
                WebUtils.toHttp((ServletResponse)response).sendError(401);
            }
        }
        return false;
    }
}

