/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authz;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.shiro.subject.Subject;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.shiro.authz.AuthorizationFilter;

public class PermissionsAuthorizationFilter
extends AuthorizationFilter {
    public PermissionsAuthorizationFilter(LoginContextService loginContextService) {
        super(loginContextService);
    }

    @Override
    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        Subject subject = this.getSubject(request, response);
        String[] perms = (String[])mappedValue;
        boolean isPermitted = true;
        if (perms != null && perms.length > 0) {
            if (perms.length == 1) {
                if (!subject.isPermitted(perms[0])) {
                    isPermitted = false;
                }
            } else if (!subject.isPermittedAll(perms)) {
                isPermitted = false;
            }
        }
        return isPermitted;
    }
}

