/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.shiro.extension.authz.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.tynamo.shiro.extension.authz.aop.AopHelper;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

public class DefaultSecurityInterceptor
implements SecurityInterceptor {
    private final AuthorizingAnnotationHandler handler;
    private final Annotation annotation;

    public DefaultSecurityInterceptor(AuthorizingAnnotationHandler handler, Annotation annotation) {
        this.handler = handler;
        this.annotation = annotation;
    }

    public DefaultSecurityInterceptor(Annotation annotation) {
        this.annotation = annotation;
        AuthorizingAnnotationHandler handler = AopHelper.createHandler(annotation);
        if (handler == null) {
            throw new IllegalStateException("No handler for " + String.valueOf(annotation) + "annotation");
        }
        this.handler = handler;
    }

    @Override
    public void intercept() {
        this.handler.assertAuthorized(this.getAnnotation());
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

