/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.watchdog.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.slf4j.Logger;
import org.tynamo.watchdog.StreamGobbler;
import org.tynamo.watchdog.services.WatchdogModule;
import org.tynamo.watchdog.services.WatchdogService;
import tynamo_watchdog.Watchdog;

@EagerLoad
public class WatchdogServiceImpl
implements WatchdogService {
    private Process watchdog;
    private WatchdogLeash watchdogLeash;
    private volatile boolean watchdogAlarmed;
    OutputStream watchdogOutputStream;
    private final String appPackageName;
    private final String smtpHost;
    private final Integer smtpPort;
    private final String sendEmail;
    private final Logger logger;

    public WatchdogServiceImpl(Logger logger, @Symbol(value="tapestry.production-mode") boolean productionMode, @Inject @Symbol(value="tapestry.app-package") String appPackageName, @Inject @Symbol(value="smtp.host") String smtpHost, @Symbol(value="smtp.port") Integer smtpPort, @Inject @Symbol(value="watchdog.sendemail") String sendEmail) throws IOException, URISyntaxException, InterruptedException {
        this.logger = logger;
        this.appPackageName = appPackageName;
        this.smtpHost = smtpHost;
        this.smtpPort = smtpPort;
        this.sendEmail = sendEmail;
        if (productionMode) {
            this.startWatchdog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File extractFromJar(URL resource, File watchdogFolder) throws IOException {
        String fileName = resource.getPath().substring(resource.getPath().lastIndexOf("/"));
        File file = new File(watchdogFolder, fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            IOException x = new IOException("Watchdog failed to create a temporary file in " + tmpdir);
            x.initCause(e);
            throw x;
        }
        InputStream is = resource.openStream();
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                WatchdogServiceImpl.copyStream(is, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
        file.deleteOnExit();
        return file;
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    File prepareWatchdog() throws IOException {
        File tempFile = File.createTempFile("forwatchdog", "test");
        tempFile.deleteOnExit();
        File watchdogFolder = new File(tempFile.getParentFile(), Watchdog.class.getPackage().getName());
        watchdogFolder.mkdir();
        this.extractFromJar(Watchdog.class.getResource(Watchdog.class.getSimpleName() + ".class"), watchdogFolder);
        this.extractFromJar(Watchdog.class.getResource(WatchdogModule.javamailSpec + ".jar"), watchdogFolder);
        this.extractFromJar(Watchdog.class.getResource(WatchdogModule.javamailProvider + ".jar"), watchdogFolder);
        return watchdogFolder.getParentFile();
    }

    public synchronized void startWatchdog() throws IOException, URISyntaxException, InterruptedException {
        File watchdogFolder = this.prepareWatchdog();
        Process testJavaProcess = Runtime.getRuntime().exec("java -version");
        try {
            if (testJavaProcess.waitFor() != 0) {
                this.logger.error("Couldn't execute java in given environment - is java on PATH? Cannot start the watchdog");
                return;
            }
        }
        catch (IllegalThreadStateException e) {
            this.logger.error("Testing java execution didn't return immediately. Report this issue to Tynamo.org");
        }
        String packageName = Watchdog.class.getPackage().getName();
        String[] args = new String[]{"java", "-Dwatchdog.sendemail=" + this.sendEmail, "-Dsmtp.host=" + this.smtpHost, "-Dsmtp.port=" + this.smtpPort, "-Xms8m", "-Xmx16m", "-XX:MaxPermSize=16m", "-cp", "." + File.pathSeparator + packageName + File.separator + WatchdogModule.javamailSpec + ".jar" + File.pathSeparator + packageName + File.separator + WatchdogModule.javamailProvider + ".jar", Watchdog.class.getName(), this.appPackageName};
        StringBuilder command = new StringBuilder();
        for (String value : args) {
            command.append(value);
            command.append(" ");
        }
        this.logger.info("Starting watchdog with command: " + command.toString());
        this.watchdog = Runtime.getRuntime().exec(args, null, watchdogFolder);
        new StreamGobbler(this.watchdog.getErrorStream(), "WATCHDOG ERROR").start();
        new StreamGobbler(this.watchdog.getInputStream(), "WATCHDOG OUTPUT").start();
        this.watchdogOutputStream = this.watchdog.getOutputStream();
        try {
            int exitCode = this.watchdog.exitValue();
            this.logger.error("Watchdog failed to start: the process exited immediately with exit code " + exitCode);
            return;
        }
        catch (IllegalThreadStateException e) {
            this.watchdogLeash = new WatchdogLeash();
            this.watchdogLeash.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        WatchdogServiceImpl.this.logger.warn("Dismissing watchdog before controlled JVM shutdown");
                        WatchdogServiceImpl.this.dismissWatchdog();
                    }
                    catch (IOException e) {
                        WatchdogServiceImpl.this.logger.warn("Couldn't controllably dismiss the watchdog. Is watchdog still alive?");
                    }
                    try {
                        int exitCode = WatchdogServiceImpl.this.watchdog.exitValue();
                        WatchdogServiceImpl.this.logger.error("Watchdog has already exited with exit code " + exitCode);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
    }

    public void dismissWatchdog() throws IOException {
        this.watchdogOutputStream.write(Watchdog.STOP_MESSAGE.getBytes());
        this.watchdogOutputStream.flush();
    }

    public void alarmWatchdog() throws IOException {
        this.watchdogOutputStream.close();
    }

    public String whoAmI() throws IOException, URISyntaxException {
        URL classFile;
        try {
            classFile = Watchdog.class.getResource(Watchdog.class.getSimpleName() + ".class");
            JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
            String fileName = jf.getName();
            String string = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        catch (Exception x) {
            System.err.println("ZipFile.name trick did not work, using fallback: " + x);
        }
        classFile = Watchdog.class.getProtectionDomain().getCodeSource().getLocation();
        String fileName = classFile.toString();
        return fileName.substring(fileName.lastIndexOf("/") + 1);
    }

    class WatchdogLeash
    extends Thread {
        public WatchdogLeash() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    WatchdogServiceImpl.this.watchdogOutputStream.write(0);
                    WatchdogServiceImpl.this.watchdogOutputStream.flush();
                    WatchdogLeash.sleep(5000L);
                }
            }
            catch (IOException e) {
                if (WatchdogServiceImpl.this.watchdogAlarmed) {
                    return;
                }
                WatchdogServiceImpl.this.logger.warn("IO exception occurred while communicating with the watchdog process. Was the watchdog killed? Releasing the leash");
                try {
                    WatchdogServiceImpl.this.logger.info("Watchdog process exited with exit code " + WatchdogServiceImpl.this.watchdog.exitValue());
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

