/*
 * Decompiled with CFR 0.152.
 */
package tynamo_watchdog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Watchdog {
    public static final String SMTP_HOST = "smtp.host";
    public static final String SMTP_PORT = "smtp.port";
    public static final String SEND_EMAIL = "watchdog.sendemail";
    public static final String EMAIL_PATH = "watchdog.emailpath";
    public static final String COMMAND = "watchdog.command";
    public static final String KEEPALIVE_INTERVAL = "watchdog.keepalive";
    public static final String FINALALARM_DELAY = "watchdog.alarmdelay";
    public static final String STOP_MESSAGE = Watchdog.class.getSimpleName();
    private String emailRecipient;
    private String smtpHost;
    private Integer smtpPort;
    private String appName;
    private String hostname;
    private long lastOk;
    private long keepAliveInterval = 5000L;
    private long finalAlarmDelay = 60000L;
    private boolean warningSent;

    public Watchdog(String appName, String emailRecipient, String smtpHost, String smtpPort, Long keepAliveInterval, Long finalAlarmDelay) {
        this.appName = appName;
        this.emailRecipient = emailRecipient;
        this.smtpHost = smtpHost;
        if (keepAliveInterval != null) {
            this.keepAliveInterval = keepAliveInterval;
        }
        if (finalAlarmDelay != null) {
            this.finalAlarmDelay = finalAlarmDelay;
        }
        this.smtpPort = smtpPort == null ? null : Integer.valueOf(smtpPort);
        this.hostname = System.getenv("HOSTNAME");
        if (this.hostname == null) {
            this.hostname = "localhost.localdomain";
        }
        this.lastOk = System.currentTimeMillis();
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        if (args.length <= 0 || arguments.contains("--help")) {
            System.out.println("Tynamo watchdog. This application is designed to run as a child process ");
            return;
        }
        String appName = args.length > 0 ? args[0] : "dev/exploded";
        Watchdog.sleep(5000L);
        String value = System.getProperty(KEEPALIVE_INTERVAL);
        Long keepAliveInterval = null;
        try {
            keepAliveInterval = Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        value = System.getProperty(FINALALARM_DELAY);
        Long finalAlarmDelay = null;
        try {
            finalAlarmDelay = Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        Watchdog watchdog = new Watchdog(appName, System.getProperty(SEND_EMAIL), System.getProperty(SMTP_HOST), System.getProperty(SMTP_PORT), keepAliveInterval, finalAlarmDelay);
        watchdog.go();
    }

    public void go() {
        try {
            while (this.lastOk + this.finalAlarmDelay > System.currentTimeMillis()) {
                this.makeRounds();
            }
        }
        catch (IOException e) {
            System.err.println("Parent process stopped at " + new Date());
        }
        this.sendApplicationLostEmail();
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void makeRounds() throws IOException {
        int available = 0;
        byte[] bytes = new byte[STOP_MESSAGE.getBytes().length];
        while ((available = System.in.available()) > 0) {
            if (available >= STOP_MESSAGE.getBytes().length) {
                System.exit(0);
            }
            System.in.read(bytes, 0, available);
            this.lastOk = System.currentTimeMillis();
            this.warningSent = false;
            Watchdog.sleep(this.keepAliveInterval * 2L);
        }
        if (!this.warningSent) {
            this.sendRunningSlowEmail();
        }
        this.warningSent = true;
        Watchdog.sleep(this.keepAliveInterval);
    }

    void sendRunningSlowEmail() {
        String subject = "Application " + this.appName + " is running slow!";
        StringBuilder sb = new StringBuilder();
        sb.append("Master application '");
        sb.append(this.appName);
        sb.append("' at ");
        sb.append(this.hostname);
        sb.append(" has missed sending some alive signals. The last OK was received at ");
        sb.append(new Date(this.lastOk));
        sb.append(". \n");
        sb.append("This may indicate the application has dead-locked, been unexpectedly terminated or is running out of resources. \n");
        sb.append("Action taken: email sent to '");
        sb.append(this.emailRecipient);
        sb.append("', still monitoring\n");
        try {
            this.sendEmail(subject, sb);
        }
        catch (MessagingException e) {
            System.err.println("Couldn't send warning email because of: " + e.getMessage());
        }
    }

    void sendApplicationLostEmail() {
        String subject = "Application " + this.appName + " has failed!";
        StringBuilder sb = new StringBuilder();
        sb.append("Master application '");
        sb.append(this.appName);
        sb.append("' at ");
        sb.append(this.hostname);
        sb.append(" was lost at ");
        sb.append(new Date());
        sb.append("\n");
        sb.append("Action taken: email sent to '");
        sb.append(this.emailRecipient);
        sb.append("'\n");
        try {
            this.sendEmail(subject, sb);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    boolean sendEmail(String subject, StringBuilder content) throws MessagingException {
        if (this.emailRecipient == null || this.emailRecipient.isEmpty()) {
            return false;
        }
        System.out.println("Sending email to: " + this.emailRecipient + " " + System.getProperty(SMTP_PORT));
        boolean debug = false;
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.port", String.valueOf(this.smtpPort));
        props.put("mail.smtp.debug", "true");
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress("watchdog@" + this.hostname);
        msg.setFrom((Address)addressFrom);
        InternetAddress[] addressTo = new InternetAddress[]{new InternetAddress(this.emailRecipient)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        msg.setSubject(subject);
        msg.setText(content.toString());
        Transport.send((Message)msg);
        return true;
    }
}

