/**
 * Copyright (c) 2008-2011 Tyranid (   http://tyranid.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tyranid.locale.db

import org.tyranid.Imp._
import org.tyranid.db.{ DbInt, DbChar, DbLink, Record }
import org.tyranid.db.ram.RamEntity


object Region extends RamEntity( tid = "a01t" ) {
  "id"     is DbInt      is 'key;
  "name"   is DbChar(64) is 'label;
  "fips"   is DbChar(4);
  "country" is DbLink(Country);
  "abbr"    is DbChar(2); 

  def idForAbbr( s:String ):Int = {
    val abbrIdx = staticView( 'abbr ).index
  
    staticRecords.find( _( abbrIdx ) == s ).flatten( _.id.asInstanceOf[Int], 0 )
  }
  
  def regionsForCountry( cid:Int ):Seq[Record] = {
    val countryIdx = staticView( 'country ).index
    
    staticRecords.filter( _( countryIdx ).asInstanceOf[Int] == cid )
  }  

	static { s =>
  s( "id",  "name",				                                "fips",   "country", "abbr" )

  /*
      There is some scala compiler bug that shows up when you have more than ~1500ish records in a single method.
   */

  init1( s )
//  init2( s )
//  init3( s )
  

}

  def init1( s:org.tyranid.db.StaticBuilder ) = {
  s(   1,    "Alabama",                                    "01",     4306,     "AL" )
  s(   2,    "Alaska",                                     "02",     4306,     "AK" )
  s(   3,    "Arizona",                                    "04",     4306,     "AZ" )
  s(   4,    "Arkansas",                                   "05",     4306,     "AR" )
  s(   5,    "California",                                 "06",     4306,     "CA" )
  s(   6,    "Colorado",                                   "08",     4306,     "CO" )
  s(   7,    "Connecticut",                                "09",     4306,     "CT" )
  s(   8,    "Delaware",                                   "10",     4306,     "DE" )
  s(   9,    "Florida",                                    "12",     4306,     "FL" )
  s(   10,   "Georgia",                                    "13",     4306,     "GA" )
  s(   11,   "Hawaii",                                     "15",     4306,     "HI" )
  s(   12,   "Idaho",                                      "16",     4306,     "ID" )
  s(   13,   "Illinois",                                   "17",     4306,     "IL" )
  s(   14,   "Indiana",                                    "18",     4306,     "IN" )
  s(   15,   "Iowa",                                       "19",     4306,     "IA" )
  s(   16,   "Kansas",                                     "20",     4306,     "KS" )
  s(   17,   "Kentucky",                                   "21",     4306,     "KY" )
  s(   18,   "Louisiana",                                  "22",     4306,     "LA" )
  s(   19,   "Maine",                                      "23",     4306,     "ME" )
  s(   20,   "Maryland",                                   "24",     4306,     "MD" )
  s(   21,   "Massachusetts",                              "25",     4306,     "MA" )
  s(   22,   "Michigan",                                   "26",     4306,     "MI" )
  s(   23,   "Minnesota",                                  "27",     4306,     "MN" )
  s(   24,   "Mississippi",                                "28",     4306,     "MS" )
  s(   25,   "Missouri",                                   "29",     4306,     "MO" )
  s(   26,   "Montana",                                    "30",     4306,     "MT" )
  s(   27,   "Nebraska",                                   "31",     4306,     "NE" )
  s(   28,   "Nevada",                                     "32",     4306,     "NV" )
  s(   29,   "New Hampshire",                              "33",     4306,     "NH" )
  s(   30,   "New Jersey",                                 "34",     4306,     "NJ" )
  s(   31,   "New Mexico",                                 "35",     4306,     "NM" )
  s(   32,   "New York",                                   "36",     4306,     "NY" )
  s(   33,   "North Carolina",                             "37",     4306,     "NC" )
  s(   34,   "North Dakota",                               "38",     4306,     "ND" )
  s(   35,   "Ohio",                                       "39",     4306,     "OH" )
  s(   36,   "Oklahoma",                                   "40",     4306,     "OK" )
  s(   37,   "Oregon",                                     "41",     4306,     "OR" )
  s(   38,   "Pennsylvania",                               "42",     4306,     "PA" )
  s(   39,   "Rhode Island",                               "44",     4306,     "RI" )
  s(   40,   "South Carolina",                             "45",     4306,     "SC" )
  s(   41,   "South Dakota",                               "46",     4306,     "SD" )
  s(   42,   "Tennessee",                                  "47",     4306,     "TN" )
  s(   43,   "Texas",                                      "48",     4306,     "TX" )
  s(   44,   "Utah",                                       "49",     4306,     "UT" )
  s(   45,   "Vermont",                                    "50",     4306,     "VT" )
  s(   46,   "Virginia",                                   "51",     4306,     "VA" )
  s(   47,   "Washington",                                 "53",     4306,     "WA" )
  s(   48,   "West Virginia",                              "54",     4306,     "WV" )
  s(   49,   "Wisconsin",                                  "55",     4306,     "WI" )
  s(   50,   "Wyoming",                                    "56",     4306,     "WY" )
  s(   51,   "Armed Forces Americas",                      "",       4306,     "AA" )
  s(   52,   "Armed Forces Europe, Middle East, & Canada", "",       4306,     "AE" )
  s(   53,   "Armed Forces Pacific",                       "",       4306,     "AP" )
  s(   54,   "American Samoa",                             "03",     4306,     "AS" )
  s(   55,   "Federated States of Micronesia",             "64",     4306,     "FM" )
  s(   56,   "Guam",                                       "14",     4306,     "GU" )
  s(   57,   "Marshall Islands",                           "68",     4306,     "MH" )
  s(   58,   "Northern Mariana Islands",                   "69",     4306,     "MP" )
  s(   59,   "Puerto Rico",                                "43",     4306,     "PR" )
  s(   60,   "Palau",                                      "70",     4306,     "PW" )
  s(   61,   "Virgin Islands",                             "52",     4306,     "VI" )
  /*
  s(   62,   "Canillo",                                    "02",     4077 )
  s(   63,   "Encamp",                                     "03",     4077 )
  s(   64,   "La Massana",                                 "04",     4077 )
  s(   65,   "Ordino",                                     "05",     4077 )
  s(   66,   "Sant Julia de Loria",                        "06",     4077 )
  s(   67,   "Andorra la Vella",                           "07",     4077 )
  s(   68,   "Escaldes-Engordany",                         "08",     4077 )
  s(   69,   "Abu Dhabi",                                  "01",     4078 )
  s(   70,   "Ajman",                                      "02",     4078 )
  s(   71,   "Dubai",                                      "03",     4078 )
  s(   72,   "Fujairah",                                   "04",     4078 )
  s(   73,   "Ras Al Khaimah",                             "05",     4078 )
  s(   74,   "Sharjah",                                    "06",     4078 )
  s(   75,   "Umm Al Quwain",                              "07",     4078 )
  s(   76,   "Badakhshan",                                 "01",     4079 )
  s(   77,   "Badghis",                                    "02",     4079 )
  s(   78,   "Baghlan",                                    "03",     4079 )
  s(   79,   "Bamian",                                     "05",     4079 )
  s(   80,   "Farah",                                      "06",     4079 )
  s(   81,   "Faryab",                                     "07",     4079 )
  s(   82,   "Ghazni",                                     "08",     4079 )
  s(   83,   "Ghowr",                                      "09",     4079 )
  s(   84,   "Helmand",                                    "10",     4079 )
  s(   85,   "Herat",                                      "11",     4079 )
  s(   86,   "Kabol",                                      "13",     4079 )
  s(   87,   "Kapisa",                                     "14",     4079 )
  s(   88,   "Konar",                                      "15",     4079 )
  s(   89,   "Laghman",                                    "16",     4079 )
  s(   90,   "Lowgar",                                     "17",     4079 )
  s(   91,   "Nangarhar",                                  "18",     4079 )
  s(   92,   "Nimruz",                                     "19",     4079 )
  s(   93,   "Paktia",                                     "21",     4079 )
  s(   94,   "Parvan",                                     "22",     4079 )
  s(   95,   "Kandahar",                                   "23",     4079 )
  s(   96,   "Kondoz",                                     "24",     4079 )
  s(   97,   "Takhar",                                     "26",     4079 )
  s(   98,   "Vardak",                                     "27",     4079 )
  s(   99,   "Zabol",                                      "28",     4079 )
  s(   100,  "Paktika",                                    "29",     4079 )
  s(   101,  "Balkh",                                      "30",     4079 )
  s(   102,  "Jowzjan",                                    "31",     4079 )
  s(   103,  "Samangan",                                   "32",     4079 )
  s(   104,  "Sar-e Pol",                                  "33",     4079 )
  s(   105,  "Konar",                                      "34",     4079 )
  s(   106,  "Laghman",                                    "35",     4079 )
  s(   107,  "Paktia",                                     "36",     4079 )
  s(   108,  "Khowst",                                     "37",     4079 )
  s(   109,  "Nurestan",                                   "38",     4079 )
  s(   110,  "Oruzgan",                                    "39",     4079 )
  s(   111,  "Parvan",                                     "40",     4079 )
  s(   112,  "Daykondi",                                   "41",     4079 )
  s(   113,  "Panjshir",                                   "42",     4079 )
  s(   114,  "Barbuda",                                    "01",     4080 )
  s(   115,  "Saint George",                               "04",     4310 )
  s(   116,  "Saint John",                                 "04",     4154 )
  s(   117,  "Saint Mary",                                 "13",     4188 )
  s(   118,  "Saint Paul",                                 "10",     4135 )
  s(   119,  "Saint Peter",                                "03",     4227 )
  s(   120,  "Saint Philip",                               "08",     4080 )
  s(   121,  "Berat",                                      "40",     4082 )
  s(   122,  "Diber",                                      "41",     4082 )
  s(   123,  "Durres",                                     "42",     4082 )
  s(   124,  "Elbasan",                                    "43",     4082 )
  s(   125,  "Fier",                                       "44",     4082 )
  s(   126,  "Gjirokaster",                                "45",     4082 )
  s(   127,  "Korce",                                      "46",     4082 )
  s(   128,  "Kukes",                                      "47",     4082 )
  s(   129,  "Lezhe",                                      "48",     4082 )
  s(   130,  "Shkoder",                                    "49",     4082 )
  s(   131,  "Tirane",                                     "50",     4082 )
  s(   132,  "Vlore",                                      "51",     4082 )
  s(   133,  "Aragatsotn",                                 "01",     4083 )
  s(   134,  "Ararat",                                     "02",     4083 )
  s(   135,  "Armavir",                                    "03",     4083 )
  s(   136,  "Geghark'unik'",                              "04",     4083 )
  s(   137,  "Kotayk'",                                    "05",     4083 )
  s(   138,  "Lorri",                                      "06",     4083 )
  s(   139,  "Shirak",                                     "07",     4083 )
  s(   140,  "Syunik'",                                    "08",     4083 )
  s(   141,  "Tavush",                                     "09",     4083 )
  s(   142,  "Vayots' Dzor",                               "10",     4083 )
  s(   143,  "Yerevan",                                    "11",     4083 )
  s(   144,  "Benguela",                                   "01",     4085 )
  s(   145,  "Bie",                                        "02",     4085 )
  s(   146,  "Cabinda",                                    "03",     4085 )
  s(   147,  "Cuando Cubango",                             "04",     4085 )
  s(   148,  "Cuanza Norte",                               "05",     4085 )
  s(   149,  "Cuanza Sul",                                 "06",     4085 )
  s(   150,  "Cunene",                                     "07",     4085 )
  s(   151,  "Huambo",                                     "08",     4085 )
  s(   152,  "Huila",                                      "16",     4125 )
  s(   153,  "Luanda",                                     "10",     4085 )
  s(   154,  "Malanje",                                    "12",     4085 )
  s(   155,  "Moxico",                                     "14",     4085 )
  s(   156,  "Uige",                                       "15",     4085 )
  s(   157,  "Zaire",                                      "16",     4085 )
  s(   158,  "Lunda Norte",                                "17",     4085 )
  s(   159,  "Lunda Sul",                                  "18",     4085 )
  s(   160,  "Bengo",                                      "19",     4085 )
  s(   161,  "Luanda",                                     "20",     4085 )
  s(   162,  "Buenos Aires",                               "01",     4088 )
  s(   163,  "Catamarca",                                  "02",     4088 )
  s(   164,  "Chaco",                                      "20",     4261 )
  s(   165,  "Chubut",                                     "04",     4088 )
  s(   166,  "Cordoba",                                    "12",     4125 )
  s(   167,  "Corrientes",                                 "06",     4088 )
  s(   168,  "Distrito Federal",                           "25",     4311 )
  s(   169,  "Entre Rios",                                 "08",     4088 )
  s(   170,  "Formosa",                                    "09",     4088 )
  s(   171,  "Jujuy",                                      "10",     4088 )
  s(   172,  "La Pampa",                                   "11",     4088 )
  s(   173,  "La Rioja",                                   "27",     4143 )
  s(   174,  "Mendoza",                                    "13",     4088 )
  s(   175,  "Misiones",                                   "12",     4261 )
  s(   176,  "Neuquen",                                    "15",     4088 )
  s(   177,  "Rio Negro",                                  "12",     4307 )
  s(   178,  "Salta",                                      "17",     4088 )
  s(   179,  "San Juan",                                   "23",     4136 )
  s(   180,  "San Luis",                                   "19",     4088 )
  s(   181,  "Santa Cruz",                                 "16",     4128 )
  s(   182,  "Santa Fe",                                   "21",     4088 )
  s(   183,  "Santiago del Estero",                        "22",     4088 )
  s(   184,  "Tierra del Fuego",                           "23",     4088 )
  s(   185,  "Tucuman",                                    "24",     4088 )
  s(   186,  "Burgenland",                                 "01",     4090 )
  s(   187,  "Karnten",                                    "02",     4090 )
  s(   188,  "Niederosterreich",                           "03",     4090 )
  s(   189,  "Oberosterreich",                             "04",     4090 )
  s(   190,  "Salzburg",                                   "05",     4090 )
  s(   191,  "Steiermark",                                 "06",     4090 )
  s(   192,  "Tirol",                                      "07",     4090 )
  s(   193,  "Vorarlberg",                                 "08",     4090 )
  s(   194,  "Wien",                                       "09",     4090 )
  s(   195,  "Australian Capital Territory",               "01",     4091 )
  s(   196,  "New South Wales",                            "02",     4091 )
  s(   197,  "Northern Territory",                         "03",     4091 )
  s(   198,  "Queensland",                                 "04",     4091 )
  s(   199,  "South Australia",                            "05",     4091 )
  s(   200,  "Tasmania",                                   "06",     4091 )
  s(   201,  "Victoria",                                   "12",     4299 )
  s(   202,  "Western Australia",                          "08",     4091 )
  s(   203,  "Abseron",                                    "01",     4094 )
  s(   204,  "Agcabadi",                                   "02",     4094 )
  s(   205,  "Agdam",                                      "03",     4094 )
  s(   206,  "Agdas",                                      "04",     4094 )
  s(   207,  "Agstafa",                                    "05",     4094 )
  s(   208,  "Agsu",                                       "06",     4094 )
  s(   209,  "Ali Bayramli",                               "07",     4094 )
  s(   210,  "Astara",                                     "08",     4094 )
  s(   211,  "Baki",                                       "09",     4094 )
  s(   212,  "Balakan",                                    "10",     4094 )
  s(   213,  "Barda",                                      "11",     4094 )
  s(   214,  "Beylaqan",                                   "12",     4094 )
  s(   215,  "Bilasuvar",                                  "13",     4094 )
  s(   216,  "Cabrayil",                                   "14",     4094 )
  s(   217,  "Calilabad",                                  "15",     4094 )
  s(   218,  "Daskasan",                                   "16",     4094 )
  s(   219,  "Davaci",                                     "17",     4094 )
  s(   220,  "Fuzuli",                                     "18",     4094 )
  s(   221,  "Gadabay",                                    "19",     4094 )
  s(   222,  "Ganca",                                      "20",     4094 )
  s(   223,  "Goranboy",                                   "21",     4094 )
  s(   224,  "Goycay",                                     "22",     4094 )
  s(   225,  "Haciqabul",                                  "23",     4094 )
  s(   226,  "Imisli",                                     "24",     4094 )
  s(   227,  "Ismayilli",                                  "25",     4094 )
  s(   228,  "Kalbacar",                                   "26",     4094 )
  s(   229,  "Kurdamir",                                   "27",     4094 )
  s(   230,  "Lacin",                                      "28",     4094 )
  s(   231,  "Lankaran",                                   "29",     4094 )
  s(   232,  "Lankaran",                                   "30",     4094 )
  s(   233,  "Lerik",                                      "31",     4094 )
  s(   234,  "Masalli",                                    "32",     4094 )
  s(   235,  "Mingacevir",                                 "33",     4094 )
  s(   236,  "Naftalan",                                   "34",     4094 )
  s(   237,  "Naxcivan",                                   "35",     4094 )
  s(   238,  "Neftcala",                                   "36",     4094 )
  s(   239,  "Oguz",                                       "37",     4094 )
  s(   240,  "Qabala",                                     "38",     4094 )
  s(   241,  "Qax",                                        "39",     4094 )
  s(   242,  "Qazax",                                      "40",     4094 )
  s(   243,  "Qobustan",                                   "41",     4094 )
  s(   244,  "Quba",                                       "42",     4094 )
  s(   245,  "Qubadli",                                    "43",     4094 )
  s(   246,  "Qusar",                                      "44",     4094 )
  s(   247,  "Saatli",                                     "45",     4094 )
  s(   248,  "Sabirabad",                                  "46",     4094 )
  s(   249,  "Saki",                                       "47",     4094 )
  s(   250,  "Saki",                                       "48",     4094 )
  s(   251,  "Salyan",                                     "49",     4094 )
  s(   252,  "Samaxi",                                     "50",     4094 )
  s(   253,  "Samkir",                                     "51",     4094 )
  s(   254,  "Samux",                                      "52",     4094 )
  s(   255,  "Siyazan",                                    "53",     4094 )
  s(   256,  "Sumqayit",                                   "54",     4094 )
  s(   257,  "Susa",                                       "55",     4094 )
  s(   258,  "Susa",                                       "56",     4094 )
  s(   259,  "Tartar",                                     "57",     4094 )
  s(   260,  "Tovuz",                                      "58",     4094 )
  s(   261,  "Ucar",                                       "59",     4094 )
  s(   262,  "Xacmaz",                                     "60",     4094 )
  s(   263,  "Xankandi",                                   "61",     4094 )
  s(   264,  "Xanlar",                                     "62",     4094 )
  s(   265,  "Xizi",                                       "63",     4094 )
  s(   266,  "Xocali",                                     "64",     4094 )
  s(   267,  "Xocavand",                                   "65",     4094 )
  s(   268,  "Yardimli",                                   "66",     4094 )
  s(   269,  "Yevlax",                                     "67",     4094 )
  s(   270,  "Yevlax",                                     "68",     4094 )
  s(   271,  "Zangilan",                                   "69",     4094 )
  s(   272,  "Zaqatala",                                   "70",     4094 )
  s(   273,  "Zardab",                                     "71",     4094 )
  s(   274,  "Federation of Bosnia and Herzegovina",       "01",     4095 )
  s(   275,  "Republika Srpska",                           "02",     4095 )
  s(   276,  "Christ Church",                              "01",     4096 )
  s(   277,  "Saint Andrew",                               "02",     4310 )
  s(   278,  "Saint George",                               "03",     4096 )
  s(   279,  "Saint James",                                "12",     4188 )
  s(   280,  "Saint John",                                 "05",     4096 )
  s(   281,  "Saint Joseph",                               "06",     4135 )
  s(   282,  "Saint Lucy",                                 "07",     4096 )
  s(   283,  "Saint Michael",                              "08",     4096 )
  s(   284,  "Saint Peter",                                "09",     4096 )
  s(   285,  "Saint Philip",                               "10",     4096 )
  s(   286,  "Saint Thomas",                               "14",     4188 )
  s(   287,  "Barisal",                                    "85",     4097 )
  s(   288,  "Bandarban",                                  "04",     4097 )
  s(   289,  "Comilla",                                    "05",     4097 )
  s(   290,  "Mymensingh",                                 "12",     4097 )
  s(   291,  "Noakhali",                                   "13",     4097 )
  s(   292,  "Patuakhali",                                 "15",     4097 )
  s(   293,  "Bagerhat",                                   "22",     4097 )
  s(   294,  "Bhola",                                      "23",     4097 )
  s(   295,  "Bogra",                                      "24",     4097 )
  s(   296,  "Barguna",                                    "25",     4097 )
  s(   297,  "Brahmanbaria",                               "26",     4097 )
  s(   298,  "Chandpur",                                   "27",     4097 )
  s(   299,  "Chapai Nawabganj",                           "28",     4097 )
  s(   300,  "Chattagram",                                 "29",     4097 )
  s(   301,  "Chuadanga",                                  "30",     4097 )
  s(   302,  "Cox's Bazar",                                "31",     4097 )
  s(   303,  "Dhaka",                                      "81",     4097 )
  s(   304,  "Dinajpur",                                   "33",     4097 )
  s(   305,  "Faridpur",                                   "34",     4097 )
  s(   306,  "Feni",                                       "35",     4097 )
  s(   307,  "Gaibandha",                                  "36",     4097 )
  s(   308,  "Gazipur",                                    "37",     4097 )
  s(   309,  "Gopalganj",                                  "38",     4097 )
  s(   310,  "Habiganj",                                   "39",     4097 )
  s(   311,  "Jaipurhat",                                  "40",     4097 )
  s(   312,  "Jamalpur",                                   "41",     4097 )
  s(   313,  "Jessore",                                    "42",     4097 )
  s(   314,  "Jhalakati",                                  "43",     4097 )
  s(   315,  "Jhenaidah",                                  "44",     4097 )
  s(   316,  "Khagrachari",                                "45",     4097 )
  s(   317,  "Khulna",                                     "46",     4097 )
  s(   318,  "Kishorganj",                                 "47",     4097 )
  s(   319,  "Kurigram",                                   "48",     4097 )
  s(   320,  "Kushtia",                                    "49",     4097 )
  s(   321,  "Laksmipur",                                  "50",     4097 )
  s(   322,  "Lalmonirhat",                                "51",     4097 )
  s(   323,  "Madaripur",                                  "52",     4097 )
  s(   324,  "Magura",                                     "53",     4097 )
  s(   325,  "Manikganj",                                  "54",     4097 )
  s(   326,  "Meherpur",                                   "55",     4097 )
  s(   327,  "Moulavibazar",                               "56",     4097 )
  s(   328,  "Munshiganj",                                 "57",     4097 )
  s(   329,  "Naogaon",                                    "58",     4097 )
  s(   330,  "Narail",                                     "59",     4097 )
  s(   331,  "Narayanganj",                                "60",     4097 )
  s(   332,  "Narsingdi",                                  "61",     4097 )
  s(   333,  "Nator",                                      "62",     4097 )
  s(   334,  "Netrakona",                                  "63",     4097 )
  s(   335,  "Nilphamari",                                 "64",     4097 )
  s(   336,  "Pabna",                                      "65",     4097 )
  s(   337,  "Panchagar",                                  "66",     4097 )
  s(   338,  "Parbattya Chattagram",                       "67",     4097 )
  s(   339,  "Pirojpur",                                   "68",     4097 )
  s(   340,  "Rajbari",                                    "69",     4097 )
  s(   341,  "Rajshahi",                                   "70",     4097 )
  s(   342,  "Rangpur",                                    "71",     4097 )
  s(   343,  "Satkhira",                                   "72",     4097 )
  s(   344,  "Shariyatpur",                                "73",     4097 )
  s(   345,  "Sherpur",                                    "74",     4097 )
  s(   346,  "Sirajganj",                                  "75",     4097 )
  s(   347,  "Sunamganj",                                  "76",     4097 )
  s(   348,  "Sylhet",                                     "77",     4097 )
  s(   349,  "Tangail",                                    "78",     4097 )
  s(   350,  "Thakurgaon",                                 "79",     4097 )
  s(   351,  "Khulna",                                     "82",     4097 )
  s(   352,  "Rajshahi",                                   "83",     4097 )
  s(   353,  "Chittagong",                                 "84",     4097 )
  s(   354,  "Sylhet",                                     "86",     4097 )
  s(   355,  "Antwerpen",                                  "01",     4098 )
  s(   356,  "Brabant",                                    "02",     4098 )
  s(   357,  "Hainaut",                                    "03",     4098 )
  s(   358,  "Liege",                                      "04",     4098 )
  s(   359,  "Limburg",                                    "05",     4241 )
  s(   360,  "Luxembourg",                                 "03",     4210 )
  s(   361,  "Namur",                                      "07",     4098 )
  s(   362,  "Oost-Vlaanderen",                            "08",     4098 )
  s(   363,  "West-Vlaanderen",                            "09",     4098 )
  s(   364,  "Brabant Wallon",                             "10",     4098 )
  s(   365,  "Brussels Hoofdstedelijk Gewest",             "11",     4098 )
  s(   366,  "Vlaams-Brabant",                             "12",     4098 )
  s(   367,  "Bam",                                        "15",     4099 )
  s(   368,  "Boulkiemde",                                 "19",     4099 )
  s(   369,  "Ganzourgou",                                 "20",     4099 )
  s(   370,  "Gnagna",                                     "21",     4099 )
  s(   371,  "Kouritenga",                                 "28",     4099 )
  s(   372,  "Oudalan",                                    "33",     4099 )
  s(   373,  "Passore",                                    "34",     4099 )
  s(   374,  "Sanguie",                                    "36",     4099 )
  s(   375,  "Soum",                                       "40",     4099 )
  s(   376,  "Tapoa",                                      "42",     4099 )
  s(   377,  "Zoundweogo",                                 "44",     4099 )
  s(   378,  "Bale",                                       "45",     4099 )
  s(   379,  "Banwa",                                      "46",     4099 )
  s(   380,  "Bazega",                                     "47",     4099 )
  s(   381,  "Bougouriba",                                 "48",     4099 )
  s(   382,  "Boulgou",                                    "49",     4099 )
  s(   383,  "Gourma",                                     "50",     4099 )
  s(   384,  "Houet",                                      "51",     4099 )
  s(   385,  "Ioba",                                       "52",     4099 )
  s(   386,  "Kadiogo",                                    "53",     4099 )
  s(   387,  "Kenedougou",                                 "54",     4099 )
  s(   388,  "Komoe",                                      "55",     4099 )
  s(   389,  "Komondjari",                                 "56",     4099 )
  s(   390,  "Kompienga",                                  "57",     4099 )
  s(   391,  "Kossi",                                      "58",     4099 )
  s(   392,  "Koulpelogo",                                 "59",     4099 )
  s(   393,  "Kourweogo",                                  "60",     4099 )
  s(   394,  "Leraba",                                     "61",     4099 )
  s(   395,  "Loroum",                                     "62",     4099 )
  s(   396,  "Mouhoun",                                    "63",     4099 )
  s(   397,  "Namentenga",                                 "64",     4099 )
  s(   398,  "Naouri",                                     "65",     4099 )
  s(   399,  "Nayala",                                     "66",     4099 )
  s(   400,  "Noumbiel",                                   "67",     4099 )
  s(   401,  "Oubritenga",                                 "68",     4099 )
  s(   402,  "Poni",                                       "69",     4099 )
  s(   403,  "Sanmatenga",                                 "70",     4099 )
  s(   404,  "Seno",                                       "71",     4099 )
  s(   405,  "Sissili",                                    "72",     4099 )
  s(   406,  "Sourou",                                     "73",     4099 )
  s(   407,  "Tuy",                                        "74",     4099 )
  s(   408,  "Yagha",                                      "75",     4099 )
  s(   409,  "Yatenga",                                    "76",     4099 )
  s(   410,  "Ziro",                                       "77",     4099 )
  s(   411,  "Zondoma",                                    "78",     4099 )
  s(   412,  "Mikhaylovgrad",                              "33",     4100 )
  s(   413,  "Blagoevgrad",                                "38",     4100 )
  s(   414,  "Burgas",                                     "39",     4100 )
  s(   415,  "Dobrich",                                    "40",     4100 )
  s(   416,  "Gabrovo",                                    "41",     4100 )
  s(   417,  "Grad Sofiya",                                "42",     4100 )
  s(   418,  "Khaskovo",                                   "43",     4100 )
  s(   419,  "Kurdzhali",                                  "44",     4100 )
  s(   420,  "Kyustendil",                                 "45",     4100 )
  s(   421,  "Lovech",                                     "46",     4100 )
  s(   422,  "Pazardzhik",                                 "48",     4100 )
  s(   423,  "Pernik",                                     "49",     4100 )
  s(   424,  "Pleven",                                     "50",     4100 )
  s(   425,  "Plovdiv",                                    "51",     4100 )
  s(   426,  "Razgrad",                                    "52",     4100 )
  s(   427,  "Ruse",                                       "L3",     4275 )
  s(   428,  "Shumen",                                     "54",     4100 )
  s(   429,  "Silistra",                                   "55",     4100 )
  s(   430,  "Sliven",                                     "56",     4100 )
  s(   431,  "Smolyan",                                    "57",     4100 )
  s(   432,  "Sofiya",                                     "58",     4100 )
  s(   433,  "Stara Zagora",                               "59",     4100 )
  s(   434,  "Turgovishte",                                "60",     4100 )
  s(   435,  "Varna",                                      "61",     4100 )
  s(   436,  "Veliko Turnovo",                             "62",     4100 )
  s(   437,  "Vidin",                                      "63",     4100 )
  s(   438,  "Vratsa",                                     "64",     4100 )
  s(   439,  "Yambol",                                     "65",     4100 )
  s(   440,  "Al Hadd",                                    "01",     4101 )
  s(   441,  "Al Manamah",                                 "02",     4101 )
  s(   442,  "Al Muharraq",                                "03",     4101 )
  s(   443,  "Jidd Hafs",                                  "05",     4101 )
  s(   444,  "Sitrah",                                     "06",     4101 )
  s(   445,  "Al Mintaqah al Gharbiyah",                   "08",     4101 )
  s(   446,  "Mintaqat Juzur Hawar",                       "09",     4101 )
  s(   447,  "Al Mintaqah ash Shamaliyah",                 "10",     4101 )
  s(   448,  "Al Mintaqah al Wusta",                       "11",     4101 )
  s(   449,  "Madinat",                                    "12",     4101 )
  s(   450,  "Ar Rifa",                                    "13",     4101 )
  s(   451,  "Madinat Hamad",                              "14",     4101 )
  s(   452,  "Al Muharraq",                                "15",     4101 )
  s(   453,  "Al Asimah",                                  "16",     4101 )
  s(   454,  "Al Janubiyah",                               "17",     4101 )
  s(   455,  "Ash Shamaliyah",                             "30",     4271 )
  s(   456,  "Al Wusta",                                   "27",     4271 )
  s(   457,  "Bujumbura",                                  "02",     4102 )
  s(   458,  "Bubanza",                                    "09",     4102 )
  s(   459,  "Bururi",                                     "10",     4102 )
  s(   460,  "Cankuzo",                                    "11",     4102 )
  s(   461,  "Cibitoke",                                   "12",     4102 )
  s(   462,  "Gitega",                                     "13",     4102 )
  s(   463,  "Karuzi",                                     "14",     4102 )
  s(   464,  "Kayanza",                                    "15",     4102 )
  s(   465,  "Kirundo",                                    "16",     4102 )
  s(   466,  "Makamba",                                    "17",     4102 )
  s(   467,  "Muyinga",                                    "18",     4102 )
  s(   468,  "Ngozi",                                      "19",     4102 )
  s(   469,  "Rutana",                                     "20",     4102 )
  s(   470,  "Ruyigi",                                     "21",     4102 )
  s(   471,  "Muramvya",                                   "22",     4102 )
  s(   472,  "Mwaro",                                      "23",     4102 )
  s(   473,  "Atakora",                                    "01",     4103 )
  s(   474,  "Atlantique",                                 "02",     4103 )
  s(   475,  "Borgou",                                     "03",     4103 )
  s(   476,  "Mono",                                       "04",     4103 )
  s(   477,  "Oueme",                                      "05",     4103 )
  s(   478,  "Zou",                                        "06",     4103 )
  s(   479,  "Littoral",                                   "05",     4123 )
  s(   480,  "Devonshire",                                 "01",     4104 )
  s(   481,  "Hamilton",                                   "02",     4104 )
  s(   482,  "Hamilton",                                   "03",     4104 )
  s(   483,  "Paget",                                      "04",     4104 )
  s(   484,  "Pembroke",                                   "05",     4104 )
  s(   485,  "Saint George's",                             "07",     4104 )
  s(   486,  "Sandys",                                     "08",     4104 )
  s(   487,  "Smiths",                                     "09",     4104 )
  s(   488,  "Southampton",                                "M4",     4153 )
  s(   489,  "Warwick",                                    "11",     4104 )
  s(   490,  "Alibori",                                    "07",     4105 )
  s(   491,  "Belait",                                     "08",     4105 )
  s(   492,  "Brunei and Muara",                           "09",     4105 )
  s(   493,  "Temburong",                                  "10",     4105 )
  s(   494,  "Collines",                                   "11",     4105 )
  s(   495,  "Kouffo",                                     "12",     4105 )
  s(   496,  "Donga",                                      "13",     4105 )
  s(   497,  "Littoral",                                   "14",     4105 )
  s(   498,  "Tutong",                                     "15",     4105 )
  s(   499,  "Oueme",                                      "16",     4105 )
  s(   500,  "Plateau",                                    "49",     4239 )
  s(   501,  "Zou",                                        "18",     4105 )
  s(   502,  "Chuquisaca",                                 "01",     4106 )
  s(   503,  "Cochabamba",                                 "02",     4106 )
  s(   504,  "El Beni",                                    "03",     4106 )
  s(   505,  "La Paz",                                     "06",     4284 )
  s(   506,  "Oruro",                                      "05",     4106 )
  s(   507,  "Pando",                                      "06",     4106 )
  s(   508,  "Potosi",                                     "07",     4106 )
  s(   509,  "Tarija",                                     "09",     4106 )
  s(   510,  "Acre",                                       "01",     4107 )
  s(   511,  "Alagoas",                                    "02",     4107 )
  s(   512,  "Amapa",                                      "03",     4107 )
  s(   513,  "Amazonas",                                   "01",     4311 )
  s(   514,  "Bahia",                                      "05",     4107 )
  s(   515,  "Ceara",                                      "06",     4107 )
  s(   516,  "Espirito Santo",                             "08",     4107 )
  s(   517,  "Mato Grosso do Sul",                         "11",     4107 )
  s(   518,  "Maranhao",                                   "13",     4107 )
  s(   519,  "Mato Grosso",                                "14",     4107 )
  s(   520,  "Minas Gerais",                               "15",     4107 )
  s(   521,  "Para",                                       "15",     4282 )
  s(   522,  "Paraiba",                                    "17",     4107 )
  s(   523,  "Parana",                                     "18",     4107 )
  s(   524,  "Piaui",                                      "20",     4107 )
  s(   525,  "Rio de Janeiro",                             "21",     4107 )
  s(   526,  "Rio Grande do Norte",                        "22",     4107 )
  s(   527,  "Rio Grande do Sul",                          "23",     4107 )
  s(   528,  "Rondonia",                                   "24",     4107 )
  s(   529,  "Roraima",                                    "25",     4107 )
  s(   530,  "Santa Catarina",                             "15",     4128 )
  s(   531,  "Sao Paulo",                                  "27",     4107 )
  s(   532,  "Sergipe",                                    "28",     4107 )
  s(   533,  "Goias",                                      "29",     4107 )
  s(   534,  "Pernambuco",                                 "30",     4107 )
  s(   535,  "Tocantins",                                  "31",     4107 )
  s(   536,  "Bimini",                                     "05",     4108 )
  s(   537,  "Cat Island",                                 "06",     4108 )
  s(   538,  "Exuma",                                      "10",     4108 )
  s(   539,  "Inagua",                                     "13",     4108 )
  s(   540,  "Long Island",                                "15",     4108 )
  s(   541,  "Mayaguana",                                  "16",     4108 )
  s(   542,  "Ragged Island",                              "18",     4108 )
  s(   543,  "Harbour Island",                             "22",     4108 )
  s(   544,  "New Providence",                             "23",     4108 )
  s(   545,  "Acklins and Crooked Islands",                "24",     4108 )
  s(   546,  "Freeport",                                   "25",     4108 )
  s(   547,  "Fresh Creek",                                "26",     4108 )
  s(   548,  "Governor's Harbour",                         "27",     4108 )
  s(   549,  "Green Turtle Cay",                           "28",     4108 )
  s(   550,  "High Rock",                                  "29",     4108 )
  s(   551,  "Kemps Bay",                                  "30",     4108 )
  s(   552,  "Marsh Harbour",                              "31",     4108 )
  s(   553,  "Nichollstown and Berry Islands",             "32",     4108 )
  s(   554,  "Rock Sound",                                 "33",     4108 )
  s(   555,  "Sandy Point",                                "34",     4108 )
  s(   556,  "San Salvador and Rum Cay",                   "35",     4108 )
  s(   557,  "Bumthang",                                   "05",     4109 )
  s(   558,  "Chhukha",                                    "06",     4109 )
  s(   559,  "Chirang",                                    "07",     4109 )
  s(   560,  "Daga",                                       "08",     4109 )
  s(   561,  "Geylegphug",                                 "09",     4109 )
  s(   562,  "Ha",                                         "01",     4297 )
  s(   563,  "Lhuntshi",                                   "11",     4109 )
  s(   564,  "Mongar",                                     "12",     4109 )
  s(   565,  "Paro",                                       "13",     4109 )
  s(   566,  "Pemagatsel",                                 "14",     4109 )
  s(   567,  "Punakha",                                    "15",     4109 )
  s(   568,  "Samchi",                                     "16",     4109 )
  s(   569,  "Samdrup",                                    "17",     4109 )
  s(   570,  "Shemgang",                                   "18",     4109 )
  s(   571,  "Tashigang",                                  "19",     4109 )
  s(   572,  "Thimphu",                                    "20",     4109 )
  s(   573,  "Tongsa",                                     "21",     4109 )
  s(   574,  "Wangdi Phodrang",                            "22",     4109 )
  s(   575,  "Central",                                    "02",     4321 )
  s(   576,  "Ghanzi",                                     "03",     4111 )
  s(   577,  "Kgalagadi",                                  "04",     4111 )
  s(   578,  "Kgatleng",                                   "05",     4111 )
  s(   579,  "Kweneng",                                    "06",     4111 )
  s(   580,  "North-East",                                 "08",     4111 )
  s(   581,  "South-East",                                 "09",     4111 )
  s(   582,  "Southern",                                   "07",     4321 )
  s(   583,  "North-West",                                 "10",     4320 )
  s(   584,  "Brestskaya Voblasts'",                       "01",     4112 )
  s(   585,  "Homyel'skaya Voblasts'",                     "02",     4112 )
  s(   586,  "Hrodzyenskaya Voblasts'",                    "03",     4112 )
  s(   587,  "Minsk",                                      "04",     4112 )
  s(   588,  "Minskaya Voblasts'",                         "05",     4112 )
  s(   589,  "Mahilyowskaya Voblasts'",                    "06",     4112 )
  s(   590,  "Vitsyebskaya Voblasts'",                     "07",     4112 )
  s(   591,  "Belize District",                            "01",     4113 )
  s(   592,  "Cayo",                                       "02",     4113 )
  s(   593,  "Corozal",                                    "03",     4113 )
  s(   594,  "Orange Walk",                                "04",     4113 )
  s(   595,  "Stann Creek",                                "05",     4113 )
  s(   596,  "Toledo",                                     "G5",     4252 )
  s(   597,  "Alberta",                                    "01",     4114 )
  s(   598,  "British Columbia",                           "02",     4114 )
  s(   599,  "Manitoba",                                   "03",     4114 )
  s(   600,  "New Brunswick",                              "04",     4114 )
  s(   601,  "Newfoundland and Labrador",                  "05",     4114 )
  s(   602,  "Nova Scotia",                                "07",     4114 )
  s(   603,  "Ontario",                                    "08",     4114 )
  s(   604,  "Prince Edward Island",                       "09",     4114 )
  s(   605,  "Quebec",                                     "10",     4114 )
  s(   606,  "Saskatchewan",                               "11",     4114 )
  s(   607,  "Yukon Territory",                            "12",     4114 )
  s(   608,  "Northwest Territories",                      "13",     4114 )
  s(   609,  "Nunavut",                                    "14",     4114 )
  s(   610,  "Bandundu",                                   "01",     4116 )
  s(   611,  "Equateur",                                   "02",     4116 )
  s(   612,  "Kasai-Oriental",                             "04",     4116 )
  s(   613,  "Katanga",                                    "05",     4116 )
  s(   614,  "Kinshasa",                                   "06",     4116 )
  s(   615,  "Kivu",                                       "07",     4116 )
  s(   616,  "Bas-Congo",                                  "08",     4116 )
  s(   617,  "Orientale",                                  "09",     4116 )
  s(   618,  "Maniema",                                    "10",     4116 )
  s(   619,  "Nord-Kivu",                                  "11",     4116 )
  s(   620,  "Sud-Kivu",                                   "12",     4116 )
  s(   621,  "Cuvette",                                    "13",     4116 )
  s(   622,  "Bamingui-Bangoran",                          "01",     4117 )
  s(   623,  "Basse-Kotto",                                "02",     4117 )
  s(   624,  "Haute-Kotto",                                "03",     4117 )
  s(   625,  "Mambere-Kadei",                              "04",     4117 )
  s(   626,  "Haut-Mbomou",                                "05",     4117 )
  s(   627,  "Kemo",                                       "06",     4117 )
  s(   628,  "Lobaye",                                     "07",     4117 )
  s(   629,  "Mbomou",                                     "08",     4117 )
  s(   630,  "Nana-Mambere",                               "09",     4117 )
  s(   631,  "Ouaka",                                      "11",     4117 )
  s(   632,  "Ouham",                                      "12",     4117 )
  s(   633,  "Ouham-Pende",                                "13",     4117 )
  s(   634,  "Vakaga",                                     "14",     4117 )
  s(   635,  "Nana-Grebizi",                               "15",     4117 )
  s(   636,  "Sangha-Mbaere",                              "16",     4117 )
  s(   637,  "Ombella-Mpoko",                              "17",     4117 )
  s(   638,  "Bangui",                                     "18",     4117 )
  s(   639,  "Bouenza",                                    "01",     4118 )
  s(   640,  "Cuvette",                                    "03",     4118 )
  s(   641,  "Kouilou",                                    "04",     4118 )
  s(   642,  "Lekoumou",                                   "05",     4118 )
  s(   643,  "Likouala",                                   "06",     4118 )
  s(   644,  "Niari",                                      "07",     4118 )
  s(   645,  "Plateaux",                                   "25",     4290 )
  s(   646,  "Sangha",                                     "10",     4118 )
  s(   647,  "Pool",                                       "11",     4118 )
  s(   648,  "Brazzaville",                                "12",     4118 )
  s(   649,  "Aargau",                                     "01",     4119 )
  s(   650,  "Ausser-Rhoden",                              "02",     4119 )
  s(   651,  "Basel-Landschaft",                           "03",     4119 )
  s(   652,  "Basel-Stadt",                                "04",     4119 )
  s(   653,  "Bern",                                       "05",     4119 )
  s(   654,  "Fribourg",                                   "06",     4119 )
  s(   655,  "Geneve",                                     "07",     4119 )
  s(   656,  "Glarus",                                     "08",     4119 )
  s(   657,  "Graubunden",                                 "09",     4119 )
  s(   658,  "Inner-Rhoden",                               "10",     4119 )
  s(   659,  "Luzern",                                     "11",     4119 )
  s(   660,  "Neuchatel",                                  "12",     4119 )
  s(   661,  "Nidwalden",                                  "13",     4119 )
  s(   662,  "Obwalden",                                   "14",     4119 )
  s(   663,  "Sankt Gallen",                               "15",     4119 )
  s(   664,  "Schaffhausen",                               "16",     4119 )
  s(   665,  "Schwyz",                                     "17",     4119 )
  s(   666,  "Solothurn",                                  "18",     4119 )
  s(   667,  "Thurgau",                                    "19",     4119 )
  s(   668,  "Ticino",                                     "20",     4119 )
  s(   669,  "Uri",                                        "21",     4119 )
  s(   670,  "Valais",                                     "22",     4119 )
  s(   671,  "Vaud",                                       "23",     4119 )
  s(   672,  "Zug",                                        "24",     4119 )
  s(   673,  "Zurich",                                     "25",     4119 )
  s(   674,  "Jura",                                       "26",     4119 )
  s(   675,  "Sassandra",                                  "51",     4120 )
  s(   676,  "Abidjan",                                    "61",     4120 )
  s(   677,  "Agneby",                                     "74",     4120 )
  s(   678,  "Bafing",                                     "75",     4120 )
  s(   679,  "Bas-Sassandra",                              "76",     4120 )
  s(   680,  "Denguele",                                   "77",     4120 )
  s(   681,  "Dix-Huit Montagnes",                         "78",     4120 )
  s(   682,  "Fromager",                                   "79",     4120 )
  s(   683,  "Haut-Sassandra",                             "80",     4120 )
  s(   684,  "Lacs",                                       "81",     4120 )
  s(   685,  "Lagunes",                                    "82",     4120 )
  s(   686,  "Marahoue",                                   "83",     4120 )
  s(   687,  "Moyen-Cavally",                              "84",     4120 )
  s(   688,  "Moyen-Comoe",                                "85",     4120 )
  s(   689,  "N'zi-Comoe",                                 "86",     4120 )
  s(   690,  "Savanes",                                    "26",     4290 )
  s(   691,  "Sud-Bandama",                                "88",     4120 )
  s(   692,  "Sud-Comoe",                                  "89",     4120 )
  s(   693,  "Vallee du Bandama",                          "90",     4120 )
  s(   694,  "Worodougou",                                 "91",     4120 )
  s(   695,  "Zanzan",                                     "92",     4120 )
  s(   696,  "Valparaiso",                                 "01",     4122 )
  s(   697,  "Aisen del General Carlos Ibanez del Campo",  "02",     4122 )
  s(   698,  "Antofagasta",                                "03",     4122 )
  s(   699,  "Araucania",                                  "04",     4122 )
  s(   700,  "Atacama",                                    "05",     4122 )
  s(   701,  "Bio-Bio",                                    "06",     4122 )
  s(   702,  "Coquimbo",                                   "07",     4122 )
  s(   703,  "Libertador General Bernardo O'Higgins",      "08",     4122 )
  s(   704,  "Los Lagos",                                  "09",     4122 )
  s(   705,  "Magallanes y de la Antartica Chilena",       "10",     4122 )
  s(   706,  "Maule",                                      "11",     4122 )
  s(   707,  "Region Metropolitana",                       "12",     4122 )
  s(   708,  "Tarapaca",                                   "13",     4122 )
  s(   709,  "Est",                                        "11",     4267 )
  s(   710,  "Nord-Ouest",                                 "03",     4175 )
  s(   711,  "Ouest",                                      "14",     4267 )
  s(   712,  "Sud-Ouest",                                  "09",     4123 )
  s(   713,  "Adamaoua",                                   "10",     4123 )
  s(   714,  "Centre",                                     "07",     4175 )
  s(   715,  "Extreme-Nord",                               "12",     4123 )
  s(   716,  "Nord",                                       "13",     4267 )
  s(   717,  "Sud",                                        "15",     4267 )
  s(   718,  "Anhui",                                      "01",     4124 )
  s(   719,  "Zhejiang",                                   "02",     4124 )
  s(   720,  "Jiangxi",                                    "03",     4124 )
  s(   721,  "Jiangsu",                                    "04",     4124 )
  s(   722,  "Jilin",                                      "05",     4124 )
  s(   723,  "Qinghai",                                    "06",     4124 )
  s(   724,  "Fujian",                                     "07",     4124 )
  s(   725,  "Heilongjiang",                               "08",     4124 )
  s(   726,  "Henan",                                      "09",     4124 )
  s(   727,  "Hebei",                                      "10",     4124 )
  s(   728,  "Hunan",                                      "11",     4124 )
  s(   729,  "Hubei",                                      "12",     4124 )
  s(   730,  "Xinjiang",                                   "13",     4124 )
  s(   731,  "Xizang",                                     "14",     4124 )
  s(   732,  "Gansu",                                      "15",     4124 )
  s(   733,  "Guangxi",                                    "16",     4124 )
  s(   734,  "Guizhou",                                    "18",     4124 )
  s(   735,  "Liaoning",                                   "19",     4124 )
  s(   736,  "Nei Mongol",                                 "20",     4124 )
  s(   737,  "Ningxia",                                    "21",     4124 )
  s(   738,  "Beijing",                                    "22",     4124 )
  s(   739,  "Shanghai",                                   "23",     4124 )
  s(   740,  "Shanxi",                                     "24",     4124 )
  s(   741,  "Shandong",                                   "25",     4124 )
  s(   742,  "Shaanxi",                                    "26",     4124 )
  s(   743,  "Tianjin",                                    "28",     4124 )
  s(   744,  "Yunnan",                                     "29",     4124 )
  s(   745,  "Guangdong",                                  "30",     4124 )
  s(   746,  "Hainan",                                     "31",     4124 )
  s(   747,  "Sichuan",                                    "32",     4124 )
  s(   748,  "Chongqing",                                  "33",     4124 )
  s(   749,  "Antioquia",                                  "02",     4125 )
  s(   750,  "Arauca",                                     "03",     4125 )
  s(   751,  "Atlantico",                                  "04",     4125 )
  s(   752,  "Bolivar Department",                         "05",     4125 )
  s(   753,  "Boyaca Department",                          "06",     4125 )
  s(   754,  "Caldas Department",                          "07",     4125 )
  s(   755,  "Caqueta",                                    "08",     4125 )
  s(   756,  "Cauca",                                      "09",     4125 )
  s(   757,  "Cesar",                                      "10",     4125 )
  s(   758,  "Choco",                                      "11",     4125 )
  s(   759,  "Guaviare",                                   "14",     4125 )
  s(   760,  "Guainia",                                    "15",     4125 )
  s(   761,  "La Guajira",                                 "17",     4125 )
  s(   762,  "Magdalena Department",                       "18",     4125 )
  s(   763,  "Meta",                                       "19",     4125 )
  s(   764,  "Narino",                                     "20",     4125 )
  s(   765,  "Norte de Santander",                         "21",     4125 )
  s(   766,  "Putumayo",                                   "22",     4125 )
  s(   767,  "Quindio",                                    "23",     4125 )
  s(   768,  "Risaralda",                                  "24",     4125 )
  s(   769,  "San Andres y Providencia",                   "25",     4125 )
  s(   770,  "Santander",                                  "26",     4125 )
  s(   771,  "Sucre",                                      "19",     4311 )
  s(   772,  "Tolima",                                     "28",     4125 )
  s(   773,  "Valle del Cauca",                            "29",     4125 )
  s(   774,  "Vaupes",                                     "30",     4125 )
  s(   775,  "Vichada",                                    "31",     4125 )
  s(   776,  "Casanare",                                   "32",     4125 )
  s(   777,  "Cundinamarca",                               "33",     4125 )
  s(   778,  "Distrito Especial",                          "34",     4125 )
  s(   779,  "Bolivar",                                    "06",     4311 )
  s(   780,  "Boyaca",                                     "36",     4125 )
  s(   781,  "Caldas",                                     "37",     4125 )
  s(   782,  "Magdalena",                                  "38",     4125 )
  s(   783,  "Alajuela",                                   "01",     4126 )
  s(   784,  "Cartago",                                    "02",     4126 )
  s(   785,  "Guanacaste",                                 "03",     4126 )
  s(   786,  "Heredia",                                    "04",     4126 )
  s(   787,  "Limon",                                      "06",     4126 )
  s(   788,  "Puntarenas",                                 "07",     4126 )
  s(   789,  "San Jose",                                   "16",     4307 )
  s(   790,  "Pinar del Rio",                              "01",     4127 )
  s(   791,  "Ciudad de la Habana",                        "02",     4127 )
  s(   792,  "Matanzas",                                   "03",     4127 )
  s(   793,  "Isla de la Juventud",                        "04",     4127 )
  s(   794,  "Camaguey",                                   "05",     4127 )
  s(   795,  "Ciego de Avila",                             "07",     4127 )
  s(   796,  "Cienfuegos",                                 "08",     4127 )
  s(   797,  "Granma",                                     "09",     4127 )
  s(   798,  "Guantanamo",                                 "10",     4127 )
  s(   799,  "La Habana",                                  "11",     4127 )
  s(   800,  "Holguin",                                    "12",     4127 )
  s(   801,  "Las Tunas",                                  "13",     4127 )
  s(   802,  "Sancti Spiritus",                            "14",     4127 )
  s(   803,  "Santiago de Cuba",                           "15",     4127 )
  s(   804,  "Villa Clara",                                "16",     4127 )
  s(   805,  "Boa Vista",                                  "01",     4128 )
  s(   806,  "Brava",                                      "02",     4128 )
  s(   807,  "Maio",                                       "04",     4128 )
  s(   808,  "Paul",                                       "05",     4128 )
  s(   809,  "Ribeira Grande",                             "07",     4128 )
  s(   810,  "Sal",                                        "08",     4128 )
  s(   811,  "Sao Nicolau",                                "10",     4128 )
  s(   812,  "Sao Vicente",                                "11",     4128 )
  s(   813,  "Mosteiros",                                  "13",     4128 )
  s(   814,  "Praia",                                      "14",     4128 )
  s(   815,  "Sao Domingos",                               "17",     4128 )
  s(   816,  "Sao Filipe",                                 "18",     4128 )
  s(   817,  "Sao Miguel",                                 "19",     4128 )
  s(   818,  "Tarrafal",                                   "20",     4128 )
  s(   819,  "Famagusta",                                  "01",     4130 )
  s(   820,  "Kyrenia",                                    "02",     4130 )
  s(   821,  "Larnaca",                                    "03",     4130 )
  s(   822,  "Nicosia",                                    "04",     4130 )
  s(   823,  "Limassol",                                   "05",     4130 )
  s(   824,  "Paphos",                                     "06",     4130 )
  s(   825,  "Blansko",                                    "03",     4131 )
  s(   826,  "Breclav",                                    "04",     4131 )
  s(   827,  "Hradec Kralove",                             "20",     4131 )
  s(   828,  "Jablonec nad Nisou",                         "21",     4131 )
  s(   829,  "Jicin",                                      "23",     4131 )
  s(   830,  "Jihlava",                                    "24",     4131 )
  s(   831,  "Kolin",                                      "30",     4131 )
  s(   832,  "Liberec",                                    "33",     4131 )
  s(   833,  "Melnik",                                     "36",     4131 )
  s(   834,  "Mlada Boleslav",                             "37",     4131 )
  s(   835,  "Nachod",                                     "39",     4131 )
  s(   836,  "Nymburk",                                    "41",     4131 )
  s(   837,  "Pardubice",                                  "45",     4131 )
  s(   838,  "Hlavni mesto Praha",                         "52",     4131 )
  s(   839,  "Semily",                                     "61",     4131 )
  s(   840,  "Trutnov",                                    "70",     4131 )
  s(   841,  "Jihomoravsky kraj",                          "78",     4131 )
  s(   842,  "Jihocesky kraj",                             "79",     4131 )
  s(   843,  "Vysocina",                                   "80",     4131 )
  s(   844,  "Karlovarsky kraj",                           "81",     4131 )
  s(   845,  "Kralovehradecky kraj",                       "82",     4131 )
  s(   846,  "Liberecky kraj",                             "83",     4131 )
  s(   847,  "Olomoucky kraj",                             "84",     4131 )
  s(   848,  "Moravskoslezsky kraj",                       "85",     4131 )
  s(   849,  "Pardubicky kraj",                            "86",     4131 )
  s(   850,  "Plzensky kraj",                              "87",     4131 )
  s(   851,  "Stredocesky kraj",                           "88",     4131 )
  s(   852,  "Ustecky kraj",                               "89",     4131 )
  s(   853,  "Zlinsky kraj",                               "90",     4131 )
  s(   854,  "Baden-Wurttemberg",                          "01",     4132 )
  s(   855,  "Bayern",                                     "02",     4132 )
  s(   856,  "Bremen",                                     "03",     4132 )
  s(   857,  "Hamburg",                                    "04",     4132 )
  s(   858,  "Hessen",                                     "05",     4132 )
  s(   859,  "Niedersachsen",                              "06",     4132 )
  s(   860,  "Nordrhein-Westfalen",                        "07",     4132 )
  s(   861,  "Rheinland-Pfalz",                            "08",     4132 )
  s(   862,  "Saarland",                                   "09",     4132 )
  s(   863,  "Schleswig-Holstein",                         "10",     4132 )
  s(   864,  "Brandenburg",                                "11",     4132 )
  s(   865,  "Mecklenburg-Vorpommern",                     "12",     4132 )
  s(   866,  "Sachsen",                                    "13",     4132 )
  s(   867,  "Sachsen-Anhalt",                             "14",     4132 )
  s(   868,  "Thuringen",                                  "15",     4132 )
  s(   869,  "Berlin",                                     "16",     4132 )
  s(   870,  "Ali Sabieh",                                 "01",     4133 )
  s(   871,  "Obock",                                      "04",     4133 )
  s(   872,  "Tadjoura",                                   "05",     4133 )
  s(   873,  "Dikhil",                                     "06",     4133 )
  s(   874,  "Djibouti",                                   "07",     4133 )
  s(   875,  "Arta",                                       "20",     4165 )
  s(   876,  "Arhus",                                      "01",     4134 )
  s(   877,  "Bornholm",                                   "02",     4134 )
  s(   878,  "Frederiksborg",                              "03",     4134 )
  s(   879,  "Fyn",                                        "04",     4134 )
  s(   880,  "Kobenhavn",                                  "05",     4134 )
  s(   881,  "Staden Kobenhavn",                           "06",     4134 )
  s(   882,  "Nordjylland",                                "07",     4134 )
  s(   883,  "Ribe",                                       "08",     4134 )
  s(   884,  "Ringkobing",                                 "09",     4134 )
  s(   885,  "Roskilde",                                   "10",     4134 )
  s(   886,  "Sonderjylland",                              "11",     4134 )
  s(   887,  "Storstrom",                                  "12",     4134 )
  s(   888,  "Vejle",                                      "13",     4134 )
  s(   889,  "Vestsjalland",                               "14",     4134 )
  s(   890,  "Viborg",                                     "15",     4134 )
  s(   891,  "Hovedstaden",                                "17",     4134 )
  s(   892,  "Midtjyllen",                                 "18",     4134 )
  s(   893,  "Nordjylland",                                "19",     4134 )
  s(   894,  "Sjelland",                                   "20",     4134 )
  s(   895,  "Syddanmark",                                 "21",     4134 )
  s(   896,  "Saint David",                                "03",     4310 )
  s(   897,  "Saint Luke",                                 "07",     4135 )
  s(   898,  "Saint Mark",                                 "05",     4154 )
  s(   899,  "Saint Patrick",                              "05",     4310 )
  s(   900,  "Azua",                                       "01",     4136 )
  s(   901,  "Baoruco",                                    "02",     4136 )
  s(   902,  "Barahona",                                   "03",     4136 )
  s(   903,  "Dajabon",                                    "04",     4136 )
  s(   904,  "Distrito Nacional",                          "05",     4136 )
  s(   905,  "Duarte",                                     "06",     4136 )
  s(   906,  "Espaillat",                                  "08",     4136 )
  s(   907,  "Independencia",                              "09",     4136 )
  s(   908,  "La Altagracia",                              "10",     4136 )
  s(   909,  "Elias Pina",                                 "11",     4136 )
  s(   910,  "La Romana",                                  "12",     4136 )
  s(   911,  "Maria Trinidad Sanchez",                     "14",     4136 )
  s(   912,  "Monte Cristi",                               "15",     4136 )
  s(   913,  "Pedernales",                                 "16",     4136 )
  s(   914,  "Peravia",                                    "17",     4136 )
  s(   915,  "Puerto Plata",                               "18",     4136 )
  s(   916,  "Salcedo",                                    "19",     4136 )
  s(   917,  "Samana",                                     "20",     4136 )
  s(   918,  "Sanchez Ramirez",                            "21",     4136 )
  s(   919,  "San Pedro De Macoris",                       "24",     4136 )
  s(   920,  "Santiago",                                   "25",     4136 )
  s(   921,  "Santiago Rodriguez",                         "26",     4136 )
  s(   922,  "Valverde",                                   "27",     4136 )
  s(   923,  "El Seibo",                                   "28",     4136 )
  s(   924,  "Hato Mayor",                                 "29",     4136 )
  s(   925,  "La Vega",                                    "30",     4136 )
  s(   926,  "Monsenor Nouel",                             "31",     4136 )
  s(   927,  "Monte Plata",                                "32",     4136 )
  s(   928,  "San Cristobal",                              "33",     4136 )
  s(   929,  "Distrito Nacional",                          "34",     4136 )
  s(   930,  "Peravia",                                    "35",     4136 )
  s(   931,  "San Jose de Ocoa",                           "36",     4136 )
  s(   932,  "Santo Domingo",                              "37",     4136 )
  s(   933,  "Alger",                                      "01",     4137 )
  s(   934,  "Batna",                                      "03",     4137 )
  s(   935,  "Constantine",                                "04",     4137 )
  s(   936,  "Medea",                                      "06",     4137 )
  s(   937,  "Mostaganem",                                 "07",     4137 )
  s(   938,  "Oran",                                       "09",     4137 )
  s(   939,  "Saida",                                      "10",     4137 )
  s(   940,  "Setif",                                      "12",     4137 )
  s(   941,  "Tiaret",                                     "13",     4137 )
  s(   942,  "Tizi Ouzou",                                 "14",     4137 )
  s(   943,  "Tlemcen",                                    "15",     4137 )
  s(   944,  "Bejaia",                                     "18",     4137 )
  s(   945,  "Biskra",                                     "19",     4137 )
  s(   946,  "Blida",                                      "20",     4137 )
  s(   947,  "Bouira",                                     "21",     4137 )
  s(   948,  "Djelfa",                                     "22",     4137 )
  s(   949,  "Guelma",                                     "23",     4137 )
  s(   950,  "Jijel",                                      "24",     4137 )
  s(   951,  "Laghouat",                                   "25",     4137 )
  s(   952,  "Mascara",                                    "26",     4137 )
  s(   953,  "M'sila",                                     "27",     4137 )
  s(   954,  "Oum el Bouaghi",                             "29",     4137 )
  s(   955,  "Sidi Bel Abbes",                             "30",     4137 )
  s(   956,  "Skikda",                                     "31",     4137 )
  s(   957,  "Tebessa",                                    "33",     4137 )
  s(   958,  "Adrar",                                      "07",     4226 )
  s(   959,  "Ain Defla",                                  "35",     4137 )
  s(   960,  "Ain Temouchent",                             "36",     4137 )
  s(   961,  "Annaba",                                     "37",     4137 )
  s(   962,  "Bechar",                                     "38",     4137 )
  s(   963,  "Bordj Bou Arreridj",                         "39",     4137 )
  s(   964,  "Boumerdes",                                  "40",     4137 )
  s(   965,  "Chlef",                                      "41",     4137 )
  s(   966,  "El Bayadh",                                  "42",     4137 )
  s(   967,  "El Oued",                                    "43",     4137 )
  s(   968,  "El Tarf",                                    "44",     4137 )
  s(   969,  "Ghardaia",                                   "45",     4137 )
  s(   970,  "Illizi",                                     "46",     4137 )
  s(   971,  "Khenchela",                                  "47",     4137 )
  s(   972,  "Mila",                                       "48",     4137 )
  s(   973,  "Naama",                                      "49",     4137 )
  s(   974,  "Ouargla",                                    "50",     4137 )
  s(   975,  "Relizane",                                   "51",     4137 )
  s(   976,  "Souk Ahras",                                 "52",     4137 )
  s(   977,  "Tamanghasset",                               "53",     4137 )
  s(   978,  "Tindouf",                                    "54",     4137 )
  s(   979,  "Tipaza",                                     "55",     4137 )
  s(   980,  "Tissemsilt",                                 "56",     4137 )
  s(   981,  "Galapagos",                                  "01",     4138 )
  s(   982,  "Azuay",                                      "02",     4138 )
  s(   983,  "Canar",                                      "04",     4138 )
  s(   984,  "Carchi",                                     "05",     4138 )
  s(   985,  "Chimborazo",                                 "06",     4138 )
  s(   986,  "Cotopaxi",                                   "07",     4138 )
  s(   987,  "El Oro",                                     "08",     4138 )
  s(   988,  "Esmeraldas",                                 "09",     4138 )
  s(   989,  "Guayas",                                     "10",     4138 )
  s(   990,  "Imbabura",                                   "11",     4138 )
  s(   991,  "Loja",                                       "12",     4138 )
  s(   992,  "Los Rios",                                   "13",     4138 )
  s(   993,  "Manabi",                                     "14",     4138 )
  s(   994,  "Morona-Santiago",                            "15",     4138 )
  s(   995,  "Pastaza",                                    "17",     4138 )
  s(   996,  "Pichincha",                                  "18",     4138 )
  s(   997,  "Tungurahua",                                 "19",     4138 )
  s(   998,  "Zamora-Chinchipe",                           "20",     4138 )
  s(   999,  "Sucumbios",                                  "22",     4138 )
  s(   1000, "Napo",                                       "23",     4138 )
  s(   1001, "Orellana",                                   "24",     4138 )
  s(   1002, "Harjumaa",                                   "01",     4139 )
  s(   1003, "Hiiumaa",                                    "02",     4139 )
  s(   1004, "Ida-Virumaa",                                "03",     4139 )
  s(   1005, "Jarvamaa",                                   "04",     4139 )
  s(   1006, "Jogevamaa",                                  "05",     4139 )
  s(   1007, "Kohtla-Jarve",                               "06",     4139 )
  s(   1008, "Laanemaa",                                   "07",     4139 )
  s(   1009, "Laane-Virumaa",                              "08",     4139 )
  s(   1010, "Narva",                                      "09",     4139 )
  s(   1011, "Parnu",                                      "10",     4139 )
  s(   1012, "Parnumaa",                                   "11",     4139 )
  s(   1013, "Polvamaa",                                   "12",     4139 )
  s(   1014, "Raplamaa",                                   "13",     4139 )
  s(   1015, "Saaremaa",                                   "14",     4139 )
  s(   1016, "Sillamae",                                   "15",     4139 )
  s(   1017, "Tallinn",                                    "16",     4139 )
  s(   1018, "Tartu",                                      "17",     4139 )
  s(   1019, "Tartumaa",                                   "18",     4139 )
  s(   1020, "Valgamaa",                                   "19",     4139 )
  s(   1021, "Viljandimaa",                                "20",     4139 )
  s(   1022, "Vorumaa",                                    "21",     4139 )
  s(   1023, "Ad Daqahliyah",                              "01",     4140 )
  s(   1024, "Al Bahr al Ahmar",                           "02",     4140 )
  s(   1025, "Al Buhayrah",                                "03",     4140 )
  s(   1026, "Al Fayyum",                                  "04",     4140 )
  s(   1027, "Al Gharbiyah",                               "05",     4140 )
  s(   1028, "Al Iskandariyah",                            "06",     4140 )
  s(   1029, "Al Isma'iliyah",                             "07",     4140 )
  s(   1030, "Al Jizah",                                   "08",     4140 )
  s(   1031, "Al Minufiyah",                               "09",     4140 )
  s(   1032, "Al Minya",                                   "10",     4140 )
  s(   1033, "Al Qahirah",                                 "11",     4140 )
  s(   1034, "Al Qalyubiyah",                              "12",     4140 )
  s(   1035, "Al Wadi al Jadid",                           "13",     4140 )
  s(   1036, "Ash Sharqiyah",                              "31",     4271 )
  s(   1037, "As Suways",                                  "15",     4140 )
  s(   1038, "Aswan",                                      "16",     4140 )
  s(   1039, "Asyut",                                      "17",     4140 )
  s(   1040, "Bani Suwayf",                                "18",     4140 )
  s(   1041, "Bur Sa'id",                                  "19",     4140 )
  s(   1042, "Dumyat",                                     "20",     4140 )
  s(   1043, "Kafr ash Shaykh",                            "21",     4140 )
  s(   1044, "Matruh",                                     "22",     4140 )
  s(   1045, "Qina",                                       "23",     4140 )
  s(   1046, "Suhaj",                                      "24",     4140 )
  s(   1047, "Janub Sina'",                                "26",     4140 )
  s(   1048, "Shamal Sina'",                               "27",     4140 )
  s(   1049, "Anseba",                                     "01",     4142 )
  s(   1050, "Debub",                                      "02",     4142 )
  s(   1051, "Debubawi K'eyih Bahri",                      "03",     4142 )
  s(   1052, "Gash Barka",                                 "04",     4142 )
  s(   1053, "Ma'akel",                                    "05",     4142 )
  s(   1054, "Semenawi K'eyih Bahri",                      "06",     4142 )
  s(   1055, "Islas Baleares",                             "07",     4143 )
  s(   1056, "Madrid",                                     "29",     4143 )
  s(   1057, "Murcia",                                     "31",     4143 )
  s(   1058, "Navarra",                                    "32",     4143 )
  s(   1059, "Asturias",                                   "34",     4143 )
  s(   1060, "Cantabria",                                  "39",     4143 )
  s(   1061, "Andalucia",                                  "51",     4143 )
  s(   1062, "Aragon",                                     "52",     4143 )
  s(   1063, "Canarias",                                   "53",     4143 )
  s(   1064, "Castilla-La Mancha",                         "54",     4143 )
  s(   1065, "Castilla y Leon",                            "55",     4143 )
  s(   1066, "Catalonia",                                  "56",     4143 )
  s(   1067, "Extremadura",                                "57",     4143 )
  s(   1068, "Galicia",                                    "58",     4143 )
  s(   1069, "Pais Vasco",                                 "59",     4143 )
  s(   1070, "Comunidad Valenciana",                       "60",     4143 )
  s(   1071, "Amhara",                                     "02",     4144 )
  s(   1072, "Somali",                                     "07",     4144 )
  s(   1073, "Gambella",                                   "08",     4144 )
  s(   1074, "Addis Abeba",                                "10",     4144 )
  s(   1075, "Tigray",                                     "12",     4144 )
  s(   1076, "Benishangul",                                "13",     4144 )
  s(   1077, "Afar",                                       "14",     4144 )
  s(   1078, "Adis Abeba",                                 "44",     4144 )
  s(   1079, "Afar",                                       "45",     4144 )
  s(   1080, "Amara",                                      "46",     4144 )
  s(   1081, "Binshangul Gumuz",                           "47",     4144 )
  s(   1082, "Dire Dawa",                                  "48",     4144 )
  s(   1083, "Gambela Hizboch",                            "49",     4144 )
  s(   1084, "Hareri Hizb",                                "50",     4144 )
  s(   1085, "Oromiya",                                    "51",     4144 )
  s(   1086, "Sumale",                                     "52",     4144 )
  s(   1087, "Tigray",                                     "53",     4144 )
  s(   1088, "YeDebub Biheroch Bihereseboch na Hizboch",   "54",     4144 )
  s(   1089, "Aland",                                      "01",     4146 )
  s(   1090, "Lapland",                                    "06",     4146 )
  s(   1091, "Oulu",                                       "08",     4146 )
  s(   1092, "Southern Finland",                           "13",     4146 )
  s(   1093, "Eastern Finland",                            "14",     4146 )
  s(   1094, "Western Finland",                            "15",     4146 )
  s(   1095, "Eastern",                                    "03",     4321 )
  s(   1096, "Northern",                                   "05",     4321 )
  s(   1097, "Rotuma",                                     "04",     4147 )
  s(   1098, "Western",                                    "01",     4321 )
  s(   1099, "Kosrae",                                     "01",     4149 )
  s(   1100, "Pohnpei",                                    "02",     4149 )
  s(   1101, "Chuuk",                                      "03",     4149 )
  s(   1102, "Yap",                                        "04",     4149 )
  s(   1103, "Aquitaine",                                  "97",     4151 )
  s(   1104, "Auvergne",                                   "98",     4151 )
  s(   1105, "Basse-Normandie",                            "99",     4151 )
  s(   1106, "Bourgogne",                                  "A1",     4151 )
  s(   1107, "Bretagne",                                   "A2",     4151 )
  s(   1108, "Champagne-Ardenne",                          "A4",     4151 )
  s(   1109, "Corse",                                      "A5",     4151 )
  s(   1110, "Franche-Comte",                              "A6",     4151 )
  s(   1111, "Haute-Normandie",                            "A7",     4151 )
  s(   1112, "Ile-de-France",                              "A8",     4151 )
  s(   1113, "Languedoc-Roussillon",                       "A9",     4151 )
  s(   1114, "Limousin",                                   "B1",     4151 )
  s(   1115, "Lorraine",                                   "B2",     4151 )
  s(   1116, "Midi-Pyrenees",                              "B3",     4151 )
  s(   1117, "Nord-Pas-de-Calais",                         "B4",     4151 )
  s(   1118, "Pays de la Loire",                           "B5",     4151 )
  s(   1119, "Picardie",                                   "B6",     4151 )
  s(   1120, "Poitou-Charentes",                           "B7",     4151 )
  s(   1121, "Provence-Alpes-Cote d'Azur",                 "B8",     4151 )
  s(   1122, "Rhone-Alpes",                                "B9",     4151 )
  s(   1123, "Alsace",                                     "C1",     4151 )
  s(   1124, "Estuaire",                                   "01",     4152 )
  s(   1125, "Haut-Ogooue",                                "02",     4152 )
  s(   1126, "Moyen-Ogooue",                               "03",     4152 )
  s(   1127, "Ngounie",                                    "04",     4152 )
  s(   1128, "Nyanga",                                     "05",     4152 )
  s(   1129, "Ogooue-Ivindo",                              "06",     4152 )
  s(   1130, "Ogooue-Lolo",                                "07",     4152 )
  s(   1131, "Ogooue-Maritime",                            "08",     4152 )
  s(   1132, "Woleu-Ntem",                                 "09",     4152 )
  s(   1133, "Avon",                                       "01",     4153 )
  s(   1134, "Berkshire",                                  "03",     4153 )
  s(   1135, "Cleveland",                                  "07",     4153 )
  s(   1136, "Greater London",                             "17",     4153 )
  s(   1137, "Greater Manchester",                         "18",     4153 )
  s(   1138, "Hereford and Worcester",                     "20",     4153 )
  s(   1139, "Humberside",                                 "22",     4153 )
  s(   1140, "Merseyside",                                 "28",     4153 )
  s(   1141, "South Yorkshire",                            "37",     4153 )
  s(   1142, "Tyne and Wear",                              "41",     4153 )
  s(   1143, "West Midlands",                              "43",     4153 )
  s(   1144, "West Yorkshire",                             "45",     4153 )
  s(   1145, "Grampian",                                   "82",     4153 )
  s(   1146, "Lothian",                                    "84",     4153 )
  s(   1147, "Strathclyde",                                "87",     4153 )
  s(   1148, "Tayside",                                    "88",     4153 )
  s(   1149, "Clwyd",                                      "90",     4153 )
  s(   1150, "Dyfed",                                      "91",     4153 )
  s(   1151, "Gwent",                                      "92",     4153 )
  s(   1152, "Mid Glamorgan",                              "94",     4153 )
  s(   1153, "South Glamorgan",                            "96",     4153 )
  s(   1154, "West Glamorgan",                             "97",     4153 )
  s(   1155, "Barking and Dagenham",                       "A1",     4153 )
  s(   1156, "Barnet",                                     "A2",     4153 )
  s(   1157, "Barnsley",                                   "A3",     4153 )
  s(   1158, "Bath and North East Somerset",               "A4",     4153 )
  s(   1159, "Bedfordshire",                               "A5",     4153 )
  s(   1160, "Bexley",                                     "A6",     4153 )
  s(   1161, "Birmingham",                                 "A7",     4153 )
  s(   1162, "Blackburn with Darwen",                      "A8",     4153 )
  s(   1163, "Blackpool",                                  "A9",     4153 )
  s(   1164, "Bolton",                                     "B1",     4153 )
  s(   1165, "Bournemouth",                                "B2",     4153 )
  s(   1166, "Bracknell Forest",                           "B3",     4153 )
  s(   1167, "Bradford",                                   "B4",     4153 )
  s(   1168, "Brent",                                      "B5",     4153 )
  s(   1169, "Brighton and Hove",                          "B6",     4153 )
  s(   1170, "Bristol, City of",                           "B7",     4153 )
  s(   1171, "Bromley",                                    "B8",     4153 )
  s(   1172, "Buckinghamshire",                            "B9",     4153 )
  s(   1173, "Bury",                                       "C1",     4153 )
  s(   1174, "Calderdale",                                 "C2",     4153 )
  s(   1175, "Cambridgeshire",                             "C3",     4153 )
  s(   1176, "Camden",                                     "C4",     4153 )
  s(   1177, "Cheshire",                                   "C5",     4153 )
  s(   1178, "Cornwall",                                   "C6",     4153 )
  s(   1179, "Coventry",                                   "C7",     4153 )
  s(   1180, "Croydon",                                    "C8",     4153 )
  s(   1181, "Cumbria",                                    "C9",     4153 )
  s(   1182, "Darlington",                                 "D1",     4153 )
  s(   1183, "Derby",                                      "D2",     4153 )
  s(   1184, "Derbyshire",                                 "D3",     4153 )
  s(   1185, "Devon",                                      "D4",     4153 )
  s(   1186, "Doncaster",                                  "D5",     4153 )
  s(   1187, "Dorset",                                     "D6",     4153 )
  s(   1188, "Dudley",                                     "D7",     4153 )
  s(   1189, "Durham",                                     "D8",     4153 )
  s(   1190, "Ealing",                                     "D9",     4153 )
  s(   1191, "East Riding of Yorkshire",                   "E1",     4153 )
  s(   1192, "East Sussex",                                "E2",     4153 )
  s(   1193, "Enfield",                                    "E3",     4153 )
  s(   1194, "Essex",                                      "E4",     4153 )
  s(   1195, "Gateshead",                                  "E5",     4153 )
  s(   1196, "Gloucestershire",                            "E6",     4153 )
  s(   1197, "Greenwich",                                  "E7",     4153 )
  s(   1198, "Hackney",                                    "E8",     4153 )
  s(   1199, "Halton",                                     "E9",     4153 )
  s(   1200, "Hammersmith and Fulham",                     "F1",     4153 )
  s(   1201, "Hampshire",                                  "F2",     4153 )
  s(   1202, "Haringey",                                   "F3",     4153 )
  s(   1203, "Harrow",                                     "F4",     4153 )
  s(   1204, "Hartlepool",                                 "F5",     4153 )
  s(   1205, "Havering",                                   "F6",     4153 )
  s(   1206, "Hertfordshire",                              "F7",     4153 )
  s(   1207, "Hertford",                                   "F8",     4153 )
  s(   1208, "Hillingdon",                                 "F9",     4153 )
  s(   1209, "Hounslow",                                   "G1",     4153 )
  s(   1210, "Isle of Wight",                              "G2",     4153 )
  s(   1211, "Islington",                                  "G3",     4153 )
  s(   1212, "Kensington and Chelsea",                     "G4",     4153 )
  s(   1213, "Kent",                                       "G5",     4153 )
  s(   1214, "Kingston upon Hull, City of",                "G6",     4153 )
  s(   1215, "Kingston upon Thames",                       "G7",     4153 )
  s(   1216, "Kirklees",                                   "G8",     4153 )
  s(   1217, "Knowsley",                                   "G9",     4153 )
  s(   1218, "Lambeth",                                    "H1",     4153 )
  s(   1219, "Lancashire",                                 "H2",     4153 )
  s(   1220, "Leeds",                                      "H3",     4153 )
  s(   1221, "Leicester",                                  "H4",     4153 )
  s(   1222, "Leicestershire",                             "H5",     4153 )
  s(   1223, "Lewisham",                                   "H6",     4153 )
  s(   1224, "Lincolnshire",                               "H7",     4153 )
  s(   1225, "Liverpool",                                  "H8",     4153 )
  s(   1226, "London, City of",                            "H9",     4153 )
  s(   1227, "Luton",                                      "I1",     4153 )
  s(   1228, "Manchester",                                 "04",     4188 )
  s(   1229, "Medway",                                     "I3",     4153 )
  s(   1230, "Merton",                                     "I4",     4153 )
  s(   1231, "Middlesbrough",                              "I5",     4153 )
  s(   1232, "Milton Keynes",                              "I6",     4153 )
  s(   1233, "Newcastle upon Tyne",                        "I7",     4153 )
  s(   1234, "Newham",                                     "I8",     4153 )
  s(   1235, "Norfolk",                                    "I9",     4153 )
  s(   1236, "Northamptonshire",                           "J1",     4153 )
  s(   1237, "North East Lincolnshire",                    "J2",     4153 )
  s(   1238, "North Lincolnshire",                         "J3",     4153 )
  s(   1239, "North Somerset",                             "J4",     4153 )
  s(   1240, "North Tyneside",                             "J5",     4153 )
  s(   1241, "Northumberland",                             "J6",     4153 )
  s(   1242, "North Yorkshire",                            "J7",     4153 )
  s(   1243, "Nottingham",                                 "J8",     4153 )
  s(   1244, "Nottinghamshire",                            "J9",     4153 )
  s(   1245, "Oldham",                                     "K1",     4153 )
  s(   1246, "Oxfordshire",                                "K2",     4153 )
  s(   1247, "Peterborough",                               "K3",     4153 )
  s(   1248, "Plymouth",                                   "K4",     4153 )
  s(   1249, "Poole",                                      "K5",     4153 )
  s(   1250, "Portsmouth",                                 "K6",     4153 )
  s(   1251, "Reading",                                    "K7",     4153 )
  s(   1252, "Redbridge",                                  "K8",     4153 )
  s(   1253, "Redcar and Cleveland",                       "K9",     4153 )
  s(   1254, "Richmond upon Thames",                       "L1",     4153 )
  s(   1255, "Rochdale",                                   "L2",     4153 )
  s(   1256, "Rotherham",                                  "L3",     4153 )
  s(   1257, "Rutland",                                    "L4",     4153 )
  s(   1258, "Salford",                                    "L5",     4153 )
  s(   1259, "Shropshire",                                 "L6",     4153 )
  s(   1260, "Sandwell",                                   "L7",     4153 )
  s(   1261, "Sefton",                                     "L8",     4153 )
  s(   1262, "Sheffield",                                  "L9",     4153 )
  s(   1263, "Slough",                                     "M1",     4153 )
  s(   1264, "Solihull",                                   "M2",     4153 )
  s(   1265, "Somerset",                                   "M3",     4153 )
  s(   1266, "Southend-on-Sea",                            "M5",     4153 )
  s(   1267, "South Gloucestershire",                      "M6",     4153 )
  s(   1268, "South Tyneside",                             "M7",     4153 )
  s(   1269, "Southwark",                                  "M8",     4153 )
  s(   1270, "Staffordshire",                              "M9",     4153 )
  s(   1271, "St. Helens",                                 "N1",     4153 )
  s(   1272, "Stockport",                                  "N2",     4153 )
  s(   1273, "Stockton-on-Tees",                           "N3",     4153 )
  s(   1274, "Stoke-on-Trent",                             "N4",     4153 )
  s(   1275, "Suffolk",                                    "N5",     4153 )
  s(   1276, "Sunderland",                                 "N6",     4153 )
  s(   1277, "Surrey",                                     "N7",     4153 )
  s(   1278, "Sutton",                                     "N8",     4153 )
  s(   1279, "Swindon",                                    "N9",     4153 )
  s(   1280, "Tameside",                                   "O1",     4153 )
  s(   1281, "Telford and Wrekin",                         "O2",     4153 )
  s(   1282, "Thurrock",                                   "O3",     4153 )
  s(   1283, "Torbay",                                     "O4",     4153 )
  s(   1284, "Tower Hamlets",                              "O5",     4153 )
  s(   1285, "Trafford",                                   "O6",     4153 )
  s(   1286, "Wakefield",                                  "O7",     4153 )
  s(   1287, "Walsall",                                    "O8",     4153 )
  s(   1288, "Waltham Forest",                             "O9",     4153 )
  s(   1289, "Wandsworth",                                 "P1",     4153 )
  s(   1290, "Warrington",                                 "P2",     4153 )
  s(   1291, "Warwickshire",                               "P3",     4153 )
  s(   1292, "West Berkshire",                             "P4",     4153 )
  s(   1293, "Westminster",                                "P5",     4153 )
  s(   1294, "West Sussex",                                "P6",     4153 )
  s(   1295, "Wigan",                                      "P7",     4153 )
  s(   1296, "Wiltshire",                                  "P8",     4153 )
  s(   1297, "Windsor and Maidenhead",                     "P9",     4153 )
  s(   1298, "Wirral",                                     "Q1",     4153 )
  s(   1299, "Wokingham",                                  "Q2",     4153 )
  s(   1300, "Wolverhampton",                              "Q3",     4153 )
  s(   1301, "Worcestershire",                             "Q4",     4153 )
  s(   1302, "York",                                       "Q5",     4153 )
  s(   1303, "Antrim",                                     "Q6",     4153 )
  s(   1304, "Ards",                                       "Q7",     4153 )
  s(   1305, "Armagh",                                     "Q8",     4153 )
  s(   1306, "Ballymena",                                  "Q9",     4153 )
  s(   1307, "Ballymoney",                                 "R1",     4153 )
  s(   1308, "Banbridge",                                  "R2",     4153 )
  s(   1309, "Belfast",                                    "R3",     4153 )
  s(   1310, "Carrickfergus",                              "R4",     4153 )
  s(   1311, "Castlereagh",                                "R5",     4153 )
  s(   1312, "Coleraine",                                  "R6",     4153 )
  s(   1313, "Cookstown",                                  "R7",     4153 )
  s(   1314, "Craigavon",                                  "R8",     4153 )
  s(   1315, "Down",                                       "R9",     4153 )
  s(   1316, "Dungannon",                                  "S1",     4153 )
  s(   1317, "Fermanagh",                                  "S2",     4153 )
  s(   1318, "Larne",                                      "S3",     4153 )
  s(   1319, "Limavady",                                   "S4",     4153 )
  s(   1320, "Lisburn",                                    "S5",     4153 )
  s(   1321, "Derry",                                      "S6",     4153 )
  s(   1322, "Magherafelt",                                "S7",     4153 )
  s(   1323, "Moyle",                                      "S8",     4153 )
  s(   1324, "Newry and Mourne",                           "S9",     4153 )
  s(   1325, "Newtownabbey",                               "T1",     4153 )
  s(   1326, "North Down",                                 "T2",     4153 )
  s(   1327, "Omagh",                                      "T3",     4153 )
  s(   1328, "Strabane",                                   "T4",     4153 )
  s(   1329, "Aberdeen City",                              "T5",     4153 )
  s(   1330, "Aberdeenshire",                              "T6",     4153 )
  s(   1331, "Angus",                                      "T7",     4153 )
  s(   1332, "Argyll and Bute",                            "T8",     4153 )
  s(   1333, "Scottish Borders, The",                      "T9",     4153 )
  s(   1334, "Clackmannanshire",                           "U1",     4153 )
  s(   1335, "Dumfries and Galloway",                      "U2",     4153 )
  s(   1336, "Dundee City",                                "U3",     4153 )
  s(   1337, "East Ayrshire",                              "U4",     4153 )
  s(   1338, "East Dunbartonshire",                        "U5",     4153 )
  s(   1339, "East Lothian",                               "U6",     4153 )
  s(   1340, "East Renfrewshire",                          "U7",     4153 )
  s(   1341, "Edinburgh, City of",                         "U8",     4153 )
  s(   1342, "Falkirk",                                    "U9",     4153 )
  s(   1343, "Fife",                                       "V1",     4153 )
  s(   1344, "Glasgow City",                               "V2",     4153 )
  s(   1345, "Highland",                                   "V3",     4153 )
  s(   1346, "Inverclyde",                                 "V4",     4153 )
  s(   1347, "Midlothian",                                 "V5",     4153 )
  s(   1348, "Moray",                                      "V6",     4153 )
  s(   1349, "North Ayrshire",                             "V7",     4153 )
  s(   1350, "North Lanarkshire",                          "V8",     4153 )
  s(   1351, "Orkney",                                     "V9",     4153 )
  s(   1352, "Perth and Kinross",                          "W1",     4153 )
  s(   1353, "Renfrewshire",                               "W2",     4153 )
  s(   1354, "Shetland Islands",                           "W3",     4153 )
  s(   1355, "South Ayrshire",                             "W4",     4153 )
  s(   1356, "South Lanarkshire",                          "W5",     4153 )
  s(   1357, "Stirling",                                   "W6",     4153 )
  s(   1358, "West Dunbartonshire",                        "W7",     4153 )
  s(   1359, "Eilean Siar",                                "W8",     4153 )
  s(   1360, "West Lothian",                               "W9",     4153 )
  s(   1361, "Isle of Anglesey",                           "X1",     4153 )
  s(   1362, "Blaenau Gwent",                              "X2",     4153 )
  s(   1363, "Bridgend",                                   "X3",     4153 )
  s(   1364, "Caerphilly",                                 "X4",     4153 )
  s(   1365, "Cardiff",                                    "X5",     4153 )
  s(   1366, "Ceredigion",                                 "X6",     4153 )
  s(   1367, "Carmarthenshire",                            "X7",     4153 )
  s(   1368, "Conwy",                                      "X8",     4153 )
  s(   1369, "Denbighshire",                               "X9",     4153 )
  s(   1370, "Flintshire",                                 "Y1",     4153 )
  s(   1371, "Gwynedd",                                    "Y2",     4153 )
  s(   1372, "Merthyr Tydfil",                             "Y3",     4153 )
  s(   1373, "Monmouthshire",                              "Y4",     4153 )
  s(   1374, "Neath Port Talbot",                          "Y5",     4153 )
  s(   1375, "Newport",                                    "Y6",     4153 )
  s(   1376, "Pembrokeshire",                              "Y7",     4153 )
  s(   1377, "Powys",                                      "Y8",     4153 )
  s(   1378, "Rhondda Cynon Taff",                         "Y9",     4153 )
  s(   1379, "Swansea",                                    "Z1",     4153 )
  s(   1380, "Torfaen",                                    "Z2",     4153 )
  s(   1381, "Vale of Glamorgan, The",                     "Z3",     4153 )
  s(   1382, "Wrexham",                                    "Z4",     4153 )
  s(   1383, "Abashis Raioni",                             "01",     4155 )
  s(   1384, "Abkhazia",                                   "02",     4155 )
  s(   1385, "Adigenis Raioni",                            "03",     4155 )
  s(   1386, "Ajaria",                                     "04",     4155 )
  s(   1387, "Akhalgoris Raioni",                          "05",     4155 )
  s(   1388, "Akhalk'alak'is Raioni",                      "06",     4155 )
  s(   1389, "Akhalts'ikhis Raioni",                       "07",     4155 )
  s(   1390, "Akhmetis Raioni",                            "08",     4155 )
  s(   1391, "Ambrolauris Raioni",                         "09",     4155 )
  s(   1392, "Aspindzis Raioni",                           "10",     4155 )
  s(   1393, "Baghdat'is Raioni",                          "11",     4155 )
  s(   1394, "Bolnisis Raioni",                            "12",     4155 )
  s(   1395, "Borjomis Raioni",                            "13",     4155 )
  s(   1396, "Chiat'ura",                                  "14",     4155 )
  s(   1397, "Ch'khorotsqus Raioni",                       "15",     4155 )
  s(   1398, "Ch'okhatauris Raioni",                       "16",     4155 )
  s(   1399, "Dedop'listsqaros Raioni",                    "17",     4155 )
  s(   1400, "Dmanisis Raioni",                            "18",     4155 )
  s(   1401, "Dushet'is Raioni",                           "19",     4155 )
  s(   1402, "Gardabanis Raioni",                          "20",     4155 )
  s(   1403, "Gori",                                       "21",     4155 )
  s(   1404, "Goris Raioni",                               "22",     4155 )
  s(   1405, "Gurjaanis Raioni",                           "23",     4155 )
  s(   1406, "Javis Raioni",                               "24",     4155 )
  s(   1407, "K'arelis Raioni",                            "25",     4155 )
  s(   1408, "Kaspis Raioni",                              "26",     4155 )
  s(   1409, "Kharagaulis Raioni",                         "27",     4155 )
  s(   1410, "Khashuris Raioni",                           "28",     4155 )
  s(   1411, "Khobis Raioni",                              "29",     4155 )
  s(   1412, "Khonis Raioni",                              "30",     4155 )
  s(   1413, "K'ut'aisi",                                  "31",     4155 )
  s(   1414, "Lagodekhis Raioni",                          "32",     4155 )
  s(   1415, "Lanch'khut'is Raioni",                       "33",     4155 )
  s(   1416, "Lentekhis Raioni",                           "34",     4155 )
  s(   1417, "Marneulis Raioni",                           "35",     4155 )
  s(   1418, "Martvilis Raioni",                           "36",     4155 )
  s(   1419, "Mestiis Raioni",                             "37",     4155 )
  s(   1420, "Mts'khet'is Raioni",                         "38",     4155 )
  s(   1421, "Ninotsmindis Raioni",                        "39",     4155 )
  s(   1422, "Onis Raioni",                                "40",     4155 )
  s(   1423, "Ozurget'is Raioni",                          "41",     4155 )
  s(   1424, "P'ot'i",                                     "42",     4155 )
  s(   1425, "Qazbegis Raioni",                            "43",     4155 )
  s(   1426, "Qvarlis Raioni",                             "44",     4155 )
  s(   1427, "Rust'avi",                                   "45",     4155 )
  s(   1428, "Sach'kheris Raioni",                         "46",     4155 )
  s(   1429, "Sagarejos Raioni",                           "47",     4155 )
  s(   1430, "Samtrediis Raioni",                          "48",     4155 )
  s(   1431, "Senakis Raioni",                             "49",     4155 )
  s(   1432, "Sighnaghis Raioni",                          "50",     4155 )
  s(   1433, "T'bilisi",                                   "51",     4155 )
  s(   1434, "T'elavis Raioni",                            "52",     4155 )
  s(   1435, "T'erjolis Raioni",                           "53",     4155 )
  s(   1436, "T'et'ritsqaros Raioni",                      "54",     4155 )
  s(   1437, "T'ianet'is Raioni",                          "55",     4155 )
  s(   1438, "Tqibuli",                                    "56",     4155 )
  s(   1439, "Ts'ageris Raioni",                           "57",     4155 )
  s(   1440, "Tsalenjikhis Raioni",                        "58",     4155 )
  s(   1441, "Tsalkis Raioni",                             "59",     4155 )
  s(   1442, "Tsqaltubo",                                  "60",     4155 )
  s(   1443, "Vanis Raioni",                               "61",     4155 )
  s(   1444, "Zestap'onis Raioni",                         "62",     4155 )
  s(   1445, "Zugdidi",                                    "63",     4155 )
  s(   1446, "Zugdidis Raioni",                            "64",     4155 )
  s(   1447, "Greater Accra",                              "01",     4158 )
  s(   1448, "Ashanti",                                    "02",     4158 )
  s(   1449, "Brong-Ahafo",                                "03",     4158 )
}

  def init2( s:org.tyranid.db.StaticBuilder ) = {
  s(   1450, "Volta",                                      "08",     4158 )
  s(   1451, "Upper East",                                 "10",     4158 )
  s(   1452, "Upper West",                                 "11",     4158 )
  s(   1453, "Nordgronland",                               "01",     4160 )
  s(   1454, "Ostgronland",                                "02",     4160 )
  s(   1455, "Vestgronland",                               "03",     4160 )
  s(   1456, "Banjul",                                     "01",     4161 )
  s(   1457, "Lower River",                                "02",     4161 )
  s(   1458, "Central River",                              "03",     4161 )
  s(   1459, "Upper River",                                "04",     4161 )
  s(   1460, "North Bank",                                 "07",     4161 )
  s(   1461, "Beyla",                                      "01",     4162 )
  s(   1462, "Boffa",                                      "02",     4162 )
  s(   1463, "Boke",                                       "03",     4162 )
  s(   1464, "Conakry",                                    "04",     4162 )
  s(   1465, "Dabola",                                     "05",     4162 )
  s(   1466, "Dalaba",                                     "06",     4162 )
  s(   1467, "Dinguiraye",                                 "07",     4162 )
  s(   1468, "Faranah",                                    "09",     4162 )
  s(   1469, "Forecariah",                                 "10",     4162 )
  s(   1470, "Fria",                                       "11",     4162 )
  s(   1471, "Gaoual",                                     "12",     4162 )
  s(   1472, "Gueckedou",                                  "13",     4162 )
  s(   1473, "Kerouane",                                   "15",     4162 )
  s(   1474, "Kindia",                                     "16",     4162 )
  s(   1475, "Kissidougou",                                "17",     4162 )
  s(   1476, "Koundara",                                   "18",     4162 )
  s(   1477, "Kouroussa",                                  "19",     4162 )
  s(   1478, "Macenta",                                    "21",     4162 )
  s(   1479, "Mali",                                       "22",     4162 )
  s(   1480, "Mamou",                                      "23",     4162 )
  s(   1481, "Pita",                                       "25",     4162 )
  s(   1482, "Telimele",                                   "27",     4162 )
  s(   1483, "Tougue",                                     "28",     4162 )
  s(   1484, "Yomou",                                      "29",     4162 )
  s(   1485, "Coyah",                                      "30",     4162 )
  s(   1486, "Dubreka",                                    "31",     4162 )
  s(   1487, "Kankan",                                     "32",     4162 )
  s(   1488, "Koubia",                                     "33",     4162 )
  s(   1489, "Labe",                                       "34",     4162 )
  s(   1490, "Lelouma",                                    "35",     4162 )
  s(   1491, "Lola",                                       "36",     4162 )
  s(   1492, "Mandiana",                                   "37",     4162 )
  s(   1493, "Nzerekore",                                  "38",     4162 )
  s(   1494, "Siguiri",                                    "39",     4162 )
  s(   1495, "Annobon",                                    "03",     4164 )
  s(   1496, "Bioko Norte",                                "04",     4164 )
  s(   1497, "Bioko Sur",                                  "05",     4164 )
  s(   1498, "Centro Sur",                                 "06",     4164 )
  s(   1499, "Kie-Ntem",                                   "07",     4164 )
  s(   1500, "Litoral",                                    "08",     4164 )
  s(   1501, "Wele-Nzas",                                  "09",     4164 )
  s(   1502, "Evros",                                      "01",     4165 )
  s(   1503, "Rodhopi",                                    "02",     4165 )
  s(   1504, "Xanthi",                                     "03",     4165 )
  s(   1505, "Drama",                                      "04",     4165 )
  s(   1506, "Serrai",                                     "05",     4165 )
  s(   1507, "Kilkis",                                     "06",     4165 )
  s(   1508, "Pella",                                      "07",     4165 )
  s(   1509, "Florina",                                    "08",     4165 )
  s(   1510, "Kastoria",                                   "09",     4165 )
  s(   1511, "Grevena",                                    "10",     4165 )
  s(   1512, "Kozani",                                     "11",     4165 )
  s(   1513, "Imathia",                                    "12",     4165 )
  s(   1514, "Thessaloniki",                               "13",     4165 )
  s(   1515, "Kavala",                                     "14",     4165 )
  s(   1516, "Khalkidhiki",                                "15",     4165 )
  s(   1517, "Pieria",                                     "16",     4165 )
  s(   1518, "Ioannina",                                   "17",     4165 )
  s(   1519, "Thesprotia",                                 "18",     4165 )
  s(   1520, "Preveza",                                    "19",     4165 )
  s(   1521, "Larisa",                                     "21",     4165 )
  s(   1522, "Trikala",                                    "22",     4165 )
  s(   1523, "Kardhitsa",                                  "23",     4165 )
  s(   1524, "Magnisia",                                   "24",     4165 )
  s(   1525, "Kerkira",                                    "25",     4165 )
  s(   1526, "Levkas",                                     "26",     4165 )
  s(   1527, "Kefallinia",                                 "27",     4165 )
  s(   1528, "Zakinthos",                                  "28",     4165 )
  s(   1529, "Fthiotis",                                   "29",     4165 )
  s(   1530, "Evritania",                                  "30",     4165 )
  s(   1531, "Aitolia kai Akarnania",                      "31",     4165 )
  s(   1532, "Fokis",                                      "32",     4165 )
  s(   1533, "Voiotia",                                    "33",     4165 )
  s(   1534, "Evvoia",                                     "34",     4165 )
  s(   1535, "Attiki",                                     "35",     4165 )
  s(   1536, "Argolis",                                    "36",     4165 )
  s(   1537, "Korinthia",                                  "37",     4165 )
  s(   1538, "Akhaia",                                     "38",     4165 )
  s(   1539, "Ilia",                                       "39",     4165 )
  s(   1540, "Messinia",                                   "40",     4165 )
  s(   1541, "Arkadhia",                                   "41",     4165 )
  s(   1542, "Lakonia",                                    "42",     4165 )
  s(   1543, "Khania",                                     "43",     4165 )
  s(   1544, "Rethimni",                                   "44",     4165 )
  s(   1545, "Iraklion",                                   "45",     4165 )
  s(   1546, "Lasithi",                                    "46",     4165 )
  s(   1547, "Dhodhekanisos",                              "47",     4165 )
  s(   1548, "Samos",                                      "48",     4165 )
  s(   1549, "Kikladhes",                                  "49",     4165 )
  s(   1550, "Khios",                                      "50",     4165 )
  s(   1551, "Lesvos",                                     "51",     4165 )
  s(   1552, "Alta Verapaz",                               "01",     4167 )
  s(   1553, "Baja Verapaz",                               "02",     4167 )
  s(   1554, "Chimaltenango",                              "03",     4167 )
  s(   1555, "Chiquimula",                                 "04",     4167 )
  s(   1556, "El Progreso",                                "05",     4167 )
  s(   1557, "Escuintla",                                  "06",     4167 )
  s(   1558, "Guatemala Department",                       "07",     4167 )
  s(   1559, "Huehuetenango",                              "08",     4167 )
  s(   1560, "Izabal",                                     "09",     4167 )
  s(   1561, "Jalapa",                                     "10",     4167 )
  s(   1562, "Jutiapa",                                    "11",     4167 )
  s(   1563, "Peten",                                      "12",     4167 )
  s(   1564, "Quetzaltenango",                             "13",     4167 )
  s(   1565, "Quiche",                                     "14",     4167 )
  s(   1566, "Retalhuleu",                                 "15",     4167 )
  s(   1567, "Sacatepequez",                               "16",     4167 )
  s(   1568, "San Marcos",                                 "17",     4167 )
  s(   1569, "Santa Rosa",                                 "18",     4167 )
  s(   1570, "Solola",                                     "19",     4167 )
  s(   1571, "Suchitepequez",                              "20",     4167 )
  s(   1572, "Totonicapan",                                "21",     4167 )
  s(   1573, "Zacapa",                                     "22",     4167 )
  s(   1574, "Bafata",                                     "01",     4169 )
  s(   1575, "Quinara",                                    "02",     4169 )
  s(   1576, "Oio",                                        "04",     4169 )
  s(   1577, "Bolama",                                     "05",     4169 )
  s(   1578, "Cacheu",                                     "06",     4169 )
  s(   1579, "Tombali",                                    "07",     4169 )
  s(   1580, "Gabu",                                       "10",     4169 )
  s(   1581, "Bissau",                                     "11",     4169 )
  s(   1582, "Biombo",                                     "12",     4169 )
  s(   1583, "Barima-Waini",                               "10",     4170 )
  s(   1584, "Cuyuni-Mazaruni",                            "11",     4170 )
  s(   1585, "Demerara-Mahaica",                           "12",     4170 )
  s(   1586, "East Berbice-Corentyne",                     "13",     4170 )
  s(   1587, "Essequibo Islands-West Demerara",            "14",     4170 )
  s(   1588, "Mahaica-Berbice",                            "15",     4170 )
  s(   1589, "Pomeroon-Supenaam",                          "16",     4170 )
  s(   1590, "Potaro-Siparuni",                            "17",     4170 )
  s(   1591, "Upper Demerara-Berbice",                     "18",     4170 )
  s(   1592, "Upper Takutu-Upper Essequibo",               "19",     4170 )
  s(   1593, "Atlantida",                                  "01",     4173 )
  s(   1594, "Choluteca",                                  "02",     4173 )
  s(   1595, "Colon",                                      "04",     4248 )
  s(   1596, "Comayagua",                                  "04",     4173 )
  s(   1597, "Copan",                                      "05",     4173 )
  s(   1598, "Cortes",                                     "06",     4173 )
  s(   1599, "El Paraiso",                                 "07",     4173 )
  s(   1600, "Francisco Morazan",                          "08",     4173 )
  s(   1601, "Gracias a Dios",                             "09",     4173 )
  s(   1602, "Intibuca",                                   "10",     4173 )
  s(   1603, "Islas de la Bahia",                          "11",     4173 )
  s(   1604, "Lempira",                                    "13",     4173 )
  s(   1605, "Ocotepeque",                                 "14",     4173 )
  s(   1606, "Olancho",                                    "15",     4173 )
  s(   1607, "Santa Barbara",                              "16",     4173 )
  s(   1608, "Valle",                                      "17",     4173 )
  s(   1609, "Yoro",                                       "18",     4173 )
  s(   1610, "Bjelovarsko-Bilogorska",                     "01",     4174 )
  s(   1611, "Brodsko-Posavska",                           "02",     4174 )
  s(   1612, "Dubrovacko-Neretvanska",                     "03",     4174 )
  s(   1613, "Istarska",                                   "04",     4174 )
  s(   1614, "Karlovacka",                                 "05",     4174 )
  s(   1615, "Koprivnicko-Krizevacka",                     "06",     4174 )
  s(   1616, "Krapinsko-Zagorska",                         "07",     4174 )
  s(   1617, "Licko-Senjska",                              "08",     4174 )
  s(   1618, "Medimurska",                                 "09",     4174 )
  s(   1619, "Osjecko-Baranjska",                          "10",     4174 )
  s(   1620, "Pozesko-Slavonska",                          "11",     4174 )
  s(   1621, "Primorsko-Goranska",                         "12",     4174 )
  s(   1622, "Sibensko-Kninska",                           "13",     4174 )
  s(   1623, "Sisacko-Moslavacka",                         "14",     4174 )
  s(   1624, "Splitsko-Dalmatinska",                       "15",     4174 )
  s(   1625, "Varazdinska",                                "16",     4174 )
  s(   1626, "Viroviticko-Podravska",                      "17",     4174 )
  s(   1627, "Vukovarsko-Srijemska",                       "18",     4174 )
  s(   1628, "Zadarska",                                   "19",     4174 )
  s(   1629, "Zagrebacka",                                 "20",     4174 )
  s(   1630, "Grad Zagreb",                                "21",     4174 )
  s(   1631, "Artibonite",                                 "06",     4175 )
  s(   1632, "Nord-Est",                                   "10",     4175 )
  s(   1633, "Sud-Est",                                    "13",     4175 )
  s(   1634, "Grand' Anse",                                "13",     4270 )
  s(   1635, "Nippes",                                     "15",     4175 )
  s(   1636, "Bacs-Kiskun",                                "01",     4176 )
  s(   1637, "Baranya",                                    "02",     4176 )
  s(   1638, "Bekes",                                      "03",     4176 )
  s(   1639, "Borsod-Abauj-Zemplen",                       "04",     4176 )
  s(   1640, "Budapest",                                   "05",     4176 )
  s(   1641, "Csongrad",                                   "06",     4176 )
  s(   1642, "Debrecen",                                   "07",     4176 )
  s(   1643, "Fejer",                                      "08",     4176 )
  s(   1644, "Gyor-Moson-Sopron",                          "09",     4176 )
  s(   1645, "Hajdu-Bihar",                                "10",     4176 )
  s(   1646, "Heves",                                      "11",     4176 )
  s(   1647, "Komarom-Esztergom",                          "12",     4176 )
  s(   1648, "Miskolc",                                    "13",     4176 )
  s(   1649, "Nograd",                                     "14",     4176 )
  s(   1650, "Pecs",                                       "15",     4176 )
  s(   1651, "Pest",                                       "16",     4176 )
  s(   1652, "Somogy",                                     "17",     4176 )
  s(   1653, "Szabolcs-Szatmar-Bereg",                     "18",     4176 )
  s(   1654, "Szeged",                                     "19",     4176 )
  s(   1655, "Jasz-Nagykun-Szolnok",                       "20",     4176 )
  s(   1656, "Tolna",                                      "21",     4176 )
  s(   1657, "Vas",                                        "22",     4176 )
  s(   1658, "Veszprem",                                   "23",     4176 )
  s(   1659, "Zala",                                       "24",     4176 )
  s(   1660, "Gyor",                                       "25",     4176 )
  s(   1661, "Bekescsaba",                                 "26",     4176 )
  s(   1662, "Dunaujvaros",                                "27",     4176 )
  s(   1663, "Eger",                                       "28",     4176 )
  s(   1664, "Hodmezovasarhely",                           "29",     4176 )
  s(   1665, "Kaposvar",                                   "30",     4176 )
  s(   1666, "Kecskemet",                                  "31",     4176 )
  s(   1667, "Nagykanizsa",                                "32",     4176 )
  s(   1668, "Nyiregyhaza",                                "33",     4176 )
  s(   1669, "Sopron",                                     "34",     4176 )
  s(   1670, "Szekesfehervar",                             "35",     4176 )
  s(   1671, "Szolnok",                                    "36",     4176 )
  s(   1672, "Szombathely",                                "37",     4176 )
  s(   1673, "Tatabanya",                                  "38",     4176 )
  s(   1674, "Veszprem",                                   "39",     4176 )
  s(   1675, "Zalaegerszeg",                               "40",     4176 )
  s(   1676, "Salgotarjan",                                "41",     4176 )
  s(   1677, "Szekszard",                                  "42",     4176 )
  s(   1678, "Aceh",                                       "01",     4177 )
  s(   1679, "Bali",                                       "02",     4177 )
  s(   1680, "Bengkulu",                                   "03",     4177 )
  s(   1681, "Jakarta Raya",                               "04",     4177 )
  s(   1682, "Jambi",                                      "05",     4177 )
  s(   1683, "Jawa Barat",                                 "06",     4177 )
  s(   1684, "Jawa Tengah",                                "07",     4177 )
  s(   1685, "Jawa Timur",                                 "08",     4177 )
  s(   1686, "Papua",                                      "09",     4177 )
  s(   1687, "Yogyakarta",                                 "10",     4177 )
  s(   1688, "Kalimantan Barat",                           "11",     4177 )
  s(   1689, "Kalimantan Selatan",                         "12",     4177 )
  s(   1690, "Kalimantan Tengah",                          "13",     4177 )
  s(   1691, "Kalimantan Timur",                           "14",     4177 )
  s(   1692, "Lampung",                                    "15",     4177 )
  s(   1693, "Maluku",                                     "16",     4177 )
  s(   1694, "Nusa Tenggara Barat",                        "17",     4177 )
  s(   1695, "Nusa Tenggara Timur",                        "18",     4177 )
  s(   1696, "Riau",                                       "19",     4177 )
  s(   1697, "Sulawesi Selatan",                           "20",     4177 )
  s(   1698, "Sulawesi Tengah",                            "21",     4177 )
  s(   1699, "Sulawesi Tenggara",                          "22",     4177 )
  s(   1700, "Sulawesi Utara",                             "23",     4177 )
  s(   1701, "Sumatera Barat",                             "24",     4177 )
  s(   1702, "Sumatera Selatan",                           "25",     4177 )
  s(   1703, "Sumatera Utara",                             "26",     4177 )
  s(   1704, "Maluku",                                     "28",     4177 )
  s(   1705, "Maluku Utara",                               "29",     4177 )
  s(   1706, "Jawa Barat",                                 "30",     4177 )
  s(   1707, "Sulawesi Utara",                             "31",     4177 )
  s(   1708, "Sumatera Selatan",                           "32",     4177 )
  s(   1709, "Banten",                                     "33",     4177 )
  s(   1710, "Gorontalo",                                  "34",     4177 )
  s(   1711, "Kepulauan Bangka Belitung",                  "35",     4177 )
  s(   1712, "Papua",                                      "36",     4177 )
  s(   1713, "Riau",                                       "37",     4177 )
  s(   1714, "Sulawesi Selatan",                           "38",     4177 )
  s(   1715, "Irian Jaya Barat",                           "39",     4177 )
  s(   1716, "Kepulauan Riau",                             "40",     4177 )
  s(   1717, "Sulawesi Barat",                             "41",     4177 )
  s(   1718, "Carlow",                                     "01",     4178 )
  s(   1719, "Cavan",                                      "02",     4178 )
  s(   1720, "Clare",                                      "03",     4178 )
  s(   1721, "Cork",                                       "04",     4178 )
  s(   1722, "Donegal",                                    "06",     4178 )
  s(   1723, "Dublin",                                     "07",     4178 )
  s(   1724, "Galway",                                     "10",     4178 )
  s(   1725, "Kerry",                                      "11",     4178 )
  s(   1726, "Kildare",                                    "12",     4178 )
  s(   1727, "Kilkenny",                                   "13",     4178 )
  s(   1728, "Leitrim",                                    "14",     4178 )
  s(   1729, "Laois",                                      "15",     4178 )
  s(   1730, "Limerick",                                   "16",     4178 )
  s(   1731, "Longford",                                   "18",     4178 )
  s(   1732, "Louth",                                      "19",     4178 )
  s(   1733, "Mayo",                                       "20",     4178 )
  s(   1734, "Meath",                                      "21",     4178 )
  s(   1735, "Monaghan",                                   "22",     4178 )
  s(   1736, "Offaly",                                     "23",     4178 )
  s(   1737, "Roscommon",                                  "24",     4178 )
  s(   1738, "Sligo",                                      "25",     4178 )
  s(   1739, "Tipperary",                                  "26",     4178 )
  s(   1740, "Waterford",                                  "27",     4178 )
  s(   1741, "Westmeath",                                  "29",     4178 )
  s(   1742, "Wexford",                                    "30",     4178 )
  s(   1743, "Wicklow",                                    "31",     4178 )
  s(   1744, "HaDarom",                                    "01",     4179 )
  s(   1745, "HaMerkaz",                                   "02",     4179 )
  s(   1746, "HaZafon",                                    "03",     4179 )
  s(   1747, "Hefa",                                       "04",     4179 )
  s(   1748, "Tel Aviv",                                   "05",     4179 )
  s(   1749, "Yerushalayim",                               "06",     4179 )
  s(   1750, "Andaman and Nicobar Islands",                "01",     4181 )
  s(   1751, "Andhra Pradesh",                             "02",     4181 )
  s(   1752, "Assam",                                      "03",     4181 )
  s(   1753, "Chandigarh",                                 "05",     4181 )
  s(   1754, "Dadra and Nagar Haveli",                     "06",     4181 )
  s(   1755, "Delhi",                                      "07",     4181 )
  s(   1756, "Gujarat",                                    "09",     4181 )
  s(   1757, "Haryana",                                    "10",     4181 )
  s(   1758, "Himachal Pradesh",                           "11",     4181 )
  s(   1759, "Jammu and Kashmir",                          "12",     4181 )
  s(   1760, "Kerala",                                     "13",     4181 )
  s(   1761, "Lakshadweep",                                "14",     4181 )
  s(   1762, "Maharashtra",                                "16",     4181 )
  s(   1763, "Manipur",                                    "17",     4181 )
  s(   1764, "Meghalaya",                                  "18",     4181 )
  s(   1765, "Karnataka",                                  "19",     4181 )
  s(   1766, "Nagaland",                                   "20",     4181 )
  s(   1767, "Orissa",                                     "21",     4181 )
  s(   1768, "Puducherry",                                 "22",     4181 )
  s(   1769, "Punjab",                                     "04",     4253 )
  s(   1770, "Rajasthan",                                  "24",     4181 )
  s(   1771, "Tamil Nadu",                                 "25",     4181 )
  s(   1772, "Tripura",                                    "26",     4181 )
  s(   1773, "West Bengal",                                "28",     4181 )
  s(   1774, "Sikkim",                                     "29",     4181 )
  s(   1775, "Arunachal Pradesh",                          "30",     4181 )
  s(   1776, "Mizoram",                                    "31",     4181 )
  s(   1777, "Daman and Diu",                              "32",     4181 )
  s(   1778, "Goa",                                        "33",     4181 )
  s(   1779, "Bihar",                                      "34",     4181 )
  s(   1780, "Madhya Pradesh",                             "35",     4181 )
  s(   1781, "Uttar Pradesh",                              "36",     4181 )
  s(   1782, "Chhattisgarh",                               "37",     4181 )
  s(   1783, "Jharkhand",                                  "38",     4181 )
  s(   1784, "Uttarakhand",                                "39",     4181 )
  s(   1785, "Al Anbar",                                   "01",     4183 )
  s(   1786, "Al Basrah",                                  "02",     4183 )
  s(   1787, "Al Muthanna",                                "03",     4183 )
  s(   1788, "Al Qadisiyah",                               "04",     4183 )
  s(   1789, "As Sulaymaniyah",                            "05",     4183 )
  s(   1790, "Babil",                                      "06",     4183 )
  s(   1791, "Baghdad",                                    "07",     4183 )
  s(   1792, "Dahuk",                                      "08",     4183 )
  s(   1793, "Dhi Qar",                                    "09",     4183 )
  s(   1794, "Diyala",                                     "10",     4183 )
  s(   1795, "Arbil",                                      "11",     4183 )
  s(   1796, "Karbala'",                                   "12",     4183 )
  s(   1797, "At Ta'mim",                                  "13",     4183 )
  s(   1798, "Maysan",                                     "14",     4183 )
  s(   1799, "Ninawa",                                     "15",     4183 )
  s(   1800, "Wasit",                                      "16",     4183 )
  s(   1801, "An Najaf",                                   "17",     4183 )
  s(   1802, "Salah ad Din",                               "18",     4183 )
  s(   1803, "Azarbayjan-e Bakhtari",                      "01",     4184 )
  s(   1804, "Azarbayjan-e Khavari",                       "02",     4184 )
  s(   1805, "Chahar Mahall va Bakhtiari",                 "03",     4184 )
  s(   1806, "Sistan va Baluchestan",                      "04",     4184 )
  s(   1807, "Kohkiluyeh va Buyer Ahmadi",                 "05",     4184 )
  s(   1808, "Fars",                                       "07",     4184 )
  s(   1809, "Gilan",                                      "08",     4184 )
  s(   1810, "Hamadan",                                    "09",     4184 )
  s(   1811, "Ilam",                                       "10",     4184 )
  s(   1812, "Hormozgan",                                  "11",     4184 )
  s(   1813, "Kerman",                                     "12",     4184 )
  s(   1814, "Bakhtaran",                                  "13",     4184 )
  s(   1815, "Khuzestan",                                  "15",     4184 )
  s(   1816, "Kordestan",                                  "16",     4184 )
  s(   1817, "Mazandaran",                                 "17",     4184 )
  s(   1818, "Semnan Province",                            "18",     4184 )
  s(   1819, "Markazi",                                    "19",     4184 )
  s(   1820, "Zanjan",                                     "21",     4184 )
  s(   1821, "Bushehr",                                    "22",     4184 )
  s(   1822, "Lorestan",                                   "23",     4184 )
  s(   1823, "Markazi",                                    "24",     4184 )
  s(   1824, "Semnan",                                     "25",     4184 )
  s(   1825, "Tehran",                                     "26",     4184 )
  s(   1826, "Zanjan",                                     "27",     4184 )
  s(   1827, "Esfahan",                                    "28",     4184 )
  s(   1828, "Kerman",                                     "29",     4184 )
  s(   1829, "Khorasan",                                   "30",     4184 )
  s(   1830, "Yazd",                                       "31",     4184 )
  s(   1831, "Ardabil",                                    "32",     4184 )
  s(   1832, "East Azarbaijan",                            "33",     4184 )
  s(   1833, "Markazi",                                    "34",     4184 )
  s(   1834, "Mazandaran",                                 "35",     4184 )
  s(   1835, "Zanjan",                                     "36",     4184 )
  s(   1836, "Golestan",                                   "37",     4184 )
  s(   1837, "Qazvin",                                     "38",     4184 )
  s(   1838, "Qom",                                        "39",     4184 )
  s(   1839, "Yazd",                                       "40",     4184 )
  s(   1840, "Khorasan-e Janubi",                          "41",     4184 )
  s(   1841, "Khorasan-e Razavi",                          "42",     4184 )
  s(   1842, "Khorasan-e Shemali",                         "43",     4184 )
  s(   1843, "Arnessysla",                                 "03",     4185 )
  s(   1844, "Austur-Hunavatnssysla",                      "05",     4185 )
  s(   1845, "Austur-Skaftafellssysla",                    "06",     4185 )
  s(   1846, "Borgarfjardarsysla",                         "07",     4185 )
  s(   1847, "Eyjafjardarsysla",                           "09",     4185 )
  s(   1848, "Gullbringusysla",                            "10",     4185 )
  s(   1849, "Kjosarsysla",                                "15",     4185 )
  s(   1850, "Myrasysla",                                  "17",     4185 )
  s(   1851, "Nordur-Mulasysla",                           "20",     4185 )

  s(   1852, "Nordur-Tingeyjarsysla",                      "21",     4185 )
  s(   1853, "Rangarvallasysla",                           "23",     4185 )
  s(   1854, "Skagafjardarsysla",                          "28",     4185 )
  s(   1855, "Snafellsnes- og Hnappadalssysla",            "29",     4185 )
  s(   1856, "Sudur-Mulasysla",                            "31",     4185 )
  s(   1857, "Sudur-Tingeyjarsysla",                       "32",     4185 )
  s(   1858, "Vestur-Bardastrandarsysla",                  "34",     4185 )
  s(   1859, "Vestur-Hunavatnssysla",                      "35",     4185 )
  s(   1860, "Vestur-Isafjardarsysla",                     "36",     4185 )
  s(   1861, "Vestur-Skaftafellssysla",                    "37",     4185 )
  s(   1862, "Norourland Eystra",                          "40",     4185 )
  s(   1863, "Norourland Vestra",                          "41",     4185 )
  s(   1864, "Suourland",                                  "42",     4185 )
  s(   1865, "Suournes",                                   "43",     4185 )
  s(   1866, "Vestfiroir",                                 "44",     4185 )
  s(   1867, "Vesturland",                                 "45",     4185 )
  s(   1868, "Abruzzi",                                    "01",     4186 )
  s(   1869, "Basilicata",                                 "02",     4186 )
  s(   1870, "Calabria",                                   "03",     4186 )
  s(   1871, "Campania",                                   "04",     4186 )
  s(   1872, "Emilia-Romagna",                             "05",     4186 )
  s(   1873, "Friuli-Venezia Giulia",                      "06",     4186 )
  s(   1874, "Lazio",                                      "07",     4186 )
  s(   1875, "Liguria",                                    "08",     4186 )
  s(   1876, "Lombardia",                                  "09",     4186 )
  s(   1877, "Marche",                                     "10",     4186 )
  s(   1878, "Molise",                                     "11",     4186 )
  s(   1879, "Piemonte",                                   "12",     4186 )
  s(   1880, "Puglia",                                     "13",     4186 )
  s(   1881, "Sardegna",                                   "14",     4186 )
  s(   1882, "Sicilia",                                    "15",     4186 )
  s(   1883, "Toscana",                                    "16",     4186 )
  s(   1884, "Trentino-Alto Adige",                        "17",     4186 )
  s(   1885, "Umbria",                                     "18",     4186 )
  s(   1886, "Valle d'Aosta",                              "19",     4186 )
  s(   1887, "Veneto",                                     "20",     4186 )
  s(   1888, "Clarendon",                                  "01",     4188 )
  s(   1889, "Hanover",                                    "02",     4188 )
  s(   1890, "Portland",                                   "07",     4188 )
  s(   1891, "Saint Ann",                                  "09",     4188 )
  s(   1892, "Saint Catherine",                            "10",     4188 )
  s(   1893, "Saint Elizabeth",                            "11",     4188 )
  s(   1894, "Trelawny",                                   "15",     4188 )
  s(   1895, "Westmoreland",                               "16",     4188 )
  s(   1896, "Kingston",                                   "17",     4188 )
  s(   1897, "Al Balqa'",                                  "02",     4189 )
  s(   1898, "Ma",                                         "07",     4189 )
  s(   1899, "Al Karak",                                   "09",     4189 )
  s(   1900, "Al Mafraq",                                  "10",     4189 )
  s(   1901, "Amman Governorate",                          "11",     4189 )
  s(   1902, "At Tafilah",                                 "12",     4189 )
  s(   1903, "Az Zarqa",                                   "13",     4189 )
  s(   1904, "Irbid",                                      "14",     4189 )
  s(   1905, "Amman",                                      "16",     4189 )
  s(   1906, "Aichi",                                      "01",     4190 )
  s(   1907, "Akita",                                      "02",     4190 )
  s(   1908, "Aomori",                                     "03",     4190 )
  s(   1909, "Chiba",                                      "04",     4190 )
  s(   1910, "Ehime",                                      "05",     4190 )
  s(   1911, "Fukui",                                      "06",     4190 )
  s(   1912, "Fukuoka",                                    "07",     4190 )
  s(   1913, "Fukushima",                                  "08",     4190 )
  s(   1914, "Gifu",                                       "09",     4190 )
  s(   1915, "Gumma",                                      "10",     4190 )
  s(   1916, "Hiroshima",                                  "11",     4190 )
  s(   1917, "Hokkaido",                                   "12",     4190 )
  s(   1918, "Hyogo",                                      "13",     4190 )
  s(   1919, "Ibaraki",                                    "14",     4190 )
  s(   1920, "Ishikawa",                                   "15",     4190 )
  s(   1921, "Iwate",                                      "16",     4190 )
  s(   1922, "Kagawa",                                     "17",     4190 )
  s(   1923, "Kagoshima",                                  "18",     4190 )
  s(   1924, "Kanagawa",                                   "19",     4190 )
  s(   1925, "Kochi",                                      "20",     4190 )
  s(   1926, "Kumamoto",                                   "21",     4190 )
  s(   1927, "Kyoto",                                      "22",     4190 )
  s(   1928, "Mie",                                        "23",     4190 )
  s(   1929, "Miyagi",                                     "24",     4190 )
  s(   1930, "Miyazaki",                                   "25",     4190 )
  s(   1931, "Nagano",                                     "26",     4190 )
  s(   1932, "Nagasaki",                                   "27",     4190 )
  s(   1933, "Nara",                                       "28",     4190 )
  s(   1934, "Niigata",                                    "29",     4190 )
  s(   1935, "Oita",                                       "30",     4190 )
  s(   1936, "Okayama",                                    "31",     4190 )
  s(   1937, "Osaka",                                      "32",     4190 )
  s(   1938, "Saga",                                       "33",     4190 )
  s(   1939, "Saitama",                                    "34",     4190 )
  s(   1940, "Shiga",                                      "35",     4190 )
  s(   1941, "Shimane",                                    "36",     4190 )
  s(   1942, "Shizuoka",                                   "37",     4190 )
  s(   1943, "Tochigi",                                    "38",     4190 )
  s(   1944, "Tokushima",                                  "39",     4190 )
  s(   1945, "Tokyo",                                      "40",     4190 )
  s(   1946, "Tottori",                                    "41",     4190 )
  s(   1947, "Toyama",                                     "42",     4190 )
  s(   1948, "Wakayama",                                   "43",     4190 )
  s(   1949, "Yamagata",                                   "44",     4190 )
  s(   1950, "Yamaguchi",                                  "45",     4190 )
  s(   1951, "Yamanashi",                                  "46",     4190 )
  s(   1952, "Okinawa",                                    "47",     4190 )
  s(   1954, "Nairobi Area",                               "05",     4191 )
  s(   1955, "North-Eastern",                              "06",     4191 )
  s(   1956, "Nyanza",                                     "07",     4191 )
  s(   1957, "Rift Valley",                                "08",     4191 )
  s(   1958, "Bishkek",                                    "01",     4192 )
  s(   1959, "Chuy",                                       "02",     4192 )
  s(   1960, "Jalal-Abad",                                 "03",     4192 )
  s(   1961, "Naryn",                                      "04",     4192 )
  s(   1962, "Osh",                                        "05",     4192 )
  s(   1963, "Talas",                                      "06",     4192 )
  s(   1964, "Ysyk-Kol",                                   "07",     4192 )
  s(   1965, "Osh",                                        "08",     4192 )
  s(   1966, "Batken",                                     "09",     4192 )
  s(   1967, "Kampong Cham",                               "02",     4193 )
  s(   1968, "Kampong Chhnang",                            "03",     4193 )
  s(   1969, "Kampong Spoe",                               "04",     4193 )
  s(   1970, "Kampong Thum",                               "05",     4193 )
  s(   1971, "Kampot",                                     "06",     4193 )
  s(   1972, "Kandal",                                     "07",     4193 )
  s(   1973, "Kaoh Kong",                                  "08",     4193 )
  s(   1974, "Kracheh",                                    "09",     4193 )
  s(   1975, "Mondol Kiri",                                "10",     4193 )
  s(   1976, "Phnum Penh",                                 "11",     4193 )
  s(   1977, "Pouthisat",                                  "12",     4193 )
  s(   1978, "Preah Vihear",                               "13",     4193 )
  s(   1979, "Prey Veng",                                  "14",     4193 )
  s(   1980, "Rotanokiri",                                 "15",     4193 )
  s(   1981, "Siemreab-Otdar Meanchey",                    "16",     4193 )
  s(   1982, "Stoeng Treng",                               "17",     4193 )
  s(   1983, "Svay Rieng",                                 "18",     4193 )
  s(   1984, "Takev",                                      "19",     4193 )
  s(   1985, "Batdambang",                                 "29",     4193 )
  s(   1986, "Pailin",                                     "30",     4193 )
  s(   1987, "Gilbert Islands",                            "01",     4194 )
  s(   1988, "Line Islands",                               "02",     4194 )
  s(   1989, "Phoenix Islands",                            "03",     4194 )
  s(   1990, "Anjouan",                                    "01",     4195 )
  s(   1991, "Grande Comore",                              "02",     4195 )
  s(   1992, "Moheli",                                     "03",     4195 )
  s(   1993, "Christ Church Nichola Town",                 "01",     4196 )
  s(   1994, "Saint Anne Sandy Point",                     "02",     4196 )
  s(   1995, "Saint George Basseterre",                    "03",     4196 )
  s(   1996, "Saint George Gingerland",                    "04",     4196 )
  s(   1997, "Saint James Windward",                       "05",     4196 )
  s(   1998, "Saint John Capisterre",                      "06",     4196 )
  s(   1999, "Saint John Figtree",                         "07",     4196 )
  s(   2000, "Saint Mary Cayon",                           "08",     4196 )
  s(   2001, "Saint Paul Capisterre",                      "09",     4196 )
  s(   2002, "Saint Paul Charlestown",                     "10",     4196 )
  s(   2003, "Saint Peter Basseterre",                     "11",     4196 )
  s(   2004, "Saint Thomas Lowland",                       "12",     4196 )
  s(   2005, "Saint Thomas Middle Island",                 "13",     4196 )
  s(   2006, "Trinity Palmetto Point",                     "15",     4196 )
  s(   2007, "Chagang-do",                                 "01",     4197 )
  s(   2008, "Hamgyong-namdo",                             "03",     4197 )
  s(   2009, "Hwanghae-namdo",                             "06",     4197 )
  s(   2010, "Hwanghae-bukto",                             "07",     4197 )
  s(   2011, "Kaesong-si",                                 "08",     4197 )
  s(   2012, "Kangwon-do",                                 "09",     4197 )
  s(   2013, "P'yongan-bukto",                             "11",     4197 )
  s(   2014, "P'yongyang-si",                              "12",     4197 )
  s(   2015, "Yanggang-do",                                "13",     4197 )
  s(   2016, "Namp'o-si",                                  "14",     4197 )
  s(   2017, "P'yongan-namdo",                             "15",     4197 )
  s(   2018, "Hamgyong-bukto",                             "17",     4197 )
  s(   2019, "Najin Sonbong-si",                           "18",     4197 )
  s(   2020, "Cheju-do",                                   "01",     4198 )
  s(   2021, "Cholla-bukto",                               "03",     4198 )
  s(   2022, "Ch'ungch'ong-bukto",                         "05",     4198 )
  s(   2023, "Kangwon-do",                                 "06",     4198 )
  s(   2024, "Pusan-jikhalsi",                             "10",     4198 )
  s(   2025, "Seoul-t'ukpyolsi",                           "11",     4198 )
  s(   2026, "Inch'on-jikhalsi",                           "12",     4198 )
  s(   2027, "Kyonggi-do",                                 "13",     4198 )
  s(   2028, "Kyongsang-bukto",                            "14",     4198 )
  s(   2029, "Taegu-jikhalsi",                             "15",     4198 )
  s(   2030, "Cholla-namdo",                               "16",     4198 )
  s(   2031, "Ch'ungch'ong-namdo",                         "17",     4198 )
  s(   2032, "Kwangju-jikhalsi",                           "18",     4198 )
  s(   2033, "Taejon-jikhalsi",                            "19",     4198 )
  s(   2034, "Kyongsang-namdo",                            "20",     4198 )
  s(   2035, "Ulsan-gwangyoksi",                           "21",     4198 )
  s(   2036, "Al Ahmadi",                                  "01",     4199 )
  s(   2037, "Al Kuwayt",                                  "02",     4199 )
  s(   2038, "Al Jahra",                                   "05",     4199 )
  s(   2039, "Al Farwaniyah",                              "07",     4199 )
  s(   2040, "Hawalli",                                    "08",     4199 )
  s(   2041, "Mubarak al Kabir",                           "09",     4199 )
  s(   2042, "Creek",                                      "01",     4200 )
  s(   2043, "Midland",                                    "03",     4200 )
  s(   2044, "South Town",                                 "04",     4200 )
  s(   2045, "Spot Bay",                                   "05",     4200 )
  s(   2046, "Stake Bay",                                  "06",     4200 )
  s(   2047, "West End",                                   "07",     4200 )
  s(   2048, "Almaty",                                     "01",     4201 )
  s(   2049, "Almaty City",                                "02",     4201 )
  s(   2050, "Aqmola",                                     "03",     4201 )
  s(   2051, "Aqtobe",                                     "04",     4201 )
  s(   2052, "Astana",                                     "05",     4201 )
  s(   2053, "Atyrau",                                     "06",     4201 )
  s(   2054, "West Kazakhstan",                            "07",     4201 )
  s(   2055, "Bayqonyr",                                   "08",     4201 )
  s(   2056, "Mangghystau",                                "09",     4201 )
  s(   2057, "South Kazakhstan",                           "10",     4201 )
  s(   2058, "Pavlodar",                                   "11",     4201 )
  s(   2059, "Qaraghandy",                                 "12",     4201 )
  s(   2060, "Qostanay",                                   "13",     4201 )
  s(   2061, "Qyzylorda",                                  "14",     4201 )
  s(   2062, "East Kazakhstan",                            "15",     4201 )
  s(   2063, "North Kazakhstan",                           "16",     4201 )
  s(   2064, "Zhambyl",                                    "17",     4201 )
  s(   2065, "Attapu",                                     "01",     4202 )
  s(   2066, "Champasak",                                  "02",     4202 )
  s(   2067, "Houaphan",                                   "03",     4202 )
  s(   2068, "Khammouan",                                  "04",     4202 )
  s(   2069, "Louang Namtha",                              "05",     4202 )
  s(   2070, "Oudomxai",                                   "07",     4202 )
  s(   2071, "Phongsali",                                  "08",     4202 )
  s(   2072, "Saravan",                                    "09",     4202 )
  s(   2073, "Savannakhet",                                "10",     4202 )
  s(   2074, "Vientiane",                                  "11",     4202 )
  s(   2075, "Xaignabouri",                                "13",     4202 )
  s(   2076, "Xiangkhoang",                                "14",     4202 )
  s(   2077, "Louangphrabang",                             "17",     4202 )
  s(   2078, "Beqaa",                                      "01",     4203 )
  s(   2079, "Liban-Nord",                                 "03",     4203 )
  s(   2080, "Beyrouth",                                   "04",     4203 )
  s(   2081, "Mont-Liban",                                 "05",     4203 )
  s(   2082, "Liban-Sud",                                  "06",     4203 )
  s(   2083, "Nabatiye",                                   "07",     4203 )
  s(   2084, "Beqaa",                                      "08",     4203 )
  s(   2085, "Liban-Nord",                                 "09",     4203 )
  s(   2086, "Aakk,r",                                     "10",     4203 )
  s(   2087, "Baalbek-Hermel",                             "11",     4203 )
  s(   2088, "Anse-la-Raye",                               "01",     4204 )
  s(   2089, "Dauphin",                                    "02",     4204 )
  s(   2090, "Castries",                                   "03",     4204 )
  s(   2091, "Choiseul",                                   "12",     4269 )
  s(   2092, "Dennery",                                    "05",     4204 )
  s(   2093, "Gros-Islet",                                 "06",     4204 )
  s(   2094, "Laborie",                                    "07",     4204 )
  s(   2095, "Micoud",                                     "08",     4204 )
  s(   2096, "Soufriere",                                  "09",     4204 )
  s(   2097, "Vieux-Fort",                                 "10",     4204 )
  s(   2098, "Praslin",                                    "05",     4286 )
  s(   2099, "Balzers",                                    "01",     4205 )
  s(   2100, "Eschen",                                     "02",     4205 )
  s(   2101, "Gamprin",                                    "03",     4205 )
  s(   2102, "Mauren",                                     "04",     4205 )
  s(   2103, "Planken",                                    "05",     4205 )
  s(   2104, "Ruggell",                                    "06",     4205 )
  s(   2105, "Schaan",                                     "07",     4205 )
  s(   2106, "Schellenberg",                               "08",     4205 )
  s(   2107, "Triesen",                                    "09",     4205 )
  s(   2108, "Triesenberg",                                "10",     4205 )
  s(   2109, "Vaduz",                                      "11",     4205 )
  s(   2110, "Gbarpolu",                                   "21",     4205 )
  s(   2111, "River Gee",                                  "22",     4205 )
  s(   2112, "Amparai",                                    "01",     4206 )
  s(   2113, "Anuradhapura",                               "02",     4206 )
  s(   2114, "Badulla",                                    "03",     4206 )
  s(   2115, "Batticaloa",                                 "04",     4206 )
  s(   2116, "Galle",                                      "06",     4206 )
  s(   2117, "Hambantota",                                 "07",     4206 )
  s(   2118, "Kalutara",                                   "09",     4206 )
  s(   2119, "Kandy",                                      "10",     4206 )
  s(   2120, "Kegalla",                                    "11",     4206 )
  s(   2121, "Kurunegala",                                 "12",     4206 )
  s(   2122, "Matale",                                     "14",     4206 )
  s(   2123, "Matara",                                     "15",     4206 )
  s(   2124, "Moneragala",                                 "16",     4206 )
  s(   2125, "Nuwara Eliya",                               "17",     4206 )
  s(   2126, "Polonnaruwa",                                "18",     4206 )
  s(   2127, "Puttalam",                                   "19",     4206 )
  s(   2128, "Ratnapura",                                  "20",     4206 )
  s(   2129, "Trincomalee",                                "21",     4206 )
  s(   2130, "Colombo",                                    "23",     4206 )
  s(   2131, "Gampaha",                                    "24",     4206 )
  s(   2132, "Jaffna",                                     "25",     4206 )
  s(   2133, "Mannar",                                     "26",     4206 )
  s(   2134, "Mullaittivu",                                "27",     4206 )
  s(   2135, "Vavuniya",                                   "28",     4206 )
  s(   2136, "North Central",                              "30",     4206 )
  s(   2137, "North Western",                              "32",     4206 )
  s(   2138, "Sabaragamuwa",                               "33",     4206 )
  s(   2139, "Uva",                                        "35",     4206 )
  s(   2140, "Bong",                                       "01",     4207 )
  s(   2141, "Grand Cape Mount",                           "04",     4207 )
  s(   2142, "Monrovia",                                   "07",     4207 )
  s(   2143, "Nimba",                                      "09",     4207 )
  s(   2144, "Sino",                                       "10",     4207 )
  s(   2145, "Grand Bassa",                                "11",     4207 )
  s(   2146, "Montserrado",                                "14",     4207 )
  s(   2147, "Grand Gedeh",                                "19",     4207 )
  s(   2148, "Lofa",                                       "20",     4207 )
  s(   2149, "Berea",                                      "10",     4208 )
  s(   2150, "Butha-Buthe",                                "11",     4208 )
  s(   2151, "Leribe",                                     "12",     4208 )
  s(   2152, "Mafeteng",                                   "13",     4208 )
  s(   2153, "Maseru",                                     "14",     4208 )
  s(   2154, "Mohales Hoek",                               "15",     4208 )
  s(   2155, "Mokhotlong",                                 "16",     4208 )
  s(   2156, "Qachas Nek",                                 "17",     4208 )
  s(   2157, "Quthing",                                    "18",     4208 )
  s(   2158, "Thaba-Tseka",                                "19",     4208 )
  s(   2159, "Alytaus Apskritis",                          "56",     4209 )
  s(   2160, "Kauno Apskritis",                            "57",     4209 )
  s(   2161, "Klaipedos Apskritis",                        "58",     4209 )
  s(   2162, "Marijampoles Apskritis",                     "59",     4209 )
  s(   2163, "Panevezio Apskritis",                        "60",     4209 )
  s(   2164, "Siauliu Apskritis",                          "61",     4209 )
  s(   2165, "Taurages Apskritis",                         "62",     4209 )
  s(   2166, "Telsiu Apskritis",                           "63",     4209 )
  s(   2167, "Utenos Apskritis",                           "64",     4209 )
  s(   2168, "Vilniaus Apskritis",                         "65",     4209 )
  s(   2169, "Diekirch",                                   "01",     4210 )
  s(   2170, "Grevenmacher",                               "02",     4210 )
  s(   2171, "Aizkraukles",                                "01",     4211 )
  s(   2172, "Aluksnes",                                   "02",     4211 )
  s(   2173, "Balvu",                                      "03",     4211 )
  s(   2174, "Bauskas",                                    "04",     4211 )
  s(   2175, "Cesu",                                       "05",     4211 )
  s(   2176, "Daugavpils",                                 "06",     4211 )
  s(   2177, "Daugavpils",                                 "07",     4211 )
  s(   2178, "Dobeles",                                    "08",     4211 )
  s(   2179, "Gulbenes",                                   "09",     4211 )
  s(   2180, "Jekabpils",                                  "10",     4211 )
  s(   2181, "Jelgava",                                    "11",     4211 )
  s(   2182, "Jelgavas",                                   "12",     4211 )
  s(   2183, "Jurmala",                                    "13",     4211 )
  s(   2184, "Kraslavas",                                  "14",     4211 )
  s(   2185, "Kuldigas",                                   "15",     4211 )
  s(   2186, "Liepaja",                                    "16",     4211 )
  s(   2187, "Liepajas",                                   "17",     4211 )
  s(   2188, "Limbazu",                                    "18",     4211 )
  s(   2189, "Ludzas",                                     "19",     4211 )
  s(   2190, "Madonas",                                    "20",     4211 )
  s(   2191, "Ogres",                                      "21",     4211 )
  s(   2192, "Preilu",                                     "22",     4211 )
  s(   2193, "Rezekne",                                    "23",     4211 )
  s(   2194, "Rezeknes",                                   "24",     4211 )
  s(   2195, "Riga",                                       "25",     4211 )
  s(   2196, "Rigas",                                      "26",     4211 )
  s(   2197, "Saldus",                                     "27",     4211 )
  s(   2198, "Talsu",                                      "28",     4211 )
  s(   2199, "Tukuma",                                     "29",     4211 )
  s(   2200, "Valkas",                                     "30",     4211 )
  s(   2201, "Valmieras",                                  "31",     4211 )
  s(   2202, "Ventspils",                                  "32",     4211 )
  s(   2203, "Ventspils",                                  "33",     4211 )
  s(   2204, "Al Aziziyah",                                "03",     4212 )
  s(   2205, "Al Jufrah",                                  "05",     4212 )
  s(   2206, "Al Kufrah",                                  "08",     4212 )
  s(   2207, "Ash Shati'",                                 "13",     4212 )
  s(   2208, "Murzuq",                                     "30",     4212 )
  s(   2209, "Sabha",                                      "34",     4212 )
  s(   2210, "Tarhunah",                                   "41",     4212 )
  s(   2211, "Tubruq",                                     "42",     4212 )
  s(   2212, "Zlitan",                                     "45",     4212 )
  s(   2213, "Ajdabiya",                                   "47",     4212 )
  s(   2214, "Al Fatih",                                   "48",     4212 )
  s(   2215, "Al Jabal al Akhdar",                         "49",     4212 )
  s(   2216, "Al Khums",                                   "50",     4212 )
  s(   2217, "An Nuqat al Khams",                          "51",     4212 )
  s(   2218, "Awbari",                                     "52",     4212 )
  s(   2219, "Az Zawiyah",                                 "53",     4212 )
  s(   2220, "Banghazi",                                   "54",     4212 )
  s(   2221, "Darnah",                                     "55",     4212 )
  s(   2222, "Ghadamis",                                   "56",     4212 )
  s(   2223, "Gharyan",                                    "57",     4212 )
  s(   2224, "Misratah",                                   "58",     4212 )
  s(   2225, "Sawfajjin",                                  "59",     4212 )
  s(   2226, "Surt",                                       "60",     4212 )
  s(   2227, "Tarabulus",                                  "61",     4212 )
  s(   2228, "Yafran",                                     "62",     4212 )
  s(   2229, "Agadir",                                     "01",     4213 )
  s(   2230, "Al Hoceima",                                 "02",     4213 )
  s(   2231, "Azilal",                                     "03",     4213 )
  s(   2232, "Ben Slimane",                                "04",     4213 )
  s(   2233, "Beni Mellal",                                "05",     4213 )
  s(   2234, "Boulemane",                                  "06",     4213 )
  s(   2235, "Casablanca",                                 "07",     4213 )
  s(   2236, "Chaouen",                                    "08",     4213 )
  s(   2237, "El Jadida",                                  "09",     4213 )
  s(   2238, "El Kelaa des Srarhna",                       "10",     4213 )
  s(   2239, "Er Rachidia",                                "11",     4213 )
  s(   2240, "Essaouira",                                  "12",     4213 )
  s(   2241, "Fes",                                        "13",     4213 )
  s(   2242, "Figuig",                                     "14",     4213 )
  s(   2243, "Kenitra",                                    "15",     4213 )
  s(   2244, "Khemisset",                                  "16",     4213 )
  s(   2245, "Khenifra",                                   "17",     4213 )
  s(   2246, "Khouribga",                                  "18",     4213 )
  s(   2247, "Marrakech",                                  "19",     4213 )
  s(   2248, "Meknes",                                     "20",     4213 )
  s(   2249, "Nador",                                      "21",     4213 )
  s(   2250, "Ouarzazate",                                 "22",     4213 )
  s(   2251, "Oujda",                                      "23",     4213 )
  s(   2252, "Rabat-Sale",                                 "24",     4213 )
  s(   2253, "Safi",                                       "25",     4213 )
  s(   2254, "Settat",                                     "26",     4213 )
  s(   2255, "Tanger",                                     "27",     4213 )
  s(   2256, "Tata",                                       "29",     4213 )
  s(   2257, "Taza",                                       "30",     4213 )
  s(   2258, "Tiznit",                                     "32",     4213 )
  s(   2259, "Guelmim",                                    "33",     4213 )
  s(   2260, "Ifrane",                                     "34",     4213 )
  s(   2261, "Laayoune",                                   "35",     4141 )
  s(   2262, "Tan-Tan",                                    "36",     4213 )
  s(   2263, "Taounate",                                   "37",     4213 )
  s(   2264, "Sidi Kacem",                                 "38",     4213 )
  s(   2265, "Taroudannt",                                 "39",     4213 )
  s(   2266, "Tetouan",                                    "40",     4213 )
  s(   2267, "Larache",                                    "41",     4213 )
  s(   2268, "Grand Casablanca",                           "45",     4213 )
  s(   2269, "Fes-Boulemane",                              "46",     4213 )
  s(   2270, "Marrakech-Tensift-Al Haouz",                 "47",     4213 )
  s(   2271, "Meknes-Tafilalet",                           "48",     4213 )
  s(   2272, "Rabat-Sale-Zemmour-Zaer",                    "49",     4213 )
  s(   2273, "Chaouia-Ouardigha",                          "50",     4213 )
  s(   2274, "Doukkala-Abda",                              "51",     4213 )
  s(   2275, "Gharb-Chrarda-Beni Hssen",                   "52",     4213 )
  s(   2276, "Guelmim-Es Smara",                           "53",     4213 )
  s(   2277, "Oriental",                                   "54",     4213 )
  s(   2278, "Souss-Massa-Dr,a",                           "55",     4213 )
  s(   2279, "Tadla-Azilal",                               "56",     4213 )
  s(   2280, "Tanger-Tetouan",                             "57",     4213 )
  s(   2281, "Taza-Al Hoceima-Taounate",                   "58",     4213 )
  s(   2282, "La,youne-Boujdour-Sakia El Hamra",           "59",     4213 )
  s(   2283, "La Condamine",                               "01",     4214 )
  s(   2284, "Monaco",                                     "02",     4214 )
  s(   2285, "Monte-Carlo",                                "03",     4214 )
  s(   2286, "Balti",                                      "46",     4215 )
  s(   2287, "Cahul",                                      "47",     4215 )
  s(   2288, "Chisinau",                                   "48",     4215 )
  s(   2289, "Stinga Nistrului",                           "49",     4215 )
  s(   2290, "Edinet",                                     "50",     4215 )
  s(   2291, "Gagauzia",                                   "51",     4215 )
  s(   2292, "Lapusna",                                    "52",     4215 )
  s(   2293, "Orhei",                                      "53",     4215 )
  s(   2294, "Soroca",                                     "54",     4215 )
  s(   2295, "Tighina",                                    "55",     4215 )
  s(   2296, "Ungheni",                                    "56",     4215 )
  s(   2297, "Stinga Nistrului",                           "58",     4215 )
  s(   2298, "Anenii Noi",                                 "59",     4215 )
  s(   2299, "Balti",                                      "60",     4215 )
  s(   2300, "Basarabeasca",                               "61",     4215 )
  s(   2301, "Bender",                                     "62",     4215 )
  s(   2302, "Briceni",                                    "63",     4215 )
  s(   2303, "Cahul",                                      "64",     4215 )
  s(   2304, "Cantemir",                                   "65",     4215 )
  s(   2305, "Calarasi",                                   "41",     4264 )
  s(   2306, "Causeni",                                    "67",     4215 )
  s(   2307, "Cimislia",                                   "68",     4215 )
  s(   2308, "Criuleni",                                   "69",     4215 )
  s(   2309, "Donduseni",                                  "70",     4215 )
  s(   2310, "Drochia",                                    "71",     4215 )
  s(   2311, "Dubasari",                                   "72",     4215 )
  s(   2312, "Edinet",                                     "73",     4215 )
  s(   2313, "Falesti",                                    "74",     4215 )
  s(   2314, "Floresti",                                   "75",     4215 )
  s(   2315, "Glodeni",                                    "76",     4215 )
  s(   2316, "Hincesti",                                   "77",     4215 )
  s(   2317, "Ialoveni",                                   "78",     4215 )
  s(   2318, "Leova",                                      "79",     4215 )
  s(   2319, "Nisporeni",                                  "80",     4215 )
  s(   2320, "Ocnita",                                     "81",     4215 )
  s(   2321, "Rezina",                                     "83",     4215 )
  s(   2322, "Riscani",                                    "84",     4215 )
  s(   2323, "Singerei",                                   "85",     4215 )
  s(   2324, "Soldanesti",                                 "86",     4215 )
  s(   2325, "Soroca",                                     "87",     4215 )
  s(   2326, "Stefan-Voda",                                "88",     4215 )
  s(   2327, "Straseni",                                   "89",     4215 )
  s(   2328, "Taraclia",                                   "90",     4215 )
  s(   2329, "Telenesti",                                  "91",     4215 )
  s(   2330, "Ungheni",                                    "92",     4215 )
  s(   2331, "Antsiranana",                                "01",     4217 )
  s(   2332, "Fianarantsoa",                               "02",     4217 )
  s(   2333, "Mahajanga",                                  "03",     4217 )
  s(   2334, "Toamasina",                                  "04",     4217 )
  s(   2335, "Antananarivo",                               "05",     4217 )
  s(   2336, "Toliara",                                    "06",     4217 )
  s(   2337, "Aracinovo",                                  "01",     4219 )
  s(   2338, "Bac",                                        "02",     4219 )
  s(   2339, "Belcista",                                   "03",     4219 )
  s(   2340, "Berovo",                                     "04",     4219 )
  s(   2341, "Bistrica",                                   "05",     4219 )
  s(   2342, "Bitola",                                     "06",     4219 )
  s(   2343, "Blatec",                                     "07",     4219 )
  s(   2344, "Bogdanci",                                   "08",     4219 )
  s(   2345, "Bogomila",                                   "09",     4219 )
  s(   2346, "Bogovinje",                                  "10",     4219 )
  s(   2347, "Bosilovo",                                   "11",     4219 )
  s(   2348, "Brvenica",                                   "12",     4219 )
  s(   2349, "Cair",                                       "13",     4219 )
  s(   2350, "Capari",                                     "14",     4219 )
  s(   2351, "Caska",                                      "15",     4219 )
  s(   2352, "Cegrane",                                    "16",     4219 )
  s(   2353, "Centar",                                     "17",     4219 )
  s(   2354, "Centar Zupa",                                "18",     4219 )
  s(   2355, "Cesinovo",                                   "19",     4219 )
  s(   2356, "Cucer-Sandevo",                              "20",     4219 )
  s(   2357, "Debar",                                      "21",     4219 )
  s(   2358, "Delcevo",                                    "22",     4219 )
  s(   2359, "Delogozdi",                                  "23",     4219 )
  s(   2360, "Demir Hisar",                                "24",     4219 )
  s(   2361, "Demir Kapija",                               "25",     4219 )
  s(   2362, "Dobrusevo",                                  "26",     4219 )
  s(   2363, "Dolna Banjica",                              "27",     4219 )
  s(   2364, "Dolneni",                                    "28",     4219 )
  s(   2365, "Dorce Petrov",                               "29",     4219 )
  s(   2366, "Drugovo",                                    "30",     4219 )
  s(   2367, "Dzepciste",                                  "31",     4219 )
  s(   2368, "Gazi Baba",                                  "32",     4219 )
  s(   2369, "Gevgelija",                                  "33",     4219 )
  s(   2370, "Gostivar",                                   "34",     4219 )
  s(   2371, "Gradsko",                                    "35",     4219 )
  s(   2372, "Ilinden",                                    "36",     4219 )
  s(   2373, "Izvor",                                      "37",     4219 )
  s(   2374, "Jegunovce",                                  "38",     4219 )
  s(   2375, "Kamenjane",                                  "39",     4219 )
  s(   2376, "Karbinci",                                   "40",     4219 )
  s(   2377, "Karpos",                                     "41",     4219 )
  s(   2378, "Kavadarci",                                  "42",     4219 )
  s(   2379, "Kicevo",                                     "43",     4219 )
  s(   2380, "Kisela Voda",                                "44",     4219 )
  s(   2381, "Klecevce",                                   "45",     4219 )
  s(   2382, "Kocani",                                     "46",     4219 )
  s(   2383, "Konce",                                      "47",     4219 )
  s(   2384, "Kondovo",                                    "48",     4219 )
  s(   2385, "Konopiste",                                  "49",     4219 )
  s(   2386, "Kosel",                                      "50",     4219 )
  s(   2387, "Kratovo",                                    "51",     4219 )
  s(   2388, "Kriva Palanka",                              "52",     4219 )
  s(   2389, "Krivogastani",                               "53",     4219 )
  s(   2390, "Krusevo",                                    "54",     4219 )
  s(   2391, "Kuklis",                                     "55",     4219 )
  s(   2392, "Kukurecani",                                 "56",     4219 )
  s(   2393, "Kumanovo",                                   "57",     4219 )
  s(   2394, "Labunista",                                  "58",     4219 )
  s(   2395, "Lipkovo",                                    "59",     4219 )
  s(   2396, "Lozovo",                                     "60",     4219 )
  s(   2397, "Lukovo",                                     "61",     4219 )
  s(   2398, "Makedonska Kamenica",                        "62",     4219 )
  s(   2399, "Makedonski Brod",                            "63",     4219 )
  s(   2400, "Mavrovi Anovi",                              "64",     4219 )
  s(   2401, "Meseista",                                   "65",     4219 )
  s(   2402, "Miravci",                                    "66",     4219 )
  s(   2403, "Mogila",                                     "67",     4219 )
  s(   2404, "Murtino",                                    "68",     4219 )
  s(   2405, "Negotino",                                   "69",     4219 )
  s(   2406, "Negotino-Polosko",                           "70",     4219 )
  s(   2407, "Novaci",                                     "71",     4219 )
  s(   2408, "Novo Selo",                                  "72",     4219 )
  s(   2409, "Oblesevo",                                   "73",     4219 )
  s(   2410, "Ohrid",                                      "74",     4219 )
  s(   2411, "Orasac",                                     "75",     4219 )
  s(   2412, "Orizari",                                    "76",     4219 )
  s(   2413, "Oslomej",                                    "77",     4219 )
  s(   2414, "Pehcevo",                                    "78",     4219 )
  s(   2415, "Petrovec",                                   "79",     4219 )
  s(   2416, "Plasnica",                                   "80",     4219 )
  s(   2417, "Podares",                                    "81",     4219 )
  s(   2418, "Prilep",                                     "82",     4219 )
  s(   2419, "Probistip",                                  "83",     4219 )
  s(   2420, "Radovis",                                    "84",     4219 )
  s(   2421, "Rankovce",                                   "85",     4219 )
  s(   2422, "Resen",                                      "86",     4219 )
  s(   2423, "Rosoman",                                    "87",     4219 )
  s(   2424, "Rostusa",                                    "88",     4219 )
  s(   2425, "Samokov",                                    "89",     4219 )
  s(   2426, "Saraj",                                      "90",     4219 )
  s(   2427, "Sipkovica",                                  "91",     4219 )
  s(   2428, "Sopiste",                                    "92",     4219 )
  s(   2429, "Sopotnica",                                  "93",     4219 )
  s(   2430, "Srbinovo",                                   "94",     4219 )
  s(   2431, "Staravina",                                  "95",     4219 )
  s(   2432, "Star Dojran",                                "96",     4219 )
  s(   2433, "Staro Nagoricane",                           "97",     4219 )
  s(   2434, "Stip",                                       "98",     4219 )
  s(   2435, "Struga",                                     "99",     4219 )
  s(   2436, "Strumica",                                   "A1",     4219 )
  s(   2437, "Studenicani",                                "A2",     4219 )
  s(   2438, "Suto Orizari",                               "A3",     4219 )
  s(   2439, "Sveti Nikole",                               "A4",     4219 )
  s(   2440, "Tearce",                                     "A5",     4219 )
  s(   2441, "Tetovo",                                     "A6",     4219 )
  s(   2442, "Topolcani",                                  "A7",     4219 )
  s(   2443, "Valandovo",                                  "A8",     4219 )
  s(   2444, "Vasilevo",                                   "A9",     4219 )
  s(   2445, "Veles",                                      "B1",     4219 )
  s(   2446, "Velesta",                                    "B2",     4219 )
  s(   2447, "Vevcani",                                    "B3",     4219 )
  s(   2448, "Vinica",                                     "B4",     4219 )
  s(   2449, "Vitoliste",                                  "B5",     4219 )
  s(   2450, "Vranestica",                                 "B6",     4219 )
  s(   2451, "Vrapciste",                                  "B7",     4219 )
  s(   2452, "Vratnica",                                   "B8",     4219 )
  s(   2453, "Vrutok",                                     "B9",     4219 )
  s(   2454, "Zajas",                                      "C1",     4219 )
  s(   2455, "Zelenikovo",                                 "C2",     4219 )
  s(   2456, "Zelino",                                     "C3",     4219 )
  s(   2457, "Zitose",                                     "C4",     4219 )
  s(   2458, "Zletovo",                                    "C5",     4219 )
  s(   2459, "Zrnovci",                                    "C6",     4219 )
  s(   2460, "Bamako",                                     "01",     4220 )
  s(   2461, "Kayes",                                      "03",     4220 )
  s(   2462, "Mopti",                                      "04",     4220 )
  s(   2463, "Segou",                                      "05",     4220 )
  s(   2464, "Sikasso",                                    "06",     4220 )
  s(   2465, "Koulikoro",                                  "07",     4220 )
  s(   2466, "Tombouctou",                                 "08",     4220 )
  s(   2467, "Gao",                                        "09",     4220 )
  s(   2468, "Kidal",                                      "10",     4220 )
  s(   2469, "Rakhine State",                              "01",     4221 )
  s(   2470, "Chin State",                                 "02",     4221 )
  s(   2471, "Irrawaddy",                                  "03",     4221 )
  s(   2472, "Kachin State",                               "04",     4221 )
  s(   2473, "Karan State",                                "05",     4221 )
  s(   2474, "Kayah State",                                "06",     4221 )
  s(   2475, "Magwe",                                      "07",     4221 )
  s(   2476, "Mandalay",                                   "08",     4221 )
  s(   2477, "Pegu",                                       "09",     4221 )
  s(   2478, "Sagaing",                                    "10",     4221 )
  s(   2479, "Shan State",                                 "11",     4221 )
  s(   2480, "Tenasserim",                                 "12",     4221 )
  s(   2481, "Mon State",                                  "13",     4221 )
  s(   2482, "Rangoon",                                    "14",     4221 )
  s(   2483, "Yangon",                                     "17",     4221 )
  s(   2484, "Arhangay",                                   "01",     4222 )
  s(   2485, "Bayanhongor",                                "02",     4222 )
  s(   2486, "Bayan-Olgiy",                                "03",     4222 )
  s(   2487, "Darhan",                                     "05",     4222 )
  s(   2488, "Dornod",                                     "06",     4222 )
  s(   2489, "Dornogovi",                                  "07",     4222 )
  s(   2490, "Dundgovi",                                   "08",     4222 )
  s(   2491, "Dzavhan",                                    "09",     4222 )
  s(   2492, "Govi-Altay",                                 "10",     4222 )
  s(   2493, "Hentiy",                                     "11",     4222 )
  s(   2494, "Hovd",                                       "12",     4222 )
  s(   2495, "Hovsgol",                                    "13",     4222 )
  s(   2496, "Omnogovi",                                   "14",     4222 )
  s(   2497, "Ovorhangay",                                 "15",     4222 )
  s(   2498, "Selenge",                                    "16",     4222 )
  s(   2499, "Suhbaatar",                                  "17",     4222 )
  s(   2500, "Tov",                                        "18",     4222 )
  s(   2501, "Uvs",                                        "19",     4222 )
  s(   2502, "Ulaanbaatar",                                "20",     4222 )
  s(   2503, "Bulgan",                                     "21",     4222 )
  s(   2504, "Erdenet",                                    "22",     4222 )
  s(   2505, "Darhan-Uul",                                 "23",     4222 )
  s(   2506, "Govisumber",                                 "24",     4222 )
  s(   2507, "Orhon",                                      "25",     4222 )
  s(   2508, "Ilhas",                                      "01",     4223 )
  s(   2509, "Macau",                                      "02",     4223 )
  s(   2510, "Hodh Ech Chargui",                           "01",     4226 )
  s(   2511, "Hodh El Gharbi",                             "02",     4226 )
  s(   2512, "Assaba",                                     "03",     4226 )
  s(   2513, "Gorgol",                                     "04",     4226 )
  s(   2514, "Brakna",                                     "05",     4226 )
  s(   2515, "Trarza",                                     "06",     4226 )
  s(   2516, "Dakhlet Nouadhibou",                         "08",     4226 )
  s(   2517, "Tagant",                                     "09",     4226 )
  s(   2518, "Guidimaka",                                  "10",     4226 )
  s(   2519, "Tiris Zemmour",                              "11",     4226 )
  s(   2520, "Inchiri",                                    "12",     4226 )
  s(   2521, "Saint Anthony",                              "01",     4227 )
  s(   2522, "Saint Georges",                              "02",     4227 )
  s(   2523, "Black River",                                "12",     4229 )
  s(   2524, "Flacq",                                      "13",     4229 )
  s(   2525, "Grand Port",                                 "14",     4229 )
  s(   2526, "Moka",                                       "15",     4229 )
  s(   2527, "Pamplemousses",                              "16",     4229 )
  s(   2528, "Plaines Wilhems",                            "17",     4229 )
  s(   2529, "Port Louis",                                 "18",     4229 )
  s(   2530, "Riviere du Rempart",                         "19",     4229 )
  s(   2531, "Savanne",                                    "20",     4229 )
  s(   2532, "Agalega Islands",                            "21",     4229 )
  s(   2533, "Cargados Carajos",                           "22",     4229 )
  s(   2534, "Rodrigues",                                  "23",     4229 )
  s(   2535, "Seenu",                                      "01",     4230 )
  s(   2536, "Aliff",                                      "02",     4230 )
  s(   2537, "Laviyani",                                   "03",     4230 )
  s(   2538, "Waavu",                                      "04",     4230 )
  s(   2539, "Laamu",                                      "05",     4230 )
  s(   2540, "Haa Aliff",                                  "07",     4230 )
  s(   2541, "Thaa",                                       "08",     4230 )
  s(   2542, "Meemu",                                      "12",     4230 )
  s(   2543, "Raa",                                        "13",     4230 )
  s(   2544, "Faafu",                                      "14",     4230 )
  s(   2545, "Daalu",                                      "17",     4230 )
  s(   2546, "Baa",                                        "20",     4230 )
  s(   2547, "Haa Daalu",                                  "23",     4230 )
  s(   2548, "Shaviyani",                                  "24",     4230 )
  s(   2549, "Noonu",                                      "25",     4230 )
  s(   2550, "Kaafu",                                      "26",     4230 )
  s(   2551, "Gaafu Aliff",                                "27",     4230 )
  s(   2552, "Gaafu Daalu",                                "28",     4230 )
  s(   2553, "Naviyani",                                   "29",     4230 )
  s(   2554, "Male",                                       "40",     4230 )
  s(   2555, "Chikwawa",                                   "02",     4231 )
  s(   2556, "Chiradzulu",                                 "03",     4231 )
  s(   2557, "Chitipa",                                    "04",     4231 )
  s(   2558, "Thyolo",                                     "05",     4231 )
  s(   2559, "Dedza",                                      "06",     4231 )
  s(   2560, "Dowa",                                       "07",     4231 )
  s(   2561, "Karonga",                                    "08",     4231 )
  s(   2562, "Kasungu",                                    "09",     4231 )
  s(   2563, "Lilongwe",                                   "11",     4231 )
  s(   2564, "Mangochi",                                   "12",     4231 )
  s(   2565, "Mchinji",                                    "13",     4231 )
  s(   2566, "Mzimba",                                     "15",     4231 )
  s(   2567, "Ntcheu",                                     "16",     4231 )
  s(   2568, "Nkhata Bay",                                 "17",     4231 )
  s(   2569, "Nkhotakota",                                 "18",     4231 )
  s(   2570, "Nsanje",                                     "19",     4231 )
  s(   2571, "Ntchisi",                                    "20",     4231 )
  s(   2572, "Rumphi",                                     "21",     4231 )
  s(   2573, "Salima",                                     "22",     4231 )
  s(   2574, "Zomba",                                      "23",     4231 )
  s(   2575, "Blantyre",                                   "24",     4231 )
  s(   2576, "Mwanza",                                     "12",     4302 )
  s(   2577, "Balaka",                                     "26",     4231 )
  s(   2578, "Likoma",                                     "27",     4231 )
  s(   2579, "Machinga",                                   "28",     4231 )
  s(   2580, "Mulanje",                                    "29",     4231 )
  s(   2581, "Phalombe",                                   "30",     4231 )
  s(   2582, "Aguascalientes",                             "01",     4232 )
  s(   2583, "Baja California",                            "02",     4232 )
  s(   2584, "Baja California Sur",                        "03",     4232 )
  s(   2585, "Campeche",                                   "04",     4232 )
  s(   2586, "Chiapas",                                    "05",     4232 )
  s(   2587, "Chihuahua",                                  "06",     4232 )
  s(   2588, "Coahuila de Zaragoza",                       "07",     4232 )
  s(   2589, "Colima",                                     "08",     4232 )
  s(   2590, "Durango",                                    "10",     4232 )
  s(   2591, "Guanajuato",                                 "11",     4232 )
  s(   2592, "Guerrero",                                   "12",     4232 )
  s(   2593, "Hidalgo",                                    "13",     4232 )
  s(   2594, "Jalisco",                                    "14",     4232 )
  s(   2595, "Mexico State",                               "15",     4232 )
  s(   2596, "Michoacan de Ocampo",                        "16",     4232 )
  s(   2597, "Morelos",                                    "17",     4232 )
  s(   2598, "Nayarit",                                    "18",     4232 )
  s(   2599, "Nuevo Leon",                                 "19",     4232 )
  s(   2600, "Oaxaca",                                     "20",     4232 )
  s(   2601, "Puebla",                                     "21",     4232 )
  s(   2602, "Queretaro de Arteaga",                       "22",     4232 )
  s(   2603, "Quintana Roo",                               "23",     4232 )
  s(   2604, "San Luis Potosi",                            "24",     4232 )
  s(   2605, "Sinaloa",                                    "25",     4232 )
  s(   2606, "Sonora",                                     "26",     4232 )
  s(   2607, "Tabasco",                                    "27",     4232 )
  s(   2608, "Tamaulipas",                                 "28",     4232 )
  s(   2609, "Tlaxcala",                                   "29",     4232 )
  s(   2610, "Veracruz-Llave",                             "30",     4232 )
  s(   2611, "Yucatan",                                    "31",     4232 )
  s(   2612, "Zacatecas",                                  "32",     4232 )
  s(   2613, "Johor",                                      "01",     4233 )
  s(   2614, "Kedah",                                      "02",     4233 )
  s(   2615, "Kelantan",                                   "03",     4233 )
  s(   2616, "Melaka",                                     "04",     4233 )
  s(   2617, "Negeri Sembilan",                            "05",     4233 )
  s(   2618, "Pahang",                                     "06",     4233 )
  s(   2619, "Perak",                                      "07",     4233 )
  s(   2620, "Perlis",                                     "08",     4233 )
  s(   2621, "Pulau Pinang",                               "09",     4233 )
  s(   2622, "Sarawak",                                    "11",     4233 )
  s(   2623, "Selangor",                                   "12",     4233 )
  s(   2624, "Terengganu",                                 "13",     4233 )
  s(   2625, "Kuala Lumpur",                               "14",     4233 )
  s(   2626, "Labuan",                                     "15",     4233 )
  s(   2627, "Sabah",                                      "16",     4233 )
  s(   2628, "Putrajaya",                                  "17",     4233 )
  s(   2629, "Cabo Delgado",                               "01",     4234 )
  s(   2630, "Gaza",                                       "GZ",     4258 )
  s(   2631, "Inhambane",                                  "03",     4234 )
  s(   2632, "Maputo",                                     "04",     4234 )
  s(   2633, "Sofala",                                     "05",     4234 )
  s(   2634, "Nampula",                                    "06",     4234 )
  s(   2635, "Niassa",                                     "07",     4234 )
  s(   2636, "Tete",                                       "08",     4234 )
  s(   2637, "Zambezia",                                   "09",     4234 )
  s(   2638, "Manica",                                     "10",     4234 )
  s(   2639, "Maputo",                                     "11",     4234 )
  s(   2640, "Bethanien",                                  "01",     4235 )
  s(   2641, "Caprivi Oos",                                "02",     4235 )
  s(   2642, "Boesmanland",                                "03",     4235 )
  s(   2643, "Gobabis",                                    "04",     4235 )
  s(   2644, "Grootfontein",                               "05",     4235 )
  s(   2645, "Kaokoland",                                  "06",     4235 )
  s(   2646, "Karibib",                                    "07",     4235 )
  s(   2647, "Keetmanshoop",                               "08",     4235 )
  s(   2648, "Luderitz",                                   "09",     4235 )
  s(   2649, "Maltahohe",                                  "10",     4235 )
  s(   2650, "Okahandja",                                  "11",     4235 )
  s(   2651, "Omaruru",                                    "12",     4235 )
  s(   2652, "Otjiwarongo",                                "13",     4235 )
  s(   2653, "Outjo",                                      "14",     4235 )
  s(   2654, "Owambo",                                     "15",     4235 )
  s(   2655, "Rehoboth",                                   "16",     4235 )
  s(   2656, "Swakopmund",                                 "17",     4235 )
  s(   2657, "Tsumeb",                                     "18",     4235 )
  s(   2658, "Karasburg",                                  "20",     4235 )
  s(   2659, "Windhoek",                                   "21",     4235 )
  s(   2660, "Damaraland",                                 "22",     4235 )
  s(   2661, "Hereroland Oos",                             "23",     4235 )
  s(   2662, "Hereroland Wes",                             "24",     4235 )
  s(   2663, "Kavango",                                    "25",     4235 )
  s(   2664, "Mariental",                                  "26",     4235 )
  s(   2665, "Namaland",                                   "27",     4235 )
  s(   2666, "Caprivi",                                    "28",     4235 )
  s(   2667, "Erongo",                                     "29",     4235 )
  s(   2668, "Hardap",                                     "30",     4235 )
  s(   2669, "Karas",                                      "31",     4235 )
  s(   2670, "Kunene",                                     "32",     4235 )
  s(   2671, "Ohangwena",                                  "33",     4235 )
  s(   2672, "Okavango",                                   "34",     4235 )
  s(   2673, "Omaheke",                                    "35",     4235 )
  s(   2674, "Omusati",                                    "36",     4235 )
  s(   2675, "Oshana",                                     "37",     4235 )
  s(   2676, "Oshikoto",                                   "38",     4235 )
  s(   2677, "Otjozondjupa",                               "39",     4235 )
  s(   2678, "Agadez",                                     "01",     4237 )
  s(   2679, "Diffa",                                      "02",     4237 )
  s(   2680, "Dosso",                                      "03",     4237 )
  s(   2681, "Maradi",                                     "04",     4237 )
  s(   2682, "Niamey",                                     "05",     4237 )
  s(   2683, "Tahoua",                                     "06",     4237 )
  s(   2684, "Zinder",                                     "07",     4237 )
  s(   2685, "Niamey",                                     "08",     4237 )
  s(   2686, "Lagos",                                      "05",     4239 )
  s(   2687, "Rivers",                                     "10",     4239 )
  s(   2688, "Federal Capital Territory",                  "11",     4239 )
  s(   2689, "Ogun",                                       "16",     4239 )
  s(   2690, "Ondo",                                       "17",     4239 )
  s(   2691, "Akwa Ibom",                                  "21",     4239 )
  s(   2692, "Cross River",                                "22",     4239 )
  s(   2693, "Kaduna",                                     "23",     4239 )
  s(   2694, "Katsina",                                    "24",     4239 )
  s(   2695, "Anambra",                                    "25",     4239 )
  s(   2696, "Benue",                                      "26",     4239 )
  s(   2697, "Borno",                                      "27",     4239 )
  s(   2698, "Imo",                                        "28",     4239 )
  s(   2699, "Kano",                                       "29",     4239 )
  s(   2700, "Kwara",                                      "30",     4239 )
  s(   2701, "Niger",                                      "31",     4239 )
  s(   2702, "Oyo",                                        "32",     4239 )
  s(   2703, "Adamawa",                                    "35",     4239 )
  s(   2704, "Delta",                                      "36",     4239 )
  s(   2705, "Edo",                                        "37",     4239 )
  s(   2706, "Jigawa",                                     "39",     4239 )
  s(   2707, "Kebbi",                                      "40",     4239 )
  s(   2708, "Kogi",                                       "41",     4239 )
  s(   2709, "Osun",                                       "42",     4239 )
  s(   2710, "Taraba",                                     "43",     4239 )
  s(   2711, "Yobe",                                       "44",     4239 )
  s(   2712, "Abia",                                       "45",     4239 )
  s(   2713, "Bauchi",                                     "46",     4239 )
  s(   2714, "Enugu",                                      "47",     4239 )
  s(   2715, "Ondo",                                       "48",     4239 )
  s(   2716, "Rivers",                                     "50",     4239 )
  s(   2717, "Sokoto",                                     "51",     4239 )
  s(   2718, "Bayelsa",                                    "52",     4239 )
  s(   2719, "Ebonyi",                                     "53",     4239 )
  s(   2720, "Ekiti",                                      "54",     4239 )
  s(   2721, "Gombe",                                      "55",     4239 )
  s(   2722, "Nassarawa",                                  "56",     4239 )
  s(   2723, "Zamfara",                                    "57",     4239 )
  s(   2724, "Boaco",                                      "01",     4240 )
  s(   2725, "Carazo",                                     "02",     4240 )
  s(   2726, "Chinandega",                                 "03",     4240 )
  s(   2727, "Chontales",                                  "04",     4240 )
  s(   2728, "Esteli",                                     "05",     4240 )
  s(   2729, "Granada",                                    "06",     4240 )
  s(   2730, "Jinotega",                                   "07",     4240 )
  s(   2731, "Leon",                                       "08",     4240 )
  s(   2732, "Madriz",                                     "09",     4240 )
  s(   2733, "Managua",                                    "10",     4240 )
  s(   2734, "Masaya",                                     "11",     4240 )
  s(   2735, "Matagalpa",                                  "12",     4240 )
  s(   2736, "Nueva Segovia",                              "13",     4240 )
  s(   2737, "Rio San Juan",                               "14",     4240 )
  s(   2738, "Rivas",                                      "15",     4240 )
  s(   2739, "Zelaya",                                     "16",     4240 )
  s(   2740, "Drenthe",                                    "01",     4241 )
  s(   2741, "Friesland",                                  "02",     4241 )
  s(   2742, "Gelderland",                                 "03",     4241 )
  s(   2743, "Groningen",                                  "04",     4241 )
  s(   2744, "Noord-Brabant",                              "06",     4241 )
  s(   2745, "Noord-Holland",                              "07",     4241 )
  s(   2746, "Overijssel",                                 "15",     4241 )
  s(   2747, "Utrecht",                                    "09",     4241 )
  s(   2748, "Zeeland",                                    "10",     4241 )
  s(   2749, "Zuid-Holland",                               "11",     4241 )
  s(   2750, "Dronten",                                    "12",     4241 )
  s(   2751, "Zuidelijke IJsselmeerpolders",               "13",     4241 )
  s(   2752, "Lelystad",                                   "14",     4241 )
  s(   2753, "Flevoland",                                  "16",     4241 )
  s(   2754, "Akershus",                                   "01",     4242 )
  s(   2755, "Aust-Agder",                                 "02",     4242 )
  s(   2756, "Buskerud",                                   "04",     4242 )
  s(   2757, "Finnmark",                                   "05",     4242 )
  s(   2758, "Hedmark",                                    "06",     4242 )
  s(   2759, "Hordaland",                                  "07",     4242 )
  s(   2760, "More og Romsdal",                            "08",     4242 )
  s(   2761, "Nordland",                                   "09",     4242 )
  s(   2762, "Nord-Trondelag",                             "10",     4242 )
  s(   2763, "Oppland",                                    "11",     4242 )
  s(   2764, "Oslo",                                       "12",     4242 )
  s(   2765, "Ostfold",                                    "13",     4242 )
  s(   2766, "Rogaland",                                   "14",     4242 )
  s(   2767, "Sogn og Fjordane",                           "15",     4242 )
  s(   2768, "Sor-Trondelag",                              "16",     4242 )
  s(   2769, "Telemark",                                   "17",     4242 )
  s(   2770, "Troms",                                      "18",     4242 )
  s(   2771, "Vest-Agder",                                 "19",     4242 )
  s(   2772, "Vestfold",                                   "20",     4242 )
  s(   2773, "Bagmati",                                    "01",     4243 )
  s(   2774, "Bheri",                                      "02",     4243 )
  s(   2775, "Dhawalagiri",                                "03",     4243 )
  s(   2776, "Gandaki",                                    "04",     4243 )
  s(   2777, "Janakpur",                                   "05",     4243 )
  s(   2778, "Karnali",                                    "06",     4243 )
  s(   2779, "Kosi",                                       "07",     4243 )
  s(   2780, "Lumbini",                                    "08",     4243 )
  s(   2781, "Mahakali",                                   "09",     4243 )
  s(   2782, "Mechi",                                      "10",     4243 )
  s(   2783, "Narayani",                                   "11",     4243 )
  s(   2784, "Rapti",                                      "12",     4243 )
  s(   2785, "Sagarmatha",                                 "13",     4243 )
  s(   2786, "Seti",                                       "14",     4243 )
  s(   2787, "Aiwo",                                       "01",     4244 )
  s(   2788, "Anabar",                                     "02",     4244 )
  s(   2789, "Anetan",                                     "03",     4244 )
  s(   2790, "Anibare",                                    "04",     4244 )
  s(   2791, "Baiti",                                      "05",     4244 )
  s(   2792, "Boe",                                        "06",     4244 )
  s(   2793, "Buada",                                      "07",     4244 )
  s(   2794, "Denigomodu",                                 "08",     4244 )
  s(   2795, "Ewa",                                        "09",     4244 )
  s(   2796, "Ijuw",                                       "10",     4244 )
  s(   2797, "Meneng",                                     "11",     4244 )
  s(   2798, "Nibok",                                      "12",     4244 )
  s(   2799, "Uaboe",                                      "13",     4244 )
  s(   2800, "Yaren",                                      "14",     4244 )
  s(   2801, "Chatham Islands",                            "10",     4246 )
  s(   2802, "Auckland",                                   "E7",     4246 )
  s(   2803, "Bay of Plenty",                              "E8",     4246 )
  s(   2804, "Canterbury",                                 "E9",     4246 )
  s(   2805, "Gisborne",                                   "F1",     4246 )
  s(   2806, "Hawke's Bay",                                "F2",     4246 )
  s(   2807, "Manawatu-Wanganui",                          "F3",     4246 )
  s(   2808, "Marlborough",                                "F4",     4246 )
  s(   2809, "Nelson",                                     "F5",     4246 )
  s(   2810, "Northland",                                  "F6",     4246 )
  s(   2811, "Otago",                                      "F7",     4246 )
  s(   2812, "Southland",                                  "F8",     4246 )
  s(   2813, "Taranaki",                                   "F9",     4246 )
  s(   2814, "Waikato",                                    "G1",     4246 )
  s(   2815, "Wellington",                                 "G2",     4246 )
  s(   2816, "West Coast",                                 "G3",     4246 )
  s(   2817, "Ad Dakhiliyah",                              "01",     4247 )
  s(   2818, "Al Batinah",                                 "02",     4247 )
  s(   2819, "Az Zahirah",                                 "05",     4247 )
  s(   2820, "Masqat",                                     "06",     4247 )
  s(   2821, "Musandam",                                   "07",     4247 )
  s(   2822, "Zufar",                                      "08",     4247 )
  s(   2823, "Bocas del Toro",                             "01",     4248 )
  s(   2824, "Chiriqui",                                   "02",     4248 )
  s(   2825, "Cocle",                                      "03",     4248 )
  s(   2826, "Darien",                                     "05",     4248 )
  s(   2827, "Herrera",                                    "06",     4248 )
  s(   2828, "Los Santos",                                 "07",     4248 )
  s(   2829, "Panama Province",                            "08",     4248 )
  s(   2830, "San Blas",                                   "09",     4248 )
  s(   2831, "Veraguas",                                   "10",     4248 )
  s(   2832, "Ancash",                                     "02",     4249 )
  s(   2833, "Apurimac",                                   "03",     4249 )
  s(   2834, "Arequipa",                                   "04",     4249 )
  s(   2835, "Ayacucho",                                   "05",     4249 )
  s(   2836, "Cajamarca",                                  "06",     4249 )
  s(   2837, "Callao",                                     "07",     4249 )
  s(   2838, "Cusco",                                      "08",     4249 )
  s(   2839, "Huancavelica",                               "09",     4249 )
  s(   2840, "Huanuco",                                    "10",     4249 )
  s(   2841, "Ica",                                        "11",     4249 )
  s(   2842, "Junin",                                      "12",     4249 )
  s(   2843, "La Libertad",                                "05",     4284 )
  s(   2844, "Lambayeque",                                 "14",     4249 )
  s(   2845, "Lima",                                       "15",     4249 )
  s(   2846, "Loreto",                                     "16",     4249 )
  s(   2847, "Madre de Dios",                              "17",     4249 )
  s(   2848, "Moquegua",                                   "18",     4249 )
  s(   2849, "Pasco",                                      "19",     4249 )
}

  def init3( s:org.tyranid.db.StaticBuilder ) = {
  s(   2850, "Piura",                                      "20",     4249 )
  s(   2851, "Puno",                                       "21",     4249 )
  s(   2852, "San Martin",                                 "22",     4249 )
  s(   2853, "Tacna",                                      "23",     4249 )
  s(   2854, "Tumbes",                                     "24",     4249 )
  s(   2855, "Ucayali",                                    "25",     4249 )
  s(   2856, "Gulf",                                       "02",     4251 )
  s(   2857, "Milne Bay",                                  "03",     4251 )
  s(   2858, "Southern Highlands",                         "05",     4251 )
  s(   2859, "North Solomons",                             "07",     4251 )
  s(   2860, "Chimbu",                                     "08",     4251 )
  s(   2861, "Eastern Highlands",                          "09",     4251 )
  s(   2862, "East New Britain",                           "10",     4251 )
  s(   2863, "East Sepik",                                 "11",     4251 )
  s(   2864, "Madang",                                     "12",     4251 )
  s(   2865, "Manus",                                      "13",     4251 )
  s(   2866, "Morobe",                                     "14",     4251 )
  s(   2867, "New Ireland",                                "15",     4251 )
  s(   2868, "Western Highlands",                          "16",     4251 )
  s(   2869, "West New Britain",                           "17",     4251 )
  s(   2870, "Sandaun",                                    "18",     4251 )
  s(   2871, "Enga",                                       "19",     4251 )
  s(   2872, "National Capital",                           "20",     4251 )
  s(   2873, "Abra",                                       "01",     4252 )
  s(   2874, "Agusan del Norte",                           "02",     4252 )
  s(   2875, "Agusan del Sur",                             "03",     4252 )
  s(   2876, "Aklan",                                      "04",     4252 )
  s(   2877, "Albay",                                      "05",     4252 )
  s(   2878, "Antique",                                    "06",     4252 )
  s(   2879, "Bataan",                                     "07",     4252 )
  s(   2880, "Batanes",                                    "08",     4252 )
  s(   2881, "Batangas",                                   "09",     4252 )
  s(   2882, "Benguet",                                    "10",     4252 )
  s(   2883, "Bohol",                                      "11",     4252 )
  s(   2884, "Bukidnon",                                   "12",     4252 )
  s(   2885, "Bulacan",                                    "13",     4252 )
  s(   2886, "Cagayan",                                    "14",     4252 )
  s(   2887, "Camarines Norte",                            "15",     4252 )
  s(   2888, "Camarines Sur",                              "16",     4252 )
  s(   2889, "Camiguin",                                   "17",     4252 )
  s(   2890, "Capiz",                                      "18",     4252 )
  s(   2891, "Catanduanes",                                "19",     4252 )
  s(   2892, "Cavite",                                     "20",     4252 )
  s(   2893, "Cebu",                                       "21",     4252 )
  s(   2894, "Basilan",                                    "22",     4252 )
  s(   2895, "Eastern Samar",                              "23",     4252 )
  s(   2896, "Davao",                                      "24",     4252 )
  s(   2897, "Davao del Sur",                              "25",     4252 )
  s(   2898, "Davao Oriental",                             "26",     4252 )
  s(   2899, "Ifugao",                                     "27",     4252 )
  s(   2900, "Ilocos Norte",                               "28",     4252 )
  s(   2901, "Ilocos Sur",                                 "29",     4252 )
  s(   2902, "Iloilo",                                     "30",     4252 )
  s(   2903, "Isabela",                                    "31",     4252 )
  s(   2904, "Kalinga-Apayao",                             "32",     4252 )
  s(   2905, "Laguna",                                     "33",     4252 )
  s(   2906, "Lanao del Norte",                            "34",     4252 )
  s(   2907, "Lanao del Sur",                              "35",     4252 )
  s(   2908, "La Union",                                   "07",     4284 )
  s(   2909, "Leyte",                                      "37",     4252 )
  s(   2910, "Marinduque",                                 "38",     4252 )
  s(   2911, "Masbate",                                    "39",     4252 )
  s(   2912, "Mindoro Occidental",                         "40",     4252 )
  s(   2913, "Mindoro Oriental",                           "41",     4252 )
  s(   2914, "Misamis Occidental",                         "42",     4252 )
  s(   2915, "Misamis Oriental",                           "43",     4252 )
  s(   2916, "Mountain",                                   "44",     4252 )
  s(   2917, "Negros Oriental",                            "46",     4252 )
  s(   2918, "Nueva Ecija",                                "47",     4252 )
  s(   2919, "Nueva Vizcaya",                              "48",     4252 )
  s(   2920, "Palawan",                                    "49",     4252 )
  s(   2921, "Pampanga",                                   "50",     4252 )
  s(   2922, "Pangasinan",                                 "51",     4252 )
  s(   2923, "Rizal",                                      "53",     4252 )
  s(   2924, "Romblon",                                    "54",     4252 )
  s(   2925, "Samar",                                      "55",     4252 )
  s(   2926, "Maguindanao",                                "56",     4252 )
  s(   2927, "North Cotabato",                             "57",     4252 )
  s(   2928, "Sorsogon",                                   "58",     4252 )
  s(   2929, "Southern Leyte",                             "59",     4252 )
  s(   2930, "Sulu",                                       "60",     4252 )
  s(   2931, "Surigao del Norte",                          "61",     4252 )
  s(   2932, "Surigao del Sur",                            "62",     4252 )
  s(   2933, "Tarlac",                                     "63",     4252 )
  s(   2934, "Zambales",                                   "64",     4252 )
  s(   2935, "Zamboanga del Norte",                        "65",     4252 )
  s(   2936, "Zamboanga del Sur",                          "66",     4252 )
  s(   2937, "Northern Samar",                             "67",     4252 )
  s(   2938, "Quirino",                                    "68",     4252 )
  s(   2939, "Siquijor",                                   "69",     4252 )
  s(   2940, "South Cotabato",                             "70",     4252 )
  s(   2941, "Sultan Kudarat",                             "71",     4252 )
  s(   2942, "Tawitawi",                                   "72",     4252 )
  s(   2943, "Angeles",                                    "A1",     4252 )
  s(   2944, "Bacolod",                                    "A2",     4252 )
  s(   2945, "Bago",                                       "A3",     4252 )
  s(   2946, "Baguio",                                     "A4",     4252 )
  s(   2947, "Bais",                                       "A5",     4252 )
  s(   2948, "Basilan City",                               "A6",     4252 )
  s(   2949, "Batangas City",                              "A7",     4252 )
  s(   2950, "Butuan",                                     "A8",     4252 )
  s(   2951, "Cabanatuan",                                 "A9",     4252 )
  s(   2952, "Cadiz",                                      "B1",     4252 )
  s(   2953, "Cagayan de Oro",                             "B2",     4252 )
  s(   2954, "Calbayog",                                   "B3",     4252 )
  s(   2955, "Caloocan",                                   "B4",     4252 )
  s(   2956, "Canlaon",                                    "B5",     4252 )
  s(   2957, "Cavite City",                                "B6",     4252 )
  s(   2958, "Cebu City",                                  "B7",     4252 )
  s(   2959, "Cotabato",                                   "B8",     4252 )
  s(   2960, "Dagupan",                                    "B9",     4252 )
  s(   2961, "Danao",                                      "C1",     4252 )
  s(   2962, "Dapitan",                                    "C2",     4252 )
  s(   2963, "Davao City",                                 "C3",     4252 )
  s(   2964, "Dipolog",                                    "C4",     4252 )
  s(   2965, "Dumaguete",                                  "C5",     4252 )
  s(   2966, "General Santos",                             "C6",     4252 )
  s(   2967, "Gingoog",                                    "C7",     4252 )
  s(   2968, "Iligan",                                     "C8",     4252 )
  s(   2969, "Iloilo City",                                "C9",     4252 )
  s(   2970, "Iriga",                                      "D1",     4252 )
  s(   2971, "La Carlota",                                 "D2",     4252 )
  s(   2972, "Laoag",                                      "D3",     4252 )
  s(   2973, "Lapu-Lapu",                                  "D4",     4252 )
  s(   2974, "Legaspi",                                    "D5",     4252 )
  s(   2975, "Lipa",                                       "D6",     4252 )
  s(   2976, "Lucena",                                     "D7",     4252 )
  s(   2977, "Mandaue",                                    "D8",     4252 )
  s(   2978, "Manila",                                     "D9",     4252 )
  s(   2979, "Marawi",                                     "E1",     4252 )
  s(   2980, "Naga",                                       "E2",     4252 )
  s(   2981, "Olongapo",                                   "E3",     4252 )
  s(   2982, "Ormoc",                                      "E4",     4252 )
  s(   2983, "Oroquieta",                                  "E5",     4252 )
  s(   2984, "Ozamis",                                     "E6",     4252 )
  s(   2985, "Pagadian",                                   "E7",     4252 )
  s(   2986, "Palayan",                                    "E8",     4252 )
  s(   2987, "Pasay",                                      "E9",     4252 )
  s(   2988, "Puerto Princesa",                            "F1",     4252 )
  s(   2989, "Quezon City",                                "F2",     4252 )
  s(   2990, "Roxas",                                      "F3",     4252 )
  s(   2991, "San Carlos",                                 "F4",     4252 )
  s(   2992, "San Carlos",                                 "F5",     4252 )
  s(   2993, "San Pablo",                                  "F7",     4252 )
  s(   2994, "Silay",                                      "F8",     4252 )
  s(   2995, "Surigao",                                    "F9",     4252 )
  s(   2996, "Tacloban",                                   "G1",     4252 )
  s(   2997, "Tagaytay",                                   "G2",     4252 )
  s(   2998, "Tagbilaran",                                 "G3",     4252 )
  s(   2999, "Tangub",                                     "G4",     4252 )
  s(   3000, "Trece Martires",                             "G6",     4252 )
  s(   3001, "Zamboanga",                                  "G7",     4252 )
  s(   3002, "Aurora",                                     "G8",     4252 )
  s(   3003, "Quezon",                                     "H2",     4252 )
  s(   3004, "Negros Occidental",                          "H3",     4252 )
  s(   3005, "Federally Administered Tribal Areas",        "01",     4253 )
  s(   3006, "Balochistan",                                "02",     4253 )
  s(   3007, "North-West Frontier",                        "03",     4253 )
  s(   3008, "Sindh",                                      "05",     4253 )
  s(   3009, "Azad Kashmir",                               "06",     4253 )
  s(   3010, "Northern Areas",                             "07",     4253 )
  s(   3011, "Islamabad",                                  "08",     4253 )
  s(   3012, "Biala Podlaska",                             "23",     4254 )
  s(   3013, "Bialystok",                                  "24",     4254 )
  s(   3014, "Bielsko",                                    "25",     4254 )
  s(   3015, "Bydgoszcz",                                  "26",     4254 )
  s(   3016, "Chelm",                                      "27",     4254 )
  s(   3017, "Ciechanow",                                  "28",     4254 )
  s(   3018, "Czestochowa",                                "29",     4254 )
  s(   3019, "Elblag",                                     "30",     4254 )
  s(   3020, "Gdansk",                                     "31",     4254 )
  s(   3021, "Gorzow",                                     "32",     4254 )
  s(   3022, "Jelenia Gora",                               "33",     4254 )
  s(   3023, "Kalisz",                                     "34",     4254 )
  s(   3024, "Katowice",                                   "35",     4254 )
  s(   3025, "Kielce",                                     "36",     4254 )
  s(   3026, "Konin",                                      "37",     4254 )
  s(   3027, "Koszalin",                                   "38",     4254 )
  s(   3028, "Krakow",                                     "39",     4254 )
  s(   3029, "Krosno",                                     "40",     4254 )
  s(   3030, "Legnica",                                    "41",     4254 )
  s(   3031, "Leszno",                                     "42",     4254 )
  s(   3032, "Lodz",                                       "43",     4254 )
  s(   3033, "Lomza",                                      "44",     4254 )
  s(   3034, "Lublin",                                     "45",     4254 )
  s(   3035, "Nowy Sacz",                                  "46",     4254 )
  s(   3036, "Olsztyn",                                    "47",     4254 )
  s(   3037, "Opole",                                      "48",     4254 )
  s(   3038, "Ostroleka",                                  "49",     4254 )
  s(   3039, "Pila",                                       "50",     4254 )
  s(   3040, "Piotrkow",                                   "51",     4254 )
  s(   3041, "Plock",                                      "52",     4254 )
  s(   3042, "Poznan",                                     "53",     4254 )
  s(   3043, "Przemysl",                                   "54",     4254 )
  s(   3044, "Radom",                                      "55",     4254 )
  s(   3045, "Rzeszow",                                    "56",     4254 )
  s(   3046, "Siedlce",                                    "57",     4254 )
  s(   3047, "Sieradz",                                    "58",     4254 )
  s(   3048, "Skierniewice",                               "59",     4254 )
  s(   3049, "Slupsk",                                     "60",     4254 )
  s(   3050, "Suwalki",                                    "61",     4254 )
  s(   3051, "Szczecin",                                   "62",     4254 )
  s(   3052, "Tarnobrzeg",                                 "63",     4254 )
  s(   3053, "Tarnow",                                     "64",     4254 )
  s(   3054, "Torun",                                      "65",     4254 )
  s(   3055, "Walbrzych",                                  "66",     4254 )
  s(   3056, "Warszawa",                                   "67",     4254 )
  s(   3057, "Wloclawek",                                  "68",     4254 )
  s(   3058, "Wroclaw",                                    "69",     4254 )
  s(   3059, "Zamosc",                                     "70",     4254 )
  s(   3060, "Zielona Gora",                               "71",     4254 )
  s(   3061, "Dolnoslaskie",                               "72",     4254 )
  s(   3062, "Kujawsko-Pomorskie",                         "73",     4254 )
  s(   3063, "Lodzkie",                                    "74",     4254 )
  s(   3064, "Lubelskie",                                  "75",     4254 )
  s(   3065, "Lubuskie",                                   "76",     4254 )
  s(   3066, "Malopolskie",                                "77",     4254 )
  s(   3067, "Mazowieckie",                                "78",     4254 )
  s(   3068, "Opolskie",                                   "79",     4254 )
  s(   3069, "Podkarpackie",                               "80",     4254 )
  s(   3070, "Podlaskie",                                  "81",     4254 )
  s(   3071, "Pomorskie",                                  "82",     4254 )
  s(   3072, "Slaskie",                                    "83",     4254 )
  s(   3073, "Swietokrzyskie",                             "84",     4254 )
  s(   3074, "Warminsko-Mazurskie",                        "85",     4254 )
  s(   3075, "Wielkopolskie",                              "86",     4254 )
  s(   3076, "Zachodniopomorskie",                         "87",     4254 )
  s(   3077, "West Bank",                                  "WE",     4258 )
  s(   3078, "Aveiro",                                     "02",     4259 )
  s(   3079, "Beja",                                       "03",     4259 )
  s(   3080, "Braga",                                      "04",     4259 )
  s(   3081, "Braganca",                                   "05",     4259 )
  s(   3082, "Castelo Branco",                             "06",     4259 )
  s(   3083, "Coimbra",                                    "07",     4259 )
  s(   3084, "Evora",                                      "08",     4259 )
  s(   3085, "Faro",                                       "09",     4259 )
  s(   3086, "Madeira",                                    "10",     4259 )
  s(   3087, "Guarda",                                     "11",     4259 )
  s(   3088, "Leiria",                                     "13",     4259 )
  s(   3089, "Lisboa",                                     "14",     4259 )
  s(   3090, "Portalegre",                                 "16",     4259 )
  s(   3091, "Porto",                                      "17",     4259 )
  s(   3092, "Santarem",                                   "18",     4259 )
  s(   3093, "Setubal",                                    "19",     4259 )
  s(   3094, "Viana do Castelo",                           "20",     4259 )
  s(   3095, "Vila Real",                                  "21",     4259 )
  s(   3096, "Viseu",                                      "22",     4259 )
  s(   3097, "Azores",                                     "23",     4259 )
  s(   3098, "Alto Parana",                                "01",     4261 )
  s(   3099, "Amambay",                                    "02",     4261 )
  s(   3100, "Boqueron",                                   "03",     4261 )
  s(   3101, "Caaguazu",                                   "04",     4261 )
  s(   3102, "Caazapa",                                    "05",     4261 )
  s(   3103, "Concepcion",                                 "07",     4261 )
  s(   3104, "Cordillera",                                 "08",     4261 )
  s(   3105, "Guaira",                                     "10",     4261 )
  s(   3106, "Itapua",                                     "11",     4261 )
  s(   3107, "Neembucu",                                   "13",     4261 )
  s(   3108, "Paraguari",                                  "15",     4261 )
  s(   3109, "Presidente Hayes",                           "16",     4261 )
  s(   3110, "San Pedro",                                  "17",     4261 )
  s(   3111, "Canindeyu",                                  "19",     4261 )
  s(   3112, "Nueva Asuncion",                             "21",     4261 )
  s(   3113, "Alto Paraguay",                              "23",     4261 )
  s(   3114, "Ad Dawhah",                                  "01",     4262 )
  s(   3115, "Al Ghuwariyah",                              "02",     4262 )
  s(   3116, "Al Jumaliyah",                               "03",     4262 )
  s(   3117, "Al Khawr",                                   "04",     4262 )
  s(   3118, "Al Wakrah Municipality",                     "05",     4262 )
  s(   3119, "Ar Rayyan",                                  "06",     4262 )
  s(   3120, "Madinat ach Shamal",                         "08",     4262 )
  s(   3121, "Umm Salal",                                  "09",     4262 )
  s(   3122, "Al Wakrah",                                  "10",     4262 )
  s(   3123, "Jariyan al Batnah",                          "11",     4262 )
  s(   3124, "Umm Sa'id",                                  "12",     4262 )
  s(   3125, "Alba",                                       "01",     4264 )
  s(   3126, "Arad",                                       "02",     4264 )
  s(   3127, "Arges",                                      "03",     4264 )
  s(   3128, "Bacau",                                      "04",     4264 )
  s(   3129, "Bihor",                                      "05",     4264 )
  s(   3130, "Bistrita-Nasaud",                            "06",     4264 )
  s(   3131, "Botosani",                                   "07",     4264 )
  s(   3132, "Braila",                                     "08",     4264 )
  s(   3133, "Brasov",                                     "09",     4264 )
  s(   3134, "Bucuresti",                                  "10",     4264 )
  s(   3135, "Buzau",                                      "11",     4264 )
  s(   3136, "Caras-Severin",                              "12",     4264 )
  s(   3137, "Cluj",                                       "13",     4264 )
  s(   3138, "Constanta",                                  "14",     4264 )
  s(   3139, "Covasna",                                    "15",     4264 )
  s(   3140, "Dambovita",                                  "16",     4264 )
  s(   3141, "Dolj",                                       "17",     4264 )
  s(   3142, "Galati",                                     "18",     4264 )
  s(   3143, "Gorj",                                       "19",     4264 )
  s(   3144, "Harghita",                                   "20",     4264 )
  s(   3145, "Hunedoara",                                  "21",     4264 )
  s(   3146, "Ialomita",                                   "22",     4264 )
  s(   3147, "Iasi",                                       "23",     4264 )
  s(   3148, "Maramures",                                  "25",     4264 )
  s(   3149, "Mehedinti",                                  "26",     4264 )
  s(   3150, "Mures",                                      "27",     4264 )
  s(   3151, "Neamt",                                      "28",     4264 )
  s(   3152, "Olt",                                        "29",     4264 )
  s(   3153, "Prahova",                                    "30",     4264 )
  s(   3154, "Salaj",                                      "31",     4264 )
  s(   3155, "Satu Mare",                                  "32",     4264 )
  s(   3156, "Sibiu",                                      "33",     4264 )
  s(   3157, "Suceava",                                    "34",     4264 )
  s(   3158, "Teleorman",                                  "35",     4264 )
  s(   3159, "Timis",                                      "36",     4264 )
  s(   3160, "Tulcea",                                     "37",     4264 )
  s(   3161, "Vaslui",                                     "38",     4264 )
  s(   3162, "Valcea",                                     "39",     4264 )
  s(   3163, "Vrancea",                                    "40",     4264 )
  s(   3164, "Giurgiu",                                    "42",     4264 )
  s(   3165, "Ilfov",                                      "43",     4264 )
  s(   3166, "Kosovo",                                     "01",     4265 )
  s(   3167, "Vojvodina",                                  "02",     4265 )
  s(   3168, "Adygeya, Republic of",                       "01",     4266 )
  s(   3169, "Aginsky Buryatsky AO",                       "02",     4266 )
  s(   3170, "Gorno-Altay",                                "03",     4266 )
  s(   3171, "Altaisky krai",                              "04",     4266 )
  s(   3172, "Amur",                                       "05",     4266 )
  s(   3173, "Arkhangel'sk",                               "06",     4266 )
  s(   3174, "Astrakhan'",                                 "07",     4266 )
  s(   3175, "Bashkortostan",                              "08",     4266 )
  s(   3176, "Belgorod",                                   "09",     4266 )
  s(   3177, "Bryansk",                                    "10",     4266 )
  s(   3178, "Buryat",                                     "11",     4266 )
  s(   3179, "Chechnya",                                   "12",     4266 )
  s(   3180, "Chelyabinsk",                                "13",     4266 )
  s(   3181, "Chita",                                      "14",     4266 )
  s(   3182, "Chukot",                                     "15",     4266 )
  s(   3183, "Chuvashia",                                  "16",     4266 )
  s(   3184, "Dagestan",                                   "17",     4266 )
  s(   3185, "Evenk",                                      "18",     4266 )
  s(   3186, "Ingush",                                     "19",     4266 )
  s(   3187, "Irkutsk",                                    "20",     4266 )
  s(   3188, "Ivanovo",                                    "21",     4266 )
  s(   3189, "Kabardin-Balkar",                            "22",     4266 )
  s(   3190, "Kaliningrad",                                "23",     4266 )
  s(   3191, "Kalmyk",                                     "24",     4266 )
  s(   3192, "Kaluga",                                     "25",     4266 )
  s(   3193, "Kamchatka",                                  "26",     4266 )
  s(   3194, "Karachay-Cherkess",                          "27",     4266 )
  s(   3195, "Karelia",                                    "28",     4266 )
  s(   3196, "Kemerovo",                                   "29",     4266 )
  s(   3197, "Khabarovsk",                                 "30",     4266 )
  s(   3198, "Khakass",                                    "31",     4266 )
  s(   3199, "Khanty-Mansiy",                              "32",     4266 )
  s(   3200, "Kirov",                                      "33",     4266 )
  s(   3201, "Komi",                                       "34",     4266 )
  s(   3202, "Komi-Permyak",                               "35",     4266 )
  s(   3203, "Koryak",                                     "36",     4266 )
  s(   3204, "Kostroma",                                   "37",     4266 )
  s(   3205, "Krasnodar",                                  "38",     4266 )
  s(   3206, "Krasnoyarsk",                                "39",     4266 )
  s(   3207, "Kurgan",                                     "40",     4266 )
  s(   3208, "Kursk",                                      "41",     4266 )
  s(   3209, "Leningrad",                                  "42",     4266 )
  s(   3210, "Lipetsk",                                    "43",     4266 )
  s(   3211, "Magadan",                                    "44",     4266 )
  s(   3212, "Mariy-El",                                   "45",     4266 )
  s(   3213, "Mordovia",                                   "46",     4266 )
  s(   3214, "Moskva",                                     "47",     4266 )
  s(   3215, "Moscow City",                                "48",     4266 )
  s(   3216, "Murmansk",                                   "49",     4266 )
  s(   3217, "Nenets",                                     "50",     4266 )
  s(   3218, "Nizhegorod",                                 "51",     4266 )
  s(   3219, "Novgorod",                                   "52",     4266 )
  s(   3220, "Novosibirsk",                                "53",     4266 )
  s(   3221, "Omsk",                                       "54",     4266 )
  s(   3222, "Orenburg",                                   "55",     4266 )
  s(   3223, "Orel",                                       "56",     4266 )
  s(   3224, "Penza",                                      "57",     4266 )
  s(   3225, "Perm'",                                      "58",     4266 )
  s(   3226, "Primor'ye",                                  "59",     4266 )
  s(   3227, "Pskov",                                      "60",     4266 )
  s(   3228, "Rostov",                                     "61",     4266 )
  s(   3229, "Ryazan'",                                    "62",     4266 )
  s(   3230, "Sakha",                                      "63",     4266 )
  s(   3231, "Sakhalin",                                   "64",     4266 )
  s(   3232, "Samara",                                     "65",     4266 )
  s(   3233, "Saint Petersburg City",                      "66",     4266 )
  s(   3234, "Saratov",                                    "67",     4266 )
  s(   3235, "North Ossetia",                              "68",     4266 )
  s(   3236, "Smolensk",                                   "69",     4266 )
  s(   3237, "Stavropol'",                                 "70",     4266 )
  s(   3238, "Sverdlovsk",                                 "71",     4266 )
  s(   3239, "Tambovskaya oblast",                         "72",     4266 )
  s(   3240, "Tatarstan",                                  "73",     4266 )
  s(   3241, "Taymyr",                                     "74",     4266 )
  s(   3242, "Tomsk",                                      "75",     4266 )
  s(   3243, "Tula",                                       "76",     4266 )
  s(   3244, "Tver'",                                      "77",     4266 )
  s(   3245, "Tyumen'",                                    "78",     4266 )
  s(   3246, "Tuva",                                       "79",     4266 )
  s(   3247, "Udmurt",                                     "80",     4266 )
  s(   3248, "Ul'yanovsk",                                 "81",     4266 )
  s(   3249, "Ust-Orda Buryat",                            "82",     4266 )
  s(   3250, "Vladimir",                                   "83",     4266 )
  s(   3251, "Volgograd",                                  "84",     4266 )
  s(   3252, "Vologda",                                    "85",     4266 )
  s(   3253, "Voronezh",                                   "86",     4266 )
  s(   3254, "Yamal-Nenets",                               "87",     4266 )
  s(   3255, "Yaroslavl'",                                 "88",     4266 )
  s(   3256, "Yevrey",                                     "89",     4266 )
  s(   3257, "Permskiy Kray",                              "90",     4266 )
  s(   3258, "Krasnoyarskiy Kray",                         "91",     4266 )
  s(   3259, "Butare",                                     "01",     4267 )
  s(   3260, "Gitarama",                                   "06",     4267 )
  s(   3261, "Kigali",                                     "09",     4267 )
  s(   3262, "Kigali",                                     "12",     4267 )
  s(   3263, "Al Bahah",                                   "02",     4268 )
  s(   3264, "Al Jawf",                                    "21",     4318 )
  s(   3265, "Al Madinah",                                 "05",     4268 )
  s(   3266, "Al Qasim",                                   "08",     4268 )
  s(   3267, "Al Qurayyat",                                "09",     4268 )
  s(   3268, "Ar Riyad",                                   "10",     4268 )
  s(   3269, "Ha'il",                                      "13",     4268 )
  s(   3270, "Makkah",                                     "14",     4268 )
  s(   3271, "Al Hudud ash Shamaliyah",                    "15",     4268 )
  s(   3272, "Najran",                                     "16",     4268 )
  s(   3273, "Jizan",                                      "17",     4268 )
  s(   3274, "Tabuk",                                      "19",     4268 )
  s(   3275, "Al Jawf",                                    "20",     4268 )
  s(   3276, "Malaita",                                    "03",     4269 )
  s(   3277, "Guadalcanal",                                "06",     4269 )
  s(   3278, "Isabel",                                     "07",     4269 )
  s(   3279, "Makira",                                     "08",     4269 )
  s(   3280, "Temotu",                                     "09",     4269 )
  s(   3281, "Rennell and Bellona",                        "13",     4269 )
  s(   3282, "Anse aux Pins",                              "01",     4270 )
  s(   3283, "Anse Boileau",                               "02",     4270 )
  s(   3284, "Anse Etoile",                                "03",     4270 )
  s(   3285, "Anse Louis",                                 "04",     4270 )
  s(   3286, "Anse Royale",                                "05",     4270 )
  s(   3287, "Baie Lazare",                                "06",     4270 )
  s(   3288, "Baie Sainte Anne",                           "07",     4270 )
  s(   3289, "Beau Vallon",                                "08",     4270 )
  s(   3290, "Bel Air",                                    "09",     4270 )
  s(   3291, "Bel Ombre",                                  "10",     4270 )
  s(   3292, "Cascade",                                    "11",     4270 )
  s(   3293, "Glacis",                                     "12",     4270 )
  s(   3294, "La Digue",                                   "15",     4270 )
  s(   3295, "La Riviere Anglaise",                        "16",     4270 )
  s(   3296, "Mont Buxton",                                "17",     4270 )
  s(   3297, "Mont Fleuri",                                "18",     4270 )
  s(   3298, "Plaisance",                                  "19",     4270 )
  s(   3299, "Pointe La Rue",                              "20",     4270 )
  s(   3300, "Port Glaud",                                 "21",     4270 )
  s(   3301, "Saint Louis",                                "22",     4270 )
  s(   3302, "Takamaka",                                   "23",     4270 )
  s(   3303, "Al Istiwa'iyah",                             "28",     4271 )
  s(   3304, "Al Khartum",                                 "29",     4271 )
  s(   3305, "Bahr al Ghazal",                             "32",     4271 )
  s(   3306, "Darfur",                                     "33",     4271 )
  s(   3307, "Kurdufan",                                   "34",     4271 )
  s(   3308, "Upper Nile",                                 "35",     4271 )
  s(   3309, "Alvsborgs Lan",                              "01",     4272 )
  s(   3310, "Blekinge Lan",                               "02",     4272 )
  s(   3311, "Gavleborgs Lan",                             "03",     4272 )
  s(   3312, "Goteborgs och Bohus Lan",                    "04",     4272 )
  s(   3313, "Gotlands Lan",                               "05",     4272 )
  s(   3314, "Hallands Lan",                               "06",     4272 )
  s(   3315, "Jamtlands Lan",                              "07",     4272 )
  s(   3316, "Jonkopings Lan",                             "08",     4272 )
  s(   3317, "Kalmar Lan",                                 "09",     4272 )
  s(   3318, "Dalarnas Lan",                               "10",     4272 )
  s(   3319, "Kristianstads Lan",                          "11",     4272 )
  s(   3320, "Kronobergs Lan",                             "12",     4272 )
  s(   3321, "Malmohus Lan",                               "13",     4272 )
  s(   3322, "Norrbottens Lan",                            "14",     4272 )
  s(   3323, "Orebro Lan",                                 "15",     4272 )
  s(   3324, "Ostergotlands Lan",                          "16",     4272 )
  s(   3325, "Skaraborgs Lan",                             "17",     4272 )
  s(   3326, "Sodermanlands Lan",                          "18",     4272 )
  s(   3327, "Uppsala Lan",                                "21",     4272 )
  s(   3328, "Varmlands Lan",                              "22",     4272 )
  s(   3329, "Vasterbottens Lan",                          "23",     4272 )
  s(   3330, "Vasternorrlands Lan",                        "24",     4272 )
  s(   3331, "Vastmanlands Lan",                           "25",     4272 )
  s(   3332, "Stockholms Lan",                             "26",     4272 )
  s(   3333, "Skane Lan",                                  "27",     4272 )
  s(   3334, "Vastra Gotaland",                            "28",     4272 )
  s(   3335, "Ascension",                                  "01",     4274 )
  s(   3336, "Saint Helena",                               "02",     4274 )
  s(   3337, "Tristan da Cunha",                           "03",     4274 )
  s(   3338, "Ajdovscina",                                 "01",     4275 )
  s(   3339, "Beltinci",                                   "02",     4275 )
  s(   3340, "Bled",                                       "03",     4275 )
  s(   3341, "Bohinj",                                     "04",     4275 )
  s(   3342, "Borovnica",                                  "05",     4275 )
  s(   3343, "Bovec",                                      "06",     4275 )
  s(   3344, "Brda",                                       "07",     4275 )
  s(   3345, "Brezice",                                    "08",     4275 )
  s(   3346, "Brezovica",                                  "09",     4275 )
  s(   3347, "Celje",                                      "11",     4275 )
  s(   3348, "Cerklje na Gorenjskem",                      "12",     4275 )
  s(   3349, "Cerknica",                                   "13",     4275 )
  s(   3350, "Cerkno",                                     "14",     4275 )
  s(   3351, "Crensovci",                                  "15",     4275 )
  s(   3352, "Crna na Koroskem",                           "16",     4275 )
  s(   3353, "Crnomelj",                                   "17",     4275 )
  s(   3354, "Divaca",                                     "19",     4275 )
  s(   3355, "Dobrepolje",                                 "20",     4275 )
  s(   3356, "Dol pri Ljubljani",                          "22",     4275 )
  s(   3357, "Dornava",                                    "24",     4275 )
  s(   3358, "Dravograd",                                  "25",     4275 )
  s(   3359, "Duplek",                                     "26",     4275 )
  s(   3360, "Gorenja Vas-Poljane",                        "27",     4275 )
  s(   3361, "Gorisnica",                                  "28",     4275 )
  s(   3362, "Gornja Radgona",                             "29",     4275 )
  s(   3363, "Gornji Grad",                                "30",     4275 )
  s(   3364, "Gornji Petrovci",                            "31",     4275 )
  s(   3365, "Grosuplje",                                  "32",     4275 )
  s(   3366, "Hrastnik",                                   "34",     4275 )
  s(   3367, "Hrpelje-Kozina",                             "35",     4275 )
  s(   3368, "Idrija",                                     "36",     4275 )
  s(   3369, "Ig",                                         "37",     4275 )
  s(   3370, "Ilirska Bistrica",                           "38",     4275 )
  s(   3371, "Ivancna Gorica",                             "39",     4275 )
  s(   3372, "Izola-Isola",                                "40",     4275 )
  s(   3373, "Jursinci",                                   "42",     4275 )
  s(   3374, "Kanal",                                      "44",     4275 )
  s(   3375, "Kidricevo",                                  "45",     4275 )
  s(   3376, "Kobarid",                                    "46",     4275 )
  s(   3377, "Kobilje",                                    "47",     4275 )
  s(   3378, "Komen",                                      "49",     4275 )
  s(   3379, "Koper-Capodistria",                          "50",     4275 )
  s(   3380, "Kozje",                                      "51",     4275 )
  s(   3381, "Kranj",                                      "52",     4275 )
  s(   3382, "Kranjska Gora",                              "53",     4275 )
  s(   3383, "Krsko",                                      "54",     4275 )
  s(   3384, "Kungota",                                    "55",     4275 )
  s(   3385, "Lasko",                                      "57",     4275 )
  s(   3386, "Ljubljana",                                  "61",     4275 )
  s(   3387, "Ljubno",                                     "62",     4275 )
  s(   3388, "Logatec",                                    "64",     4275 )
  s(   3389, "Loski Potok",                                "66",     4275 )
  s(   3390, "Lukovica",                                   "68",     4275 )
  s(   3391, "Medvode",                                    "71",     4275 )
  s(   3392, "Menges",                                     "72",     4275 )
  s(   3393, "Metlika",                                    "73",     4275 )
  s(   3394, "Mezica",                                     "74",     4275 )
  s(   3395, "Mislinja",                                   "76",     4275 )
  s(   3396, "Moravce",                                    "77",     4275 )
  s(   3397, "Moravske Toplice",                           "78",     4275 )
  s(   3398, "Mozirje",                                    "79",     4275 )
  s(   3399, "Murska Sobota",                              "80",     4275 )
  s(   3400, "Muta",                                       "81",     4275 )
  s(   3401, "Naklo",                                      "82",     4275 )
  s(   3402, "Nazarje",                                    "83",     4275 )
  s(   3403, "Nova Gorica",                                "84",     4275 )
  s(   3404, "Odranci",                                    "86",     4275 )
  s(   3405, "Ormoz",                                      "87",     4275 )
  s(   3406, "Osilnica",                                   "88",     4275 )
  s(   3407, "Pesnica",                                    "89",     4275 )
  s(   3408, "Pivka",                                      "91",     4275 )
  s(   3409, "Podcetrtek",                                 "92",     4275 )
  s(   3410, "Postojna",                                   "94",     4275 )
  s(   3411, "Puconci",                                    "97",     4275 )
  s(   3412, "Racam",                                      "98",     4275 )
  s(   3413, "Radece",                                     "99",     4275 )
  s(   3414, "Radenci",                                    "A1",     4275 )
  s(   3415, "Radlje ob Dravi",                            "A2",     4275 )
  s(   3416, "Radovljica",                                 "A3",     4275 )
  s(   3417, "Rogasovci",                                  "A6",     4275 )
  s(   3418, "Rogaska Slatina",                            "A7",     4275 )
  s(   3419, "Rogatec",                                    "A8",     4275 )
  s(   3420, "Semic",                                      "B1",     4275 )
  s(   3421, "Sencur",                                     "B2",     4275 )
  s(   3422, "Sentilj",                                    "B3",     4275 )
  s(   3423, "Sentjernej",                                 "B4",     4275 )
  s(   3424, "Sevnica",                                    "B6",     4275 )
  s(   3425, "Sezana",                                     "B7",     4275 )
  s(   3426, "Skocjan",                                    "B8",     4275 )
  s(   3427, "Skofja Loka",                                "B9",     4275 )
  s(   3428, "Skofljica",                                  "C1",     4275 )
  s(   3429, "Slovenj Gradec",                             "C2",     4275 )
  s(   3430, "Slovenske Konjice",                          "C4",     4275 )
  s(   3431, "Smarje pri Jelsah",                          "C5",     4275 )
  s(   3432, "Smartno ob Paki",                            "C6",     4275 )
  s(   3433, "Sostanj",                                    "C7",     4275 )
  s(   3434, "Starse",                                     "C8",     4275 )
  s(   3435, "Store",                                      "C9",     4275 )
  s(   3436, "Sveti Jurij",                                "D1",     4275 )
  s(   3437, "Tolmin",                                     "D2",     4275 )
  s(   3438, "Trbovlje",                                   "D3",     4275 )
  s(   3439, "Trebnje",                                    "D4",     4275 )
  s(   3440, "Trzic",                                      "D5",     4275 )
  s(   3441, "Turnisce",                                   "D6",     4275 )
  s(   3442, "Velenje",                                    "D7",     4275 )
  s(   3443, "Velike Lasce",                               "D8",     4275 )
  s(   3444, "Vipava",                                     "E1",     4275 )
  s(   3445, "Vitanje",                                    "E2",     4275 )
  s(   3446, "Vodice",                                     "E3",     4275 )
  s(   3447, "Vrhnika",                                    "E5",     4275 )
  s(   3448, "Vuzenica",                                   "E6",     4275 )
  s(   3449, "Zagorje ob Savi",                            "E7",     4275 )
  s(   3450, "Zavrc",                                      "E9",     4275 )
  s(   3451, "Zelezniki",                                  "F1",     4275 )
  s(   3452, "Ziri",                                       "F2",     4275 )
  s(   3453, "Zrece",                                      "F3",     4275 )
  s(   3454, "Dobrova-Horjul-Polhov Gradec",               "G4",     4275 )
  s(   3455, "Domzale",                                    "G7",     4275 )
  s(   3456, "Jesenice",                                   "H4",     4275 )
  s(   3457, "Kamnik",                                     "H6",     4275 )
  s(   3458, "Kocevje",                                    "H7",     4275 )
  s(   3459, "Kuzma",                                      "I2",     4275 )
  s(   3460, "Lenart",                                     "I3",     4275 )
  s(   3461, "Litija",                                     "I5",     4275 )
  s(   3462, "Ljutomer",                                   "I6",     4275 )
  s(   3463, "Loska Dolina",                               "I7",     4275 )
  s(   3464, "Luce",                                       "I9",     4275 )
  s(   3465, "Majsperk",                                   "J1",     4275 )
  s(   3466, "Maribor",                                    "J2",     4275 )
  s(   3467, "Miren-Kostanjevica",                         "J5",     4275 )
  s(   3468, "Novo Mesto",                                 "J7",     4275 )
  s(   3469, "Piran",                                      "J9",     4275 )
  s(   3470, "Preddvor",                                   "K5",     4275 )
  s(   3471, "Ptuj",                                       "K7",     4275 )
  s(   3472, "Ribnica",                                    "L1",     4275 )
  s(   3473, "Sentjur pri Celju",                          "L7",     4275 )
  s(   3474, "Slovenska Bistrica",                         "L8",     4275 )
  s(   3475, "Videm",                                      "N2",     4275 )
  s(   3476, "Vojnik",                                     "N3",     4275 )
  s(   3477, "Zalec",                                      "N5",     4275 )
  s(   3478, "Banska Bystrica",                            "01",     4277 )
  s(   3479, "Bratislava",                                 "02",     4277 )
  s(   3480, "Kosice",                                     "03",     4277 )
  s(   3481, "Nitra",                                      "04",     4277 )
  s(   3482, "Presov",                                     "05",     4277 )
  s(   3483, "Trencin",                                    "06",     4277 )
  s(   3484, "Trnava",                                     "07",     4277 )
  s(   3485, "Zilina",                                     "08",     4277 )
  s(   3486, "Western Area",                               "04",     4278 )
  s(   3487, "Acquaviva",                                  "01",     4279 )
  s(   3488, "Chiesanuova",                                "02",     4279 )
  s(   3489, "Domagnano",                                  "03",     4279 )
  s(   3490, "Faetano",                                    "04",     4279 )
  s(   3491, "Fiorentino",                                 "05",     4279 )
  s(   3492, "Borgo Maggiore",                             "06",     4279 )
  s(   3493, "San Marino",                                 "07",     4279 )
  s(   3494, "Monte Giardino",                             "08",     4279 )
  s(   3495, "Serravalle",                                 "09",     4279 )
  s(   3496, "Dakar",                                      "01",     4280 )
  s(   3497, "Diourbel",                                   "03",     4280 )
  s(   3498, "Saint-Louis",                                "04",     4280 )
  s(   3499, "Tambacounda",                                "05",     4280 )
  s(   3500, "Thies",                                      "07",     4280 )
  s(   3501, "Fatick",                                     "09",     4280 )
  s(   3502, "Kaolack",                                    "10",     4280 )
  s(   3503, "Kolda",                                      "11",     4280 )
  s(   3504, "Ziguinchor",                                 "12",     4280 )
  s(   3505, "Louga",                                      "13",     4280 )
  s(   3506, "Saint-Louis",                                "14",     4280 )
  s(   3507, "Matam",                                      "15",     4280 )
  s(   3508, "Bakool",                                     "01",     4281 )
  s(   3509, "Banaadir",                                   "02",     4281 )
  s(   3510, "Bari",                                       "03",     4281 )
  s(   3511, "Bay",                                        "04",     4281 )
  s(   3512, "Galguduud",                                  "05",     4281 )
  s(   3513, "Gedo",                                       "06",     4281 )
  s(   3514, "Hiiraan",                                    "07",     4281 )
  s(   3515, "Jubbada Dhexe",                              "08",     4281 )
  s(   3516, "Jubbada Hoose",                              "09",     4281 )
  s(   3517, "Mudug",                                      "10",     4281 )
  s(   3518, "Nugaal",                                     "11",     4281 )
  s(   3519, "Sanaag",                                     "12",     4281 )
  s(   3520, "Shabeellaha Dhexe",                          "13",     4281 )
  s(   3521, "Shabeellaha Hoose",                          "14",     4281 )
  s(   3522, "Woqooyi Galbeed",                            "16",     4281 )
  s(   3523, "Nugaal",                                     "18",     4281 )
  s(   3524, "Togdheer",                                   "19",     4281 )
  s(   3525, "Woqooyi Galbeed",                            "20",     4281 )
  s(   3526, "Awdal",                                      "21",     4281 )
  s(   3527, "Sool",                                       "22",     4281 )
  s(   3528, "Brokopondo",                                 "10",     4282 )
  s(   3529, "Commewijne",                                 "11",     4282 )
  s(   3530, "Coronie",                                    "12",     4282 )
  s(   3531, "Marowijne",                                  "13",     4282 )
  s(   3532, "Nickerie",                                   "14",     4282 )
  s(   3533, "Paramaribo",                                 "16",     4282 )
  s(   3534, "Saramacca",                                  "17",     4282 )
  s(   3535, "Sipaliwini",                                 "18",     4282 )
  s(   3536, "Wanica",                                     "19",     4282 )
  s(   3537, "Principe",                                   "01",     4283 )
  s(   3538, "Sao Tome",                                   "02",     4283 )
  s(   3539, "Ahuachapan",                                 "01",     4284 )
  s(   3540, "Cabanas",                                    "02",     4284 )
  s(   3541, "Chalatenango",                               "03",     4284 )
  s(   3542, "Cuscatlan",                                  "04",     4284 )
  s(   3543, "Morazan",                                    "08",     4284 )
  s(   3544, "San Miguel",                                 "09",     4284 )
  s(   3545, "San Salvador",                               "10",     4284 )
  s(   3546, "Santa Ana",                                  "11",     4284 )
  s(   3547, "San Vicente",                                "12",     4284 )
  s(   3548, "Sonsonate",                                  "13",     4284 )
  s(   3549, "Usulutan",                                   "14",     4284 )
  s(   3550, "Al Hasakah",                                 "01",     4285 )
  s(   3551, "Al Ladhiqiyah",                              "02",     4285 )
  s(   3552, "Al Qunaytirah",                              "03",     4285 )
  s(   3553, "Ar Raqqah",                                  "04",     4285 )
  s(   3554, "As Suwayda'",                                "05",     4285 )
  s(   3555, "Dar",                                        "06",     4285 )
  s(   3556, "Dayr az Zawr",                               "07",     4285 )
  s(   3557, "Rif Dimashq",                                "08",     4285 )
  s(   3558, "Halab",                                      "09",     4285 )
  s(   3559, "Hamah",                                      "10",     4285 )
  s(   3560, "Hims",                                       "11",     4285 )
  s(   3561, "Idlib",                                      "12",     4285 )
  s(   3562, "Dimashq",                                    "13",     4285 )
  s(   3563, "Tartus",                                     "14",     4285 )
  s(   3564, "Hhohho",                                     "01",     4286 )
  s(   3565, "Lubombo",                                    "02",     4286 )
  s(   3566, "Manzini",                                    "03",     4286 )
  s(   3567, "Shiselweni",                                 "04",     4286 )
  s(   3568, "Batha",                                      "01",     4288 )
  s(   3569, "Biltine",                                    "02",     4288 )
  s(   3570, "Borkou-Ennedi-Tibesti",                      "03",     4288 )
  s(   3571, "Chari-Baguirmi",                             "04",     4288 )
  s(   3572, "Guera",                                      "05",     4288 )
  s(   3573, "Kanem",                                      "06",     4288 )
  s(   3574, "Lac",                                        "07",     4288 )
  s(   3575, "Logone Occidental",                          "08",     4288 )
  s(   3576, "Logone Oriental",                            "09",     4288 )
  s(   3577, "Mayo-Kebbi",                                 "10",     4288 )
  s(   3578, "Moyen-Chari",                                "11",     4288 )
  s(   3579, "Ouaddai",                                    "12",     4288 )
  s(   3580, "Salamat",                                    "13",     4288 )
  s(   3581, "Tandjile",                                   "14",     4288 )
  s(   3582, "Lama-Kara",                                  "09",     4290 )
  s(   3583, "Tsevie",                                     "18",     4290 )
  s(   3584, "Centrale",                                   "22",     4290 )
  s(   3585, "Kara",                                       "23",     4290 )
  s(   3586, "Maritime",                                   "24",     4290 )
  s(   3587, "Mae Hong Son",                               "01",     4291 )
  s(   3588, "Chiang Mai",                                 "02",     4291 )
  s(   3589, "Chiang Rai",                                 "03",     4291 )
  s(   3590, "Nan",                                        "04",     4291 )
  s(   3591, "Lamphun",                                    "05",     4291 )
  s(   3592, "Lampang",                                    "06",     4291 )
  s(   3593, "Phrae",                                      "07",     4291 )
  s(   3594, "Tak",                                        "08",     4291 )
  s(   3595, "Sukhothai",                                  "09",     4291 )
  s(   3596, "Uttaradit",                                  "10",     4291 )
  s(   3597, "Kamphaeng Phet",                             "11",     4291 )
  s(   3598, "Phitsanulok",                                "12",     4291 )
  s(   3599, "Phichit",                                    "13",     4291 )
  s(   3600, "Phetchabun",                                 "14",     4291 )
  s(   3601, "Uthai Thani",                                "15",     4291 )
  s(   3602, "Nakhon Sawan",                               "16",     4291 )
  s(   3603, "Nong Khai",                                  "17",     4291 )
  s(   3604, "Loei",                                       "18",     4291 )
  s(   3605, "Sakon Nakhon",                               "20",     4291 )
  s(   3606, "Nakhon Phanom",                              "21",     4291 )
  s(   3607, "Khon Kaen",                                  "22",     4291 )
  s(   3608, "Kalasin",                                    "23",     4291 )
  s(   3609, "Maha Sarakham",                              "24",     4291 )
  s(   3610, "Roi Et",                                     "25",     4291 )
  s(   3611, "Chaiyaphum",                                 "26",     4291 )
  s(   3612, "Nakhon Ratchasima",                          "27",     4291 )
  s(   3613, "Buriram",                                    "28",     4291 )
  s(   3614, "Surin",                                      "29",     4291 )
  s(   3615, "Sisaket",                                    "30",     4291 )
  s(   3616, "Narathiwat",                                 "31",     4291 )
  s(   3617, "Chai Nat",                                   "32",     4291 )
  s(   3618, "Sing Buri",                                  "33",     4291 )
  s(   3619, "Lop Buri",                                   "34",     4291 )
  s(   3620, "Ang Thong",                                  "35",     4291 )
  s(   3621, "Phra Nakhon Si Ayutthaya",                   "36",     4291 )
  s(   3622, "Saraburi",                                   "37",     4291 )
  s(   3623, "Nonthaburi",                                 "38",     4291 )
  s(   3624, "Pathum Thani",                               "39",     4291 )
  s(   3625, "Krung Thep",                                 "40",     4291 )
  s(   3626, "Phayao",                                     "41",     4291 )
  s(   3627, "Samut Prakan",                               "42",     4291 )
  s(   3628, "Nakhon Nayok",                               "43",     4291 )
  s(   3629, "Chachoengsao",                               "44",     4291 )
  s(   3630, "Prachin Buri",                               "45",     4291 )
  s(   3631, "Chon Buri",                                  "46",     4291 )
  s(   3632, "Rayong",                                     "47",     4291 )
  s(   3633, "Chanthaburi",                                "48",     4291 )
  s(   3634, "Trat",                                       "49",     4291 )
  s(   3635, "Kanchanaburi",                               "50",     4291 )
  s(   3636, "Suphan Buri",                                "51",     4291 )
  s(   3637, "Ratchaburi",                                 "52",     4291 )
  s(   3638, "Nakhon Pathom",                              "53",     4291 )
  s(   3639, "Samut Songkhram",                            "54",     4291 )
  s(   3640, "Samut Sakhon",                               "55",     4291 )
  s(   3641, "Phetchaburi",                                "56",     4291 )
  s(   3642, "Prachuap Khiri Khan",                        "57",     4291 )
  s(   3643, "Chumphon",                                   "58",     4291 )
  s(   3644, "Ranong",                                     "59",     4291 )
  s(   3645, "Surat Thani",                                "60",     4291 )
  s(   3646, "Phangnga",                                   "61",     4291 )
  s(   3647, "Phuket",                                     "62",     4291 )
  s(   3648, "Krabi",                                      "63",     4291 )
  s(   3649, "Nakhon Si Thammarat",                        "64",     4291 )
  s(   3650, "Trang",                                      "65",     4291 )
  s(   3651, "Phatthalung",                                "66",     4291 )
  s(   3652, "Satun",                                      "67",     4291 )
  s(   3653, "Songkhla",                                   "68",     4291 )
  s(   3654, "Pattani",                                    "69",     4291 )
  s(   3655, "Yala",                                       "70",     4291 )
  s(   3656, "Ubon Ratchathani",                           "71",     4291 )
  s(   3657, "Yasothon",                                   "72",     4291 )
  s(   3658, "Ubon Ratchathani",                           "75",     4291 )
  s(   3659, "Udon Thani",                                 "76",     4291 )
  s(   3660, "Mukdahan",                                   "78",     4291 )
  s(   3661, "Kuhistoni Badakhshon",                       "01",     4292 )
  s(   3662, "Khatlon",                                    "02",     4292 )
  s(   3663, "Sughd",                                      "03",     4292 )
  s(   3664, "Ahal",                                       "01",     4295 )
  s(   3665, "Balkan",                                     "02",     4295 )
  s(   3666, "Dashoguz",                                   "03",     4295 )
  s(   3667, "Lebap",                                      "04",     4295 )
  s(   3668, "Mary",                                       "05",     4295 )
  s(   3669, "Al Qasrayn",                                 "02",     4296 )
  s(   3670, "Al Qayrawan",                                "03",     4296 )
  s(   3671, "Jundubah",                                   "06",     4296 )
  s(   3672, "Qafsah",                                     "10",     4296 )
  s(   3673, "Kef",                                        "14",     4296 )
  s(   3674, "Al Mahdiyah",                                "15",     4296 )
  s(   3675, "Al Munastir",                                "16",     4296 )
  s(   3676, "Bajah",                                      "17",     4296 )
  s(   3677, "Banzart",                                    "18",     4296 )
  s(   3678, "Nabul",                                      "19",     4296 )
  s(   3679, "Silyanah",                                   "22",     4296 )
  s(   3680, "Susah",                                      "23",     4296 )
  s(   3681, "Bin",                                        "27",     4296 )
  s(   3682, "Madanin",                                    "28",     4296 )
  s(   3683, "Qabis",                                      "29",     4296 )
  s(   3684, "Qaf?ah",                                     "30",     4296 )
  s(   3685, "Qibili",                                     "31",     4296 )
  s(   3686, "Safaqis",                                    "32",     4296 )
  s(   3687, "Sidi Bu Zayd",                               "33",     4296 )
  s(   3688, "Tatawin",                                    "34",     4296 )
  s(   3689, "Tawzar",                                     "35",     4296 )
  s(   3690, "Tunis",                                      "36",     4296 )
  s(   3691, "Zaghwan",                                    "37",     4296 )
  s(   3692, "Ariana",                                     "38",     4296 )
  s(   3693, "Manouba",                                    "39",     4296 )
  s(   3694, "Tongatapu",                                  "02",     4297 )
  s(   3695, "Vava",                                       "03",     4297 )
  s(   3696, "Adiyaman",                                   "02",     4298 )
  s(   3697, "Afyonkarahisar",                             "03",     4298 )
  s(   3698, "Agri",                                       "04",     4298 )
  s(   3699, "Amasya",                                     "05",     4298 )
  s(   3700, "Antalya",                                    "07",     4298 )
  s(   3701, "Artvin",                                     "08",     4298 )
  s(   3702, "Aydin",                                      "09",     4298 )
  s(   3703, "Balikesir",                                  "10",     4298 )
  s(   3704, "Bilecik",                                    "11",     4298 )
  s(   3705, "Bingol",                                     "12",     4298 )
  s(   3706, "Bitlis",                                     "13",     4298 )
  s(   3707, "Bolu",                                       "14",     4298 )
  s(   3708, "Burdur",                                     "15",     4298 )
  s(   3709, "Bursa",                                      "16",     4298 )
  s(   3710, "Canakkale",                                  "17",     4298 )
  s(   3711, "Corum",                                      "19",     4298 )
  s(   3712, "Denizli",                                    "20",     4298 )
  s(   3713, "Diyarbakir",                                 "21",     4298 )
  s(   3714, "Edirne",                                     "22",     4298 )
  s(   3715, "Elazig",                                     "23",     4298 )
  s(   3716, "Erzincan",                                   "24",     4298 )
  s(   3717, "Erzurum",                                    "25",     4298 )
  s(   3718, "Eskisehir",                                  "26",     4298 )
  s(   3719, "Giresun",                                    "28",     4298 )
  s(   3720, "Hatay",                                      "31",     4298 )
  s(   3721, "Icel",                                       "32",     4298 )
  s(   3722, "Isparta",                                    "33",     4298 )
  s(   3723, "Istanbul",                                   "34",     4298 )
  s(   3724, "Izmir",                                      "35",     4298 )
  s(   3725, "Kastamonu",                                  "37",     4298 )
  s(   3726, "Kayseri",                                    "38",     4298 )
  s(   3727, "Kirklareli",                                 "39",     4298 )
  s(   3728, "Kirsehir",                                   "40",     4298 )
  s(   3729, "Kocaeli",                                    "41",     4298 )
  s(   3730, "Kutahya",                                    "43",     4298 )
  s(   3731, "Malatya",                                    "44",     4298 )
  s(   3732, "Manisa",                                     "45",     4298 )
  s(   3733, "Kahramanmaras",                              "46",     4298 )
  s(   3734, "Mugla",                                      "48",     4298 )
  s(   3735, "Mus",                                        "49",     4298 )
  s(   3736, "Nevsehir",                                   "50",     4298 )
  s(   3737, "Ordu",                                       "52",     4298 )
  s(   3738, "Rize",                                       "53",     4298 )
  s(   3739, "Sakarya",                                    "54",     4298 )
  s(   3740, "Samsun",                                     "55",     4298 )
  s(   3741, "Sinop",                                      "57",     4298 )
  s(   3742, "Sivas",                                      "58",     4298 )
  s(   3743, "Tekirdag",                                   "59",     4298 )
  s(   3744, "Tokat",                                      "60",     4298 )
  s(   3745, "Trabzon",                                    "61",     4298 )
  s(   3746, "Tunceli",                                    "62",     4298 )
  s(   3747, "Sanliurfa",                                  "63",     4298 )
  s(   3748, "Usak",                                       "64",     4298 )
  s(   3749, "Van",                                        "65",     4298 )
  s(   3750, "Yozgat",                                     "66",     4298 )
  s(   3751, "Ankara",                                     "68",     4298 )
  s(   3752, "Gumushane",                                  "69",     4298 )
  s(   3753, "Hakkari",                                    "70",     4298 )
  s(   3754, "Konya",                                      "71",     4298 )
  s(   3755, "Mardin",                                     "72",     4298 )
  s(   3756, "Nigde",                                      "73",     4298 )
  s(   3757, "Siirt",                                      "74",     4298 )
  s(   3758, "Aksaray",                                    "75",     4298 )
  s(   3759, "Batman",                                     "76",     4298 )
  s(   3760, "Bayburt",                                    "77",     4298 )
  s(   3761, "Karaman",                                    "78",     4298 )
  s(   3762, "Kirikkale",                                  "79",     4298 )
  s(   3763, "Sirnak",                                     "80",     4298 )
  s(   3764, "Adana",                                      "81",     4298 )
  s(   3765, "Cankiri",                                    "82",     4298 )
  s(   3766, "Gaziantep",                                  "83",     4298 )
  s(   3767, "Kars",                                       "84",     4298 )
  s(   3768, "Zonguldak",                                  "85",     4298 )
  s(   3769, "Ardahan",                                    "86",     4298 )
  s(   3770, "Bartin",                                     "87",     4298 )
  s(   3771, "Igdir",                                      "88",     4298 )
  s(   3772, "Karabuk",                                    "89",     4298 )
  s(   3773, "Kilis",                                      "90",     4298 )
  s(   3774, "Osmaniye",                                   "91",     4298 )
  s(   3775, "Yalova",                                     "92",     4298 )
  s(   3776, "Duzce",                                      "93",     4298 )
  s(   3777, "Arima",                                      "01",     4299 )
  s(   3778, "Caroni",                                     "02",     4299 )
  s(   3779, "Mayaro",                                     "03",     4299 )
  s(   3780, "Nariva",                                     "04",     4299 )
  s(   3781, "Port-of-Spain",                              "05",     4299 )
  s(   3782, "San Fernando",                               "10",     4299 )
  s(   3783, "Tobago",                                     "11",     4299 )
  s(   3784, "Fu-chien",                                   "01",     4301 )
  s(   3785, "Kao-hsiung",                                 "02",     4301 )
  s(   3786, "T'ai-pei",                                   "03",     4301 )
  s(   3787, "T'ai-wan",                                   "04",     4301 )
  s(   3788, "Pwani",                                      "02",     4302 )
  s(   3789, "Dodoma",                                     "03",     4302 )
  s(   3790, "Iringa",                                     "04",     4302 )
  s(   3791, "Kigoma",                                     "05",     4302 )
  s(   3792, "Kilimanjaro",                                "06",     4302 )
  s(   3793, "Lindi",                                      "07",     4302 )
  s(   3794, "Mara",                                       "08",     4302 )
  s(   3795, "Mbeya",                                      "09",     4302 )
  s(   3796, "Morogoro",                                   "10",     4302 )
  s(   3797, "Mtwara",                                     "11",     4302 )
  s(   3798, "Pemba North",                                "13",     4302 )
  s(   3799, "Ruvuma",                                     "14",     4302 )
  s(   3800, "Shinyanga",                                  "15",     4302 )
  s(   3801, "Singida",                                    "16",     4302 )
  s(   3802, "Tabora",                                     "17",     4302 )
  s(   3803, "Tanga",                                      "18",     4302 )
  s(   3804, "Kagera",                                     "19",     4302 )
  s(   3805, "Pemba South",                                "20",     4302 )
  s(   3806, "Zanzibar Central",                           "21",     4302 )
  s(   3807, "Zanzibar North",                             "22",     4302 )
  s(   3808, "Dar es Salaam",                              "23",     4302 )
  s(   3809, "Rukwa",                                      "24",     4302 )
  s(   3810, "Zanzibar Urban",                             "25",     4302 )
  s(   3811, "Arusha",                                     "26",     4302 )
  s(   3812, "Manyara",                                    "27",     4302 )
  s(   3813, "Cherkas'ka Oblast'",                         "01",     4303 )
  s(   3814, "Chernihivs'ka Oblast'",                      "02",     4303 )
  s(   3815, "Chernivets'ka Oblast'",                      "03",     4303 )
  s(   3816, "Dnipropetrovs'ka Oblast'",                   "04",     4303 )
  s(   3817, "Donets'ka Oblast'",                          "05",     4303 )
  s(   3818, "Ivano-Frankivs'ka Oblast'",                  "06",     4303 )
  s(   3819, "Kharkivs'ka Oblast'",                        "07",     4303 )
  s(   3820, "Khersons'ka Oblast'",                        "08",     4303 )
  s(   3821, "Khmel'nyts'ka Oblast'",                      "09",     4303 )
  s(   3822, "Kirovohrads'ka Oblast'",                     "10",     4303 )
  s(   3823, "Krym",                                       "11",     4303 )
  s(   3824, "Kyyiv",                                      "12",     4303 )
  s(   3825, "Kyyivs'ka Oblast'",                          "13",     4303 )
  s(   3826, "Luhans'ka Oblast'",                          "14",     4303 )
  s(   3827, "L'vivs'ka Oblast'",                          "15",     4303 )
  s(   3828, "Mykolayivs'ka Oblast'",                      "16",     4303 )
  s(   3829, "Odes'ka Oblast'",                            "17",     4303 )
  s(   3830, "Poltavs'ka Oblast'",                         "18",     4303 )
  s(   3831, "Rivnens'ka Oblast'",                         "19",     4303 )
  s(   3832, "Sevastopol'",                                "20",     4303 )
  s(   3833, "Sums'ka Oblast'",                            "21",     4303 )
  s(   3834, "Ternopil's'ka Oblast'",                      "22",     4303 )
  s(   3835, "Vinnyts'ka Oblast'",                         "23",     4303 )
  s(   3836, "Volyns'ka Oblast'",                          "24",     4303 )
  s(   3837, "Zakarpats'ka Oblast'",                       "25",     4303 )
  s(   3838, "Zaporiz'ka Oblast'",                         "26",     4303 )
  s(   3839, "Zhytomyrs'ka Oblast'",                       "27",     4303 )
  s(   3840, "Busoga",                                     "05",     4304 )
  s(   3841, "Karamoja",                                   "08",     4304 )
  s(   3842, "South Buganda",                              "12",     4304 )
  s(   3843, "Nile",                                       "21",     4304 )
  s(   3844, "North Buganda",                              "22",     4304 )
  s(   3845, "Kampala",                                    "37",     4304 )
  s(   3846, "Mubende",                                    "56",     4304 )
  s(   3847, "Adjumani",                                   "65",     4304 )
  s(   3848, "Bugiri",                                     "66",     4304 )
  s(   3849, "Busia",                                      "67",     4304 )
  s(   3850, "Katakwi",                                    "69",     4304 )
  s(   3851, "Nakasongola",                                "73",     4304 )
  s(   3852, "Sembabule",                                  "74",     4304 )
  s(   3853, "Arua",                                       "77",     4304 )
  s(   3854, "Iganga",                                     "78",     4304 )
  s(   3855, "Kabarole",                                   "79",     4304 )
  s(   3856, "Kaberamaido",                                "80",     4304 )
  s(   3857, "Kamwenge",                                   "81",     4304 )
  s(   3858, "Kanungu",                                    "82",     4304 )
  s(   3859, "Kayunga",                                    "83",     4304 )
  s(   3860, "Kitgum",                                     "84",     4304 )
  s(   3861, "Kyenjojo",                                   "85",     4304 )
  s(   3862, "Mayuge",                                     "86",     4304 )
  s(   3863, "Mbale",                                      "87",     4304 )
  s(   3864, "Moroto",                                     "88",     4304 )
  s(   3865, "Mpigi",                                      "89",     4304 )
  s(   3866, "Mukono",                                     "90",     4304 )
  s(   3867, "Nakapiripirit",                              "91",     4304 )
  s(   3868, "Pader",                                      "92",     4304 )
  s(   3869, "Rukungiri",                                  "93",     4304 )
  s(   3870, "Sironko",                                    "94",     4304 )
  s(   3871, "Soroti",                                     "95",     4304 )
  s(   3872, "Wakiso",                                     "96",     4304 )
  s(   3873, "Yumbe",                                      "97",     4304 )
  s(   3874, "District of Columbia",                       "11",     4306 )
  s(   3875, "Artigas",                                    "01",     4307 )
  s(   3876, "Canelones",                                  "02",     4307 )
  s(   3877, "Cerro Largo",                                "03",     4307 )
  s(   3878, "Colonia",                                    "04",     4307 )
  s(   3879, "Durazno",                                    "05",     4307 )
  s(   3880, "Flores",                                     "06",     4307 )
  s(   3881, "Lavalleja",                                  "08",     4307 )
  s(   3882, "Maldonado",                                  "09",     4307 )
  s(   3883, "Montevideo",                                 "10",     4307 )
  s(   3884, "Paysandu",                                   "11",     4307 )
  s(   3885, "Rivera",                                     "13",     4307 )
  s(   3886, "Rocha",                                      "14",     4307 )
  s(   3887, "Salto",                                      "15",     4307 )
  s(   3888, "Soriano",                                    "17",     4307 )
  s(   3889, "Tacuarembo",                                 "18",     4307 )
  s(   3890, "Treinta y Tres",                             "19",     4307 )
  s(   3891, "Andijon",                                    "01",     4308 )
  s(   3892, "Bukhoro",                                    "02",     4308 )
  s(   3893, "Farghona",                                   "03",     4308 )
  s(   3894, "Jizzakh",                                    "04",     4308 )
  s(   3895, "Khorazm",                                    "05",     4308 )
  s(   3896, "Namangan",                                   "06",     4308 )
  s(   3897, "Nawoiy",                                     "07",     4308 )
  s(   3898, "Qashqadaryo",                                "08",     4308 )
  s(   3899, "Qoraqalpoghiston",                           "09",     4308 )
  s(   3900, "Samarqand",                                  "10",     4308 )
  s(   3901, "Sirdaryo",                                   "11",     4308 )
  s(   3902, "Surkhondaryo",                               "12",     4308 )
  s(   3903, "Toshkent",                                   "13",     4308 )
  s(   3904, "Toshkent",                                   "14",     4308 )
  s(   3905, "Charlotte",                                  "01",     4310 )
  s(   3906, "Grenadines",                                 "06",     4310 )
  s(   3907, "Anzoategui",                                 "02",     4311 )
  s(   3908, "Apure",                                      "03",     4311 )
  s(   3909, "Aragua",                                     "04",     4311 )
  s(   3910, "Barinas",                                    "05",     4311 )
  s(   3911, "Carabobo",                                   "07",     4311 )
  s(   3912, "Cojedes",                                    "08",     4311 )
  s(   3913, "Delta Amacuro",                              "09",     4311 )
  s(   3914, "Falcon",                                     "11",     4311 )
  s(   3915, "Guarico",                                    "12",     4311 )
  s(   3916, "Lara",                                       "13",     4311 )
  s(   3917, "Merida",                                     "14",     4311 )
  s(   3918, "Miranda",                                    "15",     4311 )
  s(   3919, "Monagas",                                    "16",     4311 )
  s(   3920, "Nueva Esparta",                              "17",     4311 )
  s(   3921, "Portuguesa",                                 "18",     4311 )
  s(   3922, "Tachira",                                    "20",     4311 )
  s(   3923, "Trujillo",                                   "21",     4311 )
  s(   3924, "Yaracuy",                                    "22",     4311 )
  s(   3925, "Zulia",                                      "23",     4311 )
  s(   3926, "Dependencias Federales",                     "24",     4311 )
  s(   3927, "Vargas",                                     "26",     4311 )
  s(   3928, "An Giang",                                   "01",     4314 )
  s(   3929, "Bac Thai",                                   "02",     4314 )
  s(   3930, "Ben Tre",                                    "03",     4314 )
  s(   3931, "Binh Tri Thien",                             "04",     4314 )
  s(   3932, "Cao Bang",                                   "05",     4314 )
  s(   3933, "Dac Lac",                                    "07",     4314 )
  s(   3934, "Dong Thap",                                  "09",     4314 )
  s(   3935, "Ha Bac",                                     "11",     4314 )
  s(   3936, "Hai Hung",                                   "12",     4314 )
  s(   3937, "Hai Phong",                                  "13",     4314 )
  s(   3938, "Ha Nam Ninh",                                "14",     4314 )
  s(   3939, "Ha Son Binh",                                "16",     4314 )
  s(   3940, "Ha Tuyen",                                   "17",     4314 )
  s(   3941, "Hoang Lien Son",                             "19",     4314 )
  s(   3942, "Ho Chi Minh",                                "20",     4314 )
  s(   3943, "Kien Giang",                                 "21",     4314 )
  s(   3944, "Lai Chau",                                   "22",     4314 )
  s(   3945, "Lam Dong",                                   "23",     4314 )
  s(   3946, "Long An",                                    "24",     4314 )
  s(   3947, "Minh Hai",                                   "25",     4314 )
  s(   3948, "Nghe Tinh",                                  "26",     4314 )
  s(   3949, "Nghia Binh",                                 "27",     4314 )
  s(   3950, "Phu Khanh",                                  "28",     4314 )
  s(   3951, "Quang Nam-Da Nang",                          "29",     4314 )
  s(   3952, "Quang Ninh",                                 "30",     4314 )
  s(   3953, "Song Be",                                    "31",     4314 )
  s(   3954, "Son La",                                     "32",     4314 )
  s(   3955, "Tay Ninh",                                   "33",     4314 )
  s(   3956, "Thanh Hoa",                                  "34",     4314 )
  s(   3957, "Thai Binh",                                  "35",     4314 )
  s(   3958, "Thuan Hai",                                  "36",     4314 )
  s(   3959, "Tien Giang",                                 "37",     4314 )
  s(   3960, "Vinh Phu",                                   "38",     4314 )
  s(   3961, "Lang Son",                                   "39",     4314 )
  s(   3962, "Dong Nai",                                   "40",     4314 )
  s(   3963, "An Giang",                                   "43",     4314 )
  s(   3964, "Dac Lac",                                    "44",     4314 )
  s(   3965, "Dong Nai",                                   "45",     4314 )
  s(   3966, "Dong Thap",                                  "46",     4314 )
  s(   3967, "Kien Giang",                                 "47",     4314 )
  s(   3968, "Minh Hai",                                   "48",     4314 )
  s(   3969, "Song Be",                                    "49",     4314 )
  s(   3970, "Vinh Phu",                                   "50",     4314 )
  s(   3971, "Ha Noi",                                     "51",     4314 )
  s(   3972, "Ho Chi Minh",                                "52",     4314 )
  s(   3973, "Ba Ria-Vung Tau",                            "53",     4314 )
  s(   3974, "Binh Dinh",                                  "54",     4314 )
  s(   3975, "Binh Thuan",                                 "55",     4314 )
  s(   3976, "Can Tho",                                    "56",     4314 )
  s(   3977, "Gia Lai",                                    "57",     4314 )
  s(   3978, "Ha Giang",                                   "58",     4314 )
  s(   3979, "Ha Tay",                                     "59",     4314 )
  s(   3980, "Ha Tinh",                                    "60",     4314 )
  s(   3981, "Hoa Binh",                                   "61",     4314 )
  s(   3982, "Khanh Hoa",                                  "62",     4314 )
  s(   3983, "Kon Tum",                                    "63",     4314 )
  s(   3984, "Quang Tri",                                  "64",     4314 )
  s(   3985, "Nam Ha",                                     "65",     4314 )
  s(   3986, "Nghe An",                                    "66",     4314 )
  s(   3987, "Ninh Binh",                                  "67",     4314 )
  s(   3988, "Ninh Thuan",                                 "68",     4314 )
  s(   3989, "Phu Yen",                                    "69",     4314 )
  s(   3990, "Quang Binh",                                 "70",     4314 )
  s(   3991, "Quang Ngai",                                 "71",     4314 )
  s(   3992, "Quang Tri",                                  "72",     4314 )
  s(   3993, "Soc Trang",                                  "73",     4314 )
  s(   3994, "Thua Thien",                                 "74",     4314 )
  s(   3995, "Tra Vinh",                                   "75",     4314 )
  s(   3996, "Tuyen Quang",                                "76",     4314 )
  s(   3997, "Vinh Long",                                  "77",     4314 )
  s(   3998, "Da Nang",                                    "78",     4314 )
  s(   3999, "Hai Duong",                                  "79",     4314 )
  s(   4000, "Ha Nam",                                     "80",     4314 )
  s(   4001, "Hung Yen",                                   "81",     4314 )
  s(   4002, "Nam Dinh",                                   "82",     4314 )
  s(   4003, "Phu Tho",                                    "83",     4314 )
  s(   4004, "Quang Nam",                                  "84",     4314 )
  s(   4005, "Thai Nguyen",                                "85",     4314 )
  s(   4006, "Can Tho",                                    "87",     4314 )
  s(   4007, "Dak Lak",                                    "88",     4314 )
  s(   4008, "Lai Chau",                                   "89",     4314 )
  s(   4009, "Lao Cai",                                    "90",     4314 )
  s(   4010, "Dak Nong",                                   "91",     4314 )
  s(   4011, "Dien Bien",                                  "92",     4314 )
  s(   4012, "Hau Giang",                                  "93",     4314 )
  s(   4013, "Ambrym",                                     "05",     4315 )
  s(   4014, "Aoba",                                       "06",     4315 )
  s(   4015, "Torba",                                      "07",     4315 )
  s(   4016, "Efate",                                      "08",     4315 )
  s(   4017, "Epi",                                        "09",     4315 )
  s(   4018, "Malakula",                                   "10",     4315 )
  s(   4019, "Paama",                                      "11",     4315 )
  s(   4020, "Pentecote",                                  "12",     4315 )
  s(   4021, "Sanma",                                      "13",     4315 )
  s(   4022, "Shepherd",                                   "14",     4315 )
  s(   4023, "Tafea",                                      "15",     4315 )
  s(   4024, "Malampa",                                    "16",     4315 )
  s(   4025, "Penama",                                     "17",     4315 )
  s(   4026, "Shefa",                                      "18",     4315 )
  s(   4027, "Aiga-i-le-Tai",                              "02",     4317 )
  s(   4028, "Atua",                                       "03",     4317 )
  s(   4029, "Fa",                                         "04",     4317 )
  s(   4030, "Gaga",                                       "05",     4317 )
  s(   4031, "Va",                                         "06",     4317 )
  s(   4032, "Gagaifomauga",                               "07",     4317 )
  s(   4033, "Palauli",                                    "08",     4317 )
  s(   4034, "Satupa",                                     "09",     4317 )
  s(   4035, "Tuamasaga",                                  "10",     4317 )
  s(   4036, "Vaisigano",                                  "11",     4317 )
  s(   4037, "Abyan",                                      "01",     4318 )
  s(   4038, "Adan",                                       "02",     4318 )
  s(   4039, "Al Mahrah",                                  "03",     4318 )
  s(   4040, "Hadramawt",                                  "04",     4318 )
  s(   4041, "Shabwah",                                    "05",     4318 )
  s(   4042, "Al Hudaydah",                                "08",     4318 )
  s(   4043, "Al Mahwit",                                  "10",     4318 )
  s(   4044, "Dhamar",                                     "11",     4318 )
  s(   4045, "Ma'rib",                                     "14",     4318 )
  s(   4046, "Sa",                                         "15",     4318 )
  s(   4047, "San",                                        "16",     4318 )
  s(   4048, "Al Bayda'",                                  "20",     4318 )
  s(   4049, "Hajjah",                                     "22",     4318 )
  s(   4050, "Ibb",                                        "23",     4318 )
  s(   4051, "Lahij",                                      "24",     4318 )
  s(   4052, "Ta",                                         "25",     4318 )
  s(   4053, "KwaZulu-Natal",                              "02",     4320 )
  s(   4054, "Free State",                                 "03",     4320 )
  s(   4055, "Eastern Cape",                               "05",     4320 )
  s(   4056, "Gauteng",                                    "06",     4320 )
  s(   4057, "Mpumalanga",                                 "07",     4320 )
  s(   4058, "Northern Cape",                              "08",     4320 )
  s(   4059, "Limpopo",                                    "09",     4320 )
  s(   4060, "Western Cape",                               "11",     4320 )
  s(   4061, "Luapula",                                    "04",     4321 )
  s(   4062, "North-Western",                              "06",     4321 )
  s(   4063, "Copperbelt",                                 "08",     4321 )
  s(   4064, "Lusaka",                                     "09",     4321 )
  s(   4065, "Manicaland",                                 "01",     4322 )
  s(   4066, "Midlands",                                   "02",     4322 )
  s(   4067, "Mashonaland Central",                        "03",     4322 )
  s(   4068, "Mashonaland East",                           "04",     4322 )
  s(   4069, "Mashonaland West",                           "05",     4322 )
  s(   4070, "Matabeleland North",                         "06",     4322 )
  s(   4071, "Matabeleland South",                         "07",     4322 )
  s(   4072, "Masvingo",                                   "08",     4322 )
  s(   4073, "Bulawayo",                                   "09",     4322 )
  s(   4074, "Harare",                                     "10",     4322 )
  s(   4171, "Hong Kong",                                  "HK",     4124 )
  s(   4358, "Guantanamo Bay",                             "US",     4306 )
  s(   4359, "Grand' Anse",                                "14",     4175 )
  s(   4360, "Nord",                                       "09",     4175 )
  s(   4361, "Ouest",                                      "11",     4175 )
  s(   4362, "Sud",                                        "12",     4175 )
  s(   4363, "Saint Andrew",                               "08",     4188 )
  s(   4364, "Chaco",                                      "03",     4088 )
  s(   4365, "Cordoba",                                    "05",     4088 )
  s(   4366, "Distrito Federal",                           "07",     4088 )
  s(   4367, "La Rioja",                                   "12",     4088 )
  s(   4368, "Misiones",                                   "14",     4088 )
  s(   4369, "Rio Negro",                                  "16",     4088 )
  s(   4370, "Santa Cruz",                                 "20",     4088 )
  s(   4371, "San Juan",                                   "18",     4088 )
  s(   4372, "La Paz",                                     "04",     4106 )
  s(   4373, "Santa Cruz",                                 "08",     4106 )
  s(   4374, "Amazonas",                                   "04",     4107 )
  s(   4375, "Distrito Federal",                           "07",     4107 )
  s(   4376, "Para",                                       "16",     4107 )
  s(   4377, "Santa Catarina",                             "26",     4107 )
  s(   4378, "San Jose",                                   "08",     4126 )
  s(   4379, "Amazonas",                                   "01",     4125 )
  s(   4380, "Sucre",                                      "27",     4125 )
  s(   4381, "Bolivar",                                    "03",     4138 )
  s(   4382, "Central",                                    "06",     4261 )
  s(   4383, "Florida",                                    "07",     4307 )
  s(   4384, "Amazonas",                                   "01",     4249 )
  s(   4385, "La Libertad",                                "13",     4249 )
  s(   4386, "Limburg",                                    "05",     4098 )
  s(   4387, "Luxembourg",                                 "06",     4098 )
  s(   4388, "Ruse",                                       "53",     4100 )
  s(   4389, "Centre",                                     "A3",     4151 )
  s(   4399, "Ha",                                         "10",     4109 )
  s(   4400, "Punjab",                                     "23",     4181 )
  s(   4401, "Timor Timur",                                "TP",     4324 )
  s(   4402, "Toledo",                                     "06",     4113 )
  s(   4403, "La Union",                                   "36",     4252 )
  s(   4404, "Al Jawf",                                    "03",     4268 )
  s(   4405, "'Asir",                                      "11",     4268 )
  s(   4406, "Ash Sharqiyah",                              "06",     4268 )
  s(   4407, "Adrar",                                      "34",     4137 )
  s(   4408, "Est",                                        "04",     4123 )
  s(   4409, "Nord-Ouest",                                 "07",     4123 )
  s(   4410, "Ouest",                                      "08",     4123 )
  s(   4411, "Centre",                                     "11",     4123 )
  s(   4412, "Nord",                                       "13",     4123 )
  s(   4413, "Sud",                                        "14",     4123 )
  s(   4414, "Plateaux",                                   "08",     4118 )
  s(   4415, "Ash Sharqiyah",                              "14",     4140 )
  s(   4416, "Western",                                    "05",     4161 )
  s(   4417, "Central",                                    "04",     4158 )
  s(   4418, "Eastern",                                    "05",     4158 )
  s(   4419, "Northern",                                   "06",     4158 )
  s(   4420, "Western",                                    "09",     4158 )
  s(   4421, "Savanes",                                    "87",     4120 )
  s(   4422, "Central",                                    "01",     4191 )
  s(   4423, "Coast",                                      "02",     4191 )
  s(   4424, "Western",                                    "09",     4191 )
  s(   4425, "Maryland",                                   "06",     4207 )
  s(   4426, "Eastern",                                    "03",     4191 )
  s(   4427, "Mwanza",                                     "25",     4231 )
  s(   4428, "Gaza",                                       "02",     4234 )
  s(   4429, "Plateau",                                    "17",     4105 )
  s(   4430, "Eastern",                                    "01",     4278 )
  s(   4431, "Northern",                                   "02",     4278 )
  s(   4432, "Southern",                                   "03",     4278 )
  s(   4433, "Central",                                    "01",     4111 )
  s(   4434, "Southern",                                   "10",     4111 )
  s(   4435, "North-West",                                 "11",     4111 )
  s(   4436, "North-Western Province",                     "01",     4320 )
  s(   4437, "Ash Shamaliyah",                             "18",     4101 )
  s(   4438, "Al Wusta",                                   "19",     4101 )
  s(   4439, "Praslin",                                    "11",     4204 )
  s(   4440, "Central",                                    "01",     4147 )
  s(   4441, "Eastern",                                    "02",     4147 )
  s(   4442, "Northern",                                   "03",     4147 )
  s(   4443, "Western",                                    "05",     4147 )
  s(   4444, "Victoria",                                   "07",     4091 )
  s(   4445, "Central",                                    "01",     4251 )
  s(   4446, "Northern",                                   "04",     4251 )
  s(   4447, "Western",                                    "06",     4251 )
  s(   4448, "Manchester",                                 "I2",     4153 )
  s(   4449, "Saint George",                               "03",     4080 )
  s(   4450, "Saint John",                                 "04",     4080 )
  s(   4451, "Saint Mary",                                 "05",     4080 )
  s(   4452, "Saint Paul",                                 "06",     4080 )
  s(   4453, "Saint Peter",                                "07",     4080 )
  s(   4454, "Huila",                                      "09",     4085 )
  s(   4455, "Namibe",                                     "13",     4085 )
  s(   4456, "Saint Andrew",                               "02",     4096 )
  s(   4457, "Saint James",                                "04",     4096 )
  s(   4458, "Saint Joseph",                               "06",     4096 )
  s(   4459, "Saint Thomas",                               "11",     4096 )
  s(   4460, "Barisal",                                    "01",     4097 )
  s(   4461, "Dhaka",                                      "32",     4097 )
  s(   4462, "Montana",                                    "47",     4100 )
  s(   4463, "Ar Rifa' wa al Mintaqah al Janubiyah",       "07",     4101 )
  s(   4464, "Alibori",                                    "07",     4103 )
  s(   4465, "Atakora",                                    "08",     4103 )
  s(   4466, "Atlanyique",                                 "09",     4103 )
  s(   4467, "Borgou",                                     "10",     4103 )
  s(   4468, "Collines",                                   "11",     4103 )
  s(   4469, "Kouffo",                                     "12",     4103 )
  s(   4470, "Donga",                                      "13",     4103 )
  s(   4471, "Littoral",                                   "14",     4103 )
  s(   4472, "Mono",                                       "15",     4103 )
  s(   4473, "Oueme",                                      "16",     4103 )
  s(   4474, "Plateau",                                    "17",     4103 )
  s(   4475, "Zou",                                        "18",     4103 )
  s(   4476, "Saint George",                               "06",     4104 )
  s(   4477, "Southampton",                                "10",     4104 )
  s(   4478, "Bolivar",                                    "35",     4125 )
  s(   4479, "Arta",                                       "08",     4133 )
  s(   4480, "Saint Andrew",                               "02",     4135 )
  s(   4481, "Saint David",                                "03",     4135 )
  s(   4482, "Saint George",                               "04",     4135 )
  s(   4483, "Saint John",                                 "05",     4135 )
  s(   4484, "Saint Mark",                                 "08",     4135 )
  s(   4485, "Saint Patrick",                              "09",     4135 )
  s(   4486, "Saint Peter",                                "11",     4135 )
  s(   4487, "Southern",                                   "11",     4144 )
  s(   4488, "Central",                                    "79",     4153 )
  s(   4489, "Saint Andrew",                               "01",     4154 )
  s(   4490, "Saint David",                                "02",     4154 )
  s(   4491, "Saint George",                               "03",     4154 )
  s(   4492, "Saint Patrick",                              "06",     4154 )
  s(   4493, "Colon",                                      "03",     4173 )
  s(   4494, "La Paz",                                     "12",     4173 )
  s(   4495, "Banteay Meanchey",                           "00",     4193 )
  s(   4496, "Batdambang",                                 "01",     4193 )
  s(   4497, "Eastern",                                    "02",     4200 )
  s(   4498, "Western",                                    "08",     4200 )
  s(   4499, "Choiseul",                                   "04",     4204 )
  s(   4500, "Central",                                    "29",     4206 )
  s(   4501, "Northern",                                   "31",     4206 )
  s(   4502, "Southern",                                   "34",     4206 )
  s(   4503, "Western",                                    "36",     4206 )
  s(   4504, "Laayoune",                                   "35",     4213 )
  s(   4505, "Calarasi",                                   "66",     4215 )
  s(   4506, "Distrito Federal",                           "09",     4232 )
  s(   4507, "Autonoma Atlantico Norte",                   "17",     4240 )
  s(   4508, "Region Autonoma Atlantico Sur",              "18",     4240 )
  s(   4509, "Overijssel",                                 "08",     4241 )
  s(   4510, "Al Wusta",                                   "03",     4247 )
  s(   4511, "Ash Sharqiyah",                              "04",     4247 )
  s(   4512, "San Jose",                                   "F6",     4252 )
  s(   4513, "Chechnya Republic",                          "CI",     4266 )
  s(   4514, "Central",                                    "10",     4269 )
  s(   4515, "Western",                                    "11",     4269 )
  s(   4516, "Grand' Anse",                                "14",     4270 )
  s(   4517, "Al Wahadah State",                           "40",     4271 )
  s(   4518, "Central Equatoria State",                    "44",     4271 )
  s(   4519, "Amnat Charoen",                              "77",     4291 )
  s(   4520, "Nakhon Phanom",                              "73",     4291 )
  s(   4521, "Saint Andrew",                               "06",     4299 )
  s(   4522, "Saint David",                                "07",     4299 )
  s(   4523, "Saint George",                               "08",     4299 )
  s(   4524, "Saint Patrick",                              "09",     4299 )
  s(   4525, "Central",                                    "18",     4304 )
  s(   4526, "Eastern",                                    "20",     4304 )
  s(   4527, "Northern",                                   "23",     4304 )
  s(   4528, "Southern",                                   "24",     4304 )
  s(   4529, "Western",                                    "25",     4304 )
  s(   4530, "Jinja",                                      "33",     4304 )
  s(   4531, "Kalangala",                                  "36",     4304 )
  s(   4532, "Kiboga",                                     "42",     4304 )
  s(   4533, "Mbarara",                                    "52",     4304 )
  s(   4534, "Masaka",                                     "71",     4304 )
  s(   4535, "Vinh Puc Province",                          "86",     4314 )
  s(   4536, "Boqueron",                                   "24",     4261 )
  s(   4537, "Negros Occidental",                          "45",     4252 )
  s(   4538, "Liban-Sud",                                  "02",     4203 )
  */
  }
}

object Country extends RamEntity( tid = "a02t" ) {
  "id"     is DbInt      is 'key;
  "name"   is DbChar(64) is 'label;
  "code"   is DbChar(4)  ; 

  def idForCode( s:String ):Int = {
    val codeIdx = staticView( 'code ).index
    
    staticRecords.find( _( codeIdx ) == s ).flatten( _.id.asInstanceOf[Int], 0 )
  }
  
  def idForName( s:String ):Int = {
    val nameIdx = staticView( 'name ).index
    
    staticRecords.find( _( nameIdx ) == s ).flatten( _.id.asInstanceOf[Int], 0 )
  }
  
  def nameForId( i:Int ):String = {
    val nameIdx = staticView( 'name ).index
    
    staticRecords.find( _.id.asInstanceOf[Int] == i ).flatten( _.s( 'name ), "Unknown" )
  }
  
	static { s =>
  s(    "id", "name",				                                  "code" )
	s(    4077, "Andorra",                                      "AN" )
	s(    4078, "United Arab Emirates",                         "AE" )
	s(    4079, "Afghanistan",                                  "AF" )
	s(    4080, "Antigua and Barbuda",                          "AC" )
	s(    4081, "Anguilla",                                     "AV" )
	s(    4082, "Albania",                                      "AL" )
	s(    4083, "Armenia",                                      "AM" )
	s(    4084, "Netherlands Antilles",                         "NT" )
	s(    4085, "Angola",                                       "AO" )
	s(    4088, "Argentina",                                    "AR" )
	s(    4089, "American Samoa",                               "AQ" )
	s(    4090, "Austria",                                      "AU" )
	s(    4091, "Australia",                                    "AS" )
	s(    4092, "Aruba",                                        "AA" )
	s(    4093, "Aland Islands",                                ""   )
	s(    4094, "Azerbaijan",                                   "AJ" )
	s(    4095, "Bosnia and Herzegovina",                       "BK" )
	s(    4096, "Barbados",                                     "BB" )
	s(    4097, "Bangladesh",                                   "BG" )
	s(    4098, "Belgium",                                      "BE" )
	s(    4099, "Burkina Faso",                                 "UV" )
	s(    4100, "Bulgaria",                                     "BU" )
	s(    4101, "Bahrain",                                      "BA" )
	s(    4102, "Burundi",                                      "BY" )
	s(    4103, "Benin",                                        "BN" )
	s(    4104, "Bermuda",                                      "BD" )
	s(    4105, "Brunei Darussalam",                            "BX" )
	s(    4106, "Bolivia",                                      "BL" )
	s(    4107, "Brazil",                                       "BR" )
	s(    4108, "Bahamas",                                      "BF" )
	s(    4109, "Bhutan",                                       "BT" )
	s(    4110, "Bouvet Island",                                "BV" )
	s(    4111, "Botswana",                                     "BC" )
	s(    4112, "Belarus",                                      "BO" )
	s(    4113, "Belize",                                       "BH" )
	s(    4114, "Canada",                                       "CA" )
	s(    4115, "Cocos s(Keeling) Islands",                      "CK" )
	s(    4116, "Congo, Democratic Republic of the",            "CG" )
	s(    4326, "Congo s(Zaire)",                                "CG" )
	s(    4117, "Central African Republic",                     "CT" )
	s(    4118, "Congo",                                        "CF" )
	s(    4119, "Switzerland",                                  "SZ" )
	s(    4120, "Cote d'Ivoire",                                "IV" )
	s(    4121, "Cook Islands",                                 "CW" )
	s(    4122, "Chile",                                        "CI" )
	s(    4123, "Cameroon",                                     "CM" )
	s(    4124, "China",                                        "CH" )
	s(    4125, "Colombia",                                     "CO" )
	s(    4126, "Costa Rica",                                   "CS" )
	s(    4127, "Cuba",                                         "CU" )
	s(    4128, "Cape Verde",                                   "CV" )
	s(    4129, "Christmas Island",                             "KT" )
	s(    4130, "Cyprus",                                       "CY" )
	s(    4131, "Czech Republic",                               "EZ" )
	s(    4132, "Germany",                                      "GM" )
	s(    4133, "Djibouti",                                     "DJ" )
	s(    4134, "Denmark",                                      "DA" )
	s(    4135, "Dominica",                                     "DO" )
	s(    4136, "Dominican Republic",                           "DR" )
	s(    4137, "Algeria",                                      "AG" )
	s(    4138, "Ecuador",                                      "EC" )
	s(    4139, "Estonia",                                      "EN" )
	s(    4140, "Egypt",                                        "EG" )
	s(    4141, "Western Sahara",                               "WI" )
	s(    4142, "Eritrea",                                      "ER" )
	s(    4143, "Spain",                                        "SP" )
	s(    4144, "Ethiopia",                                     "ET" )
	s(    4146, "Finland",                                      "FI" )
	s(    4147, "Fiji",                                         "FJ" )
	s(    4148, "Falkland Islands s(Malvinas)",                  "FK" )
	s(    4149, "Micronesia, Federated States of",              "FM" )
	s(    4150, "Faroe Islands",                                "FO" )
	s(    4151, "France",                                       "FR" )
	s(    4152, "Gabon",                                        "GB" )
	s(    4153, "United Kingdom",                               "UK" )
	s(    4154, "Grenada",                                      "GJ" )
	s(    4155, "Georgia",                                      "GG" )
	s(    4156, "French Guiana",                                "FG" )
	s(    4157, "Guernsey",                                     "GK" )
	s(    4158, "Ghana",                                        "GH" )
	s(    4159, "Gibraltar",                                    "GI" )
	s(    4160, "Greenland",                                    "GL" )
	s(    4161, "Gambia",                                       "GA" )
	s(    4162, "Guinea",                                       "GV" )
	s(    4163, "Guadeloupe",                                   "GP" )
	s(    4164, "Equatorial Guinea",                            "EK" )
	s(    4165, "Greece",                                       "GR" )
	s(    4166, "South Georgia and the South Sandwich Islands", "SX" )
	s(    4167, "Guatemala",                                    "GT" )
	s(    4168, "Guam",                                         "GQ" )
	s(    4169, "Guinea-Bissau",                                "PU" )
	s(    4170, "Guyana",                                       "GY" )
	s(    4172, "Heard Island and McDonald Islands",            "HM" )
	s(    4173, "Honduras",                                     "HO" )
	s(    4174, "Croatia",                                      "HR" )
	s(    4175, "Haiti",                                        "HA" )
	s(    4176, "Hungary",                                      "HU" )
	s(    4177, "Indonesia",                                    "ID" )
	s(    4178, "Ireland",                                      "EI" )
	s(    4179, "Israel",                                       "IS" )
	s(    4180, "Isle of Man",                                  "IM" )
	s(    4181, "India",                                        "IN" )
	s(    4182, "British Indian Ocean Territory",               "IO" )
	s(    4183, "Iraq",                                         "IZ" )
	s(    4184, "Iran, Islamic Republic of",                    "IR" )
	s(    4185, "Iceland",                                      "IC" )
	s(    4186, "Italy",                                        "IT" )
	s(    4187, "Jersey",                                       "JE" )
	s(    4188, "Jamaica",                                      "JM" )
	s(    4189, "Jordan",                                       "JO" )
	s(    4190, "Japan",                                        "JA" )
	s(    4191, "Kenya",                                        "KE" )
	s(    4192, "Kyrgyzstan",                                   "KG" )
	s(    4193, "Cambodia",                                     "CB" )
	s(    4194, "Kiribati",                                     "KR" )
	s(    4195, "Comoros",                                      "CN" )
	s(    4196, "Saint Kitts and Nevis",                        "SC" )
	s(    4197, "North Korea",                                  "KN" )
	s(    4198, "South Korea",                                  "KS" )
	s(    4199, "Kuwait",                                       "KU" )
	s(    4200, "Cayman Islands",                               "CJ" )
	s(    4201, "Kazakhstan",                                   "KZ" )
	s(    4202, "Lao People's Democratic Republic",             "LA" )
	s(    4203, "Lebanon",                                      "LE" )
	s(    4204, "Saint Lucia",                                  "ST" )
	s(    4205, "Liechtenstein",                                "LS" )
	s(    4206, "Sri Lanka",                                    "CE" )
	s(    4207, "Liberia",                                      "LI" )
	s(    4208, "Lesotho",                                      "LT" )
	s(    4209, "Lithuania",                                    "LH" )
	s(    4210, "Luxembourg",                                   "LU" )
	s(    4211, "Latvia",                                       "LG" )
	s(    4212, "Libyan Arab Jamahiriya",                       ""   )
	s(    4213, "Morocco",                                      "MO" )
	s(    4214, "Monaco",                                       "MN" )
	s(    4215, "Moldova, Republic of",                         "MD" )
	s(    4216, "Montenegro",                                   "MW" )
	s(    4217, "Madagascar",                                   "MA" )
	s(    4218, "Marshall Islands",                             "RM" )
	s(    4219, "Macedonia",                                    "MK" )
	s(    4220, "Mali",                                         "ML" )
	s(    4221, "Myanmar",                                      "BM" )
	s(    4222, "Mongolia",                                     "MG" )
	s(    4223, "Macao",                                        "MC" )
	s(    4224, "Northern Mariana Islands",                     "CQ" )
	s(    4225, "Martinique",                                   "MB" )
	s(    4226, "Mauritania",                                   "MR" )
	s(    4227, "Montserrat",                                   "MH" )
	s(    4228, "Malta",                                        "MT" )
	s(    4229, "Mauritius",                                    "MP" )
	s(    4230, "Maldives",                                     "MV" )
	s(    4231, "Malawi",                                       "MI" )
	s(    4232, "Mexico",                                       "MX" )
	s(    4233, "Malaysia",                                     "MY" )
	s(    4234, "Mozambique",                                   "MZ" )
	s(    4235, "Namibia",                                      "WA" )
	s(    4236, "New Caledonia",                                "NC" )
	s(    4237, "Niger",                                        "NG" )
	s(    4238, "Norfolk Island",                               "NF" )
	s(    4239, "Nigeria",                                      "NI" )
	s(    4240, "Nicaragua",                                    "NU" )
	s(    4241, "Netherlands",                                  "NL" )
	s(    4242, "Norway",                                       "NO" )
	s(    4243, "Nepal",                                        "NP" )
	s(    4244, "Nauru",                                        "NR" )
	s(    4245, "Niue",                                         "NE" )
	s(    4246, "New Zealand",                                  "NZ" )
	s(    4247, "Oman",                                         "MU" )
	s(    4248, "Panama",                                       "PM" )
	s(    4249, "Peru",                                         "PE" )
	s(    4250, "French Polynesia",                             "FP" )
	s(    4251, "Papua New Guinea",                             "PP" )
	s(    4252, "Philippines",                                  "RP" )
	s(    4253, "Pakistan",                                     "PK" )
	s(    4254, "Poland",                                       "PL" )
	s(    4255, "Saint Pierre and Miquelon",                    "SB" )
	s(    4256, "Pitcairn",                                     "PC" )
	s(    4257, "Puerto Rico",                                  "RQ" )
	s(    4258, "Palestinian Territory",                        ""   )
	s(    4259, "Portugal",                                     "PO" )
	s(    4260, "Palau",                                        "PS" )
	s(    4261, "Paraguay",                                     "PA" )
	s(    4262, "Qatar",                                        "QA" )
	s(    4263, "Reunion",                                      "RE" )
	s(    4264, "Romania",                                      "RO" )
	s(    4265, "Serbia",                                       "RI" )
	s(    4266, "Russian Federation",                           "RS" )
	s(    4267, "Rwanda",                                       "RW" )
	s(    4268, "Saudi Arabia",                                 "SA" )
	s(    4269, "Solomon Islands",                              "BP" )
	s(    4270, "Seychelles",                                   "SE" )
	s(    4271, "Sudan",                                        "SU" )
	s(    4272, "Sweden",                                       "SW" )
	s(    4273, "Singapore",                                    "SN" )
	s(    4274, "Saint Helena",                                 "SH" )
	s(    4275, "Slovenia",                                     "SI" )
	s(    4276, "Svalbard and Jan Mayen",                       "SV" )
	s(    4277, "Slovakia",                                     "LO" )
	s(    4278, "Sierra Leone",                                 "SL" )
	s(    4279, "San Marino",                                   "SM" )
	s(    4280, "Senegal",                                      "SG" )
	s(    4281, "Somalia",                                      "SO" )
	s(    4282, "Suriname",                                     "NS" )
	s(    4283, "Sao Tome and Principe",                        "TP" )
	s(    4284, "El Salvador",                                  "ES" )
	s(    4285, "Syria",                                        "SY" )
	s(    4286, "Swaziland",                                    "WZ" )
	s(    4287, "Turks and Caicos Islands",                     "TK" )
	s(    4288, "Chad",                                         "CD" )
	s(    4289, "French Southern Territories",                  "FS" )
	s(    4290, "Togo",                                         "TO" )
	s(    4291, "Thailand",                                     "TH" )
	s(    4292, "Tajikistan",                                   "TI" )
	s(    4293, "Tokelau",                                      "TL" )
	s(    4294, "Timor-Leste",                                  "TT" )
	s(    4295, "Turkmenistan",                                 "TX" )
	s(    4296, "Tunisia",                                      "TS" )
	s(    4297, "Tonga",                                        "TN" )
	s(    4298, "Turkey",                                       "TU" )
	s(    4299, "Trinidad and Tobago",                          "TD" )
	s(    4300, "Tuvalu",                                       "TV" )
	s(    4301, "Taiwan",                                       "TW" )
	s(    4302, "Tanzania, United Republic of",                 "TZ" )
	s(    4303, "Ukraine",                                      "UP" )
	s(    4304, "Uganda",                                       "UG" )
	s(    4305, "United States Minor Outlying Islands",         ""   )
	s(    4306, "United States",                                "US" )
	s(    4307, "Uruguay",                                      "UY" )
	s(    4308, "Uzbekistan",                                   "UZ" )
	s(    4309, "Holy See s(Vatican City State)",                "VT" )
	s(    4310, "Saint Vincent and the Grenadines",             "VC" )
	s(    4311, "Venezuela",                                    "VE" )
	s(    4312, "Virgin Islands, British",                      "VI" )
	s(    4313, "Virgin Islands, U.S.",                         "VQ" )
	s(    4314, "Vietnam",                                      "VM" )
	s(    4315, "Vanuatu",                                      "NH" )
	s(    4316, "Wallis and Futuna",                            "WF" )
	s(    4317, "Samoa",                                        "WS" )
	s(    4318, "Yemen",                                        "YM" )
	s(    4319, "Mayotte",                                      "MF" )
	s(    4320, "South Africa",                                 "SF" )
	s(    4321, "Zambia",                                       "ZA" )
	s(    4322, "Zimbabwe",                                     "ZI" )
	s(    4323, "Metropolitan France",                          ""   )
	s(    4324, "Timor-Leste s(East Timor)",                     "TT" )
	s(    4325, "Yugoslavia",                                   "YU" )
  }
}

