/**
 * Copyright (c) 2008-2011 Tyranid <http://tyranid.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tyranid.math

import org.tyranid.Imp._


case class ByteArray( bytes:Array[Byte] ) {

  def toHexString = {
    val sb = new StringBuilder( bytes.length * 2 )
    for ( i <- 0 until bytes.length ) {
      val v:Int = bytes( i ) & 0xff
      if ( v < 16 )
        sb += '0'
      sb ++= Integer.toHexString( v )
    }

    sb.toString
  }
}



