/*
 * Decompiled with CFR 0.152.
 */
package org.tyranid.session;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class MockHttpSession
implements HttpSession {
    private String id = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long creationTime;
    private int maxInactiveInterval = 1800000;

    public MockHttpSession() {
        this.creationTime = System.currentTimeMillis();
    }

    public MockHttpSession(String string) {
        this.id = string;
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        if (this.id == null) {
            System.out.println("Inventing data in MockHttpSession.getId() to remain plausible.");
            this.id = "mock";
        }
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Deprecated
    public Object getValue(String string) {
        return this.attributes.get(string);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    @Deprecated
    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    @Deprecated
    public void putValue(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    @Deprecated
    public void removeValue(String string) {
        this.attributes.remove(string);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return true;
    }
}

