/*
 * Decompiled with CFR 0.152.
 */
package org.tyranid.cloud.aws;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.tyranid.Bind$;
import org.tyranid.Imp$;
import org.tyranid.cloud.aws.S3Bucket;
import org.tyranid.io.IOUtils$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class S3$
implements ScalaObject {
    public static final S3$ MODULE$;
    private final AmazonS3Client s3;

    static {
        new S3$();
    }

    private AmazonS3Client s3() {
        return this.s3;
    }

    public PutObjectResult write(S3Bucket bucket, String key, File file) {
        return this.s3().putObject(bucket.name(), key, file);
    }

    public PutObjectResult write(S3Bucket bucket, String key, String mimeType, byte[] data) {
        ObjectMetadata md = new ObjectMetadata();
        md.setContentLength((long)data.length);
        md.setContentType(mimeType);
        ByteArrayInputStream is2 = new ByteArrayInputStream(data);
        PutObjectResult exceptionResult1 = null;
        try {
            exceptionResult1 = this.s3().putObject(bucket.name(), key, (InputStream)is2, md);
            return exceptionResult1;
        }
        finally {
            is2.close();
        }
    }

    public PutObjectResult write(S3Bucket bucket, String key, long contentLength, String contentType, InputStream in) {
        ObjectMetadata md = new ObjectMetadata();
        md.setContentLength(contentLength);
        md.setContentType(contentType);
        PutObjectResult exceptionResult2 = null;
        try {
            exceptionResult2 = this.s3().putObject(bucket.name(), key, in, md);
            return exceptionResult2;
        }
        finally {
            in.close();
        }
    }

    public void delete(S3Bucket bucket, String key) {
        this.s3().deleteObject(bucket.name(), key);
    }

    public void access(S3Bucket bucket, String key, boolean bl) {
        try {
            AccessControlList acl = this.s3().getObjectAcl(bucket.name(), key);
            acl.revokeAllPermissions((Grantee)GroupGrantee.AllUsers);
            if (bl) {
                acl.grantPermission((Grantee)GroupGrantee.AllUsers, Permission.Read);
            }
            this.s3().setObjectAcl(bucket.name(), key, acl);
        }
        catch (AmazonS3Exception amazonS3Exception) {
            Imp$.MODULE$.log("S3 Exception", (Exception)((Object)amazonS3Exception));
        }
    }

    public Object download(S3Bucket bucket, String key) {
        S3Object obj = null;
        BoxedUnit exceptionResult3 = null;
        try {
            Object object;
            obj = this.s3().getObject(new GetObjectRequest(bucket.name(), key));
            if (obj == null) {
                object = BoxedUnit.UNIT;
            } else {
                String tmpName = new StringBuilder().append((Object)"/tmp/").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).append((Object)"_").append((Object)key).toString();
                File f = new File(tmpName);
                FileOutputStream fops = new FileOutputStream(f);
                IOUtils$.MODULE$.transfer(obj.getObjectContent(), fops);
                fops.close();
                object = f;
            }
            exceptionResult3 = object;
        }
        catch (AmazonS3Exception amazonS3Exception) {
            amazonS3Exception.printStackTrace();
            Predef$.MODULE$.println((Object)amazonS3Exception.getMessage());
            exceptionResult3 = null;
        }
        return exceptionResult3;
    }

    /*
     * WARNING - void declaration
     */
    public Object getInputStream(S3Bucket bucket, String key) {
        void var3_3;
        Object exceptionResult4 = null;
        try {
            S3Object obj = this.s3().getObject(new GetObjectRequest(bucket.name(), key));
            exceptionResult4 = obj == null ? BoxedUnit.UNIT : obj.getObjectContent();
        }
        catch (AmazonS3Exception amazonS3Exception) {
            amazonS3Exception.printStackTrace();
            Predef$.MODULE$.println((Object)amazonS3Exception.getMessage());
            exceptionResult4 = null;
        }
        return var3_3;
    }

    public S3Object getObject(S3Bucket bucket, String key) {
        return this.s3().getObject(new GetObjectRequest(bucket.name(), key));
    }

    private S3$() {
        MODULE$ = this;
        this.s3 = new AmazonS3Client(Bind$.MODULE$.AwsCredentials());
    }
}

