/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.attributes;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ubercraft.sucre.attributes.DefaultProxyKeyFactory;
import org.ubercraft.sucre.attributes.ProxyKey;
import org.ubercraft.sucre.attributes.ProxyKeyFactory;
import org.ubercraft.sucre.coercer.CoercerUtil;
import org.ubercraft.sucre.common.AssertUtil;
import org.ubercraft.sucre.common.ObjectUtil;
import org.ubercraft.sucre.common.ReflectionUtil;
import org.ubercraft.sucre.reflect.Accessor;
import org.ubercraft.sucre.reflect.MethodReflector;
import org.ubercraft.sucre.reflect.Mutator;
import org.ubercraft.sucre.reflect.Reflect;
import org.ubercraft.sucre.reflect.Reflector;

public final class Attributes
implements Serializable {
    private static final long serialVersionUID = 6687989846839179831L;
    public static final Attributes EMPTY_ATTRIBUTES = new Attributes(Collections.emptyMap());
    private final Map<Object, Object> values;
    private final Attributes defaults;

    public static Attributes backedBy(Map<? extends Object, ? extends Object> values) {
        return Attributes.backedBy(values, null);
    }

    public static Attributes backedBy(Map<? extends Object, ? extends Object> values, Attributes defaults) {
        return new Attributes(AssertUtil.notNull(values), defaults, true);
    }

    public Attributes() {
        this(null, null);
    }

    public Attributes(Map<? extends Object, ? extends Object> values) {
        this(values, null);
    }

    public Attributes(Attributes defaults) {
        this(null, defaults);
    }

    public Attributes(Map<? extends Object, ? extends Object> values, Attributes defaults) {
        this(values, defaults, false);
    }

    private Attributes(Map<? extends Object, ? extends Object> values, Attributes defaults, boolean backed) {
        this.values = values != null ? (backed ? values : new HashMap<Object, Object>(values)) : new HashMap();
        this.defaults = defaults;
    }

    public Map<Object, Object> getValues() {
        return this.values;
    }

    public Attributes getDefaults() {
        return this.defaults;
    }

    public Set<Object> keySet() {
        return this.values.keySet();
    }

    public boolean hasKey(Object key) {
        return this.values.containsKey(key);
    }

    public boolean hasKeyOrDefaultKey(Object key) {
        return this.hasKey(key) || this.defaults != null && this.defaults.hasKeyOrDefaultKey(key);
    }

    public Object get(Object key) {
        return this.get(key, null);
    }

    public Object get(Object key, Object def) {
        return this.hasKey(key) ? this.values.get(key) : (this.defaults != null ? this.defaults.get(key, def) : def);
    }

    public String getString(Object key) {
        return this.getString(key, null);
    }

    public String getString(Object key, String def) {
        return CoercerUtil.coerceToString(this.get(key, def));
    }

    public Boolean getBoolean(Object key) {
        return CoercerUtil.coerceToBoolean(this.get(key), false);
    }

    public boolean getBoolean(Object key, boolean def) {
        return ObjectUtil.unwrap(this.getBoolean(key), def);
    }

    public Integer getInt(Object key) {
        return CoercerUtil.coerceToInteger(this.get(key), false);
    }

    public int getInt(Object key, int def) {
        return ObjectUtil.unwrap(this.getInt(key), def);
    }

    public Double getDouble(Object key) {
        return CoercerUtil.coerceToDouble(this.get(key), false);
    }

    public double getDouble(Object key, double def) {
        return ObjectUtil.unwrap(this.getDouble(key), def);
    }

    public <T> T getTyped(Class<T> type) {
        return (T)this.get(type);
    }

    public Object set(Object key, Object value) {
        return this.values.put(key, value);
    }

    public Object remove(Object key) {
        return this.values.remove(key);
    }

    public void addAll(Attributes attributes) {
        this.values.putAll(attributes.values);
    }

    public void addAll(Map<? extends Object, ? extends Object> values) {
        this.values.putAll(values);
    }

    public void clear() {
        this.values.clear();
    }

    public int hashCode() {
        int hashCode = this.values.hashCode();
        if (this.defaults != null) {
            return hashCode ^= this.defaults.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Attributes other = (Attributes)o;
        return this.values.equals(other.values) && ObjectUtil.nullSafeEquals(this.defaults, other.defaults);
    }

    public String toString() {
        return "values: " + this.values + (this.defaults != null ? ", default " + this.defaults : "");
    }

    public <T> T proxy(Class<T> api, Class<?> ... apis) {
        return this.proxy((ProxyKeyFactory)null, (Reflect)null, api, apis);
    }

    public <T> T proxy(Reflect reflect, Class<T> api, Class<?> ... apis) {
        return this.proxy((ProxyKeyFactory)null, reflect, api, apis);
    }

    public <T> T proxy(ProxyKeyFactory factory, Class<T> api, Class<?> ... apis) {
        return this.proxy(factory, (Reflect)null, api, apis);
    }

    public <T> T proxy(ProxyKeyFactory factory, Reflect reflect, Class<T> api, Class<?> ... apis) {
        Class[] interfaces = new Class[1 + (apis != null ? apis.length : 0)];
        interfaces[0] = api;
        if (apis != null) {
            System.arraycopy(apis, 0, interfaces, 1, apis.length);
        }
        return (T)this.proxy(factory, reflect, interfaces);
    }

    private Object proxy(ProxyKeyFactory factory, Reflect reflect, Class<?> ... apis) {
        if (factory == null) {
            factory = DefaultProxyKeyFactory.DEFAULT_PROXY_KEY_FACTORY;
        }
        HashMap<Method, ProxyKey> mappings = new HashMap<Method, ProxyKey>();
        Class<?>[] classArray = apis;
        int n = apis.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> api = classArray[n2];
            Attributes.createProxyKeyMappings(factory, reflect, api, mappings);
            ++n2;
        }
        return Proxy.newProxyInstance(apis[0].getClassLoader(), apis, (InvocationHandler)new AttributeProxyInvocationHandler(mappings));
    }

    private static void createProxyKeyMappings(ProxyKeyFactory factory, Reflect reflect, Class<?> api, Map<Method, ProxyKey> mappings) {
        if (reflect == null) {
            reflect = Reflect.METHODS;
        }
        Reflector reflector = reflect.getReflector(api);
        for (Accessor accessor : reflector.getAccessors()) {
            Mutator mutator;
            Method mutatorMethod;
            ProxyKey proxyKey;
            Method accessorMethod = ((MethodReflector)((Object)accessor)).getMethod();
            if (mappings.containsKey(accessorMethod) || (proxyKey = factory.proxyKeyFor(accessor)) == null) continue;
            mappings.put(accessorMethod, proxyKey);
            if (!accessor.isPaired() || mappings.containsKey(mutatorMethod = ((MethodReflector)((Object)(mutator = reflector.getMutator(accessor.getName())))).getMethod())) continue;
            mappings.put(mutatorMethod, proxyKey);
        }
    }

    private static AttributeProxyInvocationHandler getInvocationHandler(Object proxy) {
        return (AttributeProxyInvocationHandler)Proxy.getInvocationHandler(proxy);
    }

    public static Attributes getProxiedAttributes(Object proxy) {
        return Attributes.getInvocationHandler(proxy).getAttributes();
    }

    public static Collection<ProxyKey> getProxyKeys(Object proxy) {
        return Attributes.getInvocationHandler(proxy).mappings.values();
    }

    private class AttributeProxyInvocationHandler
    implements InvocationHandler {
        private final Map<Method, ProxyKey> mappings;

        AttributeProxyInvocationHandler(Map<Method, ProxyKey> mappings) {
            this.mappings = Collections.unmodifiableMap(mappings);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ProxyKey key = this.mappings.get(method);
            Class<?> type = method.getReturnType();
            if (key != null) {
                if (type == Void.TYPE) {
                    this.setValue(args, key);
                    return null;
                }
                return this.getValue(key, type);
            }
            if (Attributes.class.isAssignableFrom(type) && method.getParameterTypes().length == 0) {
                return Attributes.this;
            }
            if (ReflectionUtil.isHashCodeMethod(method)) {
                return System.identityHashCode(proxy);
            }
            if (ReflectionUtil.isEqualsMethod(method)) {
                if (proxy == args[0]) {
                    return true;
                }
                return false;
            }
            if (ReflectionUtil.isToStringMethod(method)) {
                return this.toString();
            }
            if (method.getReturnType().isPrimitive()) {
                return ObjectUtil.getPrimitiveDefault(method.getReturnType());
            }
            return null;
        }

        private Object getValue(ProxyKey key, Class<?> type) {
            Object value = key.getDefault();
            Object[] objectArray = key.getAttributeKeys();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object attributeKey = objectArray[n2];
                if (Attributes.this.hasKeyOrDefaultKey(attributeKey)) {
                    value = Attributes.this.get(attributeKey, value);
                    break;
                }
                ++n2;
            }
            if (value != null) {
                value = key.getCoercer().coerce(value, type, key.isStrictCoerce());
            }
            if (value == null && type.isPrimitive()) {
                value = ObjectUtil.getPrimitiveDefault(type);
            }
            return value;
        }

        private void setValue(Object[] args, ProxyKey key) {
            Object value = args[0];
            Object[] objectArray = key.getAttributeKeys();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object attributeKey = objectArray[n2];
                Attributes.this.set(attributeKey, value);
                ++n2;
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("[");
            for (ProxyKey key : this.mappings.values()) {
                b.append(Arrays.asList(key.getAttributeKeys()));
                b.append("=");
                b.append(this.getValue(key, Object.class));
                b.append(", ");
            }
            if (b.length() > 1) {
                b.setLength(b.length() - 2);
            }
            b.append("]");
            return b.toString();
        }

        private Attributes getAttributes() {
            return Attributes.this;
        }
    }
}

