/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.coercer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TimeZone;
import org.ubercraft.sucre.coercer.Coercer;
import org.ubercraft.sucre.coercer.CoercerException;
import org.ubercraft.sucre.coercer.CoercerUtil;
import org.ubercraft.sucre.common.AssertUtil;

public class DateCoercer
implements Coercer {
    private final List<SimpleDateFormat> dateFormats;

    public DateCoercer(TimeZone timezone, String ... dateFormatStrings) {
        if (dateFormatStrings == null || dateFormatStrings.length == 0) {
            throw new IllegalArgumentException("must specify at least one date format");
        }
        LinkedHashSet<String> dateFormatStringSet = new LinkedHashSet<String>();
        String[] stringArray = dateFormatStrings;
        int n = dateFormatStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String dateFormatString = stringArray[n2];
            dateFormatStringSet.add(AssertUtil.notNull(dateFormatString, "date format must not be null"));
            ++n2;
        }
        this.dateFormats = new ArrayList<SimpleDateFormat>(dateFormatStringSet.size());
        for (String dateFormatString : dateFormatStringSet) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatString);
            simpleDateFormat.setTimeZone(timezone);
            this.dateFormats.add(simpleDateFormat);
        }
    }

    @Override
    public Date coerce(Object value, Class<?> type, boolean strict) {
        if (value == null || value instanceof Date) {
            return (Date)value;
        }
        String string = CoercerUtil.coerceToString(value);
        for (SimpleDateFormat dateFormat : this.dateFormats) {
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (strict) {
            throw new CoercerException("could not parse as date: " + string);
        }
        return null;
    }
}

