/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.common;

import java.util.HashMap;
import java.util.Map;

public final class ObjectUtil {
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS;

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, false);
        map.put(Integer.TYPE, 0);
        map.put(Double.TYPE, 0.0);
        map.put(Long.TYPE, 0L);
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Character.TYPE, 0);
        map.put(Short.TYPE, 0);
        map.put(Byte.TYPE, 0);
        PRIMITIVE_DEFAULTS = map;
    }

    public static Object getPrimitiveDefault(Class<?> type) {
        return PRIMITIVE_DEFAULTS.get(type);
    }

    public static boolean unwrap(Boolean b, boolean nullValue) {
        return b != null ? b : nullValue;
    }

    public static int unwrap(Integer i, int nullValue) {
        return i != null ? i : nullValue;
    }

    public static long unwrap(Long l, long nullValue) {
        return l != null ? l : nullValue;
    }

    public static double unwrap(Double d, double nullValue) {
        return d != null ? d : nullValue;
    }

    public static float unwrap(Float f, float nullValue) {
        return f != null ? f.floatValue() : nullValue;
    }

    public static byte unwrap(Byte b, byte nullValue) {
        return b != null ? b : nullValue;
    }

    public static short unwrap(Short s, byte nullValue) {
        return s != null ? s : nullValue;
    }

    public static char unwrap(Character c, char nullValue) {
        return c != null ? c.charValue() : nullValue;
    }

    public static boolean nullSafeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean leftEquals(Object a, Object b) {
        if (a == null || a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean rightEquals(Object a, Object b) {
        return ObjectUtil.leftEquals(b, a);
    }
}

