/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.common;

import java.lang.reflect.Method;
import org.ubercraft.sucre.common.ExceptionUtil;

public final class ReflectionUtil {
    public static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method.getName().equals("toString") && method.getReturnType() == String.class && method.getParameterTypes().length == 0;
    }

    public static <T> T newInstanceUnchecked(Class<? extends T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtil.asUnchecked(e);
        }
    }
}

