/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ubercraft.sucre.reflect.AbstractAccessorMutatorBase;
import org.ubercraft.sucre.reflect.Accessor;
import org.ubercraft.sucre.reflect.FieldReflector;
import org.ubercraft.sucre.reflect.Mutator;
import org.ubercraft.sucre.reflect.ReflectException;
import org.ubercraft.sucre.reflect.Reflector;
import org.ubercraft.sucre.reflect.ReflectorFactory;

public class FieldReflectorFactory
implements ReflectorFactory {
    @Override
    public Reflector createReflector(Class<?> type) {
        return new FieldReflectorImpl(type);
    }

    private static class FieldReflectorImpl
    implements Reflector {
        private Class<?> type;
        private Map<String, ? super FieldAccessorMutator> accessorsMutators = null;

        FieldReflectorImpl(Class<?> type) {
            this.type = type;
        }

        @Override
        public void preCache() throws Exception {
            this.accessorsMutators();
        }

        @Override
        public Accessor getAccessor(String name) {
            return (Accessor)this.getAccessorMutator(name);
        }

        @Override
        public Iterable<Accessor> getAccessors() {
            return this.iterateAccessorsMutators();
        }

        @Override
        public Mutator getMutator(String name) {
            return (Mutator)this.getAccessorMutator(name);
        }

        @Override
        public Iterable<Mutator> getMutators() {
            return this.iterateAccessorsMutators();
        }

        private Object getAccessorMutator(String name) {
            return this.accessorsMutators().get(name);
        }

        private Iterable<? super FieldAccessorMutator> iterateAccessorsMutators() {
            return this.accessorsMutators().values();
        }

        private Map<String, ? super FieldAccessorMutator> accessorsMutators() {
            if (this.accessorsMutators == null) {
                this.accessorsMutators = this.createAccessorMutatorMap();
            }
            return this.accessorsMutators;
        }

        private Map<String, ? super FieldAccessorMutator> createAccessorMutatorMap() {
            HashMap<String, FieldAccessorMutator> accessorsMutators = new HashMap<String, FieldAccessorMutator>();
            List<Field> fieldList = FieldReflectorImpl.findAllDeclaredFields(this.type);
            Iterator<Field> iterator = fieldList.iterator();
            while (iterator.hasNext()) {
                Field field = iterator.next();
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                    iterator.remove();
                    continue;
                }
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                accessorsMutators.put(fieldName, new FieldAccessorMutator(field, fieldName, fieldType));
            }
            AccessibleObject[] fields = fieldList.toArray(new Field[fieldList.size()]);
            Field.setAccessible(fields, true);
            return accessorsMutators;
        }

        private static List<Field> findAllDeclaredFields(Class<?> type) {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            FieldReflectorImpl.findAllDeclaredFields(type, fieldList);
            return fieldList;
        }

        private static void findAllDeclaredFields(Class<?> type, List<Field> fieldList) {
            Field[] declaredFields = type.getDeclaredFields();
            int i = 0;
            while (i < declaredFields.length) {
                fieldList.add(declaredFields[i]);
                ++i;
            }
            if ((type = type.getSuperclass()) == Object.class) {
                return;
            }
            FieldReflectorImpl.findAllDeclaredFields(type, fieldList);
        }

        private static class FieldAccessorMutator
        extends AbstractAccessorMutatorBase
        implements Accessor,
        Mutator,
        FieldReflector {
            private final Field field;

            FieldAccessorMutator(Field field, String name, Class<?> type) {
                super(name, type);
                this.field = field;
            }

            @Override
            public Field getField() {
                return this.field;
            }

            @Override
            public Class<?> getDeclaringType() {
                return this.field.getDeclaringClass();
            }

            @Override
            public Object access(Object object) {
                try {
                    return this.field.get(object);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ReflectException("access on field: '" + this + "' failed", e);
                }
            }

            @Override
            public void mutate(Object object, Object value) {
                try {
                    this.field.set(object, value);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ReflectException("mutate on field: '" + this + "' failed", e);
                }
            }

            @Override
            public boolean isPaired() {
                return true;
            }

            @Override
            public Accessor getPairedAccessor() {
                return this;
            }

            @Override
            public Mutator getPairedMutator() {
                return this;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return this.field.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return this.field.getAnnotations();
            }
        }
    }
}

