/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.ubercraft.sucre.reflect.AbstractAccessorMutatorBase;
import org.ubercraft.sucre.reflect.Accessor;
import org.ubercraft.sucre.reflect.AccessorMutator;
import org.ubercraft.sucre.reflect.MethodReflector;
import org.ubercraft.sucre.reflect.Mutator;
import org.ubercraft.sucre.reflect.ReflectHelper;
import org.ubercraft.sucre.reflect.Reflector;
import org.ubercraft.sucre.reflect.ReflectorFactory;

public class MethodReflectorFactory
implements ReflectorFactory {
    @Override
    public Reflector createReflector(Class<?> type) {
        return new MethodReflectorImpl(type);
    }

    private static class MethodReflectorImpl
    implements Reflector {
        private Class<?> type;
        private Map<String, Accessor> accessors = null;
        private Map<String, Mutator> mutators = null;

        MethodReflectorImpl(Class<?> type) {
            this.type = type;
        }

        @Override
        public void preCache() throws Exception {
            this.accessors();
            this.mutators();
        }

        @Override
        public Accessor getAccessor(String name) {
            return this.accessors().get(name);
        }

        @Override
        public Iterable<Accessor> getAccessors() {
            return this.accessors().values();
        }

        @Override
        public Mutator getMutator(String name) {
            return this.mutators().get(name);
        }

        @Override
        public Iterable<Mutator> getMutators() {
            return this.mutators().values();
        }

        private Map<String, Accessor> accessors() {
            if (this.accessors == null) {
                this.accessors = this.createAccessorMap();
            }
            return this.accessors;
        }

        private Map<String, Mutator> mutators() {
            if (this.mutators == null) {
                this.mutators = this.createMutatorMap();
            }
            return this.mutators;
        }

        private Map<String, Accessor> createAccessorMap() {
            HashMap<String, Accessor> accessors = new HashMap<String, Accessor>();
            Method[] methods = this.type.getMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?> returnType;
                String fieldName;
                Method method = methods[i];
                if (method.getDeclaringClass() != Object.class && (fieldName = ReflectHelper.accessorMethodNameToFieldName(method.getName())) != null && method.getParameterTypes().length == 0 && (returnType = method.getReturnType()) != Void.TYPE) {
                    accessors.put(fieldName, new MethodAccessorImpl(method, fieldName, returnType));
                }
                ++i;
            }
            return accessors;
        }

        private Map<String, Mutator> createMutatorMap() {
            HashMap<String, Mutator> mutators = new HashMap<String, Mutator>();
            Method[] methods = this.type.getMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] parameterTypes;
                String fieldName;
                Method method = methods[i];
                if (method.getDeclaringClass() != Object.class && (fieldName = ReflectHelper.mutatorMethodNameToFieldName(method.getName())) != null && (parameterTypes = method.getParameterTypes()).length == 1) {
                    Class<?> parameterType = parameterTypes[0];
                    Class<?> returnType = method.getReturnType();
                    if (returnType == Void.TYPE) {
                        mutators.put(fieldName, new MethodMutatorImpl(method, fieldName, parameterType));
                    }
                }
                ++i;
            }
            return mutators;
        }

        private class MethodAccessorImpl
        extends MethodAccessorMutator
        implements Accessor {
            private Mutator pairedMutator;

            MethodAccessorImpl(Method method, String name, Class<?> type) {
                super(method, name, type);
            }

            private void checkPair() {
                if (!this.checkedPair) {
                    this.checkedPair = true;
                    this.pairedMutator = (Mutator)MethodReflectorImpl.this.mutators().get(this.getName());
                }
            }

            @Override
            public Object access(Object object) {
                try {
                    return this.method.invoke(object, null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean isPaired() {
                this.checkPair();
                return this.pairedMutator != null;
            }

            @Override
            public Accessor getPairedAccessor() {
                return this;
            }

            @Override
            public Mutator getPairedMutator() {
                this.checkPair();
                return this.pairedMutator;
            }
        }

        private abstract class MethodAccessorMutator
        extends AbstractAccessorMutatorBase
        implements AccessorMutator,
        MethodReflector {
            protected final Method method;
            protected boolean checkedPair;

            MethodAccessorMutator(Method method, String name, Class<?> type) {
                super(name, type);
                this.checkedPair = false;
                this.method = method;
            }

            @Override
            public Method getMethod() {
                return this.method;
            }

            @Override
            public Class<?> getDeclaringType() {
                return this.method.getDeclaringClass();
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return this.method.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return this.method.getAnnotations();
            }
        }

        private class MethodMutatorImpl
        extends MethodAccessorMutator
        implements Mutator {
            private Accessor pairedAccessor;

            MethodMutatorImpl(Method method, String name, Class<?> type) {
                super(method, name, type);
            }

            private void checkPair() {
                if (!this.checkedPair) {
                    this.checkedPair = true;
                    this.pairedAccessor = (Accessor)MethodReflectorImpl.this.accessors().get(this.getName());
                }
            }

            @Override
            public void mutate(Object object, Object value) {
                try {
                    this.method.invoke(object, value);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean isPaired() {
                this.checkPair();
                return this.pairedAccessor != null;
            }

            @Override
            public Accessor getPairedAccessor() {
                this.checkPair();
                return this.pairedAccessor;
            }

            @Override
            public Mutator getPairedMutator() {
                return this;
            }
        }
    }
}

