/*
 * Decompiled with CFR 0.152.
 */
package org.ubercraft.sucre.reflect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ubercraft.sucre.common.AssertUtil;
import org.ubercraft.sucre.reflect.FieldReflectorFactory;
import org.ubercraft.sucre.reflect.MethodReflectorFactory;
import org.ubercraft.sucre.reflect.ReflectException;
import org.ubercraft.sucre.reflect.Reflector;
import org.ubercraft.sucre.reflect.ReflectorFactory;

public class Reflect {
    public static final Reflect METHODS = new Reflect(MethodReflectorFactory.class);
    public static final Reflect FIELDS = new Reflect(FieldReflectorFactory.class);
    private final Class<? extends ReflectorFactory> defaultFactoryClass;
    private final Map<Class<?>, Class<? extends ReflectorFactory>> factoryMappings = new ConcurrentHashMap();
    private final Map<Class<?>, ReflectorFactory> factories = new ConcurrentHashMap();
    private final Map<Class<?>, Reflector> reflectorCache = new ConcurrentHashMap();

    public Reflect() {
        this(MethodReflectorFactory.class);
    }

    public Reflect(Class<? extends ReflectorFactory> defaultFactoryClass) {
        this.defaultFactoryClass = defaultFactoryClass;
    }

    public void setReflectorFactoryClass(Class<?> type, Class<? extends ReflectorFactory> clazz) {
        AssertUtil.notNull(type, "type cannot be null");
        if (type != null) {
            this.factoryMappings.put(type, clazz);
        } else {
            this.factoryMappings.remove(type);
        }
    }

    public void preCache(Class<?> type) {
        AssertUtil.notNull(type, "type cannot be null");
        try {
            Reflector reflector = this.getReflector(type);
            reflector.preCache();
        }
        catch (ReflectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectException("failed to pre-cache accessor/mutator maps for type: " + type.getName(), e);
        }
    }

    public void unCache(Class<?> type) {
        this.reflectorCache.remove(type);
    }

    public void clearCache() {
        this.reflectorCache.clear();
    }

    public Reflector getReflector(Class<?> type) {
        AssertUtil.notNull(type, "type cannot be null");
        try {
            Reflector reflector = this.reflectorCache.get(type);
            if (reflector != null) {
                return reflector;
            }
            ReflectorFactory factory = this.factories.get(type);
            if (factory == null) {
                Class<? extends ReflectorFactory> clazz = this.factoryMappings.get(type);
                if (clazz == null) {
                    clazz = this.defaultFactoryClass;
                }
                factory = clazz.newInstance();
                this.factories.put(type, factory);
            }
            reflector = factory.createReflector(type);
            this.reflectorCache.put(type, reflector);
            return reflector;
        }
        catch (ReflectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectException("failed to create reflector for type: " + type.getName(), e);
        }
    }
}

