/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.client.stateControl.registry.impl;

import java.util.List;
import org.appformer.client.stateControl.registry.RegistryChangeListener;
import org.appformer.client.stateControl.registry.impl.DefaultRegistryImpl;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultRegistryImplTest {
    private static final Command COMMAND1 = new Command(1);
    private static final Command COMMAND2 = new Command(2);
    private static final Command COMMAND3 = new Command(3);
    private static final Command COMMAND4 = new Command(4);
    @Mock
    private RegistryChangeListener changeListener;
    private DefaultRegistryImpl<Command> registry;

    @Before
    public void init() {
        this.registry = new DefaultRegistryImpl();
        this.registry.setRegistryChangeListener(this.changeListener);
    }

    @Test
    public void basicTest() {
        this.registry.register((Object)COMMAND1);
        this.registry.register((Object)COMMAND2);
        this.registry.register((Object)COMMAND3);
        this.registry.register((Object)COMMAND4);
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)4))).notifyRegistryChange();
        Assert.assertFalse((boolean)this.registry.isEmpty());
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(4)).containsExactly((Object[])new Command[]{COMMAND4, COMMAND3, COMMAND2, COMMAND1});
        Assertions.assertThat((Object)this.registry.peek()).isSameAs((Object)COMMAND4);
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(4)).containsExactly((Object[])new Command[]{COMMAND4, COMMAND3, COMMAND2, COMMAND1});
        Assertions.assertThat((Object)this.registry.pop()).isSameAs((Object)COMMAND4);
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)5))).notifyRegistryChange();
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(3)).containsExactly((Object[])new Command[]{COMMAND3, COMMAND2, COMMAND1});
        Assert.assertFalse((boolean)this.registry.isEmpty());
        Assertions.assertThat((Object)this.registry.pop()).isSameAs((Object)COMMAND3);
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)6))).notifyRegistryChange();
        Assert.assertFalse((boolean)this.registry.isEmpty());
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(2)).containsExactly((Object[])new Command[]{COMMAND2, COMMAND1});
        this.registry.clear();
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)7))).notifyRegistryChange();
        Assert.assertTrue((boolean)this.registry.isEmpty());
        Assertions.assertThat((List)this.registry.getHistory()).isEmpty();
    }

    @Test
    public void testAddReachingMax() {
        this.registry.setMaxSize(2);
        this.registry.register((Object)COMMAND1);
        this.registry.register((Object)COMMAND2);
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)2))).notifyRegistryChange();
        Assert.assertFalse((boolean)this.registry.isEmpty());
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(2)).containsExactly((Object[])new Command[]{COMMAND2, COMMAND1});
        this.registry.register((Object)COMMAND3);
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)3))).notifyRegistryChange();
        Assert.assertFalse((boolean)this.registry.isEmpty());
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(2)).containsExactly((Object[])new Command[]{COMMAND3, COMMAND2});
        this.registry.register((Object)COMMAND4);
        ((RegistryChangeListener)Mockito.verify((Object)this.changeListener, (VerificationMode)Mockito.times((int)4))).notifyRegistryChange();
        Assert.assertFalse((boolean)this.registry.isEmpty());
        ((ListAssert)Assertions.assertThat((List)this.registry.getHistory()).hasSize(2)).containsExactly((Object[])new Command[]{COMMAND4, COMMAND3});
    }

    @Test
    public void testSettingWrongMax() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.registry.setMaxSize(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("The registry size should be a positive number");
    }

    public static class Command {
        private Integer id;

        public Command(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }
    }
}

