/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.client.context;

import java.util.stream.Stream;

public enum Channel {
    DEFAULT("DEFAULT"),
    ONLINE("ONLINE"),
    VSCODE("VSCODE"),
    GITHUB("GITHUB"),
    DESKTOP("DESKTOP"),
    EMBEDDED("EMBEDDED");

    private final String name;

    private Channel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Channel withName(String name) {
        return Stream.of(Channel.values()).filter(channel -> channel.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Name not recognized: " + name));
    }
}

