/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.client.context;

import java.util.stream.Stream;

public enum OperatingSystem {
    DEFAULT("DEFAULT"),
    MACOS("MACOS"),
    LINUX("LINUX"),
    WINDOWS("WINDOWS");

    private final String name;

    private OperatingSystem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static OperatingSystem withName(String name) {
        return Stream.of(OperatingSystem.values()).filter(os -> os.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Name not recognized: " + name));
    }
}

