/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.loading;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.jsbridge.client.loading.AppFormerComponentsRegistry;
import org.uberfire.jsbridge.client.loading.JsWorkbenchLazyPerspectiveActivity;
import org.uberfire.jsbridge.client.perspective.JsWorkbenchPerspectiveActivity;
import org.uberfire.mvp.PlaceRequest;

public class JsWorkbenchLazyPerspectiveActivityTest {
    private JsWorkbenchLazyPerspectiveActivity jsWorkbenchLazyPerspectiveActivity;
    private PlaceManager placeManager;
    private AppFormerComponentsRegistry.Entry entry;
    private ActivityManager activityManager;
    private Consumer<String> lazyLoadingParentScript;

    @Before
    public void before() {
        this.placeManager = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.entry = (AppFormerComponentsRegistry.Entry)Mockito.mock(AppFormerComponentsRegistry.Entry.class);
        this.activityManager = (ActivityManager)Mockito.mock(ActivityManager.class);
        this.lazyLoadingParentScript = s -> {};
        this.jsWorkbenchLazyPerspectiveActivity = (JsWorkbenchLazyPerspectiveActivity)Mockito.spy((Object)new JsWorkbenchLazyPerspectiveActivity(this.entry, this.placeManager, this.activityManager, this.lazyLoadingParentScript));
    }

    @Test
    public void getNotLoaded() {
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn(Mockito.mock(JsWorkbenchPerspectiveActivity.class));
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)false);
        Assert.assertEquals((Object)this.jsWorkbenchLazyPerspectiveActivity, (Object)this.jsWorkbenchLazyPerspectiveActivity.get());
    }

    @Test
    public void getLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)true);
        Assert.assertEquals((Object)backedPerspective, (Object)this.jsWorkbenchLazyPerspectiveActivity.get());
    }

    @Test
    public void onStartupLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)true);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup(placeRequest);
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective)).onStartup(placeRequest);
    }

    @Test
    public void onStartupNotLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)false);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup(placeRequest);
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective, (VerificationMode)Mockito.never())).onStartup(placeRequest);
    }

    @Test
    public void onOpenLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)true);
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective)).onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).executeOnOpenCallbacks((PlaceRequest)Matchers.any());
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.verify((Object)this.jsWorkbenchLazyPerspectiveActivity, (VerificationMode)Mockito.never())).onLoaded();
    }

    @Test
    public void onOpenNotLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)false);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective, (VerificationMode)Mockito.never())).onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)2))).executeOnOpenCallbacks((PlaceRequest)Matchers.any());
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.verify((Object)this.jsWorkbenchLazyPerspectiveActivity)).onLoaded();
    }

    @Test
    public void onCloseLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)true);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onClose();
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective)).onClose();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).executeOnCloseCallbacks((PlaceRequest)Matchers.any());
    }

    @Test
    public void onCloseNotLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)false);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        this.jsWorkbenchLazyPerspectiveActivity.onClose();
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective, (VerificationMode)Mockito.never())).onClose();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)2))).executeOnCloseCallbacks((PlaceRequest)Matchers.any());
    }

    @Test
    public void onShutdownLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)true);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        this.jsWorkbenchLazyPerspectiveActivity.onShutdown();
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective)).onShutdown();
    }

    @Test
    public void onShutdownNotLoaded() {
        JsWorkbenchPerspectiveActivity backedPerspective = (JsWorkbenchPerspectiveActivity)Mockito.mock(JsWorkbenchPerspectiveActivity.class);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.getBackedPerspective()).thenReturn((Object)backedPerspective);
        Mockito.when((Object)this.jsWorkbenchLazyPerspectiveActivity.isPerspectiveLoaded()).thenReturn((Object)false);
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        this.jsWorkbenchLazyPerspectiveActivity.onClose();
        this.jsWorkbenchLazyPerspectiveActivity.onShutdown();
        ((JsWorkbenchPerspectiveActivity)Mockito.verify((Object)backedPerspective, (VerificationMode)Mockito.never())).onShutdown();
    }

    @Test
    public void updateRealContent() {
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.doReturn((Object)perspectiveActivity).when((Object)this.jsWorkbenchLazyPerspectiveActivity)).getBackedPerspective((JavaScriptObject)Matchers.any());
        ((ActivityManager)Mockito.doReturn((Object)true).when((Object)this.activityManager)).isStarted((Activity)Matchers.any());
        this.jsWorkbenchLazyPerspectiveActivity.updateRealContent((JavaScriptObject)Mockito.mock(JavaScriptObject.class));
        Assert.assertEquals((Object)perspectiveActivity, (Object)this.jsWorkbenchLazyPerspectiveActivity.backedPerspective);
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity)).onStartup((PlaceRequest)Matchers.any());
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity)).onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Matchers.any());
    }

    @Test
    public void updateRealContent_notStarted() {
        this.jsWorkbenchLazyPerspectiveActivity.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.jsWorkbenchLazyPerspectiveActivity.onOpen();
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.doReturn((Object)perspectiveActivity).when((Object)this.jsWorkbenchLazyPerspectiveActivity)).getBackedPerspective((JavaScriptObject)Matchers.any());
        ((ActivityManager)Mockito.doReturn((Object)false).when((Object)this.activityManager)).isStarted((Activity)Matchers.any());
        this.jsWorkbenchLazyPerspectiveActivity.updateRealContent((JavaScriptObject)Mockito.mock(JavaScriptObject.class));
        Assert.assertEquals((Object)perspectiveActivity, (Object)this.jsWorkbenchLazyPerspectiveActivity.backedPerspective);
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any());
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity)).onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Matchers.any());
    }

    @Test
    public void updateRealContent_notOpen() {
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.doReturn((Object)perspectiveActivity).when((Object)this.jsWorkbenchLazyPerspectiveActivity)).getBackedPerspective((JavaScriptObject)Matchers.any());
        ((ActivityManager)Mockito.doReturn((Object)false).when((Object)this.activityManager)).isStarted((Activity)Matchers.any());
        this.jsWorkbenchLazyPerspectiveActivity.updateRealContent((JavaScriptObject)Mockito.mock(JavaScriptObject.class));
        Assert.assertEquals((Object)perspectiveActivity, (Object)this.jsWorkbenchLazyPerspectiveActivity.backedPerspective);
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any());
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity, (VerificationMode)Mockito.never())).onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Matchers.any());
    }
}

