/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.perspective;

import elemental2.dom.Attr;
import elemental2.dom.DomGlobal;
import elemental2.dom.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jsinterop.base.Js;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.TemplatedActivity;
import org.uberfire.client.workbench.panels.impl.TemplatedWorkbenchPanelPresenter;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativePerspective;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.ResourceType;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.NamedPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;

public class JsWorkbenchTemplatedPerspectiveActivity
extends AbstractWorkbenchPerspectiveActivity
implements TemplatedActivity {
    private static final String UF_PERSPECTIVE_COMPONENT = "uf-perspective-component";
    private static final String UF_PERSPECTIVE_CONTAINER = "uf-perspective-container";
    private static final String STARTUP_PARAM_ATTR = "data-startup-";
    private final String componentId;
    private final boolean isDefault;
    private final elemental2.dom.HTMLElement container;
    private final JsNativePerspective realPerspective;
    private Map<String, elemental2.dom.HTMLElement> componentContainersById;

    public JsWorkbenchTemplatedPerspectiveActivity(String componentId, boolean isDefault, JsNativePerspective realPerspective, PlaceManager placeManager) {
        super(placeManager);
        this.componentId = componentId;
        this.isDefault = isDefault;
        this.realPerspective = realPerspective;
        this.container = (elemental2.dom.HTMLElement)DomGlobal.document.createElement("div");
        this.container.classList.add(new String[]{UF_PERSPECTIVE_CONTAINER});
        this.componentContainersById = new HashMap<String, elemental2.dom.HTMLElement>();
    }

    public void onStartup(PlaceRequest place) {
        this.place = place;
        super.onStartup(place);
        this.realPerspective.onStartup();
    }

    public void onOpen() {
        super.onOpen();
        this.realPerspective.renderNative(this.container);
        this.componentContainersById = this.loadTemplateComponents(this.container);
        this.realPerspective.onOpen();
        this.placeManager.executeOnOpenCallbacks(this.place);
    }

    public void onClose() {
        super.onClose();
        this.realPerspective.onClose(this.container);
        this.placeManager.executeOnCloseCallbacks(this.place);
    }

    public void onShutdown() {
        super.onShutdown();
        this.realPerspective.onShutdown();
    }

    public ResourceType getResourceType() {
        return ActivityResourceType.PERSPECTIVE;
    }

    public String getIdentifier() {
        return this.componentId;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isTransient() {
        return this.realPerspective.isTransient();
    }

    public void getMenus(Consumer<Menus> consumer) {
        consumer.accept(this.realPerspective.menus());
    }

    public ToolBar getToolBar() {
        return this.realPerspective.toolbar();
    }

    public PerspectiveDefinition getDefaultPerspectiveLayout() {
        PerspectiveDefinitionImpl perspectiveDefinition = new PerspectiveDefinitionImpl(TemplatedWorkbenchPanelPresenter.class.getName());
        perspectiveDefinition.setName(this.realPerspective.name());
        this.componentContainersById.forEach((arg_0, arg_1) -> this.lambda$getDefaultPerspectiveLayout$0((PerspectiveDefinition)perspectiveDefinition, arg_0, arg_1));
        return perspectiveDefinition;
    }

    public HTMLElement resolvePosition(NamedPosition namedPosition) {
        String fieldName = namedPosition.getName();
        elemental2.dom.HTMLElement element = this.componentContainersById.get(fieldName);
        return element == null ? null : (HTMLElement)Js.cast((Object)element);
    }

    public HTMLElement getRootElement() {
        return (HTMLElement)Js.cast((Object)this.container);
    }

    private Map<String, elemental2.dom.HTMLElement> loadTemplateComponents(elemental2.dom.HTMLElement container) {
        Map<String, elemental2.dom.HTMLElement> templateComponents = this.realPerspective.getContainerComponents(container).stream().collect(Collectors.toMap(e -> e.getAttribute("af-js-component"), e -> e));
        templateComponents.values().forEach(component -> this.recursivelyMarkComponentContainers((Node)container, (Node)component));
        return templateComponents;
    }

    private void recursivelyMarkComponentContainers(Node root, Node leaf) {
        if (!(leaf instanceof elemental2.dom.HTMLElement)) {
            return;
        }
        if (leaf == root) {
            return;
        }
        elemental2.dom.HTMLElement htmlElement = (elemental2.dom.HTMLElement)leaf;
        if (!htmlElement.classList.contains(UF_PERSPECTIVE_COMPONENT)) {
            htmlElement.classList.add(new String[]{UF_PERSPECTIVE_COMPONENT});
        }
        this.recursivelyMarkComponentContainers(root, leaf.parentNode);
    }

    private Map<String, String> retrieveStartUpParams(elemental2.dom.HTMLElement component) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < component.attributes.length; ++i) {
            String key;
            Attr attr = (Attr)component.attributes.getAt(i);
            if (!attr.name.startsWith(STARTUP_PARAM_ATTR) || (key = attr.name.replaceFirst(STARTUP_PARAM_ATTR, "")).length() <= 0) continue;
            params.put(key, attr.value);
        }
        return params;
    }

    private /* synthetic */ void lambda$getDefaultPerspectiveLayout$0(PerspectiveDefinition perspectiveDefinition, String key, elemental2.dom.HTMLElement value) {
        Map<String, String> placeParams = this.retrieveStartUpParams(value);
        PanelDefinitionImpl panelDefinition = new PanelDefinitionImpl("PARENT_CHOOSES_TYPE");
        panelDefinition.addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(key, placeParams)));
        perspectiveDefinition.getRoot().appendChild((Position)new NamedPosition(key), (PanelDefinition)panelDefinition);
    }
}

