/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.context;

import java.util.stream.Stream;

public enum KogitoChannel {
    DEFAULT("DEFAULT"),
    ONLINE("ONLINE"),
    VSCODE("VSCODE"),
    GITHUB("GITHUB"),
    DESKTOP("DESKTOP");

    private final String name;

    private KogitoChannel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static KogitoChannel withName(String name) {
        return Stream.of(KogitoChannel.values()).filter(channel -> channel.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Name not recognized: " + name));
    }
}

