/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.stateControl.registry.producer;

import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import org.appformer.client.stateControl.registry.Registry;
import org.appformer.client.stateControl.registry.impl.DefaultRegistryImpl;
import org.appformer.kogito.bridge.client.interop.WindowRef;
import org.appformer.kogito.bridge.client.stateControl.registry.impl.KogitoCommandRegistry;

public class CommandRegistryProducer {
    private final Supplier<Boolean> envelopeEnabledSupplier;
    private final Supplier<KogitoCommandRegistry<?>> kogitoCommandRegistrySupplier;

    public CommandRegistryProducer() {
        this(WindowRef::isEnvelopeAvailable, KogitoCommandRegistry::new);
    }

    CommandRegistryProducer(Supplier<Boolean> envelopeEnabledSupplier, Supplier<KogitoCommandRegistry<?>> kogitoCommandRegistrySupplier) {
        this.envelopeEnabledSupplier = envelopeEnabledSupplier;
        this.kogitoCommandRegistrySupplier = kogitoCommandRegistrySupplier;
    }

    @Produces
    @Dependent
    public Registry lookup() {
        if (this.isEnvelopeEnabled()) {
            return this.kogitoCommandRegistrySupplier.get();
        }
        return new DefaultRegistryImpl();
    }

    boolean isEnvelopeEnabled() {
        return this.envelopeEnabledSupplier.get();
    }
}

