/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour.observers;

import elemental2.dom.DomGlobal;
import elemental2.dom.Event;
import elemental2.dom.EventListener;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.NamedNodeMap;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;

public class GlobalHTMLObserver
extends GuidedTourObserver<GlobalHTMLObserver> {
    final EventListener CLICK_LISTENER = this::onHTMLElementEvent;

    @Inject
    public GlobalHTMLObserver(Disposer<GlobalHTMLObserver> selfDisposer) {
        super(selfDisposer);
    }

    @PostConstruct
    public void init() {
        this.addGlobalEventListener("click", this.CLICK_LISTENER);
    }

    @Override
    protected void dispose() {
        this.removeGlobalEventListener("click", this.CLICK_LISTENER);
        super.dispose();
    }

    void onHTMLElementEvent(Event event) {
        this.getMonitorBridge().ifPresent(bridge -> bridge.refresh(this.getUserInteraction(event)));
    }

    private UserInteraction getUserInteraction(Event event) {
        String action = "click".toUpperCase();
        String selector = this.getSelector(this.getTarget(event));
        return this.makeUserInteraction(action, selector);
    }

    private String getSelector(HTMLElement element) {
        String tag = element.tagName.toLowerCase();
        String id = element.id != null && !element.id.isEmpty() ? "#" + element.id : "";
        String dataAttributes = this.getDataAttributes(element);
        String className = element.classList.length > 0 ? "." + String.join((CharSequence)".", element.classList.asList()) : "";
        return tag + dataAttributes + id + className;
    }

    public String getDataAttributes(HTMLElement element) {
        NamedNodeMap attributes = element.attributes;
        ArrayList<String> dataAttributes = new ArrayList<String>();
        int objectsSize = attributes.length;
        for (int i = 0; i < objectsSize; ++i) {
            String nodeName = attributes.item((int)i).nodeName;
            String nodeValue = attributes.item((int)i).nodeValue;
            if (!nodeName.startsWith("data-")) continue;
            dataAttributes.add("[" + nodeName + "=\"" + nodeValue + "\"]");
        }
        return String.join((CharSequence)"", dataAttributes);
    }

    private HTMLElement getTarget(Event e) {
        return (HTMLElement)e.target;
    }

    private void addGlobalEventListener(String type, EventListener eventListener) {
        this.document().addEventListener(type, eventListener);
    }

    private void removeGlobalEventListener(String type, EventListener eventListener) {
        this.document().removeEventListener(type, eventListener);
    }

    UserInteraction makeUserInteraction(String action, String target) {
        UserInteraction userInteraction = new UserInteraction();
        userInteraction.setAction(action);
        userInteraction.setTarget(target);
        return userInteraction;
    }

    HTMLDocument document() {
        return DomGlobal.document;
    }
}

