/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.stateControl.registry.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.appformer.client.stateControl.registry.Registry;
import org.appformer.client.stateControl.registry.RegistryChangeListener;
import org.appformer.kogito.bridge.client.interop.WindowRef;
import org.appformer.kogito.bridge.client.stateControl.interop.StateControl;
import org.appformer.kogito.bridge.client.stateControl.registry.interop.KogitoJSCommandRegistry;

public class KogitoCommandRegistry<C>
implements Registry<C> {
    private KogitoJSCommandRegistry<C> wrapped;
    private RegistryChangeListener registryChangeListener;

    public KogitoCommandRegistry() {
        this(WindowRef::isEnvelopeAvailable, () -> StateControl.get().getCommandRegistry());
    }

    KogitoCommandRegistry(Supplier<Boolean> envelopeEnabledSupplier, Supplier<KogitoJSCommandRegistry<C>> kogitoJSCommandRegistrySupplier) {
        if (!envelopeEnabledSupplier.get().booleanValue()) {
            throw new RuntimeException("Envelope isn't present, we shouldn't be here!");
        }
        this.wrapped = kogitoJSCommandRegistrySupplier.get();
    }

    public void register(C item) {
        this.wrapped.register(String.valueOf(item.hashCode()), item);
        this.notifyRegistryChange();
    }

    public C peek() {
        return this.wrapped.peek();
    }

    public C pop() {
        Optional<C> optional = Optional.ofNullable(this.wrapped.pop());
        if (optional.isPresent()) {
            this.notifyRegistryChange();
        }
        return optional.orElse(null);
    }

    public List<C> getHistory() {
        return Stream.of(this.wrapped.getCommands()).collect(Collectors.toList());
    }

    public void setMaxSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The registry size should be a positive number");
        }
        this.wrapped.setMaxSize(size);
    }

    public void clear() {
        this.wrapped.clear();
        this.notifyRegistryChange();
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public void setRegistryChangeListener(RegistryChangeListener registryChangeListener) {
        this.registryChangeListener = registryChangeListener;
    }

    private void notifyRegistryChange() {
        if (this.registryChangeListener != null) {
            this.registryChangeListener.notifyRegistryChange();
        }
    }
}

