/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.backend.vfs.impl.DirectoryStreamImpl;
import org.uberfire.backend.vfs.impl.FileSystemImpl;
import org.uberfire.backend.vfs.impl.PathImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.file.attribute.UserPrincipal;

@Service
@ApplicationScoped
public class VFSServicesServerImpl
implements VFSService {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public org.uberfire.backend.vfs.Path get(String first, String ... more) throws IllegalArgumentException {
        return this.convert(Paths.get((String)first, (String[])more));
    }

    public org.uberfire.backend.vfs.Path get(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException {
        return this.convert(Paths.get((URI)URI.create(path.toURI())));
    }

    public FileSystem newFileSystem(org.uberfire.backend.vfs.Path path, Map<String, Object> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException {
        return this.newFileSystem(path.toURI(), env);
    }

    public FileSystem newFileSystem(String uri, Map<String, Object> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException {
        URI furi = URI.create(uri);
        org.uberfire.java.nio.file.FileSystem newFileSystem = FileSystems.newFileSystem((URI)furi, env);
        return new FileSystemImpl(Arrays.asList(new PathImpl(furi.getPath(), uri)));
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir) throws IllegalArgumentException, NotDirectoryException, IOException {
        Iterator content = Files.newDirectoryStream((Path)this.fromPath(dir)).iterator();
        return this.newDirectoryStream(content);
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir, String glob) throws IllegalArgumentException, UnsupportedOperationException, PatternSyntaxException, NotDirectoryException, IOException {
        return null;
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir, DirectoryStream.Filter<? super org.uberfire.backend.vfs.Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createFile(org.uberfire.backend.vfs.Path path, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createDirectory(org.uberfire.backend.vfs.Path dir, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createDirectories(org.uberfire.backend.vfs.Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createSymbolicLink(org.uberfire.backend.vfs.Path link, org.uberfire.backend.vfs.Path target, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createLink(org.uberfire.backend.vfs.Path link, org.uberfire.backend.vfs.Path existing) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException {
        return null;
    }

    public void delete(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException {
    }

    public boolean deleteIfExists(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, DirectoryNotEmptyException, IOException {
        return false;
    }

    public org.uberfire.backend.vfs.Path createTempFile(org.uberfire.backend.vfs.Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createTempDirectory(org.uberfire.backend.vfs.Path dir, String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path move(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path readSymbolicLink(org.uberfire.backend.vfs.Path link) throws IllegalArgumentException, UnsupportedOperationException, NotLinkException, IOException {
        return null;
    }

    public String probeContentType(org.uberfire.backend.vfs.Path path) throws UnsupportedOperationException, IOException {
        return null;
    }

    public Map<String, Object> readAttributes(org.uberfire.backend.vfs.Path path) throws UnsupportedOperationException, IllegalArgumentException, IOException {
        return Files.readAttributes((Path)this.fromPath(path), (String)"*", null);
    }

    public org.uberfire.backend.vfs.Path setAttribute(org.uberfire.backend.vfs.Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException {
        return null;
    }

    public Object getAttribute(org.uberfire.backend.vfs.Path path, String attribute, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException {
        return null;
    }

    public UserPrincipal getOwner(org.uberfire.backend.vfs.Path path, LinkOption ... options) throws UnsupportedOperationException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path setOwner(org.uberfire.backend.vfs.Path path, UserPrincipal owner) throws UnsupportedOperationException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path setLastModifiedTime(org.uberfire.backend.vfs.Path path, FileTime time) throws IOException {
        return null;
    }

    public long size(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException {
        return 0L;
    }

    public boolean exists(org.uberfire.backend.vfs.Path path, LinkOption ... options) throws IllegalArgumentException {
        return Files.exists((Path)this.fromPath(path), (LinkOption[])options);
    }

    public boolean notExists(org.uberfire.backend.vfs.Path path, LinkOption ... options) throws IllegalArgumentException {
        return Files.notExists((Path)this.fromPath(path), (LinkOption[])options);
    }

    public boolean isSameFile(org.uberfire.backend.vfs.Path path, org.uberfire.backend.vfs.Path path2) throws IllegalArgumentException, IOException {
        return false;
    }

    public boolean isExecutable(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException {
        return false;
    }

    public byte[] readAllBytes(org.uberfire.backend.vfs.Path path) throws IOException {
        return new byte[0];
    }

    public String readAllString(org.uberfire.backend.vfs.Path path, String charset) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.readAllString(path, Charset.forName(charset));
    }

    public String readAllString(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.readAllString(path, UTF_8);
    }

    private String readAllString(org.uberfire.backend.vfs.Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException {
        List result = Files.readAllLines((Path)this.fromPath(path), (Charset)cs);
        if (result == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : result) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    public List<String> readAllLines(org.uberfire.backend.vfs.Path path, String charset) throws IllegalArgumentException, NoSuchFileException, IOException {
        return null;
    }

    public List<String> readAllLines(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        return null;
    }

    public org.uberfire.backend.vfs.Path write(org.uberfire.backend.vfs.Path path, String content) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.convert(Files.write((Path)this.fromPath(path), (byte[])content.getBytes(), (OpenOption[])new OpenOption[0]));
    }

    private org.uberfire.backend.vfs.Path convert(Path path) {
        Map attributes = Files.readAttributes((Path)path, (String)"*", (LinkOption[])new LinkOption[0]);
        return new PathImpl(path.getFileName().toString(), path.toUri().toString(), attributes);
    }

    private DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(Iterator<Path> iterator) {
        LinkedList<org.uberfire.backend.vfs.Path> content = new LinkedList<org.uberfire.backend.vfs.Path>();
        while (iterator.hasNext()) {
            content.add(this.convert(iterator.next()));
        }
        return new DirectoryStreamImpl(content);
    }

    private Path fromPath(org.uberfire.backend.vfs.Path path) {
        try {
            return Paths.get((URI)URI.create(path.toURI()));
        }
        catch (IllegalArgumentException e) {
            try {
                return Paths.get((URI)URI.create(URIUtil.encodePath((String)path.toURI())));
            }
            catch (URIException ex) {
                return null;
            }
        }
    }
}

