/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.authz;

import java.util.List;
import org.uberfire.commons.util.PreconditionsServer;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.ResourceDecisionManager;
import org.uberfire.security.authz.RoleDecisionManager;
import org.uberfire.security.authz.RolesResource;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.ConsensusBasedVoter;
import org.uberfire.security.impl.authz.RolesResourceImpl;
import org.uberfire.security.server.URLResource;
import org.uberfire.security.server.URLResourceManager;

public class URLAccessDecisionManager
implements ResourceDecisionManager {
    private static final VotingStrategy DEFAULT_VOTER = new ConsensusBasedVoter();
    private final URLResourceManager resourceManager;

    public URLAccessDecisionManager(ResourceManager resourceManager) {
        this.resourceManager = (URLResourceManager)PreconditionsServer.checkInstanceOf((String)"resourceManager", (Object)resourceManager, URLResourceManager.class);
    }

    public boolean supports(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource instanceof URLResource;
    }

    public AuthorizationResult decide(Resource resource, Subject subject, RoleDecisionManager roleDecisionManager) {
        URLResource urlResource = (URLResource)PreconditionsServer.checkInstanceOf((String)"resource", (Object)resource, URLResource.class);
        List<Role> roles = this.resourceManager.getMandatoryRoles(urlResource);
        if (roles == null || roles.isEmpty()) {
            return AuthorizationResult.ACCESS_ABSTAIN;
        }
        return DEFAULT_VOTER.vote(roleDecisionManager.decide((RolesResource)new RolesResourceImpl(roles), subject));
    }
}

