/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.workbench.model;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

public class TestWorkbenchModel {
    @Test
    public void testPanelHierarchyInsert() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl("what.ever.panel.PresenterClass");
        perspective.setName("perspective");
        PanelDefinitionImpl westPanel = new PanelDefinitionImpl("what.ever.panel.PresenterClass");
        PanelDefinitionImpl eastPanel = new PanelDefinitionImpl("what.ever.panel.PresenterClass");
        PartDefinitionImpl part1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("one"));
        PartDefinitionImpl part2 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("two"));
        perspective.getRoot().insertChild((Position)CompassPosition.WEST, (PanelDefinition)westPanel);
        perspective.getRoot().insertChild((Position)CompassPosition.EAST, (PanelDefinition)eastPanel);
        westPanel.addPart((PartDefinition)part1);
        eastPanel.addPart((PartDefinition)part2);
        Assert.assertTrue((part1.getParentPanel() == westPanel ? 1 : 0) != 0);
        Assert.assertTrue((westPanel.getParent() == perspective.getRoot() ? 1 : 0) != 0);
        Assert.assertTrue((part2.getParentPanel() == eastPanel ? 1 : 0) != 0);
        Assert.assertTrue((eastPanel.getParent() == perspective.getRoot() ? 1 : 0) != 0);
        Assert.assertTrue((perspective.getRoot().getParent() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPanelHierarchyAppend() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl("what.ever.panel.PresenterClass");
        perspective.setName("perspective");
        PanelDefinitionImpl westPanel = new PanelDefinitionImpl("what.ever.panel.PresenterClass");
        PanelDefinitionImpl eastPanel = new PanelDefinitionImpl("what.ever.panel.PresenterClass");
        PartDefinitionImpl part1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("one"));
        PartDefinitionImpl part2 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("two"));
        perspective.getRoot().appendChild((Position)CompassPosition.WEST, (PanelDefinition)westPanel);
        perspective.getRoot().appendChild((Position)CompassPosition.EAST, (PanelDefinition)eastPanel);
        westPanel.addPart((PartDefinition)part1);
        eastPanel.addPart((PartDefinition)part2);
        Assert.assertTrue((part1.getParentPanel() == westPanel ? 1 : 0) != 0);
        Assert.assertTrue((westPanel.getParent() == perspective.getRoot() ? 1 : 0) != 0);
        Assert.assertTrue((part2.getParentPanel() == eastPanel ? 1 : 0) != 0);
        Assert.assertTrue((eastPanel.getParent() == perspective.getRoot() ? 1 : 0) != 0);
        Assert.assertTrue((perspective.getRoot().getParent() == null ? 1 : 0) != 0);
    }

    @Test(expected=IllegalStateException.class)
    public void testDetachedPanels() {
        PanelDefinitionImpl westPanel = new PanelDefinitionImpl("what.ever.panel.PresenterClass");
        PartDefinitionImpl part1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("one"));
        westPanel.addPart((PartDefinition)part1);
        Assert.assertTrue((part1.getParentPanel() == westPanel ? 1 : 0) != 0);
        westPanel.getParent();
    }
}

