/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.vfs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceCopied;
import org.uberfire.workbench.events.ResourceCopiedEvent;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamed;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdated;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ObservablePathImplTest {
    @Spy
    @InjectMocks
    private ObservablePathImpl observablePathImpl;
    @Mock
    private PathPlaceRequest pathPlaceRequest;
    @Mock
    private Path destinationPath;
    @Mock
    private ParameterizedCommand<ObservablePath.OnConcurrentDelete> onDelete;
    @Mock
    private ParameterizedCommand<ObservablePath.OnConcurrentUpdateEvent> onUpdate;
    @Mock
    private ParameterizedCommand<ObservablePath.OnConcurrentRenameEvent> onRename;
    @Mock
    private ParameterizedCommand<ObservablePath.OnConcurrentCopyEvent> onCopy;
    private static final User identityUser = new UserImpl("userName");
    private static final String MESSAGE = "test message";
    private static final String ASSET_PATH = "default://project/package/Asset.java";
    private static final String OBSERVE_SESSION_ID = "observeSession";
    private static final String RESOURCE_SESSION_ID = "resourceSession";

    @Before
    public void setup() {
        this.observablePathImpl.onConcurrentDelete(this.onDelete);
        this.observablePathImpl.onConcurrentUpdate(this.onUpdate);
        this.observablePathImpl.onConcurrentRename(this.onRename);
        this.observablePathImpl.onConcurrentCopy(this.onCopy);
        this.observablePathImpl.sessionInfo = new SessionInfoImpl(OBSERVE_SESSION_ID, identityUser);
    }

    @Test
    public void testResourceDeleteEvent() {
        ((PathPlaceRequest)Mockito.doReturn((Object)this.createPath()).when((Object)this.pathPlaceRequest)).getPath();
        this.observablePathImpl.onResourceDeleted(new ResourceDeletedEvent((Path)this.pathPlaceRequest.getPath(), MESSAGE, (SessionInfo)this.createSessionInfo()));
        ((ParameterizedCommand)Mockito.verify(this.onDelete)).execute(ArgumentMatchers.any());
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentDeleteCommand((Path)this.pathPlaceRequest.getPath(), RESOURCE_SESSION_ID, identityUser);
    }

    @Test
    public void testResourceUpdateEvent() {
        ((PathPlaceRequest)Mockito.doReturn((Object)this.createPath()).when((Object)this.pathPlaceRequest)).getPath();
        this.observablePathImpl.onResourceUpdated(new ResourceUpdatedEvent((Path)this.pathPlaceRequest.getPath(), MESSAGE, (SessionInfo)this.createSessionInfo()));
        ((ParameterizedCommand)Mockito.verify(this.onUpdate)).execute(ArgumentMatchers.any());
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentUpdateCommand((Path)this.pathPlaceRequest.getPath(), RESOURCE_SESSION_ID, identityUser);
    }

    @Test
    public void testResourceRenameEvent() {
        ((PathPlaceRequest)Mockito.doReturn((Object)this.createPath()).when((Object)this.pathPlaceRequest)).getPath();
        this.observablePathImpl.onResourceRenamed(new ResourceRenamedEvent((Path)this.pathPlaceRequest.getPath(), this.destinationPath, MESSAGE, (SessionInfo)this.createSessionInfo()));
        ((ParameterizedCommand)Mockito.verify(this.onRename)).execute(ArgumentMatchers.any());
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentRenameCommand((Path)this.pathPlaceRequest.getPath(), this.destinationPath, RESOURCE_SESSION_ID, identityUser);
    }

    @Test
    public void testResourceCopyEvent() {
        ((PathPlaceRequest)Mockito.doReturn((Object)this.createPath()).when((Object)this.pathPlaceRequest)).getPath();
        this.observablePathImpl.onResourceCopied(new ResourceCopiedEvent((Path)this.pathPlaceRequest.getPath(), this.destinationPath, MESSAGE, (SessionInfo)this.createSessionInfo()));
        ((ParameterizedCommand)Mockito.verify(this.onCopy)).execute(ArgumentMatchers.any());
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentCopyCommand((Path)this.pathPlaceRequest.getPath(), this.destinationPath, RESOURCE_SESSION_ID, identityUser);
    }

    @Test
    public void testResourceBatchEvent() {
        ((PathPlaceRequest)Mockito.doReturn((Object)this.createPath()).when((Object)this.pathPlaceRequest)).getPath();
        ObservablePath path = this.pathPlaceRequest.getPath();
        HashMap<Path, Collection<ResourceChange>> batchEvents = new HashMap<Path, Collection<ResourceChange>>((Path)path){
            final /* synthetic */ Path val$path;
            {
                this.val$path = path;
                this.put(this.val$path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceCopied(ObservablePathImplTest.this.destinationPath, "copied event"));
                        this.add(new ResourceDeleted("deleted event"));
                        this.add(new ResourceRenamed(ObservablePathImplTest.this.destinationPath, "renamed event"));
                        this.add(new ResourceUpdated("updated event"));
                    }
                });
            }
        };
        this.observablePathImpl.onResourceBatchEvent(new ResourceBatchChangesEvent((Map)batchEvents, MESSAGE, (SessionInfo)this.createSessionInfo()));
        ((ParameterizedCommand)Mockito.verify(this.onCopy)).execute(ArgumentMatchers.any());
        ((ParameterizedCommand)Mockito.verify(this.onDelete)).execute(ArgumentMatchers.any());
        ((ParameterizedCommand)Mockito.verify(this.onRename)).execute(ArgumentMatchers.any());
        ((ParameterizedCommand)Mockito.verify(this.onUpdate)).execute(ArgumentMatchers.any());
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentCopyCommand((Path)this.pathPlaceRequest.getPath(), this.destinationPath, RESOURCE_SESSION_ID, identityUser);
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentDeleteCommand((Path)this.pathPlaceRequest.getPath(), RESOURCE_SESSION_ID, identityUser);
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentRenameCommand((Path)this.pathPlaceRequest.getPath(), this.destinationPath, RESOURCE_SESSION_ID, identityUser);
        ((ObservablePathImpl)Mockito.verify((Object)this.observablePathImpl)).executeConcurrentUpdateCommand(this.destinationPath, RESOURCE_SESSION_ID, identityUser);
    }

    private ObservablePath createPath() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        this.observablePathImpl.wrap((Path)path);
        return path;
    }

    private SessionInfoImpl createSessionInfo() {
        return new SessionInfoImpl(RESOURCE_SESSION_ID, identityUser);
    }
}

