/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.api;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.api.DirectoryBreadCrumb;

public class DirectoryBreadCrumbTest {
    private static final String TOP_DIR_NAME = "top";
    private static final String MIDDLE_DIR_NAME = "middle";
    private static final String LOW_DIR_NAME = "low";
    private static final String OTHER_DIR_NAME = "other";

    @Test
    public void breadCrumbsOrderTest() {
        Directory topDir = new Directory(TOP_DIR_NAME, "", "", new HashMap());
        Directory middleDir = new Directory(MIDDLE_DIR_NAME, "", "", topDir);
        Directory lowDir = new Directory(LOW_DIR_NAME, "", "", middleDir);
        Directory otherDir = new Directory(OTHER_DIR_NAME, "", "", topDir);
        this.assertDirectoryBreadCrumbs(topDir, TOP_DIR_NAME);
        this.assertDirectoryBreadCrumbs(middleDir, TOP_DIR_NAME, MIDDLE_DIR_NAME);
        this.assertDirectoryBreadCrumbs(lowDir, TOP_DIR_NAME, MIDDLE_DIR_NAME, LOW_DIR_NAME);
        this.assertDirectoryBreadCrumbs(otherDir, TOP_DIR_NAME, OTHER_DIR_NAME);
    }

    private void assertDirectoryBreadCrumbs(Directory workingDir, String ... expectedNames) {
        List breadCrumbs = DirectoryBreadCrumb.getBreadCrumbs((Directory)workingDir);
        int breadCrumbsSize = breadCrumbs.size();
        Assert.assertEquals((long)expectedNames.length, (long)breadCrumbsSize);
        for (int i = 0; i < breadCrumbsSize; ++i) {
            Assert.assertEquals((Object)expectedNames[i], (Object)((DirectoryBreadCrumb)breadCrumbs.get(i)).getName());
        }
    }
}

