/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.client.home.components.popup;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.client.home.components.popup.DirectoryNameValidator;

public class DirectoryNameValidatorTest {
    private DirectoryNameValidator directoryNameValidator;

    @Before
    public void setUp() throws Exception {
        this.directoryNameValidator = new DirectoryNameValidator(new Directory());
    }

    @Test
    public void isValidTest() throws Exception {
        Assert.assertTrue((boolean)this.directoryNameValidator.isValid("app"));
        Assert.assertTrue((boolean)this.directoryNameValidator.isValid("my app"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid(""));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid(" "));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("app\\"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("app/"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("app:"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("*app"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("a<pp"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("app>"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("ap|p"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("ap*p"));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("ap?p"));
    }

    @Test
    public void isValidTestDuplicatedDir() throws Exception {
        Directory currentDirectory = new Directory("parent", "", "", new HashMap());
        this.directoryNameValidator = new DirectoryNameValidator(currentDirectory);
        Assert.assertTrue((boolean)this.directoryNameValidator.isValid("app"));
        currentDirectory.addChildDirectory(new Directory("app", "", "", currentDirectory));
        Assert.assertFalse((boolean)this.directoryNameValidator.isValid("app"));
    }
}

