/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.client.home.components.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.client.home.components.popup.DirectoryNameValidator;
import org.uberfire.ext.apps.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;
import org.uberfire.mvp.ParameterizedCommand;

public class NewDirectoryPopup
extends BaseModal {
    private ParameterizedCommand clickCommand;
    @UiField
    FormGroup directoryNameControlGroup;
    @UiField
    TextBox directoryName;
    @UiField
    HelpBlock directoryNameInline;
    private DirectoryNameValidator directoryNameValidator;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public NewDirectoryPopup(Directory currentDirectory) {
        this.setTitle(CommonConstants.INSTANCE.CreateDir());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                NewDirectoryPopup.this.okButton();
            }
        }, new Command(){

            public void execute() {
                NewDirectoryPopup.this.cancelButton();
            }
        }));
        this.directoryNameValidator = new DirectoryNameValidator(currentDirectory);
    }

    public void show(ParameterizedCommand clickCommand) {
        this.clickCommand = clickCommand;
        this.show();
    }

    private void cancelButton() {
        this.closePopup();
    }

    private void okButton() {
        if (this.directoryNameValidator.isValid(this.directoryName.getText())) {
            this.clickCommand.execute((Object)this.directoryName.getText());
            this.closePopup();
        } else {
            this.directoryNameControlGroup.setValidationState(ValidationState.ERROR);
            this.directoryNameInline.setText(this.directoryNameValidator.getValidationError());
        }
    }

    private void closePopup() {
        this.directoryName.setText("");
        this.hide();
        super.hide();
    }

    static interface Binder
    extends UiBinder<Widget, NewDirectoryPopup> {
    }
}

