/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.client.home;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Breadcrumbs;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.api.DirectoryBreadCrumb;
import org.uberfire.ext.apps.client.home.AppsHomePresenter;
import org.uberfire.ext.apps.client.home.components.TilesApp;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class AppsHomeView
extends Composite
implements AppsHomePresenter.View {
    private static AppsHomeViewBinder uiBinder = (AppsHomeViewBinder)GWT.create(AppsHomeViewBinder.class);
    @UiField
    FlowPanel mainPanel;
    @UiField
    Breadcrumbs dirs;
    @UiField
    FlowPanel dirContent;
    private AppsHomePresenter presenter;

    @AfterInitialization
    public void initialize() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(AppsHomePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setupBreadCrumbs(List<DirectoryBreadCrumb> breadCrumbs, final ParameterizedCommand<String> breadCrumbAction) {
        this.dirs.clear();
        for (final DirectoryBreadCrumb breadCrumb : breadCrumbs) {
            AnchorListItem bread = new AnchorListItem(breadCrumb.getName());
            bread.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    breadCrumbAction.execute((Object)breadCrumb.getUri());
                }
            });
            this.dirs.add((Widget)bread);
        }
    }

    @Override
    public void setupAddDir(ParameterizedCommand<String> clickCommand, Directory currentDirectory) {
        this.generateCreateDirThumbNail(clickCommand, currentDirectory);
    }

    @Override
    public void setupChildsDirectories(List<Directory> childsDirectories, ParameterizedCommand<String> clickCommand, ParameterizedCommand<String> deleteCommand) {
        for (Directory childsDirectory : childsDirectories) {
            TilesApp link = TilesApp.directoryTiles(childsDirectory.getName(), childsDirectory.getURI(), TilesApp.TYPE.DIR, clickCommand, deleteCommand);
            this.dirContent.add((Widget)link);
        }
    }

    @Override
    public void clear() {
        this.dirContent.clear();
    }

    @Override
    public void setupChildComponents(List<String> childComponents, ParameterizedCommand<String> clickCommand) {
        for (String childComponent : childComponents) {
            TilesApp link = TilesApp.componentTiles(childComponent, TilesApp.TYPE.COMPONENT, clickCommand);
            this.dirContent.add((Widget)link);
        }
    }

    private void generateCreateDirThumbNail(ParameterizedCommand<String> clickCommand, Directory currentDirectory) {
        TilesApp link = TilesApp.createDirTiles(TilesApp.TYPE.ADD, clickCommand, currentDirectory);
        this.dirContent.add((Widget)link);
    }

    static interface AppsHomeViewBinder
    extends UiBinder<Widget, AppsHomeView> {
    }
}

