/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.asset.management.model.ConfigureRepositoryEvent;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class AssetManagementServiceImpl
implements AssetManagementService {
    private Instance<ProjectService<?>> projectService;
    private IOService ioService;
    private POMService pomService;
    private RepositoryService repositoryService;
    private Event<NewBranchEvent> newBranchEvent;
    private Event<ConfigureRepositoryEvent> configureRepositoryEvent;

    public AssetManagementServiceImpl() {
    }

    @Inject
    public AssetManagementServiceImpl(Event<NewBranchEvent> newBranchEvent, Event<ConfigureRepositoryEvent> configureRepositoryEvent, POMService pomService, @Named(value="ioStrategy") IOService ioService, RepositoryService repositoryService, Instance<ProjectService<?>> projectService) {
        this.ioService = ioService;
        this.newBranchEvent = newBranchEvent;
        this.configureRepositoryEvent = configureRepositoryEvent;
        this.pomService = pomService;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
    }

    public void configureRepository(String repository, String sourceBranch, String devBranch, String releaseBranch, String version) {
        String branchName = devBranch;
        if (version != null && !version.isEmpty()) {
            branchName = branchName + "-" + version;
        }
        Path branchPath = this.ioService.get(URI.create("default://" + branchName + "@" + repository));
        Path branchOriginPath = this.ioService.get(URI.create("default://" + sourceBranch + "@" + repository));
        this.ioService.copy(branchOriginPath, branchPath, new CopyOption[0]);
        Repository repo = this.repositoryService.getRepository(Paths.convert((Path)branchPath));
        String devVersion = null;
        devVersion = version == null ? "1.0.0" : (!version.endsWith("-SNAPSHOT") ? version.concat("-SNAPSHOT") : version);
        Set<Project> projects = this.getProjects(repo);
        for (Project project : projects) {
            POM pom = (POM)this.pomService.load(project.getPomXMLPath());
            pom.getGav().setVersion(devVersion);
            this.pomService.save(project.getPomXMLPath(), (Object)pom, null, "Update project version on development branch");
        }
        this.newBranchEvent.fire((Object)new NewBranchEvent(repository, branchName, Paths.convert((Path)branchPath), Long.valueOf(System.currentTimeMillis())));
        branchName = releaseBranch;
        if (version != null && !version.isEmpty()) {
            branchName = branchName + "-" + version;
        }
        branchPath = this.ioService.get(URI.create("default://" + branchName + "@" + repository));
        branchOriginPath = this.ioService.get(URI.create("default://" + sourceBranch + "@" + repository));
        this.ioService.copy(branchOriginPath, branchPath, new CopyOption[0]);
        this.newBranchEvent.fire((Object)new NewBranchEvent(repository, branchName, Paths.convert((Path)branchPath), Long.valueOf(System.currentTimeMillis())));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("RepositoryName", repository);
        parameters.put("SourceBranchName", sourceBranch);
        parameters.put("DevBranchName", devBranch);
        parameters.put("RelBranchName", releaseBranch);
        parameters.put("Version", version);
        this.configureRepositoryEvent.fire((Object)new ConfigureRepositoryEvent(parameters));
    }

    public Set<Project> getProjects(Repository repository, String branch) {
        return ((ProjectService)this.projectService.get()).getProjects(repository, branch);
    }

    private Set<Project> getProjects(Repository repository) {
        HashSet<Project> authorizedProjects = new HashSet<Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        Path repositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot());
        DirectoryStream nioRepositoryPaths = this.ioService.newDirectoryStream(repositoryRoot);
        for (Path nioRepositoryPath : nioRepositoryPaths) {
            if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0])) continue;
            org.uberfire.backend.vfs.Path projectPath = Paths.convert((Path)nioRepositoryPath);
            Project project = ((ProjectService)this.projectService.get()).resolveProject(projectPath);
            if (project == null) continue;
            authorizedProjects.add(project);
        }
        return authorizedProjects;
    }
}

