/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModuleRow;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModulesView;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataView;
import org.guvnor.asset.management.client.editors.repository.structure.ActionHistory;
import org.guvnor.asset.management.client.editors.repository.structure.HasModel;
import org.guvnor.asset.management.client.editors.repository.structure.QueryDeletePopup;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryManagedStatusUpdater;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureContext;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureMenu;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureTitle;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.context.ProjectContextChangeHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectWizard;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="repositoryStructureScreen")
public class RepositoryStructurePresenter
implements RepositoryStructureView.Presenter,
RepositoryStructureDataView.Presenter,
ProjectModulesView.Presenter,
ProjectContextChangeHandler {
    private RepositoryStructureView view;
    private Caller<POMService> pomService;
    private Caller<RepositoryStructureService> repositoryStructureService;
    private Event<ProjectContextChangeEvent> contextChangeEvent;
    private ConflictingRepositoriesPopup conflictingRepositoriesPopup;
    private PlaceManager placeManager;
    private ProjectContext projectContext;
    private ProjectWizard wizard;
    private RepositoryStructureModel model;
    private ActionHistory history = new ActionHistory();
    private RepositoryStructureContext repositoryStructureContext = new RepositoryStructureContext();
    private ObservablePath pathToRepositoryStructure;
    private ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;
    private ListDataProvider<ProjectModuleRow> dataProvider = new ListDataProvider();
    private RepositoryStructureMenu menus;
    private RepositoryManagedStatusUpdater repositoryManagedStatusUpdater;
    private RepositoryStructureTitle repositoryStructureTitle;

    public RepositoryStructurePresenter() {
    }

    @Inject
    public RepositoryStructurePresenter(RepositoryStructureView view, Caller<POMService> pomService, Caller<RepositoryStructureService> repositoryStructureService, RepositoryStructureTitle repositoryStructureTitle, Event<ProjectContextChangeEvent> contextChangeEvent, ConflictingRepositoriesPopup conflictingRepositoriesPopup, RepositoryStructureMenu menus, PlaceManager placeManager, ProjectContext projectContext, ProjectWizard wizard, RepositoryManagedStatusUpdater repositoryManagedStatusUpdater) {
        this.view = view;
        this.pomService = pomService;
        this.repositoryStructureService = repositoryStructureService;
        this.repositoryStructureTitle = repositoryStructureTitle;
        this.contextChangeEvent = contextChangeEvent;
        this.conflictingRepositoriesPopup = conflictingRepositoriesPopup;
        this.menus = menus;
        this.placeManager = placeManager;
        this.projectContext = projectContext;
        this.wizard = wizard;
        this.repositoryManagedStatusUpdater = repositoryManagedStatusUpdater;
        this.repositoryManagedStatusUpdater.bind(view, this.history, this);
        projectContext.addChangeHandler((ProjectContextChangeHandler)this);
        view.setPresenter(this);
        view.getModulesView().setPresenter(this);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.repositoryStructureTitle.init(placeRequest);
        this.makeMenuBar();
        this.processContextChange();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.RepositoryStructure();
    }

    @WorkbenchPartView
    public IsWidget asWidget() {
        return this.view.asWidget();
    }

    @OnClose
    public void onClose() {
        this.concurrentUpdateSessionInfo = null;
        if (this.pathToRepositoryStructure != null) {
            this.pathToRepositoryStructure.dispose();
        }
    }

    @OnFocus
    public void onFocus() {
        this.dataProvider.flush();
        this.dataProvider.refresh();
    }

    public void onChange() {
        this.processContextChange();
    }

    private void processContextChange() {
        if (this.projectContext.getActiveRepository() == null) {
            this.clearView();
            this.view.setModulesViewVisible(false);
            this.enableActions(false);
        } else {
            boolean repoOrBranchChanged = this.repositoryStructureContext.repositoryOrBranchChanged(this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch());
            if (repoOrBranchChanged || this.repositoryStructureContext.activeProjectChanged(this.projectContext.getActiveProject())) {
                if (repoOrBranchChanged || this.history.alreadyUpToDate(this.projectContext.getActiveProject())) {
                    this.loadModel(this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch());
                }
                this.history.reset();
                this.repositoryStructureContext.reset(this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), this.projectContext.getActiveProject());
            }
        }
    }

    @Override
    public void setModel(RepositoryStructureModel model) {
        this.model = model;
        this.dataProvider.getList().clear();
        if (this.pathToRepositoryStructure != null) {
            this.destroyObservablePath(this.pathToRepositoryStructure);
        }
        this.concurrentUpdateSessionInfo = null;
        boolean initialized = this.updateView();
        this.addStructureChangeListeners();
        this.updateEditorTitle(initialized);
    }

    private boolean updateView() {
        if (this.model == null) {
            this.model = new RepositoryStructureModel();
            this.view.setDataPresenterMode(RepositoryStructureDataView.ViewMode.CREATE_STRUCTURE);
            this.view.getModulesView().setMode(ProjectModulesView.ViewMode.MODULES_VIEW);
            this.initDataPresenter();
            this.view.setModulesViewVisible(false);
            this.menus.enableAssetsManagementMenu(false);
            this.pathToRepositoryStructure = null;
            return false;
        }
        if (this.model.isMultiModule()) {
            this.view.setDataPresenterMode(RepositoryStructureDataView.ViewMode.EDIT_MULTI_MODULE_PROJECT);
            this.view.getModulesView().setMode(ProjectModulesView.ViewMode.MODULES_VIEW);
            this.initDataPresenter();
            this.view.setModulesViewVisible(true);
            this.pathToRepositoryStructure = this.createObservablePath(this.model.getPathToPOM());
            this.updateModulesList(this.model.getModules());
            this.menus.enableAssetsManagementMenu(true);
            return true;
        }
        if (this.model.isSingleProject()) {
            this.view.setDataPresenterMode(RepositoryStructureDataView.ViewMode.EDIT_SINGLE_MODULE_PROJECT);
            this.view.getModulesView().setMode(ProjectModulesView.ViewMode.PROJECTS_VIEW);
            this.initDataPresenter();
            this.view.setModulesViewVisible(false);
            this.pathToRepositoryStructure = this.createObservablePath(((Project)this.model.getOrphanProjects().get(0)).getPomXMLPath());
            this.menus.enableAssetsManagementMenu(true);
            return true;
        }
        this.view.setDataPresenterMode(RepositoryStructureDataView.ViewMode.EDIT_UNMANAGED_REPOSITORY);
        this.view.getModulesView().setMode(ProjectModulesView.ViewMode.PROJECTS_VIEW);
        this.view.setModulesViewVisible(true);
        this.menus.enableAssetsManagementMenu(false);
        this.initDataPresenter();
        this.updateProjectsList(this.model.getOrphanProjects());
        return true;
    }

    private void initDataPresenter() {
        if (this.model == null) {
            return;
        }
        if (this.model.getPathToPOM() != null) {
            this.view.setDataPresenterModel(this.model.getPOM().getGav());
        } else if (this.model.isSingleProject()) {
            Project project = (Project)this.model.getOrphanProjects().get(0);
            POM pom = (POM)this.model.getOrphanProjectsPOM().get(project.getIdentifier());
            if (pom != null && pom.getGav() != null) {
                this.view.setDataPresenterModel(pom.getGav());
            }
        }
    }

    ObservablePath createObservablePath(Path path) {
        return ((ObservablePath)IOC.getBeanManager().lookupBean(ObservablePath.class, new Annotation[0]).getInstance()).wrap(path);
    }

    void destroyObservablePath(ObservablePath path) {
        path.dispose();
    }

    private void reload() {
        this.concurrentUpdateSessionInfo = null;
        this.loadModel(this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch());
    }

    private void updateEditorTitle(boolean initialized) {
        this.repositoryStructureTitle.updateEditorTitle(this.model, initialized);
    }

    private void addStructureChangeListeners() {
        if (this.pathToRepositoryStructure != null) {
            this.pathToRepositoryStructure.onConcurrentUpdate((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentUpdateEvent>(){

                public void execute(ObservablePath.OnConcurrentUpdateEvent eventInfo) {
                    RepositoryStructurePresenter.this.concurrentUpdateSessionInfo = eventInfo;
                }
            });
            this.pathToRepositoryStructure.onConcurrentRename((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentRenameEvent>(){

                public void execute(ObservablePath.OnConcurrentRenameEvent info) {
                    ConcurrentChangePopup.newConcurrentRename((Path)info.getSource(), (Path)info.getTarget(), (User)info.getIdentity(), (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.enableActions(false);
                        }
                    }, (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.reload();
                        }
                    }).show();
                }
            });
            this.pathToRepositoryStructure.onConcurrentDelete((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentDelete>(){

                public void execute(ObservablePath.OnConcurrentDelete info) {
                    ConcurrentChangePopup.newConcurrentDelete((Path)info.getPath(), (User)info.getIdentity(), (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.enableActions(false);
                        }
                    }, (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.placeManager.closePlace("repositoryStructureScreen");
                        }
                    }).show();
                }
            });
        }
    }

    private void updateModulesList(List<String> modules) {
        if (modules != null) {
            for (String module : this.model.getModules()) {
                this.dataProvider.getList().add(new ProjectModuleRow(module));
            }
        }
    }

    private void updateProjectsList(List<Project> projects) {
        if (projects != null) {
            for (Project project : projects) {
                this.dataProvider.getList().add(new ProjectModuleRow(project.getProjectName()));
            }
        }
    }

    private void enableActions(boolean value) {
        this.view.getModulesView().enableActions(value);
    }

    @Override
    public void clearView() {
        this.view.clearDataView();
        this.dataProvider.getList().clear();
        this.enableActions(true);
    }

    @Override
    public void onAddModule() {
        this.wizard.initialise(this.getPom());
        this.wizard.start(this.getModuleAddedSuccessCallback(), false);
    }

    private POM getPom() {
        if (this.model.isMultiModule()) {
            return this.makeMultiModulePom();
        }
        POM pom = new POM();
        pom.getGav().setGroupId(this.projectContext.getActiveOrganizationalUnit().getDefaultGroupId());
        return pom;
    }

    private POM makeMultiModulePom() {
        POM pom = new POM();
        GAV parentGAV = this.view.getDataPresenterGav();
        pom.setParent(parentGAV);
        pom.getGav().setGroupId(parentGAV.getGroupId());
        pom.getGav().setVersion(parentGAV.getVersion());
        return pom;
    }

    private Callback<Project> getModuleAddedSuccessCallback() {
        return new Callback<Project>(){

            public void callback(final Project _project) {
                RepositoryStructurePresenter.this.history.setLastAddedModule(_project);
                if (_project != null) {
                    if (RepositoryStructurePresenter.this.model.isMultiModule()) {
                        RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.Loading());
                        ((RepositoryStructureService)RepositoryStructurePresenter.this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

                            public void callback(RepositoryStructureModel _model) {
                                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                if (_model != null) {
                                    RepositoryStructurePresenter.this.model.setPOM(_model.getPOM());
                                    RepositoryStructurePresenter.this.model.setPOMMetaData(_model.getPOMMetaData());
                                    RepositoryStructurePresenter.this.model.setModules((Collection)_model.getModules());
                                    RepositoryStructurePresenter.this.model.getModulesProject().put(_project.getProjectName(), _project);
                                    RepositoryStructurePresenter.this.addToModulesList(_project);
                                }
                            }
                        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).load(RepositoryStructurePresenter.this.projectContext.getActiveRepository(), RepositoryStructurePresenter.this.projectContext.getActiveBranch(), false);
                    } else {
                        RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.Loading());
                        ((POMService)RepositoryStructurePresenter.this.pomService.call((RemoteCallback)new RemoteCallback<POM>(){

                            public void callback(POM _pom) {
                                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                RepositoryStructurePresenter.this.model.getOrphanProjects().add(_project);
                                RepositoryStructurePresenter.this.model.getOrphanProjectsPOM().put(_project.getIdentifier(), _pom);
                                RepositoryStructurePresenter.this.addToModulesList(_project);
                            }
                        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).load(_project.getPomXMLPath());
                    }
                }
            }
        };
    }

    @Override
    public void addDataDisplay(HasData<ProjectModuleRow> display) {
        this.dataProvider.addDataDisplay(display);
    }

    @Override
    public void onDeleteModule(ProjectModuleRow moduleRow) {
        final Project project = this.getSelectedModule(moduleRow.getName());
        if (project != null) {
            QueryDeletePopup.showDeletePopup(this.getDeleteMessage(moduleRow), new Command(){

                public void execute() {
                    RepositoryStructurePresenter.this.deleteSelectedModule(project);
                }
            });
        }
    }

    private String getDeleteMessage(ProjectModuleRow moduleRow) {
        if (this.model.isMultiModule()) {
            return Constants.INSTANCE.ConfirmModuleDeletion(moduleRow.getName());
        }
        return Constants.INSTANCE.ConfirmProjectDeletion(moduleRow.getName());
    }

    private void deleteSelectedModule(Project project) {
        this.view.showBusyIndicator(Constants.INSTANCE.Deleting());
        this.history.setLastDeletedModule(project);
        ((RepositoryStructureService)this.repositoryStructureService.call(this.getModuleDeletedSuccessCallback(project), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).delete(project.getPomXMLPath(), "Module removed");
    }

    private RemoteCallback<Void> getModuleDeletedSuccessCallback(final Project _project) {
        return new RemoteCallback<Void>(){

            public void callback(Void response) {
                if (_project != null) {
                    if (RepositoryStructurePresenter.this.model.isMultiModule()) {
                        RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.Loading());
                        ((RepositoryStructureService)RepositoryStructurePresenter.this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

                            public void callback(RepositoryStructureModel _model) {
                                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                if (_model != null) {
                                    RepositoryStructurePresenter.this.model.setPOM(_model.getPOM());
                                    RepositoryStructurePresenter.this.model.setPOMMetaData(_model.getPOMMetaData());
                                    RepositoryStructurePresenter.this.model.setModules((Collection)_model.getModules());
                                    RepositoryStructurePresenter.this.model.getModulesProject().remove(_project.getProjectName());
                                    RepositoryStructurePresenter.this.removeFromModulesList(_project.getProjectName());
                                }
                            }
                        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).load(RepositoryStructurePresenter.this.projectContext.getActiveRepository(), RepositoryStructurePresenter.this.projectContext.getActiveBranch(), false);
                    } else {
                        RepositoryStructurePresenter.this.model.getOrphanProjects().remove(_project);
                        RepositoryStructurePresenter.this.model.getOrphanProjectsPOM().remove(_project.getIdentifier());
                        RepositoryStructurePresenter.this.removeFromModulesList(_project.getProjectName());
                    }
                }
            }
        };
    }

    @Override
    public void onEditModule(ProjectModuleRow moduleRow) {
        Project project = this.getSelectedModule(moduleRow.getName());
        if (project != null) {
            this.contextChangeEvent.fire((Object)new ProjectContextChangeEvent(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), project));
            this.placeManager.goTo("projectScreen");
        }
    }

    @Override
    public void loadModel(Repository repository, String branch) {
        this.view.showBusyIndicator(Constants.INSTANCE.Loading());
        this.clearView();
        ((RepositoryStructureService)this.repositoryStructureService.call(this.getLoadModelSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).load(repository, branch);
    }

    private RemoteCallback<RepositoryStructureModel> getLoadModelSuccessCallback() {
        return new RemoteCallback<RepositoryStructureModel>(){

            public void callback(RepositoryStructureModel model) {
                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                RepositoryStructurePresenter.this.setModel(model);
            }
        };
    }

    @Override
    public void onInitRepositoryStructure() {
        if (this.model != null) {
            if (this.model.isMultiModule()) {
                this.doRepositoryStructureInitialization(DeploymentMode.VALIDATED);
            } else if (this.model.isSingleProject()) {
                this.repositoryManagedStatusUpdater.initSingleProject(this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch());
            } else if (!this.model.isManaged().booleanValue()) {
                this.repositoryManagedStatusUpdater.updateNonManaged(this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch());
            }
        }
    }

    private void doRepositoryStructureInitialization(DeploymentMode mode) {
        this.view.showBusyIndicator(Constants.INSTANCE.CreatingRepositoryStructure());
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path response) {
                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                RepositoryStructurePresenter.this.loadModel(RepositoryStructurePresenter.this.projectContext.getActiveRepository(), RepositoryStructurePresenter.this.projectContext.getActiveBranch());
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback(this.view){

            public boolean error(Message message, Throwable throwable) {
                Throwable _throwable;
                Throwable throwable2 = _throwable = throwable.getCause() == null ? throwable : throwable.getCause();
                if (_throwable instanceof GAVAlreadyExistsException) {
                    GAVAlreadyExistsException gae = (GAVAlreadyExistsException)_throwable;
                    RepositoryStructurePresenter.this.conflictingRepositoriesPopup.setContent(gae.getGAV(), gae.getRepositories(), new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.conflictingRepositoriesPopup.hide();
                            RepositoryStructurePresenter.this.doRepositoryStructureInitialization(DeploymentMode.FORCED);
                        }
                    });
                    RepositoryStructurePresenter.this.conflictingRepositoriesPopup.show();
                    return true;
                }
                return super.error(message, _throwable);
            }
        })).initRepositoryStructure(this.view.getDataPresenterGav(), this.projectContext.getActiveRepository(), mode);
    }

    private Project getSelectedModule(String name) {
        if (this.model != null && name != null) {
            if (this.model.isMultiModule()) {
                return this.model.getModulesProject() != null ? (Project)this.model.getModulesProject().get(name) : null;
            }
            if (this.model.getOrphanProjects() != null) {
                for (Project _project : this.model.getOrphanProjects()) {
                    if (!name.equals(_project.getProjectName())) continue;
                    return _project;
                }
            }
        }
        return null;
    }

    private void removeFromModulesList(String module) {
        if (module != null) {
            int index = -1;
            for (ProjectModuleRow row : this.dataProvider.getList()) {
                ++index;
                if (!module.equals(row.getName())) continue;
                break;
            }
            if (index >= 0 && (index == 0 || index < this.dataProvider.getList().size())) {
                this.dataProvider.getList().remove(index);
            }
        }
    }

    private void addToModulesList(Project project) {
        ProjectModuleRow row = new ProjectModuleRow(project.getProjectName());
        if (!this.dataProvider.getList().contains(row)) {
            this.dataProvider.getList().add(row);
        }
    }

    private void makeMenuBar() {
        this.menus.init(new HasModel<RepositoryStructureModel>(){

            @Override
            public RepositoryStructureModel getModel() {
                return RepositoryStructurePresenter.this.model;
            }
        });
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

