/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Project;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mvp.PlaceRequest;

@Dependent
public class RepositoryStructureTitle {
    private final ProjectContext workbenchContext;
    private final Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest placeRequest;

    @Inject
    public RepositoryStructureTitle(ProjectContext workbenchContext, Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent) {
        this.workbenchContext = workbenchContext;
        this.changeTitleWidgetEvent = changeTitleWidgetEvent;
    }

    public void init(PlaceRequest placeRequest) {
        PortablePreconditions.checkNotNull((String)"placeRequest.", (Object)placeRequest);
        this.placeRequest = placeRequest;
    }

    public void updateEditorTitle(RepositoryStructureModel model, boolean initialized) {
        PortablePreconditions.checkNotNull((String)"Please set placeRequest.", (Object)this.placeRequest);
        if (this.workbenchContext.getActiveRepository() == null) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.RepositoryNotSelected()));
        } else if (!initialized) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.UnInitializedStructure(this.getRepositoryLabel())));
        } else if (model.isMultiModule()) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.RepositoryStructureWithName(this.getRepositoryLabel() + "\u2192 " + model.getPOM().getGav().getArtifactId() + ":" + model.getPOM().getGav().getGroupId() + ":" + model.getPOM().getGav().getVersion())));
        } else if (model.isSingleProject()) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.RepositoryStructureWithName(this.getRepositoryLabel() + "\u2192 " + ((Project)model.getOrphanProjects().get(0)).getProjectName())));
        } else {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.UnmanagedRepository(this.getRepositoryLabel())));
        }
    }

    private String getRepositoryLabel() {
        return this.workbenchContext.getActiveRepository() != null ? this.workbenchContext.getActiveRepository().getAlias() + " (" + this.workbenchContext.getActiveBranch() + ") " : "";
    }
}

