/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.plugin;

public interface PluginProcessor {
    public boolean shouldProcess(String var1);

    public void removeAll();

    public void process(String var1, String var2, boolean var3);

    public boolean isRegistered(String var1);

    public static boolean isAValidPluginFileExtension(String fileName) {
        for (PluginProcessorType type : PluginProcessorType.values()) {
            if (!fileName.endsWith(type.getExtension())) continue;
            return true;
        }
        return false;
    }

    public static enum PluginProcessorType {
        GWT("nocache.js", false),
        PERSPECTIVE_EDITOR("layout.json", true),
        HTML_TEMPLATE(".html", true),
        JS(".js", true);

        private String extension;
        private boolean isRuntimePlugin;

        private PluginProcessorType(String extension, boolean isRuntimePlugin) {
            this.extension = extension;
            this.isRuntimePlugin = isRuntimePlugin;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean isRuntimePlugin() {
            return this.isRuntimePlugin;
        }
    }
}

