/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.vfs;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

public class PathTest {
    @Test
    public void generalState() {
        Path path = PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource");
        Assertions.assertThat((Comparable)path).isEqualTo((Object)path);
        Assertions.assertThat((Comparable)path).isEqualTo((Object)PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource"));
        Assertions.assertThat((int)path.hashCode()).isEqualTo(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource").hashCode());
        Assertions.assertThat((int)path.hashCode()).isEqualTo(path.hashCode());
        path = PathFactory.newPath((String)"resource", (String)"scheme://different/path/to/some/resource");
        Assertions.assertThat((boolean)path.equals(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource"))).isFalse();
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource").hashCode());
        path = PathFactory.newPath((String)"resource", (String)"scheme://different/path/to/some/resource");
        Assertions.assertThat((boolean)path.equals("something")).isFalse();
        Assertions.assertThat((boolean)path.equals(null)).isFalse();
    }

    @Test
    public void checkNPE() {
        HashMap<Path, String> hashMap = new HashMap<Path, String>();
        Path path = PathFactory.newPath((String)"defaultPackage", (String)"default://guvnor-jcr2vfs-migration/defaultPackage/");
        hashMap.put(path, "content");
        Assertions.assertThat((String)((String)hashMap.get(path))).isEqualTo("content");
        Assertions.assertThat((String)((String)hashMap.get(PathFactory.newPath((String)"defaultPackage", (String)"default://guvnor-jcr2vfs-migration/defaultPackage/")))).isEqualTo("content");
    }
}

