/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.cdi.SystemConfigProducer;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@RunWith(value=MockitoJUnitRunner.class)
public class SystemConfigProducerTest {
    SystemConfigProducer producer;
    BeanManager bm;
    Bean<IOService> ioServiceBean;
    Set<Bean<?>> configIOBeans = new HashSet();
    IOService ioServiceMock;
    FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.producer = new SystemConfigProducer();
        this.bm = (BeanManager)Mockito.mock(BeanManager.class);
        this.ioServiceBean = (Bean)Mockito.mock(Bean.class);
        this.configIOBeans.add(this.ioServiceBean);
        this.ioServiceMock = (IOService)Mockito.mock(IOService.class);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
    }

    @Test
    public void createAndDestroyFSShouldRegisterUnregisterOnPriorityDisposableRegistry() throws Exception {
        Mockito.when((Object)this.bm.getBeans("configIO")).thenReturn(this.configIOBeans);
        Mockito.when((Object)this.bm.getReference((Bean)Matchers.eq(this.ioServiceBean), (Type)Matchers.eq(IOService.class), (CreationalContext)Matchers.any(CreationalContext.class))).thenReturn((Object)this.ioServiceMock);
        Mockito.when((Object)this.ioServiceMock.newFileSystem((URI)Matchers.any(URI.class), (Map)Matchers.any(Map.class))).thenReturn((Object)this.fs);
        Bean fileSystemBean = this.producer.createFileSystemBean(this.bm, (InjectionTarget)Mockito.mock(InjectionTarget.class));
        Assert.assertNull((Object)PriorityDisposableRegistry.get((String)"systemFS"));
        fileSystemBean.create((CreationalContext)Mockito.mock(CreationalContext.class));
        Assert.assertNotNull((Object)PriorityDisposableRegistry.get((String)"systemFS"));
        fileSystemBean.destroy((Object)this.fs, (CreationalContext)Mockito.mock(CreationalContext.class));
        Assert.assertNull((Object)PriorityDisposableRegistry.get((String)"systemFS"));
    }
}

