/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.backend.cdi.workspace.Workspace;
import org.uberfire.backend.server.cdi.SessionBasedBean;
import org.uberfire.backend.server.cdi.model.WorkspaceImpl;
import org.uberfire.backend.server.cdi.workspace.WorkspaceManager;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScopedExtension;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;

@RunWith(value=Arquillian.class)
public class WorkspaceBuilderServiceTest {
    @Inject
    private WorkspaceManager workspaceManager;
    @Inject
    SessionBasedBean bean;

    @Deployment
    public static JavaArchive createDeployment() {
        System.setProperty("errai.marshalling.force_static_marshallers", Boolean.toString(true));
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new String[]{"org.uberfire.preferences"})).addPackages(true, new String[]{"org.uberfire.mvp"})).addPackages(true, new String[]{"org.uberfire.commons"})).addPackages(true, new String[]{"org.uberfire.backend.java"})).addPackages(true, new String[]{"org.uberfire.backend.server.cdi"})).addPackages(true, new String[]{"org.uberfire.backend.server.cluster"})).addPackages(true, new String[]{"org.uberfire.backend.server.io"})).addPackages(true, new String[]{"org.uberfire.java.nio.fs.jgit"})).addClass(JGitFileSystemProvider.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsResource("ErraiApp.properties", "ErraiApp.properties")).addAsManifestResource("META-INF/services/org.uberfire.java.nio.file.spi.FileSystemProvider", "services/org.uberfire.java.nio.file.spi.FileSystemProvider")).addAsServiceProvider(Extension.class, new Class[]{WorkspaceScopedExtension.class});
    }

    @Produces
    protected SessionInfo createSessionInfo(InjectionPoint injectionPoint) {
        return new SessionInfoImpl((User)new UserImpl(Thread.currentThread().getName()));
    }

    @BeforeClass
    public static void setUp() {
    }

    @Test
    public void testConcurrentWorkspaceBeans() {
        String THREAD_NAME_2 = "ray vaughan";
        String THREAD_NAME_1 = "hendrix";
        CountDownLatch latch = new CountDownLatch(2);
        Thread thread1 = this.createThread(this.bean, "a:b:c", latch);
        Thread thread2 = this.createThread(this.bean, "d:e:f", latch);
        thread1.setName(THREAD_NAME_1);
        thread2.setName(THREAD_NAME_2);
        thread1.start();
        thread2.start();
        try {
            latch.await(7000L, TimeUnit.SECONDS);
            WorkspaceImpl workspace1 = (WorkspaceImpl)this.workspaceManager.getWorkspace(THREAD_NAME_1);
            Assert.assertEquals((long)1L, (long)this.workspaceManager.getBeansCount((Workspace)workspace1));
            WorkspaceImpl workspace2 = (WorkspaceImpl)this.workspaceManager.getWorkspace(THREAD_NAME_2);
            Assert.assertEquals((long)1L, (long)this.workspaceManager.getBeansCount((Workspace)workspace2));
            Assert.assertEquals((long)2L, (long)this.workspaceManager.getWorkspaceCount());
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private Thread createThread(SessionBasedBean bean, String gav, CountDownLatch latch) {
        return new Thread(() -> {
            bean.build(gav);
            latch.countDown();
        });
    }
}

