/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import java.lang.annotation.Annotation;
import java.util.NoSuchElementException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.cdi.workspace.Workspace;
import org.uberfire.backend.server.cdi.workspace.WorkspaceManager;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScoped;
import org.uberfire.rpc.SessionInfo;

public class WorkspaceScopeContext
implements Context {
    private static Logger logger = LoggerFactory.getLogger(WorkspaceScopeContext.class);
    private final BeanManager beanManager;

    public WorkspaceScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Class<? extends Annotation> getScope() {
        return WorkspaceScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Bean<T> bean = this.getBean(contextual);
        Workspace workspace = this.getWorkspaceManager().getOrCreateWorkspace(this.getWorkspaceName());
        Object instance = this.getWorkspaceManager().getBean(workspace, bean.getBeanClass().getSimpleName());
        if (instance == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating Bean <<{}>> with creational context for workspace <<{}>>", (Object)bean.getBeanClass(), (Object)workspace.getName());
            }
            Object created = bean.create(creationalContext);
            this.getWorkspaceManager().putBean(workspace, bean.getBeanClass().getSimpleName(), created);
            return (T)created;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bean <<{}>> found for workspace <<{}>>", (Object)bean.getBeanClass(), (Object)workspace.getName());
        }
        return instance;
    }

    public <T> T get(Contextual<T> contextual) {
        Bean<T> bean = this.getBean(contextual);
        Workspace workspace = this.getWorkspaceManager().getOrCreateWorkspace(this.getWorkspaceName());
        if (logger.isDebugEnabled()) {
            logger.debug("Getting Bean <<{}>> for workspace <<{}>>", (Object)bean.getBeanClass(), (Object)workspace.getName());
        }
        return this.getWorkspaceManager().getBean(workspace, bean.getBeanClass().toString());
    }

    private String getWorkspaceName() {
        try {
            return this.getSessionInfo().getIdentity().getIdentifier();
        }
        catch (NoSuchElementException e) {
            return "default";
        }
    }

    public boolean isActive() {
        return true;
    }

    private <T> Bean<T> getBean(Contextual contextual) {
        return (Bean)contextual;
    }

    protected SessionInfo getSessionInfo() {
        Bean bean = (Bean)this.beanManager.getBeans(SessionInfo.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        return (SessionInfo)this.beanManager.getReference(bean, SessionInfo.class, creationalContext);
    }

    protected WorkspaceManager getWorkspaceManager() {
        Bean bean = (Bean)this.beanManager.getBeans(WorkspaceManager.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        return (WorkspaceManager)this.beanManager.getReference(bean, WorkspaceManager.class, creationalContext);
    }
}

