/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workspace.WorkspaceContext;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceNameResolverTest {
    private WorkspaceNameResolver resolver;
    private BeanManager beanManager;

    @Before
    public void setUp() {
        WorkspaceContext.set(null);
        this.beanManager = (BeanManager)Mockito.mock(BeanManager.class);
        this.resolver = (WorkspaceNameResolver)Mockito.spy((Object)new WorkspaceNameResolver(this.beanManager));
    }

    @Test
    public void testGlobalWorkspaceName() {
        String name = this.resolver.getWorkspaceName();
        Assert.assertEquals((Object)"global", (Object)name);
    }

    @Test
    public void testContextWorkspaceName() {
        String user = "hendrix";
        WorkspaceContext.set((String)"hendrix");
        String name = this.resolver.getWorkspaceName();
        Assert.assertEquals((Object)"hendrix", (Object)name);
    }

    @Test
    public void testUserInfoWorkspaceName() {
        String user = "clapton";
        SessionInfo sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);
        Mockito.when((Object)sessionInfo.getIdentity()).thenReturn((Object)new UserImpl("clapton"));
        ((WorkspaceNameResolver)Mockito.doReturn((Object)sessionInfo).when((Object)this.resolver)).getSessionInfo();
        String name = this.resolver.getWorkspaceName();
        Assert.assertEquals((Object)"clapton", (Object)name);
    }
}

